/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.utils.MobUtil;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class IllBomb
extends ThrowableProjectile {
    private static final EntityDataAccessor<Integer> BOUNCE_TIMES = SynchedEntityData.m_135353_(IllBomb.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public IllBomb(EntityType<? extends ThrowableProjectile> p_37466_, Level p_37467_) {
        super(p_37466_, p_37467_);
    }

    public IllBomb(double p_37457_, double p_37458_, double p_37459_, Level p_37460_) {
        super((EntityType)ModEntityType.ILL_BOMB.get(), p_37457_, p_37458_, p_37459_, p_37460_);
    }

    public IllBomb(LivingEntity p_37463_, Level p_37464_) {
        super((EntityType)ModEntityType.ILL_BOMB.get(), p_37463_, p_37464_);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BOUNCE_TIMES, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("BounceTimes", this.getBounceTimes());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBounceTimes(compound.m_128451_("BounceTimes"));
    }

    public int getBounceTimes() {
        return (Integer)this.f_19804_.m_135370_(BOUNCE_TIMES);
    }

    public void setBounceTimes(int bounce) {
        this.f_19804_.m_135381_(BOUNCE_TIMES, (Object)bounce);
    }

    protected void m_6532_(HitResult result) {
        HitResult.Type raytraceresult$type = result.m_6662_();
        if (raytraceresult$type == HitResult.Type.BLOCK) {
            BlockHitResult hitResult = (BlockHitResult)result;
            BlockState blockstate = this.f_19853_.m_8055_(hitResult.m_82425_());
            if (!blockstate.m_60812_((BlockGetter)this.f_19853_, hitResult.m_82425_()).m_83281_()) {
                Direction face = hitResult.m_82434_();
                blockstate.m_60669_(this.f_19853_, blockstate, hitResult, (Projectile)this);
                Vec3 vec3 = this.m_20184_();
                double motionX = vec3.m_7096_();
                double motionY = vec3.m_7098_();
                double motionZ = vec3.m_7094_();
                if (face.m_122434_() == Direction.Axis.X) {
                    motionX = -motionX;
                } else if (face.m_122434_() == Direction.Axis.Z) {
                    motionZ = -motionZ;
                } else if (face.m_122434_().m_122478_()) {
                    motionY = -motionY;
                }
                this.m_20334_(motionX, motionY, motionZ);
                if (this.f_19797_ > 25 || this.getBounceTimes() >= 1) {
                    this.explode();
                } else {
                    this.m_5496_(SoundEvents.f_11746_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    this.setBounceTimes(this.getBounceTimes() + 1);
                }
            }
        } else if (raytraceresult$type == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)result).m_82443_();
            if (!this.f_19853_.f_46443_ && this.m_5603_(entity)) {
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    if (living.m_21254_()) {
                        IllBomb snowball = new IllBomb(living, this.f_19853_);
                        snowball.m_37251_((Entity)living, living.m_146909_(), living.m_146908_(), 0.0f, 1.5f, 1.0f);
                        this.f_19853_.m_7967_((Entity)snowball);
                        MobUtil.hurtUsedShield(living, 1.0f);
                        this.f_19853_.m_7605_((Entity)living, (byte)29);
                        this.m_146870_();
                    } else {
                        this.explode();
                    }
                } else {
                    this.explode();
                }
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 300 || this.f_19797_ >= 25 && this.getBounceTimes() >= 1) {
            this.explode();
        } else {
            if (this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82490_(1.01));
            }
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), this.f_19796_.m_188583_() * 0.1, 0.0, this.f_19796_.m_188583_() * 0.1);
            }
        }
    }

    public void explode() {
        if (!this.f_19853_.f_46443_) {
            Entity owner = this.m_19749_();
            if (this.f_19853_.f_46441_.m_188501_() >= 0.25f) {
                this.f_19853_.m_254849_((Entity)(owner != null ? owner : this), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, Level.ExplosionInteraction.NONE);
            } else {
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    this.m_216990_(SoundEvents.f_11913_);
                }
                for (int i = 0; i < 8 + this.f_19853_.f_46441_.m_188503_(16); ++i) {
                    FireworkRocketEntity arrow = new FireworkRocketEntity(this.f_19853_, this.getProjectile(), (Entity)(owner != null ? owner : this), this.m_20185_(), this.m_20186_(), this.m_20189_(), true);
                    float yaw = this.f_19796_.m_188501_() * 360.0f;
                    float pitch = this.f_19796_.m_188501_() * 90.0f - 75.0f;
                    arrow.m_37251_((Entity)this, yaw, pitch, 0.0f, 3.0f, 0.1f);
                    this.f_19853_.m_7967_((Entity)arrow);
                }
            }
            this.m_146870_();
        }
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.m_19749_() != null && (this.m_19749_().m_7307_(pEntity) || pEntity.m_7307_(this.m_19749_()))) {
            return false;
        }
        return super.m_5603_(pEntity);
    }

    public ItemStack getProjectile() {
        int difficulty = this.f_19853_.m_6436_(this.m_20183_()).m_19048_().m_19028_();
        return MobUtil.createFirework(difficulty * 2, DyeColor.values());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

