/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.render.IceBouquetTextures;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.GroundProjectile;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.WandUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class IceBouquet
extends GroundProjectile {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(IceBouquet.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SOUL_EATING = SynchedEntityData.m_135353_(IceBouquet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CONCENTRATE = SynchedEntityData.m_135353_(IceBouquet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public IceBouquet(EntityType<? extends Entity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
        this.m_146922_(0.0f);
        this.lifeTicks = 80;
    }

    public IceBouquet(Level world, double pPosX, double pPosY, double pPosZ, @Nullable LivingEntity owner) {
        this((EntityType<? extends Entity>)((EntityType)ModEntityType.ICE_BOUQUET.get()), world);
        this.setOwner(owner);
        this.m_6034_(pPosX, pPosY, pPosZ);
    }

    public IceBouquet(Level world, BlockPos blockPos, @Nullable LivingEntity owner) {
        this((EntityType<? extends Entity>)((EntityType)ModEntityType.ICE_BOUQUET.get()), world);
        this.setOwner(owner);
        this.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public IceBouquet(Level world, Vec3 vector3d, @Nullable LivingEntity owner) {
        this((EntityType<? extends Entity>)((EntityType)ModEntityType.ICE_BOUQUET.get()), world);
        this.setOwner(owner);
        this.m_6034_(vector3d.m_7096_(), vector3d.m_7098_(), vector3d.m_7094_());
    }

    public ResourceLocation getResourceLocation() {
        return IceBouquetTextures.TEXTURES.getOrDefault(this.getAnimation(), IceBouquetTextures.TEXTURES.get(0));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
        this.f_19804_.m_135372_(SOUL_EATING, (Object)false);
        this.f_19804_.m_135372_(CONCENTRATE, (Object)true);
    }

    public int getAnimation() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    public void setAnimation(int pType) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)pType);
    }

    public boolean isSoulEating() {
        return (Boolean)this.f_19804_.m_135370_(SOUL_EATING);
    }

    public void setSoulEating(boolean soulEating) {
        this.f_19804_.m_135381_(SOUL_EATING, (Object)soulEating);
    }

    public boolean needsConcentrate() {
        return (Boolean)this.f_19804_.m_135370_(CONCENTRATE);
    }

    public void setConcentrate(boolean concentrate) {
        this.f_19804_.m_135381_(CONCENTRATE, (Object)concentrate);
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setAnimation(pCompound.m_128451_("Animation"));
        this.setSoulEating(pCompound.m_128471_("soulEating"));
        this.setConcentrate(pCompound.m_128471_("concentrate"));
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Animation", this.getAnimation());
        pCompound.m_128379_("soulEating", this.isSoulEating());
        pCompound.m_128379_("concentrate", this.needsConcentrate());
    }

    public float m_213856_() {
        return 1.0f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.sentTrapEvent) {
                if (this.animationTicks > 9) {
                    --this.animationTicks;
                }
                if (this.getAnimation() < 44) {
                    this.setAnimation(this.getAnimation() + 1);
                } else {
                    this.setAnimation(13);
                }
                --this.lifeTicks;
                if (this.f_19797_ >= 10) {
                    for (int i = 0; i < 3; ++i) {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
                    }
                    if (this.f_19853_.f_46441_.m_188503_(24) == 0) {
                        this.f_19853_.m_7785_((double)this.m_20183_().m_123341_() + 0.5, (double)this.m_20183_().m_123342_() + 0.5, (double)this.m_20183_().m_123343_() + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + this.f_19853_.f_46441_.m_188501_(), this.f_19853_.f_46441_.m_188501_() * 0.7f + 0.3f, false);
                    }
                }
            }
        } else {
            if (!this.m_20068_()) {
                MobUtil.moveDownToGround(this);
            }
            if (!this.sentTrapEvent) {
                this.f_19853_.m_7605_((Entity)this, (byte)4);
                this.sentTrapEvent = true;
            }
            if (!this.playSound) {
                this.f_19853_.m_7605_((Entity)this, (byte)5);
                this.playSound = true;
            }
            if (this.f_19797_ >= 12) {
                for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_())) {
                    this.dealDamageTo(livingentity);
                }
            }
            if (this.f_19797_ > 0 && --this.lifeTicks < 0) {
                this.m_146870_();
            }
            if (this.getOwner() != null && this.getOwner() instanceof Mob && this.needsConcentrate() && this.getOwner().f_20916_ > 0 && this.f_19797_ < 10 && !this.getOwner().m_21224_()) {
                this.lifeTicks = 14;
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            }
            if (this.m_20077_()) {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
                this.m_146870_();
            }
        }
    }

    public void dealDamageTo(LivingEntity target) {
        LivingEntity owner = this.getOwner();
        float damage = 4.0f;
        if (this.f_19797_ >= 14) {
            damage = 2.0f;
        }
        if (target.m_6084_() && !target.m_20147_() && target != owner) {
            if (target.m_6095_().m_204039_(EntityTypeTags.f_144294_)) {
                return;
            }
            if (owner == null) {
                boolean flag = target.m_6095_().m_204039_(EntityTypeTags.f_144295_);
                if (flag) {
                    damage *= 2.0f;
                }
                target.m_6469_(this.m_269291_().m_269109_(), damage);
            } else {
                if (owner instanceof Mob) {
                    IOwned owned;
                    Mob mobOwner = (Mob)owner;
                    if (mobOwner instanceof Enemy && target instanceof Enemy && mobOwner.m_5448_() != target) {
                        return;
                    }
                    if (mobOwner instanceof IOwned && (owned = (IOwned)mobOwner).getTrueOwner() != null && (target.m_7307_((Entity)owned.getTrueOwner()) || owned.getTrueOwner().m_7307_((Entity)target) || target == owned.getTrueOwner())) {
                        return;
                    }
                } else {
                    if (target.m_7307_((Entity)owner)) {
                        return;
                    }
                    if (owner.m_7307_((Entity)target)) {
                        return;
                    }
                }
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    if (WandUtil.enchantedFocus((LivingEntity)player)) {
                        damage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), (LivingEntity)player);
                    }
                } else if (owner.m_21051_(Attributes.f_22281_) != null) {
                    damage = (float)owner.m_21133_(Attributes.f_22281_);
                    if (damage < 1.0f) {
                        damage = 1.0f;
                    }
                    if (this.f_19797_ >= 14) {
                        damage /= 2.0f;
                    }
                }
                if (target.m_6469_(ModDamageSource.iceBouquet(this, (Entity)owner), damage) && owner instanceof Player && this.isSoulEating()) {
                    SEHelper.increaseSouls((Player)owner, 1);
                }
            }
        }
    }

    @Override
    public void m_7822_(byte pId) {
        super.m_7822_(pId);
        if (pId == 5 && !this.m_20067_()) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.WRAITH_FIRE.get(), this.m_5720_(), 1.0f, 1.0f, false);
        }
        if (pId == 6 && !this.m_20067_()) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11937_, this.m_5720_(), 1.0f, 1.0f, false);
        }
        if (pId == 7) {
            this.lifeTicks = 14;
        }
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

