/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.render.HellfireTextures;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.GroundProjectile;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class Hellfire
extends GroundProjectile {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(Hellfire.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Hellfire(EntityType<? extends Entity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
        this.m_146922_(0.0f);
        this.lifeTicks = MathHelper.secondsToTicks(7);
    }

    public Hellfire(Level world, double pPosX, double pPosY, double pPosZ, @Nullable LivingEntity owner) {
        this((EntityType<? extends Entity>)((EntityType)ModEntityType.HELLFIRE.get()), world);
        this.setOwner(owner);
        this.m_6034_(pPosX, pPosY, pPosZ);
    }

    public Hellfire(Level world, BlockPos blockPos, @Nullable LivingEntity owner) {
        this((EntityType<? extends Entity>)((EntityType)ModEntityType.HELLFIRE.get()), world);
        this.setOwner(owner);
        this.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public Hellfire(Level world, Vec3 vector3d, @Nullable LivingEntity owner) {
        this((EntityType<? extends Entity>)((EntityType)ModEntityType.HELLFIRE.get()), world);
        this.setOwner(owner);
        this.m_6034_(vector3d.m_7096_(), vector3d.m_7098_(), vector3d.m_7094_());
    }

    public ResourceLocation getResourceLocation() {
        return HellfireTextures.TEXTURES.getOrDefault(this.getAnimation(), HellfireTextures.TEXTURES.get(0));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
    }

    public int getAnimation() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    public void setAnimation(int pType) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)pType);
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setAnimation(pCompound.m_128451_("Animation"));
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Animation", this.getAnimation());
    }

    public float m_213856_() {
        return 1.0f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.getAnimation() < HellfireTextures.TEXTURES.size()) {
                this.setAnimation(this.getAnimation() + 1);
            } else {
                this.setAnimation(0);
            }
            --this.lifeTicks;
            for (int i = 0; i < 3; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
            if (this.f_19853_.f_46441_.m_188503_(24) == 0) {
                this.f_19853_.m_7785_((double)this.m_20183_().m_123341_() + 0.5, (double)this.m_20183_().m_123342_() + 0.5, (double)this.m_20183_().m_123343_() + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + this.f_19853_.f_46441_.m_188501_(), this.f_19853_.f_46441_.m_188501_() * 0.7f + 0.3f, false);
            }
        } else {
            if (!this.m_20068_()) {
                MobUtil.moveDownToGround(this);
            }
            if (this.lifeTicks > 13) {
                for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_())) {
                    this.dealDamageTo(livingentity);
                }
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
            if (this.m_20077_()) {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
                this.m_146870_();
            }
        }
    }

    public void dealDamageTo(LivingEntity target) {
        LivingEntity owner = this.getOwner();
        float damage = target.m_21233_() * 0.05f;
        if (target.m_6084_() && !target.m_20147_() && target != owner) {
            if (owner == null) {
                if (target.m_6469_(ModDamageSource.getDamageSource(this.f_19853_, ModDamageSource.HELLFIRE, new EntityType[0]), damage)) {
                    target.f_19802_ = 15;
                }
            } else {
                if (owner instanceof Mob) {
                    IOwned owned;
                    Mob mobOwner = (Mob)owner;
                    if (mobOwner instanceof Enemy && target instanceof Enemy && mobOwner.m_5448_() != target) {
                        return;
                    }
                    if (mobOwner instanceof IOwned && (owned = (IOwned)mobOwner).getTrueOwner() != null && (target.m_7307_((Entity)owned.getTrueOwner()) || owned.getTrueOwner().m_7307_((Entity)target) || target == owned.getTrueOwner())) {
                        return;
                    }
                } else {
                    if (target.m_7307_((Entity)owner)) {
                        return;
                    }
                    if (owner.m_7307_((Entity)target)) {
                        return;
                    }
                }
                if (target.m_6469_(ModDamageSource.hellfire(this, (Entity)this.getOwner()), damage)) {
                    target.f_19802_ = 15;
                }
            }
        }
    }

    @Override
    public float getAnimationProgress(float pPartialTicks) {
        if (this.lifeTicks <= 24) {
            int i = this.lifeTicks;
            return 1.0f - (24.0f - (float)i) / 24.0f;
        }
        return 1.0f;
    }

    @Override
    public void m_7822_(byte pId) {
        super.m_7822_(pId);
        if (pId == 6 && !this.m_20067_()) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11937_, this.m_5720_(), 1.0f, 1.0f, false);
        }
        if (pId == 7) {
            this.lifeTicks = 26;
        }
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

