/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.DustCloudParticleOption;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.Hellfire;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class HellBolt
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(HellBolt.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Map<Integer, ResourceLocation> TEXTURE_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(0, Goety.location("textures/entity/projectiles/hell_bolt/bolt_1.png"));
        map.put(1, Goety.location("textures/entity/projectiles/hell_bolt/bolt_2.png"));
        map.put(2, Goety.location("textures/entity/projectiles/hell_bolt/bolt_3.png"));
    });
    public static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(HellBolt.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public HellBolt(EntityType<? extends HellBolt> p_i50160_1_, Level p_i50160_2_) {
        super(p_i50160_1_, p_i50160_2_);
    }

    public HellBolt(LivingEntity p_i1771_2_, double p_i1771_3_, double p_i1771_5_, double p_i1771_7_, Level p_i1771_1_) {
        super((EntityType)ModEntityType.HELL_BOLT.get(), p_i1771_2_, p_i1771_3_, p_i1771_5_, p_i1771_7_, p_i1771_1_);
    }

    public HellBolt(double pX, double pY, double pZ, double pAccelX, double pAccelY, double pAccelZ, Level pWorld) {
        super((EntityType)ModEntityType.HELL_BOLT.get(), pX, pY, pZ, pAccelX, pAccelY, pAccelZ, pWorld);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_DAMAGE, (Object)Float.valueOf(5.0f));
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
    }

    public boolean m_20069_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getAnimation() < 2) {
            this.setAnimation(this.getAnimation() + 1);
        } else {
            this.setAnimation(0);
        }
        Entity entity = this.m_19749_();
        if (this.f_19797_ >= MathHelper.secondsToTicks(10)) {
            this.m_146870_();
        }
        if (this.f_19853_.f_46443_ || (entity == null || !entity.m_213877_()) && this.f_19853_.m_46805_(this.m_20183_())) {
            Vec3 vec3 = this.m_20184_();
            double d0 = this.m_20185_() - vec3.f_82479_;
            double d1 = this.m_20186_() - vec3.f_82480_;
            double d2 = this.m_20189_() - vec3.f_82481_;
            if (this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
                this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.BIG_FIRE.get(), d0, d1 + 0.15, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_DAMAGE)).floatValue();
    }

    public void setDamage(float pDamage) {
        this.f_19804_.m_135381_(DATA_DAMAGE, (Object)Float.valueOf(pDamage));
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (!this.f_19853_.f_46443_) {
            Entity entity = pResult.m_82443_();
            Entity entity1 = this.m_19749_();
            float enchantment = 0.0f;
            float damage = 5.0f;
            if (entity1 instanceof Player) {
                Player player = (Player)entity1;
                if (WandUtil.enchantedFocus((LivingEntity)player)) {
                    enchantment = WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), (LivingEntity)player);
                }
                damage = ((Double)SpellConfig.FireballDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
            } else if (entity1 instanceof LivingEntity) {
                damage = this.getDamage();
            }
            entity.m_6469_(ModDamageSource.hellfire((Entity)this, entity1), damage + enchantment);
            if (entity1 instanceof LivingEntity) {
                this.m_19970_((LivingEntity)entity1, entity);
            }
        }
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        if (!this.f_19853_.f_46443_) {
            Level blockHitResult;
            Entity entity = this.m_19749_();
            Vec3 vec3 = Vec3.m_82512_((Vec3i)this.m_20183_());
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (pResult instanceof BlockHitResult) {
                    blockHitResult = (BlockHitResult)pResult;
                    BlockPos blockpos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
                    if (BlockFinder.canBeReplaced(this.f_19853_, blockpos)) {
                        hellfire = new Hellfire(this.f_19853_, Vec3.m_82512_((Vec3i)blockpos), livingEntity);
                        vec3 = Vec3.m_82512_((Vec3i)blockpos);
                        this.f_19853_.m_7967_((Entity)hellfire);
                    }
                } else if (pResult instanceof EntityHitResult) {
                    EntityHitResult entityHitResult = (EntityHitResult)pResult;
                    Entity entity1 = entityHitResult.m_82443_();
                    hellfire = new Hellfire(this.f_19853_, Vec3.m_82512_((Vec3i)entity1.m_20183_()), livingEntity);
                    vec3 = Vec3.m_82512_((Vec3i)entity1.m_20183_());
                    this.f_19853_.m_7967_((Entity)hellfire);
                }
            }
            if ((blockHitResult = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)blockHitResult;
                ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ModParticleTypes.BIG_FIRE.get(), (Entity)this);
                ColorUtil colorUtil = new ColorUtil(14523414);
                serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 2.0f, 1), vec3.f_82479_, BlockFinder.moveDownToGround((Entity)this), vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                DustCloudParticleOption cloudParticleOptions = new DustCloudParticleOption(new Vector3f((Vector3fc)Vec3.m_82501_((int)8021604).m_252839_()), 1.0f);
                DustCloudParticleOption cloudParticleOptions2 = new DustCloudParticleOption(new Vector3f((Vector3fc)Vec3.m_82501_((int)15508116).m_252839_()), 1.0f);
                for (int i = 0; i < 2; ++i) {
                    ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)cloudParticleOptions, vec3.f_82479_, this.m_20186_() + 0.25, vec3.f_82481_, 0.0, 0.14, 0.0, 1.0f);
                }
                ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)cloudParticleOptions2, vec3.f_82479_, this.m_20186_() + 0.25, vec3.f_82481_, 0.0, 0.14, 0.0, 1.0f);
            }
            this.m_5496_((SoundEvent)ModSounds.HELL_BOLT_IMPACT.get(), 1.0f, 1.0f);
            this.m_146870_();
        }
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.m_19749_() != null) {
            Mob mob;
            if (pEntity == this.m_19749_()) {
                return false;
            }
            Entity entity = this.m_19749_();
            if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (this.m_19749_().m_7307_(pEntity) || pEntity.m_7307_(this.m_19749_())) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)entity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return super.m_5603_(pEntity);
    }

    protected ParticleOptions m_5967_() {
        return (ParticleOptions)ModParticleTypes.NONE.get();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Animation", this.getAnimation());
        pCompound.m_128350_("Damage", this.getDamage());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setAnimation(pCompound.m_128451_("Animation"));
        if (pCompound.m_128441_("Damage")) {
            this.setDamage(pCompound.m_128457_("Damage"));
        }
    }

    public ResourceLocation getResourceLocation() {
        return TEXTURE_BY_TYPE.getOrDefault(this.getAnimation(), TEXTURE_BY_TYPE.get(0));
    }

    public void rotateToMatchMovement() {
        this.m_37283_();
    }

    public int getAnimation() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    public void setAnimation(int pType) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)pType);
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

