/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.boss.Apostle;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class FireTornado
extends AbstractHurtingProjectile {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(FireTornado.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private int lifespan;
    private int totalLife;
    private int spun = 0;

    public FireTornado(EntityType<? extends AbstractHurtingProjectile> p_i50173_1_, Level p_i50173_2_) {
        super(p_i50173_1_, p_i50173_2_);
        this.f_19794_ = false;
        this.lifespan = 0;
        this.totalLife = 60;
    }

    public FireTornado(Level level, LivingEntity shooter, double xPower, double yPower, double zPower) {
        super((EntityType)ModEntityType.FIRE_TORNADO.get(), shooter, xPower, yPower, zPower, level);
    }

    public FireTornado(Level p_i1795_1_, double p_i1795_2_, double p_i1795_4_, double p_i1795_6_, double p_i1795_8_, double p_i1795_10_, double p_i1795_12_) {
        super((EntityType)ModEntityType.FIRE_TORNADO.get(), p_i1795_2_, p_i1795_4_, p_i1795_6_, p_i1795_8_, p_i1795_10_, p_i1795_12_, p_i1795_1_);
    }

    protected float m_6884_() {
        return 0.68f;
    }

    public int getTotalLife() {
        return this.totalLife;
    }

    public void setTotalLife(int totalLife) {
        this.totalLife = totalLife;
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public void setLifespan(int lifespan) {
        this.lifespan = lifespan;
    }

    public int getSpun() {
        return this.spun;
    }

    public void setSpun(int spun) {
        this.spun = spun;
    }

    public LivingEntity getTrueOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public void m_8119_() {
        LivingEntity livingEntity;
        super.m_8119_();
        if (this.getLifespan() < this.getTotalLife()) {
            ++this.lifespan;
        } else {
            this.trueRemove();
        }
        if (this.f_146808_) {
            this.lifespan += 10;
        }
        if (this.getTrueOwner() != null && (livingEntity = this.getTrueOwner()) instanceof Mob) {
            Mob owner = (Mob)livingEntity;
            if (owner.m_5448_() != null) {
                LivingEntity livingentity = owner.m_5448_();
                double d1 = livingentity.m_20185_() - this.m_20185_();
                double d2 = livingentity.m_20227_(0.5) - this.m_20227_(0.5);
                double d3 = livingentity.m_20189_() - this.m_20189_();
                if (this.f_19797_ % 50 == 0) {
                    this.fakeRemove(d1, d2, d3);
                }
            } else {
                this.trueRemove();
            }
        }
        int maxSpun = 80;
        if (this.getSpun() >= maxSpun) {
            this.trueRemove();
        }
        if (this.f_19797_ % 20 == 0) {
            this.m_5496_((SoundEvent)ModSounds.FIRE_TORNADO_AMBIENT.get(), 1.0f, 0.5f);
        }
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        for (LivingEntity entity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(this.AreaOfEffect()))) {
            if (this.getTrueOwner() != null) {
                if (entity == this.getTrueOwner() || entity.m_7307_((Entity)this.getTrueOwner()) || this.getTrueOwner().m_7307_((Entity)entity)) continue;
                targets.add(entity);
                continue;
            }
            targets.add(entity);
        }
        if (!targets.isEmpty()) {
            for (LivingEntity entity : targets) {
                if (!MobUtil.validEntity((Entity)entity)) continue;
                entity.m_20254_(30);
                if (entity.m_21023_(MobEffects.f_19607_)) {
                    entity.m_6234_(MobEffects.f_19607_);
                }
                this.suckInMobs(entity);
            }
        }
    }

    public void trueRemove() {
        this.setLifespan(this.getTotalLife());
        this.remove();
    }

    public void fakeRemove(double x, double y, double z) {
        FireTornado fireTornadoEntity = new FireTornado(this.f_19853_, this.getTrueOwner(), x, y, z);
        fireTornadoEntity.setOwnerId(this.getTrueOwner().m_20148_());
        fireTornadoEntity.setLifespan(this.getLifespan());
        fireTornadoEntity.setTotalLife(this.getTotalLife());
        fireTornadoEntity.setSpun(this.getSpun());
        fireTornadoEntity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.f_19853_.m_7967_((Entity)fireTornadoEntity);
        this.remove();
    }

    public void remove() {
        if (!this.f_19853_.f_46443_ && this.getLifespan() >= this.getTotalLife()) {
            ServerLevel serverWorld = (ServerLevel)this.f_19853_;
            for (int k = 0; k < 200; ++k) {
                float f2 = this.f_19796_.m_188501_() * 4.0f;
                float f1 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                double d1 = Mth.m_14089_((float)f1) * f2;
                double d2 = 0.01 + this.f_19796_.m_188500_() * 0.5;
                double d3 = Mth.m_14031_((float)f1) * f2;
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + d1 * 0.1, this.m_20186_() + 0.3, this.m_20189_() + d3 * 0.1, 0, d1, d2, d3, 0.5);
            }
            LivingEntity livingEntity = this.getTrueOwner();
            if (livingEntity instanceof Apostle) {
                Apostle apostle = (Apostle)livingEntity;
                apostle.setTornadoCoolDown(apostle.getTornadoCoolDown() + MathHelper.secondsToTicks(45));
            }
        }
        this.m_146870_();
    }

    private void suckInMobs(LivingEntity livingEntity) {
        ++this.spun;
        float radius = 1.0f + (float)this.spun * 0.05f;
        float knockBack = (float)Mth.m_14008_((double)(1.0 - livingEntity.m_21133_(Attributes.f_22278_)), (double)0.0, (double)1.0);
        float angle = (float)this.spun * -0.25f;
        double f0 = this.m_20185_() + (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle))));
        double f1 = this.m_20189_() + (double)(radius * Mth.m_14089_((float)angle));
        double d0 = (f0 - livingEntity.m_20185_()) * (double)knockBack;
        double d1 = (f1 - livingEntity.m_20189_()) * (double)knockBack;
        if ((this.f_36813_ != 0.0 || this.f_36814_ != 0.0 || this.f_36815_ != 0.0) && this.getTrueOwner() != null) {
            this.fakeRemove(0.0, 0.0, 0.0);
        }
        this.hurtMobs(livingEntity);
        MobUtil.twister((Entity)livingEntity, d0, 0.1 * (double)knockBack, d1);
    }

    public void hurtMobs(LivingEntity living) {
        Player player;
        if (this.getTrueOwner() != null) {
            if (this.getTrueOwner() instanceof Apostle) {
                if (living.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this.getTrueOwner()), ((Double)AttributesConfig.ApostleMagicDamage.get()).floatValue() / 1.5f)) {
                    living.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BURN_HEX.get(), 1200));
                }
            } else {
                living.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this.getTrueOwner()), 4.0f);
            }
        } else if (!living.m_5825_()) {
            living.m_6469_(this.m_269291_().m_269387_(), 4.0f);
        }
        if (living instanceof Player && (player = (Player)living).m_21254_()) {
            player.m_36384_(true);
        }
    }

    public double AreaOfEffect() {
        return 2.0;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
    }

    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (compound.m_128441_("Lifespan")) {
            this.setLifespan(compound.m_128451_("Lifespan"));
        }
        if (compound.m_128441_("TotalLife")) {
            this.setTotalLife(compound.m_128451_("TotalLife"));
        }
        if (compound.m_128441_("Spun")) {
            this.setSpun(compound.m_128451_("Spun"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getOwnerId() != null) {
            compound.m_128362_("Owner", this.getOwnerId());
        }
        compound.m_128405_("Lifespan", this.getLifespan());
        compound.m_128405_("TotalLife", this.getTotalLife());
        compound.m_128405_("Spun", this.getSpun());
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123744_;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

