/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class Fangs
extends Entity {
    private static final EntityDataAccessor<Boolean> ABSORBING = SynchedEntityData.m_135353_(Fangs.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TOTEM = SynchedEntityData.m_135353_(Fangs.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 22;
    private boolean clientSideAttackStarted;
    private int damage = 0;
    private int burning = 0;
    private int soulEater = 0;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public Fangs(EntityType<? extends Fangs> p_36923_, Level p_36924_) {
        super(p_36923_, p_36924_);
    }

    public Fangs(Level p_36926_, double p_36927_, double p_36928_, double p_36929_, float p_36930_, int p_36931_, LivingEntity p_36932_) {
        this((EntityType<? extends Fangs>)((EntityType)ModEntityType.FANG.get()), p_36926_);
        this.warmupDelayTicks = p_36931_;
        this.setOwner(p_36932_);
        this.m_146922_(p_36930_ * 57.295776f);
        this.m_6034_(p_36927_, p_36928_, p_36929_);
    }

    public Fangs(Level world, double pPosX, double pPosY, double pPosZ, float pYRot, int pWarmUp, int damage, int burning, int soulEater, LivingEntity owner) {
        this((EntityType<? extends Fangs>)((EntityType)ModEntityType.FANG.get()), world);
        this.warmupDelayTicks = pWarmUp;
        this.setOwner(owner);
        this.m_146922_(pYRot * 57.295776f);
        this.damage = damage;
        this.burning = burning;
        this.soulEater = soulEater;
        this.setTotemSpawned(true);
        this.m_6034_(pPosX, pPosY, pPosZ);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ABSORBING, (Object)false);
        this.f_19804_.m_135372_(TOTEM, (Object)false);
    }

    public boolean isAbsorbing() {
        return (Boolean)this.f_19804_.m_135370_(ABSORBING);
    }

    public void setAbsorbing(boolean absorbing) {
        this.f_19804_.m_135381_(ABSORBING, (Object)absorbing);
    }

    public boolean isTotemSpawned() {
        return (Boolean)this.f_19804_.m_135370_(TOTEM);
    }

    public void setTotemSpawned(boolean totemSpawned) {
        this.f_19804_.m_135381_(TOTEM, (Object)totemSpawned);
    }

    public int getSoulEater() {
        return this.soulEater;
    }

    public void setOwner(@Nullable LivingEntity p_36939_) {
        this.owner = p_36939_;
        this.ownerUUID = p_36939_ == null ? null : p_36939_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void m_7378_(CompoundTag pCompound) {
        this.warmupDelayTicks = pCompound.m_128451_("Warmup");
        if (pCompound.m_128441_("Damage")) {
            this.damage = pCompound.m_128451_("Damage");
        }
        if (pCompound.m_128441_("Burning")) {
            this.burning = pCompound.m_128451_("Burning");
        }
        if (pCompound.m_128441_("SoulEater")) {
            this.soulEater = pCompound.m_128451_("SoulEater");
        }
        if (pCompound.m_128441_("Absorbing")) {
            this.setAbsorbing(pCompound.m_128471_("Absorbing"));
        }
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.isTotemSpawned()) {
            pCompound.m_128405_("Damage", this.damage);
            pCompound.m_128405_("Burning", this.burning);
        }
        if (this.soulEater > 0) {
            pCompound.m_128405_("SoulEater", this.soulEater);
        }
        if (this.isAbsorbing()) {
            pCompound.m_128379_("Absorbing", this.isAbsorbing());
        }
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 14) {
                    for (int i = 0; i < 12; ++i) {
                        double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d1 = this.m_20186_() + 0.05 + this.f_19796_.m_188500_();
                        double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d3 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                        double d4 = 0.3 + this.f_19796_.m_188500_() * 0.3;
                        double d5 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, d0, d1 + 1.0, d2, d3, d4, d5);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -8) {
                for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2))) {
                    this.dealDamageTo(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.f_19853_.m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
    }

    private void dealDamageTo(LivingEntity target) {
        LivingEntity livingentity = this.getOwner();
        float baseDamage = ((Double)SpellConfig.FangDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        if (target.m_6084_() && !target.m_20147_() && target != livingentity) {
            if (livingentity == null) {
                target.m_6469_(this.m_269291_().m_269425_(), 6.0f);
            } else {
                if (target.m_7307_((Entity)livingentity)) {
                    return;
                }
                if (livingentity.m_7307_((Entity)target)) {
                    return;
                }
                if (livingentity instanceof Player) {
                    Player player = (Player)livingentity;
                    if (this.isTotemSpawned()) {
                        target.m_6469_(target.m_269291_().m_269104_((Entity)this, (Entity)livingentity), baseDamage + (float)this.damage);
                        if (this.burning > 0) {
                            target.m_20254_(5 * this.burning);
                        }
                    } else {
                        float enchantment = 0.0f;
                        int burning = 0;
                        if (WandUtil.enchantedFocus((LivingEntity)player)) {
                            enchantment = WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), (LivingEntity)player);
                            burning = WandUtil.getLevels((Enchantment)ModEnchantments.BURNING.get(), (LivingEntity)player);
                        }
                        if (target.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingentity), baseDamage + enchantment)) {
                            int soulEater = Mth.m_14045_((int)this.getSoulEater(), (int)0, (int)10);
                            SEHelper.increaseSouls(player, (Integer)SpellConfig.FangGainSouls.get() * soulEater);
                            if (burning > 0) {
                                target.m_20254_(5 * burning);
                            }
                        }
                    }
                } else {
                    target.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingentity), baseDamage);
                }
            }
        }
    }

    public void m_7822_(byte p_36935_) {
        super.m_7822_(p_36935_);
        if (p_36935_ == 4) {
            this.clientSideAttackStarted = true;
            if (!this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11865_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
            }
        }
    }

    public float getAnimationProgress(float p_36937_) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - p_36937_) / 20.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

