/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.client.CBeamPacket;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class CorruptedBeam
extends Entity
implements IEntityAdditionalSpawnData {
    public static final double MAX_RAYTRACE_DISTANCE = 256.0;
    private boolean itemBase;
    private LivingEntity owner;
    private UUID ownerUUID;
    private final float beamWidth = 0.2f;

    public CorruptedBeam(EntityType<?> p_i48580_1_, Level p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    public CorruptedBeam(EntityType<?> p_i48580_1_, Level p_i48580_2_, LivingEntity owner) {
        super(p_i48580_1_, p_i48580_2_);
        this.setOwner(owner);
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
        if (owner != null) {
            this.ownerUUID = owner.m_20148_();
            this.updatePositionAndRotation();
        }
    }

    public void m_8119_() {
        LivingEntity owner = this.getOwner();
        if (this.f_19853_.f_46443_) {
            if (this.owner instanceof Player) {
                ModNetwork.INSTANCE.sendToServer((Object)new CBeamPacket(this));
            }
            this.updatePositionAndRotation();
        }
        if (owner != null && owner.m_6084_() && ((Boolean)SpellConfig.CorruptionImmobile.get()).booleanValue()) {
            owner.m_20334_(0.0, owner.m_20184_().f_82480_, 0.0);
            owner.f_20900_ = 0.0f;
            owner.f_20902_ = 0.0f;
        }
        if (!this.f_19853_.f_46443_) {
            if (owner == null || !owner.m_6084_() || this.itemBase && !owner.m_6117_()) {
                this.m_146870_();
                return;
            }
            this.updatePositionAndRotation();
            HashSet entities = new HashSet();
            AABB aABB = new AABB(this.m_20182_(), this.m_20182_());
            Objects.requireNonNull(this);
            AABB aabb = aABB.m_82400_((double)0.2f);
            double distanceToDestination = this.beamTraceDistance(256.0, 1.0f, false);
            double distanceTraveled = 0.0;
            while (!(this.m_20182_().m_82554_(aabb.m_82399_()) > distanceToDestination) && !(this.m_20182_().m_82554_(aabb.m_82399_()) > 256.0)) {
                entities.addAll(this.f_19853_.m_6443_(LivingEntity.class, aabb, this.canHitEntity(owner)));
                Vec3 viewVector = this.m_20252_(1.0f);
                Vec3 targetVector = this.m_20182_().m_82520_(viewVector.f_82479_ * (distanceTraveled += 1.0), viewVector.f_82480_ * distanceTraveled, viewVector.f_82481_ * distanceTraveled);
                AABB aABB2 = new AABB(targetVector, targetVector);
                Objects.requireNonNull(this);
                aabb = aABB2.m_82400_((double)0.2f);
            }
            for (LivingEntity entity : entities) {
                entity.f_19802_ = 0;
                Vec3 deltaMovement = entity.m_20184_();
                float damage = ((Double)SpellConfig.CorruptedBeamDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
                if (this.getOwner() != null && WandUtil.enchantedFocus(this.getOwner())) {
                    damage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), this.getOwner()) / 2.0f;
                }
                entity.m_6469_(entity.m_269291_().m_269104_((Entity)owner, (Entity)owner), damage);
                entity.m_20256_(deltaMovement);
            }
        }
    }

    public Predicate<LivingEntity> canHitEntity(LivingEntity living) {
        return living1 -> living1 != living && living.m_142582_((Entity)living1) && living1.m_6084_() && !MobUtil.areAllies((Entity)living, (Entity)living1);
    }

    public void setItemBase(boolean itemBase) {
        this.itemBase = itemBase;
    }

    public void updatePositionAndRotation() {
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            Vec3 vec1 = owner.m_20182_();
            vec1 = vec1.m_82549_(this.getOffsetVector(owner));
            this.m_6034_(vec1.f_82479_, vec1.f_82480_, vec1.f_82481_);
            this.m_146922_(this.boundDegrees(this.owner.m_146908_()));
            this.m_146926_(this.boundDegrees(this.owner.m_146909_()));
            this.f_19859_ = this.boundDegrees(this.owner.f_19859_);
            this.f_19860_ = this.boundDegrees(this.owner.f_19860_);
        }
    }

    private float boundDegrees(float v) {
        return (v % 360.0f + 360.0f) % 360.0f;
    }

    private Vec3 getOffsetVector(LivingEntity living) {
        Vec3 viewVector = this.m_20252_(1.0f);
        return new Vec3(viewVector.f_82479_, (double)living.m_20192_() * 0.8, viewVector.f_82481_);
    }

    public float getBeamWidth() {
        return this.beamWidth;
    }

    public final Vec3 getWorldPosition(float p_242282_1_) {
        double d0 = Mth.m_14139_((double)p_242282_1_, (double)this.f_19854_, (double)this.m_20185_());
        double d1 = Mth.m_14139_((double)p_242282_1_, (double)this.f_19855_, (double)this.m_20186_());
        double d2 = Mth.m_14139_((double)p_242282_1_, (double)this.f_19856_, (double)this.m_20189_());
        return new Vec3(d0, d1, d2);
    }

    public HitResult beamTraceResult(double distance, float ticks, boolean passesWater) {
        Vec3 vector3d = this.getWorldPosition(ticks);
        Vec3 vector3d1 = this.m_20252_(ticks);
        Vec3 vector3d2 = vector3d.m_82520_(vector3d1.f_82479_ * distance, vector3d1.f_82480_ * distance, vector3d1.f_82481_ * distance);
        return this.f_19853_.m_45547_(new ClipContext(vector3d, vector3d2, ClipContext.Block.COLLIDER, passesWater ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)this));
    }

    public double beamTraceDistance(double distance, float ticks, boolean passesWater) {
        HitResult rayTraceResult = this.beamTraceResult(distance, ticks, passesWater);
        double distanceToDestination = 256.0;
        if (rayTraceResult instanceof BlockHitResult) {
            BlockPos collision = ((BlockHitResult)rayTraceResult).m_82425_();
            Vec3 destination = new Vec3((double)collision.m_123341_(), (double)collision.m_123342_(), (double)collision.m_123343_());
            distanceToDestination = this.m_20182_().m_82554_(destination);
        }
        return distanceToDestination;
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.owner == null && this.ownerUUID != null) {
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Entity entity = serverLevel.m_8791_(this.ownerUUID);
                if (entity instanceof LivingEntity) {
                    this.owner = (LivingEntity)entity;
                }
            } else if (this.f_19853_.f_46443_) {
                this.owner = this.f_19853_.m_46003_(this.ownerUUID);
            }
        }
        return this.owner;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
        if (pCompound.m_128441_("ItemBase")) {
            this.itemBase = pCompound.m_128471_("ItemBase");
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
        pCompound.m_128379_("ItemBase", this.itemBase);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        if (this.ownerUUID != null) {
            buffer.m_130077_(this.ownerUUID);
        }
        buffer.writeBoolean(this.itemBase);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.ownerUUID = additionalData.m_130259_();
        this.itemBase = additionalData.readBoolean();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

