/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;

public class Wartling
extends Summoned {
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(Wartling.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> MEGA = SynchedEntityData.m_135353_(Wartling.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int searchTime;
    private MobEffectInstance effect;

    public Wartling(EntityType<? extends Summoned> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    @Override
    public void m_8119_() {
        if (!this.f_19853_.f_46443_) {
            boolean flag;
            int i;
            ServerLevel serverLevel = (ServerLevel)this.f_19853_;
            this.setClimbing(this.f_19862_);
            if (this.getStoredEffect() != null && (i = Wartling.getColor(this.getStoredEffect())) > 0 && (flag = this.m_20145_() ? this.f_19796_.m_188503_(15) == 0 : this.f_19796_.m_188499_())) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0, d0, d1, d2, 0.5);
            }
        }
        super.m_8119_();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new AvoidOwnerGoal(this, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 10.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 2.0);
    }

    @Override
    public int xpReward() {
        return 1;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
        this.f_19804_.m_135372_(MEGA, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag p_21145_) {
        super.m_7380_(p_21145_);
        if (this.getStoredEffect() != null) {
            p_21145_.m_128365_("StoredEffect", (Tag)this.getStoredEffect().m_19555_(new CompoundTag()));
        }
        p_21145_.m_128405_("SearchTime", this.searchTime);
        p_21145_.m_128379_("Mega", this.isMega());
    }

    @Override
    public void m_7378_(CompoundTag p_21096_) {
        super.m_7378_(p_21096_);
        if (p_21096_.m_128441_("StoredEffect")) {
            this.setStoredEffect(MobEffectInstance.m_19560_((CompoundTag)p_21096_.m_128469_("StoredEffect")));
        }
        this.searchTime = p_21096_.m_128451_("SearchTime");
        if (p_21096_.m_128471_("Mega")) {
            this.setMega();
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_33134_) {
        if (MEGA.equals(p_33134_)) {
            this.m_6210_();
        }
        super.m_7350_(p_33134_);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12432_;
    }

    public float m_6100_() {
        return super.m_6100_() * 1.5f;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12434_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public boolean isMega() {
        return (Boolean)this.f_19804_.m_135370_(MEGA);
    }

    public void setMega() {
        this.f_19804_.m_135381_(MEGA, (Object)true);
        AttributeInstance attack = this.m_21051_(Attributes.f_22281_);
        AttributeInstance health = this.m_21051_(Attributes.f_22276_);
        if (attack != null) {
            attack.m_22100_(4.0);
        }
        if (health != null) {
            health.m_22100_(8.0);
            this.m_21153_(8.0f);
        }
    }

    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    public void m_7601_(BlockState state, Vec3 motionMultiplierIn) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, motionMultiplierIn);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_6138_() {
    }

    @Override
    public void m_7334_(Entity p_20293_) {
    }

    public boolean m_6094_() {
        return false;
    }

    @Override
    public boolean m_7337_(Entity p_20303_) {
        return p_20303_ != this.getTrueOwner();
    }

    public boolean m_5829_() {
        return false;
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        if (this.isMega() && entityIn instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityIn;
            if (this.getStoredEffect() != null) {
                if (!this.getStoredEffect().m_19544_().m_19486_()) {
                    livingEntity.m_7292_(this.getStoredEffect());
                }
            } else if (!livingEntity.m_21220_().isEmpty()) {
                livingEntity.m_21220_().stream().filter(mobEffect -> mobEffect.m_19544_().m_19486_() && !mobEffect.m_19544_().getCurativeItems().isEmpty()).findFirst().ifPresent(effect -> {
                    this.setStoredEffect((MobEffectInstance)effect);
                    livingEntity.m_21195_(effect.m_19544_());
                    this.m_216990_((SoundEvent)ModSounds.SPIDER_BITE.get());
                });
            }
        }
        return super.m_7327_(entityIn);
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        if (!this.f_19853_.f_46443_ && this.getStoredEffect() != null) {
            AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaEffectCloud.m_19712_(1.0f);
            areaEffectCloud.m_19740_(0);
            areaEffectCloud.m_19734_(MathHelper.secondsToTicks(2));
            areaEffectCloud.m_19716_(this.getStoredEffect());
            this.f_19853_.m_7967_((Entity)areaEffectCloud);
        }
    }

    @Override
    public void lifeSpanDamage() {
        if (this.getTrueOwner() != null && this.getTrueOwner().m_6084_() && !this.getTrueOwner().m_21224_() && (this.getStoredEffect() == null || this.getStoredEffect().m_19544_().m_19486_())) {
            this.m_21573_().m_5624_((Entity)this.getTrueOwner(), 1.25);
            this.m_6710_(null);
            ++this.searchTime;
            if (this.m_20191_().m_82381_(this.getTrueOwner().m_20191_())) {
                this.getTrueOwner().m_5634_(this.m_21223_());
                for (MobEffectInstance mobEffectInstance : this.m_21220_()) {
                    if (!mobEffectInstance.m_19544_().m_19486_()) continue;
                    this.getTrueOwner().m_7292_(mobEffectInstance);
                }
                if (this.getStoredEffect() != null && this.getStoredEffect().m_19544_().m_19486_()) {
                    this.getTrueOwner().m_7292_(this.getStoredEffect());
                }
                this.m_5496_(SoundEvents.f_215753_, 1.0f, 1.0f);
                if (!this.f_19853_.f_46443_) {
                    this.f_19853_.m_7605_((Entity)this, (byte)15);
                }
                this.m_146870_();
            } else if (this.searchTime >= MathHelper.secondsToTicks(5)) {
                this.m_6469_(this.m_269291_().m_269064_(), this.m_21233_());
            }
        } else {
            this.limitedLifeTicks = 20;
            this.m_6469_(this.m_269291_().m_269064_(), this.m_21233_());
        }
    }

    @Override
    public boolean m_7301_(MobEffectInstance potionEffectIn) {
        if (potionEffectIn.m_19544_() == MobEffects.f_19614_) {
            MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((LivingEntity)this, potionEffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        if (this.getStoredEffect() != null) {
            return potionEffectIn.m_19544_() != this.getStoredEffect().m_19544_() && super.m_7301_(potionEffectIn);
        }
        return super.m_7301_(potionEffectIn);
    }

    public void setStoredEffect(MobEffectInstance effect) {
        this.effect = effect;
    }

    public MobEffectInstance getStoredEffect() {
        return this.effect;
    }

    public static int getColor(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance == null) {
            return 3694022;
        }
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int j = 0;
        int k = mobEffectInstance.m_19544_().m_19484_();
        int l = mobEffectInstance.m_19564_() + 1;
        f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
        f1 += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
        f2 += (float)(l * (k >> 0 & 0xFF)) / 255.0f;
        if ((j += l) == 0) {
            return 0;
        }
        f = f / (float)j * 255.0f;
        f1 = f1 / (float)j * 255.0f;
        f2 = f2 / (float)j * 255.0f;
        return (int)f << 16 | (int)f1 << 8 | (int)f2;
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING, (Object)b0);
    }

    public void m_7822_(byte p_34138_) {
        if (p_34138_ == 15) {
            for (int i = 0; i < this.f_19796_.m_188503_(35) + 10; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.CULT_SPELL.get(), this.m_20185_() + this.f_19796_.m_188583_() * (double)0.13f, this.m_20186_() + this.f_19796_.m_188583_() * (double)0.13f, this.m_20189_() + this.f_19796_.m_188583_() * (double)0.13f, 1.0, 1.0, 1.0);
            }
        } else {
            super.m_7822_(p_34138_);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return spawnDataIn;
    }

    public EntityDimensions m_6972_(Pose p_33113_) {
        EntityDimensions entitydimensions = super.m_6972_(p_33113_);
        return this.isMega() ? entitydimensions.m_20388_(2.0f) : super.m_6972_(p_33113_);
    }

    public static class AvoidOwnerGoal
    extends Goal {
        protected final Wartling mob;
        private final double walkSpeedModifier;
        private final double sprintSpeedModifier;
        protected final float maxDist;
        @Nullable
        protected Path path;
        protected final PathNavigation pathNav;

        public AvoidOwnerGoal(Wartling p_25040_, float p_25043_, double p_25044_, double p_25045_) {
            this.mob = p_25040_;
            this.maxDist = p_25043_;
            this.walkSpeedModifier = p_25044_;
            this.sprintSpeedModifier = p_25045_;
            this.pathNav = p_25040_.m_21573_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.getTrueOwner() == null || this.mob.getTrueOwner().m_21224_()) {
                return false;
            }
            Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)this.mob.getTrueOwner().m_20182_());
            if (vec3 == null) {
                return false;
            }
            if (this.mob.getTrueOwner().m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.mob.getTrueOwner().m_20280_((Entity)this.mob)) {
                return false;
            }
            this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
            return this.path != null && this.mob.getStoredEffect() != null && this.mob.getStoredEffect().m_19544_().m_19483_() != MobEffectCategory.BENEFICIAL && this.mob.m_5448_() == null;
        }

        public boolean m_8045_() {
            return !this.pathNav.m_26571_() && this.mob.getTrueOwner() != null && this.mob.getTrueOwner().m_6084_();
        }

        public void m_8056_() {
            this.pathNav.m_26536_(this.path, this.walkSpeedModifier);
        }

        public void m_8041_() {
            this.pathNav.m_26573_();
        }

        public void m_8037_() {
            if (this.mob.getTrueOwner() != null) {
                if (this.mob.m_20280_((Entity)this.mob.getTrueOwner()) < 49.0) {
                    this.mob.m_21573_().m_26517_(this.sprintSpeedModifier);
                } else {
                    this.mob.m_21573_().m_26517_(this.walkSpeedModifier);
                }
            }
        }
    }
}

