/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.Pyroclast;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Volcano
extends AbstractMonolith {
    public float explosionPower = 1.5f;
    public int potency = 0;
    public int flaming = 0;
    private int attackStep;
    private int attackTime = MathHelper.secondsToTicks(2);

    public Volcano(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (this.canSpawn((Level)pLevel.m_6018_())) {
            this.m_5496_((SoundEvent)ModSounds.RUMBLE.get(), 2.0f, 1.0f);
            this.m_5496_((SoundEvent)ModSounds.WALL_ERUPT.get(), 1.0f, 1.0f);
        }
        return pSpawnData;
    }

    public void setExplosionPower(float pExplosionPower) {
        this.explosionPower = pExplosionPower;
    }

    public float getExplosionPower() {
        return this.explosionPower;
    }

    public void setPotency(int potency) {
        this.potency = potency;
    }

    public int getPotency() {
        return this.potency;
    }

    public void setFlaming(int flaming) {
        this.flaming = flaming;
    }

    public int getFlaming() {
        return this.flaming;
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("ExplosionPower", this.getExplosionPower());
        pCompound.m_128405_("Potency", this.getPotency());
        pCompound.m_128405_("Flaming", this.getFlaming());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("ExplosionPower")) {
            this.setExplosionPower(pCompound.m_128457_("ExplosionPower"));
        }
        if (pCompound.m_128441_("Potency")) {
            this.setPotency(pCompound.m_128451_("Potency"));
        }
        if (pCompound.m_128441_("Flaming")) {
            this.setFlaming(pCompound.m_128451_("Flaming"));
        }
    }

    @Override
    protected void m_7324_(Entity p_20971_) {
    }

    @Override
    public boolean m_7337_(Entity p_20303_) {
        return false;
    }

    @Override
    public BlockState getState() {
        return Blocks.f_50730_.m_49966_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return pSource.m_269533_(DamageTypeTags.f_268738_);
    }

    @Override
    public boolean m_5829_() {
        return false;
    }

    @Override
    public int getAgeSpeed() {
        return 5;
    }

    @Override
    public boolean canSpawn(Level level) {
        return true;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.isEmerging()) {
            if (!this.isActivate()) {
                this.setActivate(true);
            }
            if (!this.f_19853_.f_46443_) {
                --this.attackTime;
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep <= 8) {
                        this.attackTime = 5;
                    } else {
                        this.attackTime = 80;
                        this.attackStep = 0;
                    }
                    if (this.attackStep > 1) {
                        Level level;
                        if (!this.m_20067_()) {
                            this.f_19853_.m_5898_((Player)null, 1018, this.m_20183_(), 0);
                        }
                        if ((level = this.f_19853_) instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            double d0 = this.m_20185_() + this.f_19796_.m_188500_();
                            double d1 = this.m_20186_() + 1.0;
                            double d2 = this.m_20189_() + this.f_19796_.m_188500_();
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, d0, d1, d2, 0, 0.0, 0.0, 0.0, 0.5);
                        }
                        Pyroclast pyroclast = new Pyroclast((LivingEntity)this, this.f_19853_);
                        if (this.getTrueOwner() != null) {
                            pyroclast.m_5602_((Entity)this.getTrueOwner());
                        } else {
                            pyroclast.m_5602_((Entity)this);
                        }
                        pyroclast.setExplosionPower(this.getExplosionPower());
                        pyroclast.setPotency(this.getPotency());
                        pyroclast.setFlaming(this.getFlaming());
                        MobUtil.shootUp((Projectile)pyroclast, (LivingEntity)this, MobUtil.ceilingVelocity((LivingEntity)this, 1.5f));
                    }
                } else {
                    Level d0 = this.f_19853_;
                    if (d0 instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)d0;
                        ServerParticleUtil.smokeParticles((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Level)serverLevel);
                        if (this.f_19796_.m_188503_(100) == 0) {
                            double d02 = this.m_20185_() + this.f_19796_.m_188500_();
                            double d1 = this.m_20186_() + 1.0;
                            double d2 = this.m_20189_() + this.f_19796_.m_188500_();
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, d02, d1, d2, 0, 0.0, 0.0, 0.0, 0.5);
                            this.m_5496_(SoundEvents.f_12032_, 0.2f + this.f_19796_.m_188501_() * 0.2f, 0.9f + this.f_19796_.m_188501_() * 0.15f);
                        }
                        if (this.f_19796_.m_188503_(200) == 0) {
                            this.m_5496_(SoundEvents.f_12030_, 0.2f + this.f_19796_.m_188501_() * 0.2f, 0.9f + this.f_19796_.m_188501_() * 0.15f);
                        }
                    }
                }
                if (this.f_19797_ >= MathHelper.secondsToTicks(this.getLifeSpan())) {
                    this.setAge(this.getAge() - this.getAgeSpeed());
                    this.f_19853_.m_7605_((Entity)this, (byte)5);
                }
                if (this.getAge() <= 0) {
                    this.m_146870_();
                }
            }
            this.m_6853_(true);
            if (this.f_19797_ == MathHelper.secondsToTicks(this.getLifeSpan())) {
                this.m_5496_((SoundEvent)ModSounds.RUMBLE.get(), 2.0f, 1.0f);
            }
        }
    }
}

