/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.utils.EntityFinder;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VampireBat
extends Bat
implements IOwned {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(VampireBat.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Optional<UUID>> TARGET_ID = SynchedEntityData.m_135353_(VampireBat.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    @Nullable
    private BlockPos targetPosition;

    public VampireBat(EntityType<? extends Bat> p_27412_, Level p_27413_) {
        super(p_27412_, p_27413_);
        this.m_27456_(false);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(TARGET_ID, Optional.empty());
    }

    public void m_7378_(CompoundTag compound) {
        UUID uuid2;
        UUID uuid;
        super.m_7378_(compound);
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable s) {
                // empty catch block
            }
        }
        if (compound.m_128403_("Target")) {
            uuid2 = compound.m_128342_("Target");
        } else {
            String s = compound.m_128461_("Target");
            uuid2 = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid2 != null) {
            try {
                this.setTargetId(uuid2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getOwnerId() != null) {
            compound.m_128362_("Owner", this.getOwnerId());
        }
        if (this.getTargetId() != null) {
            compound.m_128362_("Target", this.getTargetId());
        }
    }

    @Override
    public LivingEntity getTrueOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    @Override
    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    @Override
    public void setTrueOwner(LivingEntity livingEntity) {
        this.setOwnerId(livingEntity.m_20148_());
    }

    @Override
    public void setHostile(boolean hostile) {
    }

    @Override
    public boolean isHostile() {
        return !(this.getTrueOwner() instanceof Player);
    }

    public LivingEntity m_5448_() {
        try {
            UUID uuid = this.getTargetId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getTargetId() {
        return ((Optional)this.f_19804_.m_135370_(TARGET_ID)).orElse(null);
    }

    public void setTargetId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(TARGET_ID, Optional.ofNullable(p_184754_1_));
    }

    public void m_6710_(LivingEntity livingEntity) {
        if (livingEntity != null && EntitySelector.f_20406_.test(livingEntity)) {
            this.setTargetId(livingEntity.m_20148_());
        }
    }

    protected void m_7324_(Entity entity) {
        LivingEntity livingEntity;
        if (!this.f_19853_.f_46443_ && entity instanceof LivingEntity && !((livingEntity = (LivingEntity)entity) instanceof Bat) && livingEntity != this.getTrueOwner()) {
            livingEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
            this.callBats(livingEntity);
        }
    }

    protected void m_6138_() {
        List list = this.f_19853_.m_6249_((Entity)this, this.m_20191_(), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                this.m_7324_(entity);
            }
        }
    }

    public boolean m_6469_(DamageSource p_27424_, float p_27425_) {
        Entity entity = p_27424_.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.m_5448_() == null && living != this.getTrueOwner() && !(living instanceof Bat)) {
                this.m_6710_(living);
                this.callBats(living);
            }
        }
        return super.m_6469_(p_27424_, p_27425_);
    }

    public void callBats(LivingEntity livingEntity) {
        for (VampireBat vampireBat : this.f_19853_.m_45976_(VampireBat.class, this.m_20191_().m_82400_(10.0))) {
            if (vampireBat.m_5448_() != null || livingEntity == this.getTrueOwner() || livingEntity instanceof Bat) continue;
            vampireBat.m_6710_(livingEntity);
        }
    }

    protected void m_8024_() {
        BlockPos blockPos;
        if (!(this.targetPosition == null || this.f_19853_.m_46859_(this.targetPosition) && this.targetPosition.m_123342_() > this.f_19853_.m_141937_())) {
            this.targetPosition = null;
        }
        if (this.targetPosition == null || this.f_19796_.m_188503_(30) == 0 || this.targetPosition.m_203195_((Position)this.m_20182_(), 2.0)) {
            if (this.m_5448_() != null && this.m_5448_().m_6084_()) {
                blockPos = BlockPos.m_274446_((Position)this.m_5448_().m_146892_());
                this.targetPosition = blockPos.m_7918_(this.f_19796_.m_188503_(2) - this.f_19796_.m_188503_(2), this.f_19796_.m_188503_(2), this.f_19796_.m_188503_(2) - this.f_19796_.m_188503_(2));
            } else {
                this.targetPosition = BlockPos.m_274561_((double)(this.m_20185_() + (double)this.f_19796_.m_188503_(7) - (double)this.f_19796_.m_188503_(7)), (double)(this.m_20186_() + (double)this.f_19796_.m_188503_(6) - 2.0), (double)(this.m_20189_() + (double)this.f_19796_.m_188503_(7) - (double)this.f_19796_.m_188503_(7)));
            }
        }
        if ((blockPos = this.targetPosition) != null) {
            double d0 = (double)blockPos.m_123341_() + 0.5 - this.m_20185_();
            double d1 = (double)blockPos.m_123342_() + 0.1 - this.m_20186_();
            double d2 = (double)blockPos.m_123343_() + 0.5 - this.m_20189_();
            Vec3 vec3 = this.m_20184_();
            Vec3 vec31 = vec3.m_82520_((Math.signum(d0) * 0.5 - vec3.f_82479_) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3.f_82480_) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3.f_82481_) * (double)0.1f);
            this.m_20256_(vec31);
            float f = (float)(Mth.m_14136_((double)vec31.f_82481_, (double)vec31.f_82479_) * 57.2957763671875) - 90.0f;
            float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
            this.f_20902_ = 0.5f;
            this.m_146922_(this.m_146908_() + f1);
        }
    }
}

