/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.client.particles.ShockwaveParticleOption;
import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class TotemicBomb
extends AbstractMonolith {
    public float explosionPower = 2.0f;

    public TotemicBomb(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public void m_7380_(CompoundTag p_31485_) {
        super.m_7380_(p_31485_);
        p_31485_.m_128350_("ExplosionPower", this.getExplosionPower());
    }

    @Override
    public void m_7378_(CompoundTag p_31474_) {
        super.m_7378_(p_31474_);
        if (p_31474_.m_128441_("ExplosionPower")) {
            this.setExplosionPower(p_31474_.m_128457_("ExplosionPower"));
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (this.canSpawn((Level)pLevel.m_6018_())) {
            this.m_5496_((SoundEvent)ModSounds.BOMB_SPAWN.get(), 2.0f, 1.0f);
            ServerLevel serverLevel = pLevel.m_6018_();
            for (int i = 0; i < serverLevel.f_46441_.m_188503_(35) + 10; ++i) {
                ServerParticleUtil.smokeParticles((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Level)serverLevel);
            }
        }
        return pSpawnData;
    }

    @Override
    public BlockState getState() {
        return Blocks.f_50069_.m_49966_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!pSource.m_269533_(DamageTypeTags.f_268490_)) {
            this.m_216990_((SoundEvent)ModSounds.BOMB_SPARKLE.get());
        }
        return pSource.m_269533_(DamageTypeTags.f_268738_);
    }

    @Override
    public int getAgeSpeed() {
        return 5;
    }

    @Override
    public int getLifeSpan() {
        return 5;
    }

    public float getExplosionPower() {
        return this.explosionPower;
    }

    public void setExplosionPower(float explosionPower) {
        this.explosionPower = explosionPower;
    }

    private void explode() {
        if (!this.f_19853_.f_46443_) {
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)new ShockwaveParticleOption(0), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
            }
            this.f_20890_ = true;
            this.f_19853_.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionPower, Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.isEmerging()) {
            if (!this.isActivate()) {
                this.setActivate(true);
                this.m_5496_((SoundEvent)ModSounds.BOMB_LOAD.get(), 2.0f, 1.0f);
            }
            if (this.f_19797_ == MathHelper.secondsToTicks(1)) {
                this.m_5496_((SoundEvent)ModSounds.BOMB_FUSE.get(), 2.0f, 1.0f);
            }
            if (this.f_19797_ == MathHelper.secondsToTicks(this.getLifeSpan() - 2)) {
                this.m_5496_((SoundEvent)ModSounds.BOMB_PULSE.get(), 2.0f, 1.0f);
            }
            if (this.f_19797_ >= MathHelper.secondsToTicks(this.getLifeSpan())) {
                this.explode();
            }
        }
    }
}

