/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.MobsConfig;
import com.Polarice3.Goety.api.entities.ICustomAttributes;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.entities.hostile.IBoss;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.Tags;

public class Owned
extends PathfinderMob
implements IOwned,
OwnableEntity,
ICustomAttributes {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(Owned.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> OWNER_CLIENT_ID = SynchedEntityData.m_135353_(Owned.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> HOSTILE = SynchedEntityData.m_135353_(Owned.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> NATURAL = SynchedEntityData.m_135353_(Owned.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final NearestAttackableTargetGoal<Player> targetGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
    public boolean limitedLifespan;
    public int limitedLifeTicks;

    protected Owned(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.checkHostility();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal(this));
    }

    @Override
    public void setConfigurableAttributes() {
    }

    public void checkHostility() {
        if (!this.f_19853_.f_46443_) {
            IOwned owned;
            LivingEntity livingEntity;
            if (this.getTrueOwner() instanceof Enemy) {
                this.setHostile(true);
            }
            if ((livingEntity = this.getTrueOwner()) instanceof IOwned && (owned = (IOwned)livingEntity).isHostile()) {
                this.setHostile(true);
            }
            if (this instanceof Enemy) {
                this.setHostile(true);
            }
        }
    }

    public void m_8107_() {
        this.m_21203_();
        if (this.isHostile()) {
            this.updateNoActionTime();
        }
        super.m_8107_();
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity livingEntity = this.m_5448_();
        if (livingEntity instanceof IOwned) {
            IOwned ownedEntity = (IOwned)livingEntity;
            if (this.getTrueOwner() != null && ownedEntity.getTrueOwner() == this.getTrueOwner()) {
                this.m_6710_(null);
                if (this.m_21188_() == ownedEntity) {
                    this.m_6703_(null);
                }
            }
            if (ownedEntity.getTrueOwner() == this) {
                this.m_6710_(null);
                if (this.m_21188_() == ownedEntity) {
                    this.m_6703_(null);
                }
            }
            if (MobUtil.ownerStack(this, ownedEntity)) {
                this.m_6710_(null);
                if (this.m_21188_() == ownedEntity) {
                    this.m_6703_(null);
                }
            }
        }
        if (this.getTrueOwner() != null) {
            if (this.m_21188_() == this.getTrueOwner()) {
                this.m_6703_(null);
            }
            if ((livingEntity = this.getTrueOwner()) instanceof Mob) {
                Mob mobOwner = (Mob)livingEntity;
                if (mobOwner.m_5448_() != null && this.m_5448_() == null) {
                    this.m_6710_(mobOwner.m_5448_());
                }
                if ((mobOwner instanceof IBoss || mobOwner.m_6095_().m_204039_(Tags.EntityTypes.BOSSES)) && (mobOwner.m_213877_() || mobOwner.m_21224_())) {
                    this.m_6074_();
                }
            }
            if ((livingEntity = this.getTrueOwner()) instanceof IOwned) {
                IOwned owned = (IOwned)livingEntity;
                if (this.getTrueOwner().m_21224_() || !this.getTrueOwner().m_6084_()) {
                    if (owned.getTrueOwner() != null) {
                        this.setTrueOwner(owned.getTrueOwner());
                    } else if (!(this.isHostile() || this.isNatural() || owned instanceof Enemy || owned.isHostile())) {
                        this.m_6074_();
                    }
                }
            }
            for (Owned target : this.f_19853_.m_45976_(Owned.class, this.m_20191_().m_82400_(this.m_21133_(Attributes.f_22277_)))) {
                if (this.getTrueOwner() == target.getTrueOwner() || target.m_5448_() != this.getTrueOwner()) continue;
                this.m_6710_((LivingEntity)target);
            }
        }
        if (this.m_5448_() != null && (this.m_5448_().m_213877_() || this.m_5448_().m_21224_())) {
            this.m_6710_(null);
        }
        this.mobSense();
        if (this.limitedLifespan && --this.limitedLifeTicks <= 0) {
            this.lifeSpanDamage();
        }
    }

    public void mobSense() {
        Mob mob;
        LivingEntity livingEntity;
        if (((Boolean)MobsConfig.MobSense.get()).booleanValue() && this.m_6084_() && this.m_5448_() != null && (livingEntity = this.m_5448_()) instanceof Mob && ((mob = (Mob)livingEntity).m_5448_() == null || mob.m_5448_().m_21224_())) {
            mob.m_6710_((LivingEntity)this);
        }
    }

    protected void updateNoActionTime() {
        float f = this.m_213856_();
        if (f > 0.5f) {
            this.f_20891_ += 2;
        }
    }

    public void lifeSpanDamage() {
        this.limitedLifeTicks = 20;
        this.m_6469_(this.m_269291_().m_269064_(), 1.0f);
    }

    public boolean m_7327_(Entity entity) {
        if (this.getTrueOwner() != null) {
            boolean flag;
            int i;
            float f = (float)this.m_21133_(Attributes.f_22281_);
            float f1 = (float)this.m_21133_(Attributes.f_22282_);
            if (entity instanceof LivingEntity) {
                f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entity).m_6336_());
                f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
            }
            if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
                entity.m_20254_(i * 4);
            }
            if (flag = entity.m_6469_(ModDamageSource.summonAttack((LivingEntity)this, this.getTrueOwner()), f)) {
                if (f1 > 0.0f && entity instanceof LivingEntity) {
                    ((LivingEntity)entity).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                    this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    this.m_21424_(player, this.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
                }
                this.m_19970_((LivingEntity)this, entity);
                this.m_21335_(entity);
            }
            return flag;
        }
        return super.m_7327_(entity);
    }

    public void m_21424_(Player player, ItemStack axe, ItemStack shield) {
        if (!axe.m_41619_() && !shield.m_41619_() && axe.m_41720_() instanceof AxeItem && shield.m_150930_(Items.f_42740_)) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                player.m_36335_().m_41524_(Items.f_42740_, 100);
                this.f_19853_.m_7605_((Entity)player, (byte)30);
            }
        }
    }

    public Team m_5647_() {
        LivingEntity livingentity;
        if (this.getTrueOwner() != null && (livingentity = this.getTrueOwner()) != null) {
            return livingentity.m_5647_();
        }
        return super.m_5647_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_7307_(Entity entityIn) {
        if (this.getTrueOwner() == null) return super.m_7307_(entityIn);
        LivingEntity trueOwner = this.getTrueOwner();
        if (trueOwner.m_7307_(entityIn)) return true;
        if (entityIn.m_7307_((Entity)trueOwner)) return true;
        if (entityIn == trueOwner) return true;
        if (entityIn instanceof IOwned) {
            IOwned owned = (IOwned)entityIn;
            if (MobUtil.ownerStack(this, owned)) return true;
        }
        if (entityIn instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entityIn;
            if (ownable.m_269323_() == trueOwner) return true;
        }
        if (!(trueOwner instanceof Player)) return false;
        Player player = (Player)trueOwner;
        if (!(entityIn instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)entityIn;
        if (SEHelper.getAllyEntities(player).contains(livingEntity)) return true;
        if (!SEHelper.getAllyEntityTypes(player).contains(livingEntity.m_6095_())) return false;
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(OWNER_CLIENT_ID, (Object)-1);
        this.f_19804_.m_135372_(HOSTILE, (Object)false);
        this.f_19804_.m_135372_(NATURAL, (Object)false);
    }

    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (compound.m_128441_("OwnerClient")) {
            this.setOwnerClientId(compound.m_128451_("OwnerClient"));
        }
        if (compound.m_128441_("isHostile")) {
            this.setHostile(compound.m_128471_("isHostile"));
        } else {
            this.checkHostility();
        }
        if (compound.m_128441_("isNatural")) {
            this.setNatural(compound.m_128471_("isNatural"));
        }
        if (compound.m_128441_("LifeTicks")) {
            this.setLimitedLife(compound.m_128451_("LifeTicks"));
        }
        this.setConfigurableAttributes();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getOwnerId() != null) {
            compound.m_128362_("Owner", this.getOwnerId());
        }
        if (this.getOwnerClientId() > -1) {
            compound.m_128405_("OwnerClient", this.getOwnerClientId());
        }
        if (this.isHostile()) {
            compound.m_128379_("isHostile", this.isHostile());
        }
        if (this.isNatural()) {
            compound.m_128379_("isNatural", this.isNatural());
        }
        if (this.limitedLifespan) {
            compound.m_128405_("LifeTicks", this.limitedLifeTicks);
        }
    }

    public void setLimitedLife(int limitedLifeTicksIn) {
        this.limitedLifespan = true;
        this.limitedLifeTicks = limitedLifeTicksIn;
    }

    @Override
    public void convertNewEquipment(Entity entity) {
        this.m_213945_(this.f_19796_, this.f_19853_.m_6436_(this.m_20183_()));
    }

    @Override
    @Nullable
    public EntityType<?> getVariant(Level level, BlockPos blockPos) {
        return this.m_6095_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.checkHostility();
        if (pReason != MobSpawnType.MOB_SUMMONED && this.getTrueOwner() == null) {
            this.setNatural(true);
        }
        return pSpawnData;
    }

    @Override
    public LivingEntity getTrueOwner() {
        LivingEntity living;
        if (!this.f_19853_.f_46443_) {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
        }
        Entity entity = this.f_19853_.m_6815_(this.getOwnerClientId());
        return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    @Override
    public LivingEntity getMasterOwner() {
        LivingEntity livingEntity = this.getTrueOwner();
        if (livingEntity instanceof IOwned) {
            IOwned owned = (IOwned)livingEntity;
            return owned.getTrueOwner();
        }
        return null;
    }

    @Nullable
    public UUID m_21805_() {
        return this.getOwnerId();
    }

    public LivingEntity m_269323_() {
        return this.getTrueOwner();
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    @Override
    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public int getOwnerClientId() {
        return (Integer)this.f_19804_.m_135370_(OWNER_CLIENT_ID);
    }

    public void setOwnerClientId(int id) {
        this.f_19804_.m_135381_(OWNER_CLIENT_ID, (Object)id);
    }

    @Override
    public void setTrueOwner(LivingEntity livingEntity) {
        this.setOwnerId(livingEntity.m_20148_());
        this.setOwnerClientId(livingEntity.m_19879_());
    }

    @Override
    public void setHostile(boolean hostile) {
        this.f_19804_.m_135381_(HOSTILE, (Object)hostile);
        this.addTargetGoal();
    }

    public void addTargetGoal() {
        this.f_21346_.m_25352_(2, this.targetGoal);
    }

    @Override
    public boolean isHostile() {
        return (Boolean)this.f_19804_.m_135370_(HOSTILE);
    }

    public void setNatural(boolean natural) {
        this.f_19804_.m_135381_(NATURAL, (Object)natural);
    }

    public boolean isNatural() {
        return (Boolean)this.f_19804_.m_135370_(NATURAL);
    }

    public boolean m_7301_(MobEffectInstance pPotioneffect) {
        return pPotioneffect.m_19544_() != GoetyEffects.GOLD_TOUCHED.get() && super.m_7301_(pPotioneffect);
    }

    public int m_213860_() {
        if (this.isHostile()) {
            this.f_21364_ = this.xpReward();
        }
        return super.m_213860_();
    }

    public int xpReward() {
        return 5;
    }

    public void m_7334_(Entity p_21294_) {
        if (!this.f_19853_.f_46443_ && p_21294_ != this.getTrueOwner()) {
            super.m_7334_(p_21294_);
        }
    }

    protected void m_7324_(Entity p_20971_) {
        if (!this.f_19853_.f_46443_ && p_20971_ != this.getTrueOwner()) {
            super.m_7324_(p_20971_);
        }
    }

    public boolean m_7337_(Entity p_20303_) {
        if (p_20303_ != this.getTrueOwner()) {
            return super.m_7337_(p_20303_);
        }
        return false;
    }

    protected boolean m_8028_() {
        return this.isHostile();
    }

    public boolean m_6785_(double p_27519_) {
        return this.isHostile();
    }

    public static boolean checkHostileSpawnRules(EntityType<? extends Owned> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)pLevel, (BlockPos)pPos, (RandomSource)pRandom) && Owned.m_217057_(pType, (LevelAccessor)pLevel, (MobSpawnType)pReason, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public boolean isChargingCrossbow() {
        return false;
    }

    public class OwnerHurtByTargetGoal
    extends TargetGoal {
        private LivingEntity attacker;
        private int timestamp;

        public OwnerHurtByTargetGoal(Owned summonedEntity) {
            super((Mob)summonedEntity, false);
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = Owned.this.getTrueOwner();
            if (livingentity == null) {
                return false;
            }
            this.attacker = livingentity.m_21188_();
            int i = livingentity.m_21213_();
            return i != this.timestamp && this.m_26150_(this.attacker, TargetingConditions.f_26872_) && this.attacker != Owned.this.getTrueOwner();
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.attacker);
            LivingEntity livingentity = Owned.this.getTrueOwner();
            if (livingentity != null) {
                this.timestamp = livingentity.m_21213_();
            }
            super.m_8056_();
        }
    }

    public class OwnerHurtTargetGoal
    extends TargetGoal {
        private LivingEntity attacker;
        private int timestamp;

        public OwnerHurtTargetGoal(Owned summonedEntity) {
            super((Mob)summonedEntity, false);
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = Owned.this.getTrueOwner();
            if (livingentity == null) {
                return false;
            }
            this.attacker = livingentity.m_21214_();
            int i = livingentity.m_21215_();
            return i != this.timestamp && this.m_26150_(this.attacker, TargetingConditions.f_26872_) && this.attacker != Owned.this.getTrueOwner();
        }

        public void m_8056_() {
            Owned.this.m_6710_(this.attacker);
            LivingEntity livingentity = Owned.this.getTrueOwner();
            if (livingentity != null) {
                this.timestamp = livingentity.m_21215_();
            }
            super.m_8056_();
        }
    }

    public static class LesserFollowOwnerGoal
    extends Goal {
        private final Owned ownedEntity;
        private LivingEntity owner;
        private final LevelReader level;
        private final double followSpeed;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float maxDist;
        private final float minDist;
        private float oldWaterCost;

        public LesserFollowOwnerGoal(Owned ownedEntity, double speed, float minDist, float maxDist) {
            this.ownedEntity = ownedEntity;
            this.level = ownedEntity.f_19853_;
            this.followSpeed = speed;
            this.navigation = ownedEntity.m_21573_();
            this.minDist = minDist;
            this.maxDist = maxDist;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(ownedEntity.m_21573_() instanceof GroundPathNavigation) && !(ownedEntity.m_21573_() instanceof FlyingPathNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.ownedEntity.getTrueOwner();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            if (this.ownedEntity.m_20280_((Entity)livingentity) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean m_8045_() {
            if (this.navigation.m_26571_()) {
                return false;
            }
            return !(this.ownedEntity.m_20280_((Entity)this.owner) <= (double)(this.maxDist * this.maxDist));
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.ownedEntity.m_21439_(BlockPathTypes.WATER);
            this.ownedEntity.m_21441_(BlockPathTypes.WATER, 0.0f);
        }

        public void m_8041_() {
            this.owner = null;
            this.navigation.m_26573_();
            this.ownedEntity.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        }

        public void m_8037_() {
            this.ownedEntity.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.ownedEntity.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (!this.ownedEntity.m_21523_() && !this.ownedEntity.m_20159_()) {
                    this.navigation.m_5624_((Entity)this.owner, this.followSpeed);
                }
            }
        }
    }
}

