/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.common.entities.hostile.cultists.Cultist;
import com.Polarice3.Goety.common.entities.hostile.cultists.SpellCastingCultist;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ApostleShade
extends SpellCastingCultist {
    private static final EntityDataAccessor<Float> SPIN = SynchedEntityData.m_135353_(ApostleShade.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Byte> SHADE_FLAGS = SynchedEntityData.m_135353_(ApostleShade.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public UUID dealingPlayer;
    public int castingTime;
    public int checkTime;
    public int coolTime;

    public ApostleShade(EntityType<? extends SpellCastingCultist> type, Level p_i48551_2_) {
        super(type, p_i48551_2_);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHADE_FLAGS, (Object)0);
        this.f_19804_.m_135372_(SPIN, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128362_("DealingPlayer", this.dealingPlayer);
        compound.m_128405_("CheckTime", this.checkTime);
        compound.m_128405_("CoolTime", this.coolTime);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("DealingPlayer")) {
            this.dealingPlayer = compound.m_128342_("DealingPlayer");
        }
        if (compound.m_128441_("CheckTime")) {
            this.setCheckTime(compound.m_128451_("CheckTime"));
        }
        if (compound.m_128441_("CoolTime")) {
            this.setCoolTime(compound.m_128451_("CoolTime"));
        }
    }

    private boolean getShadeFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(SHADE_FLAGS);
        return (i & mask) != 0;
    }

    private void setShadeFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(SHADE_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(SHADE_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isPleased() {
        return this.getShadeFlag(1);
    }

    public boolean isIdle() {
        return this.getShadeFlag(2);
    }

    public boolean isMiffed() {
        return this.getShadeFlag(4);
    }

    public void setMood(int mood) {
        if (mood == 0) {
            this.setShadeFlag(1, true);
            this.setShadeFlag(2, false);
            this.setShadeFlag(4, false);
        } else if (mood == 2) {
            this.setShadeFlag(1, false);
            this.setShadeFlag(2, false);
            this.setShadeFlag(4, true);
        } else {
            this.setShadeFlag(1, false);
            this.setShadeFlag(2, true);
            this.setShadeFlag(4, false);
        }
    }

    public void setSpin(float spin) {
        this.f_19804_.m_135381_(SPIN, (Object)Float.valueOf(spin));
    }

    public float getSpin() {
        return ((Float)this.f_19804_.m_135370_(SPIN)).floatValue();
    }

    @Override
    protected SoundEvent getCastingSoundEvent() {
        return (SoundEvent)ModSounds.APOSTLE_CAST_SPELL.get();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() instanceof Player) {
            return super.m_6469_(source, 1.0f);
        }
        return source.m_269533_(DamageTypeTags.f_268738_);
    }

    public void m_6667_(DamageSource cause) {
        if (!this.f_19853_.f_46443_) {
            for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
                ServerParticleUtil.smokeParticles((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20188_(), this.m_20189_(), this.f_19853_);
            }
        }
        this.m_146870_();
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource damageSource) {
        return false;
    }

    public boolean m_7301_(MobEffectInstance p_21197_) {
        return false;
    }

    @Override
    public Cultist.CultistArmPose getArmPose() {
        if (this.isSpellcasting()) {
            return Cultist.CultistArmPose.SPELLCASTING;
        }
        if (this.isChecking()) {
            return Cultist.CultistArmPose.ITEM;
        }
        return Cultist.CultistArmPose.CROSSED;
    }

    protected boolean m_7341_(Entity pEntity) {
        return false;
    }

    public Player getDealingPlayer() {
        if (this.dealingPlayer != null) {
            return this.f_19853_.m_46003_(this.dealingPlayer);
        }
        return null;
    }

    public void setDealingPlayer(Player player) {
        this.dealingPlayer = player.m_20148_();
    }

    public boolean isCoolDown() {
        return this.coolTime > 0;
    }

    public int getCoolTime() {
        return this.coolTime;
    }

    public void setCoolTime(int coolTime) {
        this.coolTime = coolTime;
    }

    public boolean isChecking() {
        return this.checkTime > 0;
    }

    public int getCheckTime() {
        return this.checkTime;
    }

    public void setCheckTime(int checkTime) {
        this.checkTime = checkTime;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_20256_(Vec3.f_82478_);
        if (this.castingTime > 0) {
            --this.castingTime;
        }
        if (this.checkTime > 0) {
            --this.checkTime;
        }
        if (this.coolTime > 0) {
            --this.coolTime;
        }
        if (this.f_19853_.f_46443_) {
            if (this.m_6084_()) {
                if (this.getSpin() < 3.14f) {
                    this.setSpin(this.getSpin() + 0.01f);
                } else {
                    this.setSpin(-3.14f);
                }
            }
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }
}

