/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.MobsConfig;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.TeleportInShockwaveParticleOption;
import com.Polarice3.Goety.client.particles.TeleportShockwaveParticleOption;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.FloatSwimGoal;
import com.Polarice3.Goety.common.entities.ai.SummonTargetGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.hostile.Wraith;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class AbstractWraith
extends Summoned {
    private static final EntityDataAccessor<Byte> FLAGS = SynchedEntityData.m_135353_(AbstractWraith.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public int fireTick;
    public int fireCooldown;
    public int teleportCooldown;
    public int teleportTime = 20;
    public int teleportTime2;
    public int postTeleportTime;
    public double prevX;
    public double prevY;
    public double prevZ;
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState postTeleportAnimationState = new AnimationState();
    public AnimationState breathingAnimationState = new AnimationState();

    public AbstractWraith(EntityType<? extends Summoned> p_i48553_1_, Level p_i48553_2_) {
        super(p_i48553_1_, p_i48553_2_);
        this.f_21342_ = new MobUtil.WraithMoveController((Mob)this);
        this.fireTick = 0;
        this.fireCooldown = 0;
        this.teleportTime2 = 0;
        this.teleportCooldown = 0;
        this.postTeleportTime = 0;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatSwimGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new WraithLookGoal(this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new WraithLookGoal(this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new WraithLookRandomlyGoal(this));
    }

    @Override
    public void targetSelectGoal() {
        this.f_21346_.m_25352_(1, (Goal)new SummonTargetGoal((Mob)this, false, false));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.WraithHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.WraithDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.WraithHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.WraithDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLAGS, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("fireTick", this.fireTick);
        pCompound.m_128405_("fireCooldown", this.fireCooldown);
        pCompound.m_128405_("teleportTime2", this.teleportTime2);
        pCompound.m_128405_("teleportCooldown", this.teleportCooldown);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.fireTick = pCompound.m_128451_("fireTick");
        this.fireCooldown = pCompound.m_128451_("fireCooldown");
        this.teleportTime2 = pCompound.m_128451_("teleportTime2");
        this.teleportCooldown = pCompound.m_128451_("teleportCooldown");
    }

    protected boolean getWraithFlags(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(FLAGS);
        return (i & mask) != 0;
    }

    protected void setWraithFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isFiring() {
        return this.getWraithFlags(1);
    }

    public void setIsFiring(boolean charging) {
        this.setWraithFlags(1, charging);
    }

    public boolean isTeleporting() {
        return this.getWraithFlags(2);
    }

    public void setIsTeleporting(boolean charging) {
        this.setWraithFlags(2, charging);
    }

    public boolean isBreathing() {
        return this.getWraithFlags(4);
    }

    public void setBreathing(boolean flag) {
        this.setWraithFlags(4, flag);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.WRAITH_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.WRAITH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.WRAITH_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSounds.WRAITH_FLY.get();
    }

    protected SoundEvent getAttackSound() {
        return (SoundEvent)ModSounds.WRAITH_ATTACK.get();
    }

    protected SoundEvent getTeleportInSound() {
        return (SoundEvent)ModSounds.WRAITH_TELEPORT.get();
    }

    protected SoundEvent getTeleportOutSound() {
        return (SoundEvent)ModSounds.WRAITH_TELEPORT.get();
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        if (this.getStepSound() != null) {
            this.m_5496_(this.getStepSound(), 0.5f, 1.0f);
        }
    }

    protected float m_6059_() {
        return this.f_19788_ + 2.0f;
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource damageSource) {
        return false;
    }

    protected boolean m_6129_() {
        return false;
    }

    public double getFollowRange() {
        return this.m_21133_(Attributes.f_22277_);
    }

    public float getFloatFollowRange() {
        return (float)this.getFollowRange();
    }

    public float halfFollowRange() {
        return this.getFloatFollowRange() / 2.0f;
    }

    @Override
    public int xpReward() {
        return 10;
    }

    @Override
    protected boolean isSunSensitive() {
        return true;
    }

    @Override
    public void m_8119_() {
        this.setGravity();
        super.m_8119_();
    }

    public boolean isPostTeleporting() {
        return this.postTeleportTime > 0;
    }

    public void setGravity() {
        this.m_20242_(this.m_5842_());
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        Vec3 vector3d = this.m_20184_();
        if (!this.m_20096_() && vector3d.f_82480_ < 0.0 && !this.m_20068_()) {
            this.m_20256_(vector3d.m_82542_(1.0, 0.6, 1.0));
        }
        if (this.teleportCooldown > 0) {
            --this.teleportCooldown;
        }
        if (this.postTeleportTime > 0) {
            Level level;
            if (this.postTeleportTime == 36 && (level = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)new TeleportShockwaveParticleOption(0), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.5);
            }
            --this.postTeleportTime;
        } else {
            this.f_19853_.m_7605_((Entity)this, (byte)7);
        }
        if (this.m_6084_()) {
            this.attackAI();
            this.teleportAI();
        }
    }

    public void teleportAI() {
        if (!this.f_19853_.f_46443_) {
            if (this.isTeleporting()) {
                Level level;
                --this.teleportTime;
                if (this.teleportTime == 2 && (level = this.f_19853_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)new TeleportInShockwaveParticleOption(0), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.5);
                }
                if (this.teleportTime <= 2) {
                    this.prevX = this.m_20185_();
                    this.prevY = this.m_20186_();
                    this.prevZ = this.m_20189_();
                }
                if (this.teleportTime <= 0) {
                    this.teleport();
                }
            } else {
                this.teleportTime = 20;
            }
        } else if (this.isTeleporting()) {
            --this.teleportTime;
            ++this.teleportTime2;
            if (this.teleportTime <= 2) {
                this.prevX = this.m_20185_();
                this.prevY = this.m_20186_();
                this.prevZ = this.m_20189_();
            }
        } else {
            this.teleportTime = 20;
            this.teleportTime2 = 0;
        }
    }

    public void attackAI() {
        if (!this.f_19853_.f_46443_) {
            if (this.isPostTeleporting()) {
                this.m_21573_().m_26573_();
            }
            if (this.fireCooldown > 0) {
                --this.fireCooldown;
            }
            if (this.m_5448_() != null && !this.isPostTeleporting()) {
                if (!this.isFiring()) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, (float)this.m_8132_());
                }
                if (this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                    if (this.fireCooldown <= 0 && !this.isTeleporting() && this.m_5448_().m_20280_((Entity)this) < (double)Mth.m_14207_((float)this.halfFollowRange()) || this.isFiring()) {
                        ++this.fireTick;
                        if (this.isFiring()) {
                            this.m_21573_().m_26573_();
                            double d2 = this.m_5448_().m_20185_() - this.m_20185_();
                            double d1 = this.m_5448_().m_20189_() - this.m_20189_();
                            this.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                            this.f_20883_ = this.m_146908_();
                        }
                        if (this.fireTick > 10) {
                            this.startFiring();
                            this.m_21573_().m_26573_();
                        } else {
                            this.movement();
                            this.stopFiring();
                        }
                        if (this.fireTick == 20) {
                            this.magicFire(this.m_5448_());
                        }
                        if (this.fireTick > 44) {
                            this.fireCooldown = 100;
                            this.fireTick = 0;
                        }
                    } else {
                        if (this.fireTick > 0) {
                            this.fireTick = 0;
                        }
                        this.stopFiring();
                        if (!this.isStaying() && this.m_5448_().m_20280_((Entity)this) <= (double)Mth.m_14207_((float)4.0f) && this.teleportCooldown <= 0 && !this.isPostTeleporting()) {
                            this.m_21573_().m_26573_();
                            this.setIsTeleporting(true);
                        } else {
                            this.setIsTeleporting(false);
                            this.movement();
                        }
                    }
                } else if (((Boolean)MobsConfig.WraithAggressiveTeleport.get()).booleanValue() && !this.isStaying() && this.teleportCooldown <= 0 && !this.isPostTeleporting()) {
                    this.m_21573_().m_26573_();
                    this.setIsTeleporting(true);
                }
            } else {
                this.setIsTeleporting(false);
                this.stopFiring();
            }
        }
    }

    public void magicFire(LivingEntity livingEntity) {
        if (this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
            WandUtil.spawnCrossIceBouquet(this.f_19853_, livingEntity.m_20182_(), (LivingEntity)this);
        } else {
            WandUtil.spawnIceBouquet(this.f_19853_, livingEntity.m_20182_(), (LivingEntity)this);
        }
    }

    public void movement() {
        Path path;
        Vec3 vector3d2;
        if (this.m_5448_() != null && !this.isStaying() && !this.isPostTeleporting() && (vector3d2 = this.m_5448_().m_20280_((Entity)this) > (double)Mth.m_14207_((float)this.halfFollowRange()) ? this.m_5448_().m_20182_() : LandRandomPos.m_148488_((PathfinderMob)this, (int)4, (int)4)) != null && (path = this.m_21573_().m_26524_(vector3d2.f_82479_, vector3d2.f_82480_, vector3d2.f_82481_, 0)) != null && this.m_21573_().m_26571_()) {
            this.m_21573_().m_26536_(path, 1.25);
        }
    }

    protected void teleport() {
        if (!this.f_19853_.m_5776_() && this.m_6084_() && this.m_5448_() != null) {
            if (this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                for (int i = 0; i < 128; ++i) {
                    double d5;
                    double d4;
                    double d3 = this.m_5448_().m_20185_() + (this.m_217043_().m_188500_() - 0.5) * this.getFollowRange();
                    BlockPos blockPos1 = BlockPos.m_274561_((double)d3, (double)(d4 = this.m_5448_().m_20186_()), (double)(d5 = this.m_5448_().m_20189_() + (this.m_217043_().m_188500_() - 0.5) * this.getFollowRange()));
                    if (this.f_19853_.m_45527_(blockPos1) && this.f_19853_.m_46461_() && !this.m_5825_() && !this.m_21023_(MobEffects.f_19607_)) continue;
                    Wraith wraith = new Wraith((EntityType<? extends AbstractWraith>)((EntityType)ModEntityType.WRAITH.get()), this.f_19853_);
                    wraith.m_6034_(d3, d4, d5);
                    wraith.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
                    if (wraith.m_142582_((Entity)this.m_5448_())) {
                        if (!this.m_20984_(d3, d4, d5, false)) continue;
                        this.teleportHits();
                        this.setIsTeleporting(false);
                        wraith.m_146870_();
                        MobUtil.instaLook((Mob)this, this.m_5448_());
                        break;
                    }
                    wraith.m_146870_();
                }
            } else {
                this.teleportTowardsEntity(this.m_5448_());
            }
        }
    }

    public void teleportTowardsEntity(LivingEntity livingEntity) {
        for (int i = 0; i < 128; ++i) {
            double d3;
            double d2;
            Vec3 vector3d = new Vec3(this.m_20185_() - livingEntity.m_20185_(), this.m_20227_(0.5) - livingEntity.m_20188_(), this.m_20189_() - livingEntity.m_20189_());
            vector3d = vector3d.m_82541_();
            double d0 = 16.0;
            double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82479_ * d0;
            if (!this.m_20984_(d1, d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vector3d.f_82480_ * d0, d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82481_ * d0, false)) continue;
            this.teleportHits();
            this.teleportCooldown = 100;
            this.setIsTeleporting(false);
            MobUtil.instaLook((Mob)this, livingEntity);
            break;
        }
    }

    public void teleportHits() {
        this.postTeleportTime = 38;
        this.f_19853_.m_7605_((Entity)this, (byte)6);
        this.f_19853_.m_7605_((Entity)this, (byte)100);
        this.f_19853_.m_7605_((Entity)this, (byte)101);
        this.f_19853_.m_214171_(GameEvent.f_238175_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)this));
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.prevX, this.prevY, this.prevZ, this.getTeleportInSound(), this.m_5720_(), 1.0f, 1.0f);
            this.m_5496_(this.getTeleportOutSound(), 1.0f, 1.0f);
        }
    }

    public void startFiring() {
        if (!this.isFiring()) {
            this.setIsFiring(true);
            this.f_19853_.m_7605_((Entity)this, (byte)4);
            this.f_19853_.m_7605_((Entity)this, (byte)100);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)new TeleportShockwaveParticleOption(0), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.5);
            }
            if (!this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getAttackSound(), this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(this.getAttackSound(), 1.0f, 1.0f);
            }
        }
    }

    public void stopFiring() {
        if (this.isFiring()) {
            this.setIsFiring(false);
            this.f_19853_.m_7605_((Entity)this, (byte)5);
        }
    }

    public ParticleOptions getFireParticles() {
        return (ParticleOptions)ModParticleTypes.WRAITH.get();
    }

    public ParticleOptions getBurstParticles() {
        return (ParticleOptions)ModParticleTypes.WRAITH_BURST.get();
    }

    public void m_7822_(byte pId) {
        super.m_7822_(pId);
        if (pId == 4) {
            this.setIsFiring(true);
            this.attackAnimationState.m_216977_(this.f_19797_);
        }
        if (pId == 5) {
            this.setIsFiring(false);
            this.attackAnimationState.m_216973_();
        }
        if (pId == 6) {
            this.postTeleportAnimationState.m_216977_(this.f_19797_);
            this.postTeleportTime = 38;
        }
        if (pId == 7) {
            this.postTeleportAnimationState.m_216973_();
        }
        if (pId == 100) {
            for (int j = 0; j < 8; ++j) {
                double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                double d2 = this.m_20186_() + (this.f_19796_.m_188500_() + 0.5);
                double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                this.f_19853_.m_7106_(this.getFireParticles(), d1, d2, d3, 0.0, 0.0, 0.0);
                this.f_19853_.m_7106_(this.getBurstParticles(), d1, d2, d3, 0.0, 0.0, 0.0);
            }
        }
        if (pId == 101 && !this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.prevX, this.prevY, this.prevZ, this.getTeleportInSound(), this.m_5720_(), 1.0f, 1.0f);
            this.m_5496_(this.getTeleportOutSound(), 1.0f, 1.0f);
        }
    }

    public float getAnimationProgress(float pPartialTicks) {
        if (this.teleportTime <= 12 && this.m_6084_()) {
            int i = this.teleportTime - 2;
            return i <= 0 ? 1.0f : 1.0f - ((float)i - pPartialTicks) / 20.0f;
        }
        return 0.0f;
    }

    public static class WraithLookGoal
    extends LookAtPlayerGoal {
        public AbstractWraith wraith;

        public WraithLookGoal(AbstractWraith p_i1631_1_, Class<? extends LivingEntity> p_i1631_2_, float p_i1631_3_) {
            super((Mob)p_i1631_1_, p_i1631_2_, p_i1631_3_);
            this.wraith = p_i1631_1_;
        }

        public WraithLookGoal(AbstractWraith p_i1632_1_, Class<? extends LivingEntity> p_i1632_2_, float p_i1632_3_, float p_i1632_4_) {
            super((Mob)p_i1632_1_, p_i1632_2_, p_i1632_3_, p_i1632_4_);
            this.wraith = p_i1632_1_;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.wraith.fireTick < 0 && this.wraith.m_5448_() == null;
        }
    }

    public static class WraithLookRandomlyGoal
    extends RandomLookAroundGoal {
        public AbstractWraith wraith;

        public WraithLookRandomlyGoal(AbstractWraith p_i1631_1_) {
            super((Mob)p_i1631_1_);
            this.wraith = p_i1631_1_;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.wraith.fireTick < 0 && this.wraith.m_5448_() == null;
        }
    }
}

