/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.MobsConfig;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.WraithServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.AbstractSkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.SkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.VanguardServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieServant;
import com.Polarice3.Goety.common.entities.projectiles.SoulBolt;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.SoulJar;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNecromancer
extends AbstractSkeletonServant
implements RangedAttackMob {
    private static final EntityDataAccessor<Byte> SPELL = SynchedEntityData.m_135353_(AbstractNecromancer.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> FLAGS = SynchedEntityData.m_135353_(AbstractNecromancer.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.m_135353_(AbstractNecromancer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static int INITIAL_LEVEL = 0;
    public static int MAX_LEVEL = 2;
    protected List<EntityType<?>> summonList = new ArrayList();
    protected int spellCooldown;
    protected int idleSpellCool;
    public int cantDo;
    protected float attackSpeed = 1.0f;
    private NecromancerSpellType activeSpell = NecromancerSpellType.NONE;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState summonAnimationState = new AnimationState();
    public AnimationState spellAnimationState = new AnimationState();

    public AbstractNecromancer(EntityType<? extends AbstractSkeletonServant> type, Level level) {
        super((EntityType<? extends Summoned>)type, level);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new CastingSpellGoal());
        this.summonSpells(1);
        this.f_21345_.m_25352_(2, AvoidTargetGoal.AvoidRadiusGoal.newGoal(this, 2.0f, 4, 1.0, 1.2));
        this.projectileGoal(3);
    }

    public void projectileGoal(int priority) {
        this.f_21345_.m_25352_(priority, (Goal)new NecromancerRangedGoal(this, 1.0, 20, 12.0f));
    }

    public void summonSpells(int priority) {
        this.f_21345_.m_25352_(priority, (Goal)new SummonZombieSpell());
        this.f_21345_.m_25352_(priority + 1, (Goal)new SummonUndeadGoal());
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.NecromancerHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.NecromancerDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.NecromancerHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.NecromancerDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL, (Object)0);
        this.f_19804_.m_135372_(FLAGS, (Object)0);
        this.f_19804_.m_135372_(LEVEL, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> p_33609_) {
        if (LEVEL.equals(p_33609_)) {
            this.m_6210_();
            this.m_146922_(this.f_20885_);
            this.f_20883_ = this.f_20885_;
        }
        super.m_7350_(p_33609_);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("SpellCoolDown")) {
            this.spellCooldown = compound.m_128451_("SpellCoolDown");
        }
        if (compound.m_128441_("IdleSpellCool")) {
            this.idleSpellCool = compound.m_128451_("IdleSpellCool");
        }
        if (compound.m_128441_("MultiShot")) {
            this.setNecroLevel(compound.m_128451_("MultiShot"));
        } else if (compound.m_128441_("NecroLevel")) {
            this.setNecroLevel(compound.m_128451_("NecroLevel"));
        }
        if (compound.m_128441_("AttackSpeed")) {
            this.setAttackSpeed(compound.m_128457_("AttackSpeed"));
        }
        if (compound.m_128441_("HasAlternate") && compound.m_128471_("HasAlternate")) {
            this.addSummon((EntityType)ModEntityType.SKELETON_SERVANT.get());
        }
        if (compound.m_128441_("SpawnUndeadIdle")) {
            this.setUndeadIdle(compound.m_128471_("SpawnUndeadIdle"));
        }
        if (compound.m_128425_("SummonList", 9)) {
            ListTag listTag = compound.m_128437_("SummonList", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                String string = listTag.m_128728_(i).m_128461_("id");
                if (!EntityType.m_20632_((String)string).isPresent()) continue;
                this.addSummon((EntityType)EntityType.m_20632_((String)string).get());
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("SpellCoolDown", this.spellCooldown);
        compound.m_128405_("IdleSpellCool", this.idleSpellCool);
        compound.m_128405_("NecroLevel", this.getNecroLevel());
        compound.m_128350_("AttackSpeed", this.getAttackSpeed());
        compound.m_128379_("SpawnUndeadIdle", this.spawnUndeadIdle());
        ListTag listTag = new ListTag();
        if (!this.getSummonList().isEmpty()) {
            for (EntityType<?> entityType : this.getSummonList()) {
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.m_128359_("id", EntityType.m_20613_(entityType).toString());
                listTag.add((Object)compoundTag);
            }
        }
        if (!listTag.isEmpty()) {
            compound.m_128365_("SummonList", (Tag)listTag);
        }
    }

    @Override
    protected void m_213945_(RandomSource p_219154_, DifficultyInstance p_219155_) {
    }

    public void setSpellCasting(boolean casting) {
        this.setNecromancerFlags(1, casting);
    }

    public boolean isSpellCasting() {
        return this.getNecromancerFlags(1);
    }

    public void setUndeadIdle(boolean spawn) {
        this.setNecromancerFlags(4, spawn);
    }

    public boolean spawnUndeadIdle() {
        return this.getNecromancerFlags(4);
    }

    public void setShooting(boolean shooting) {
        this.setNecromancerFlags(8, shooting);
    }

    public boolean isShooting() {
        return this.getNecromancerFlags(8);
    }

    public void setAttackSpeed(float speed) {
        this.attackSpeed = speed;
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    public void setNecroLevel(int shot) {
        int i = Mth.m_14045_((int)shot, (int)0, (int)2);
        this.f_19804_.m_135381_(LEVEL, (Object)i);
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22276_);
        if (attributeInstance != null) {
            attributeInstance.m_22100_((Double)AttributesConfig.NecromancerHealth.get() * (double)Math.max((float)i * 1.25f, 1.0f));
        }
        this.m_20090_();
        this.m_6210_();
    }

    public int getNecroLevel() {
        return (Integer)this.f_19804_.m_135370_(LEVEL);
    }

    public List<EntityType<?>> getSummonList() {
        return this.summonList;
    }

    public void addSummon(EntityType<?> entityType) {
        if (!this.summonList.contains(entityType) && entityType != this.getDefaultSummon().m_6095_()) {
            this.summonList.add(entityType);
        }
    }

    public void setNecromancerSpellType(NecromancerSpellType necromancerSpellType) {
        this.activeSpell = necromancerSpellType;
        this.f_19804_.m_135381_(SPELL, (Object)((byte)necromancerSpellType.id));
    }

    protected NecromancerSpellType getNecromancerSpellType() {
        return !this.f_19853_.f_46443_ ? this.activeSpell : NecromancerSpellType.getFromId(((Byte)this.f_19804_.m_135370_(SPELL)).byteValue());
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        float f1 = this.getNecroLevel();
        float size = 1.0f + Math.max(f1 * 0.15f, 0.0f);
        return 2.17f * size;
    }

    @Override
    public void reassessWeaponGoal() {
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.NECROMANCER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.NECROMANCER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.NECROMANCER_DEATH.get();
    }

    @Override
    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSounds.NECROMANCER_STEP.get();
    }

    private boolean getNecromancerFlags(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(FLAGS);
        return (i & mask) != 0;
    }

    private void setNecromancerFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(FLAGS, (Object)((byte)(i & 0xFF)));
    }

    protected int getSpellCooldown() {
        return this.spellCooldown;
    }

    protected void setSpellCooldown(int cooldown) {
        this.spellCooldown = cooldown;
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose p_33597_) {
        if (this.getNecroLevel() > 0) {
            float f1 = this.getNecroLevel();
            float size = 1.0f + Math.max(f1 * 0.15f, 0.0f);
            return super.m_6972_(p_33597_).m_20388_(size);
        }
        return super.m_6972_(p_33597_);
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        if (this.getTrueOwner() != null && ((Boolean)MobsConfig.NecromancerSoulJar.get()).booleanValue()) {
            ItemStack itemStack = new ItemStack((ItemLike)ModItems.SOUL_JAR.get());
            SoulJar.setOwnerName(this.getTrueOwner(), itemStack);
            SoulJar.setNecromancer(this, itemStack);
            ItemEntity itemEntity = this.m_19983_(itemStack);
            if (itemEntity != null) {
                itemEntity.m_32064_();
            }
        }
        super.m_6667_(pCause);
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.walkAnimationState);
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.summonAnimationState);
        animationStates.add(this.spellAnimationState);
        return animationStates;
    }

    public void stopAllAnimations() {
        for (AnimationState animationState : this.getAnimations()) {
            animationState.m_216973_();
        }
    }

    public boolean isMoving() {
        return this.m_20184_().m_165925_() > 1.0E-6;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.spellCooldown > 0) {
            --this.spellCooldown;
        }
        if (this.idleSpellCool > 0) {
            --this.idleSpellCool;
        }
        if (this.cantDo > 0) {
            --this.cantDo;
        }
        if (this.f_19853_.f_46443_) {
            if (this.m_6084_()) {
                if (!this.isShooting() && !this.isSpellCasting()) {
                    if (!this.isMoving()) {
                        this.idleAnimationState.m_216982_(this.f_19797_);
                        this.walkAnimationState.m_216973_();
                    } else {
                        this.idleAnimationState.m_216973_();
                        this.walkAnimationState.m_216982_(this.f_19797_);
                    }
                } else {
                    this.walkAnimationState.m_216973_();
                    this.idleAnimationState.m_216973_();
                }
                if (this.isSpellCasting()) {
                    this.spellCastParticles();
                }
            }
        } else if (!this.isShooting()) {
            this.f_19853_.m_7605_((Entity)this, (byte)8);
        }
    }

    public void spellCastParticles() {
        double d0 = MathHelper.rgbParticle(this.getNecromancerSpellType().particleSpeed)[0];
        double d1 = MathHelper.rgbParticle(this.getNecromancerSpellType().particleSpeed)[1];
        double d2 = MathHelper.rgbParticle(this.getNecromancerSpellType().particleSpeed)[2];
        for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.CULT_SPELL.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), d0, d1, d2);
        }
    }

    @Override
    public void m_6504_(@NotNull LivingEntity p_33317_, float p_33318_) {
        if (this.getNecroLevel() <= 0) {
            Vec3 vector3d = this.m_20252_(1.0f);
            SoulBolt soulBolt = new SoulBolt((LivingEntity)this, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, this.f_19853_);
            soulBolt.m_6034_(this.m_20185_() + vector3d.f_82479_ / 2.0, this.m_20188_() - 0.2, this.m_20189_() + vector3d.f_82481_ / 2.0);
            soulBolt.rotateToMatchMovement();
            if (this.f_19853_.m_7967_((Entity)soulBolt)) {
                this.m_216990_((SoundEvent)ModSounds.CAST_SPELL.get());
                this.m_6674_(InteractionHand.MAIN_HAND);
            }
        } else {
            for (int i = -this.getNecroLevel(); i <= this.getNecroLevel(); ++i) {
                Vec3 vector3d = this.m_20252_(1.0f);
                SoulBolt soulBolt = new SoulBolt((LivingEntity)this, vector3d.f_82479_ + (double)((float)i / 10.0f), vector3d.f_82480_, vector3d.f_82481_ + (double)((float)i / 10.0f), this.f_19853_);
                soulBolt.m_6034_(this.m_20185_() + vector3d.f_82479_ / 2.0, this.m_20188_() - 0.2, this.m_20189_() + vector3d.f_82481_ / 2.0);
                if (!this.f_19853_.m_7967_((Entity)soulBolt)) continue;
                this.m_216990_((SoundEvent)ModSounds.CAST_SPELL.get());
                this.m_6674_(InteractionHand.MAIN_HAND);
            }
        }
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
            Item item = itemstack.m_41720_();
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
                if (!this.spawnUndeadIdle() && itemstack.m_41619_()) {
                    if (this.idleSpellCool <= 0) {
                        this.setUndeadIdle(true);
                    } else {
                        this.m_216990_((SoundEvent)ModSounds.NECROMANCER_HURT.get());
                        this.f_19853_.m_7605_((Entity)this, (byte)9);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (item == Items.f_42500_ && this.m_21223_() < this.m_21233_()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_5496_((SoundEvent)ModSounds.NECROMANCER_STEP.get(), 1.0f, 1.25f);
                    this.m_5634_(2.0f);
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 7; ++i) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    return InteractionResult.CONSUME;
                }
                if (!this.getSummonList().contains(ModEntityType.SKELETON_SERVANT.get()) && item == ModItems.OSSEOUS_FOCUS.get()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.addSummon((EntityType)ModEntityType.SKELETON_SERVANT.get());
                    this.m_216990_((SoundEvent)ModSounds.NECROMANCER_LAUGH.get());
                    return InteractionResult.SUCCESS;
                }
                if (!this.getSummonList().contains(ModEntityType.WRAITH_SERVANT.get()) && item == ModItems.SPOOKY_FOCUS.get()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.addSummon((EntityType)ModEntityType.WRAITH_SERVANT.get());
                    this.m_216990_((SoundEvent)ModSounds.NECROMANCER_LAUGH.get());
                    return InteractionResult.SUCCESS;
                }
                if (!this.getSummonList().contains(ModEntityType.VANGUARD_SERVANT.get()) && item == ModItems.VANGUARD_FOCUS.get()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.addSummon((EntityType)ModEntityType.VANGUARD_SERVANT.get());
                    this.m_216990_((SoundEvent)ModSounds.NECROMANCER_LAUGH.get());
                    return InteractionResult.SUCCESS;
                }
                if (item == ModItems.SOUL_JAR.get()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    if (this.getNecroLevel() < 2) {
                        this.setNecroLevel(this.getNecroLevel() + 1);
                    }
                    this.m_5634_(((Double)AttributesConfig.NecromancerHealth.get()).floatValue());
                    Level i = this.f_19853_;
                    if (i instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)i;
                        for (int i2 = 0; i2 < 7; ++i2) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235898_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    this.m_5496_((SoundEvent)ModSounds.NECROMANCER_LAUGH.get(), 1.0f, 0.5f);
                    return InteractionResult.SUCCESS;
                }
            } else {
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public Summoned getDefaultSummon() {
        return new ZombieServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.ZOMBIE_SERVANT.get()), this.f_19853_);
    }

    public Summoned getSummon() {
        Summoned summoned = this.getDefaultSummon();
        if (this.getSummonList().contains(ModEntityType.ZOMBIE_SERVANT.get()) && this.f_19853_.f_46441_.m_188499_()) {
            summoned = new ZombieServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.ZOMBIE_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.SKELETON_SERVANT.get()) && this.f_19853_.f_46441_.m_188499_()) {
            summoned = new SkeletonServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.SKELETON_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.WRAITH_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
            summoned = new WraithServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.WRAITH_SERVANT.get()), this.f_19853_);
        }
        if (this.getSummonList().contains(ModEntityType.VANGUARD_SERVANT.get()) && this.f_19853_.f_46441_.m_188501_() <= 0.15f) {
            summoned = new VanguardServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.VANGUARD_SERVANT.get()), this.f_19853_);
        }
        return summoned;
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.stopAllAnimations();
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (p_21375_ == 5) {
            this.stopAllAnimations();
            this.summonAnimationState.m_216977_(this.f_19797_);
        } else if (p_21375_ == 6) {
            this.stopAllAnimations();
            this.spellAnimationState.m_216977_(this.f_19797_);
        } else if (p_21375_ == 7) {
            this.stopAllAnimations();
        } else if (p_21375_ == 8) {
            this.attackAnimationState.m_216973_();
        } else if (p_21375_ == 9) {
            this.cantDo = 40;
        } else {
            super.m_7822_(p_21375_);
        }
    }

    public static enum NecromancerSpellType {
        NONE(0, 0xFFFFFF),
        ZOMBIE(1, 1507071),
        CLOUD(2, 0xF2FFFF);

        private final int id;
        private final int particleSpeed;

        private NecromancerSpellType(int idIn, int color) {
            this.id = idIn;
            this.particleSpeed = color;
        }

        public static NecromancerSpellType getFromId(int idIn) {
            for (NecromancerSpellType necromancerSpellType : NecromancerSpellType.values()) {
                if (idIn != necromancerSpellType.id) continue;
                return necromancerSpellType;
            }
            return NONE;
        }
    }

    public class CastingSpellGoal
    extends Goal {
        public CastingSpellGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return AbstractNecromancer.this.isSpellCasting();
        }

        public void m_8056_() {
            super.m_8056_();
            AbstractNecromancer.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            super.m_8041_();
            AbstractNecromancer.this.setNecromancerSpellType(NecromancerSpellType.NONE);
        }

        public void m_8037_() {
            if (AbstractNecromancer.this.m_5448_() != null) {
                AbstractNecromancer.this.m_21563_().m_24960_((Entity)AbstractNecromancer.this.m_5448_(), (float)AbstractNecromancer.this.m_8085_(), (float)AbstractNecromancer.this.m_8132_());
            }
        }
    }

    public static class NecromancerRangedGoal
    extends Goal {
        private final AbstractNecromancer mob;
        @Nullable
        private LivingEntity target;
        private int attackTime = -1;
        private final double speedModifier;
        private int seeTime;
        private final int attackIntervalMin;
        private final int attackIntervalMax;
        private final float attackRadius;
        private final float attackRadiusSqr;

        public NecromancerRangedGoal(AbstractNecromancer p_25768_, double speed, int attackInterval, float attackRadius) {
            this(p_25768_, speed, attackInterval, attackInterval, attackRadius);
        }

        public NecromancerRangedGoal(AbstractNecromancer mob, double speed, int attackMin, int attackMax, float attackRadius) {
            this.mob = mob;
            this.speedModifier = speed;
            this.attackIntervalMin = attackMin;
            this.attackIntervalMax = attackMax;
            this.attackRadius = attackRadius;
            this.attackRadiusSqr = attackRadius * attackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                this.target = livingentity;
                return !this.mob.isSpellCasting();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_() || this.target != null && this.target.m_6084_() && !this.mob.m_21573_().m_26571_() && !this.mob.isSpellCasting();
        }

        public void m_8041_() {
            this.mob.setShooting(false);
            this.target = null;
            this.seeTime = 0;
            this.attackTime = -1;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.target != null && !this.mob.isSpellCasting()) {
                double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
                boolean flag = this.mob.m_21574_().m_148306_((Entity)this.target);
                this.seeTime = flag ? ++this.seeTime : 0;
                if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
                    this.mob.m_21573_().m_26573_();
                } else {
                    this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
                }
                int speed = Mth.m_14143_((float)Math.max(this.mob.getAttackSpeed(), 1.0f));
                this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
                --this.attackTime;
                if (this.attackTime == 5) {
                    this.mob.setShooting(true);
                    this.mob.attackAnimationState.m_216977_(this.mob.f_19797_);
                    this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)4);
                } else if (this.attackTime == 0) {
                    if (!flag) {
                        return;
                    }
                    float f = (float)Math.sqrt(d0) / this.attackRadius;
                    float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                    this.mob.m_6504_(this.target, f1);
                    this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin)) / speed;
                } else if (this.attackTime < 0) {
                    this.mob.setShooting(false);
                    this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax)) / speed;
                }
            }
        }
    }

    public class SummonZombieSpell
    extends SummoningSpellGoal {
        @Override
        public boolean m_8036_() {
            Predicate<Entity> predicate = entity -> {
                IOwned owned;
                return entity.m_6084_() && entity instanceof IOwned && (owned = (IOwned)entity).getTrueOwner() instanceof AbstractNecromancer;
            };
            int i = AbstractNecromancer.this.f_19853_.m_6443_(LivingEntity.class, AbstractNecromancer.this.m_20191_().m_82377_(64.0, 16.0, 64.0), predicate).size();
            return super.m_8036_() && i < 7;
        }

        @Override
        protected void castSpell() {
            Level level = AbstractNecromancer.this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Predicate<Entity> predicate = entity -> {
                    IOwned owned;
                    return entity.m_6084_() && entity instanceof IOwned && (owned = (IOwned)entity).getTrueOwner() instanceof AbstractNecromancer;
                };
                int i = AbstractNecromancer.this.f_19853_.m_6443_(LivingEntity.class, AbstractNecromancer.this.m_20191_().m_82377_(64.0, 16.0, 64.0), predicate).size();
                if (i < 7) {
                    int j = 7 - i;
                    for (int i1 = 0; i1 < 1 + serverLevel.f_46441_.m_188503_(j); ++i1) {
                        Summoned summonedentity = AbstractNecromancer.this.getSummon();
                        BlockPos blockPos = BlockFinder.SummonRadius((LivingEntity)AbstractNecromancer.this, (Level)serverLevel);
                        summonedentity.setTrueOwner((LivingEntity)AbstractNecromancer.this);
                        summonedentity.m_20035_(blockPos, AbstractNecromancer.this.m_146908_(), AbstractNecromancer.this.m_146909_());
                        if (((Boolean)MobsConfig.NecromancerSummonsLife.get()).booleanValue()) {
                            summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)serverLevel));
                        }
                        summonedentity.m_21530_();
                        summonedentity.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(AbstractNecromancer.this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                        summonedentity.m_6863_(false);
                        this.populateDefaultEquipmentSlots((LivingEntity)summonedentity, serverLevel.f_46441_);
                        if (!serverLevel.m_7967_((Entity)summonedentity)) continue;
                        summonedentity.m_5496_((SoundEvent)ModSounds.SUMMON_SPELL.get(), 1.0f, 1.0f);
                    }
                }
            }
        }

        protected void populateDefaultEquipmentSlots(LivingEntity livingEntity, RandomSource p_217055_) {
            if (p_217055_.m_188501_() <= 0.15f) {
                int i = p_217055_.m_188503_(2) + 2;
                if (p_217055_.m_188501_() < 0.095f) {
                    ++i;
                }
                boolean flag = true;
                for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                    Item item;
                    if (equipmentslot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                    ItemStack itemstack = livingEntity.m_6844_(equipmentslot);
                    if (!flag && p_217055_.m_188501_() < 0.1f) break;
                    flag = false;
                    if (!itemstack.m_41619_() || (item = Mob.m_21412_((EquipmentSlot)equipmentslot, (int)i)) == null) continue;
                    livingEntity.m_8061_(equipmentslot, new ItemStack((ItemLike)item));
                }
            }
        }

        @Override
        protected SoundEvent getCastSound() {
            return null;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.PREPARE_SUMMON.get();
        }

        @Override
        protected NecromancerSpellType getNecromancerSpellType() {
            return NecromancerSpellType.ZOMBIE;
        }
    }

    public class SummonUndeadGoal
    extends Goal {
        protected int spellTime;

        public boolean m_8036_() {
            if (AbstractNecromancer.this.m_5448_() != null && AbstractNecromancer.this.m_5448_().m_6084_()) {
                return false;
            }
            if (AbstractNecromancer.this.isShooting()) {
                return false;
            }
            if (AbstractNecromancer.this.isSpellCasting()) {
                return false;
            }
            if (!AbstractNecromancer.this.spawnUndeadIdle()) {
                return false;
            }
            return AbstractNecromancer.this.getSpellCooldown() <= 0 && AbstractNecromancer.this.idleSpellCool <= 0;
        }

        public boolean m_8045_() {
            return this.spellTime > 0 && AbstractNecromancer.this.f_20916_ <= 0;
        }

        public void m_8056_() {
            this.spellTime = 29;
            AbstractNecromancer.this.setSpellCooldown(100);
            AbstractNecromancer.this.m_5496_((SoundEvent)ModSounds.PREPARE_SUMMON.get(), 1.0f, 1.0f);
            AbstractNecromancer.this.setSpellCasting(true);
            AbstractNecromancer.this.setNecromancerSpellType(NecromancerSpellType.ZOMBIE);
            AbstractNecromancer.this.f_19853_.m_7605_((Entity)AbstractNecromancer.this, (byte)6);
        }

        public void m_8041_() {
            super.m_8041_();
            AbstractNecromancer.this.setSpellCasting(false);
            AbstractNecromancer.this.f_19853_.m_7605_((Entity)AbstractNecromancer.this, (byte)7);
        }

        public void m_8037_() {
            --this.spellTime;
            if (this.spellTime == 0) {
                AbstractNecromancer.this.m_5496_((SoundEvent)ModSounds.NECROMANCER_LAUGH.get(), 2.0f, AbstractNecromancer.this.m_6100_());
                AbstractNecromancer.this.setNecromancerSpellType(NecromancerSpellType.NONE);
                int i = 2 + AbstractNecromancer.this.f_19853_.f_46441_.m_188503_(4);
                for (int i1 = 0; i1 < i; ++i1) {
                    Entity entity;
                    Level level = AbstractNecromancer.this.f_19853_;
                    if (!(level instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    Summoned summonedentity = AbstractNecromancer.this.getSummon();
                    EntityType<?> entityType = summonedentity.getVariant((Level)serverLevel, AbstractNecromancer.this.m_20183_());
                    if (entityType != null && (entity = entityType.m_20615_((Level)serverLevel)) instanceof Summoned) {
                        Summoned summoned;
                        summonedentity = summoned = (Summoned)entity;
                    }
                    BlockPos blockPos = BlockFinder.SummonRadius((LivingEntity)AbstractNecromancer.this, (Level)serverLevel);
                    AbstractNecromancer owner = AbstractNecromancer.this.getTrueOwner() != null ? AbstractNecromancer.this.getTrueOwner() : AbstractNecromancer.this;
                    summonedentity.setTrueOwner((LivingEntity)owner);
                    summonedentity.m_20035_(blockPos, AbstractNecromancer.this.m_146908_(), AbstractNecromancer.this.m_146909_());
                    if (((Boolean)MobsConfig.NecromancerSummonsLife.get()).booleanValue()) {
                        summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)serverLevel));
                    }
                    summonedentity.m_21530_();
                    summonedentity.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(AbstractNecromancer.this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    this.populateDefaultEquipmentSlots((LivingEntity)summonedentity, serverLevel.f_46441_);
                    if (!serverLevel.m_7967_((Entity)summonedentity)) continue;
                    summonedentity.m_5496_((SoundEvent)ModSounds.SUMMON_SPELL.get(), 1.0f, 1.0f);
                }
                AbstractNecromancer.this.setUndeadIdle(false);
                AbstractNecromancer.this.idleSpellCool = MathHelper.secondsToTicks(20);
            }
        }

        protected void populateDefaultEquipmentSlots(LivingEntity livingEntity, RandomSource p_217055_) {
            if (p_217055_.m_188501_() <= 0.15f) {
                int i = p_217055_.m_188503_(2) + 2;
                if (p_217055_.m_188501_() < 0.095f) {
                    ++i;
                }
                boolean flag = true;
                for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                    Item item;
                    if (equipmentslot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                    ItemStack itemstack = livingEntity.m_6844_(equipmentslot);
                    if (!flag && p_217055_.m_188501_() < 0.1f) break;
                    flag = false;
                    if (!itemstack.m_41619_() || (item = Mob.m_21412_((EquipmentSlot)equipmentslot, (int)i)) == null) continue;
                    livingEntity.m_8061_(equipmentslot, new ItemStack((ItemLike)item));
                }
            }
        }
    }

    public abstract class SummoningSpellGoal
    extends Goal {
        protected int spellTime;

        protected SummoningSpellGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = AbstractNecromancer.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                if (AbstractNecromancer.this.isSpellCasting()) {
                    return false;
                }
                return AbstractNecromancer.this.getSpellCooldown() <= 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.spellTime > 0;
        }

        public void m_8056_() {
            this.spellTime = this.getCastingTime();
            AbstractNecromancer.this.setSpellCooldown(this.getCastingInterval());
            if (this.getSpellPrepareSound() != null) {
                AbstractNecromancer.this.m_5496_(this.getSpellPrepareSound(), 1.0f, 1.0f);
            }
            AbstractNecromancer.this.f_19853_.m_7605_((Entity)AbstractNecromancer.this, (byte)5);
            AbstractNecromancer.this.setSpellCasting(true);
            AbstractNecromancer.this.setNecromancerSpellType(this.getNecromancerSpellType());
        }

        public void m_8041_() {
            AbstractNecromancer.this.setSpellCasting(false);
            AbstractNecromancer.this.f_19853_.m_7605_((Entity)AbstractNecromancer.this, (byte)7);
        }

        public void m_8037_() {
            --this.spellTime;
            if (this.spellTime == 10) {
                if (this.getCastSound() != null) {
                    AbstractNecromancer.this.m_5496_(this.getCastSound(), 1.0f, 1.0f);
                }
                AbstractNecromancer.this.m_5496_((SoundEvent)ModSounds.NECROMANCER_LAUGH.get(), 2.0f, AbstractNecromancer.this.m_6100_());
                this.castSpell();
                AbstractNecromancer.this.setNecromancerSpellType(NecromancerSpellType.NONE);
            }
        }

        protected abstract void castSpell();

        protected int getCastingTime() {
            return 20;
        }

        protected int getCastingInterval() {
            return 100;
        }

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        @Nullable
        protected SoundEvent getCastSound() {
            return (SoundEvent)ModSounds.SUMMON_SPELL.get();
        }

        protected abstract NecromancerSpellType getNecromancerSpellType();
    }
}

