/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.api.entities.IBreathing;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ai.BreathingAttackGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.AbstractWraith;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.WandUtil;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class AbstractBorderWraith
extends AbstractWraith
implements IBreathing {
    public Vec3 initial;
    public int breathTick = 0;

    public AbstractBorderWraith(EntityType<? extends Summoned> p_i48553_1_, Level p_i48553_2_) {
        super(p_i48553_1_, p_i48553_2_);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.initial != null) {
            pCompound.m_128347_("targetX", this.initial.f_82479_);
            pCompound.m_128347_("targetY", this.initial.f_82480_);
            pCompound.m_128347_("targetZ", this.initial.f_82481_);
        }
        pCompound.m_128405_("breathTick", this.breathTick);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("targetX")) {
            this.initial = new Vec3(pCompound.m_128459_("targetX"), pCompound.m_128459_("targetY"), pCompound.m_128459_("targetZ"));
        }
        this.breathTick = pCompound.m_128451_("breathTick");
    }

    @Override
    public void teleportAI() {
    }

    @Override
    public void attackAI() {
        if (!this.f_19853_.f_46443_) {
            if (this.m_5448_() != null) {
                if (this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                    if (!this.isBreathing()) {
                        if ((this.m_5448_().m_20280_((Entity)this) >= (double)Mth.m_14207_((float)4.0f) || this.isStaying()) && this.m_5448_().m_20280_((Entity)this) < (double)Mth.m_14207_((float)this.halfFollowRange()) || this.isFiring()) {
                            ++this.fireTick;
                            if (this.isFiring()) {
                                this.m_21573_().m_26573_();
                                double d2 = this.m_5448_().m_20185_() - this.m_20185_();
                                double d1 = this.m_5448_().m_20189_() - this.m_20189_();
                                this.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                                this.f_20883_ = this.m_146908_();
                            }
                            if (this.fireTick > 10) {
                                this.startFiring();
                            } else {
                                this.movement();
                                this.stopFiring();
                            }
                            if (this.fireTick == 20) {
                                this.magicFire(this.m_5448_());
                            }
                            if (this.fireTick > 44) {
                                this.fireTick = -30;
                            }
                        } else {
                            if (this.fireTick > 0) {
                                this.fireTick = 0;
                            }
                            this.stopFiring();
                            this.movement();
                        }
                    } else {
                        this.m_21573_().m_26573_();
                        this.fireTick = -20;
                        ++this.breathTick;
                        if (this.initial != null) {
                            this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.initial);
                        }
                        this.m_146922_(this.f_20885_);
                        if (this.breathTick >= 20) {
                            Vec3 vector3d = new Vec3(this.m_5448_().m_20185_() - this.initial.f_82479_, this.m_5448_().m_20186_() + (double)this.m_5448_().m_20192_() - this.initial.f_82480_, this.m_5448_().m_20189_() - this.initial.f_82481_);
                            vector3d = vector3d.m_82541_();
                            double speed = 0.25;
                            this.initial = this.initial.m_82520_(vector3d.f_82479_ * speed, vector3d.f_82480_ * speed, vector3d.f_82481_ * speed);
                            this.f_19853_.m_7605_((Entity)this, (byte)10);
                            Entity entity = MobUtil.getSingleTarget(this.f_19853_, (LivingEntity)this, 8.0, 3.0);
                            if (entity != null) {
                                this.doBreathing(entity);
                                this.m_146850_(GameEvent.f_157778_);
                            }
                        } else {
                            this.initial = new Vec3(this.m_5448_().m_20185_(), this.m_5448_().m_20188_(), this.m_5448_().m_20189_());
                        }
                        if ((float)this.breathTick >= MathHelper.secondsToTicks(3.5f) || this.hurtStop()) {
                            this.stopBreathing();
                        }
                    }
                }
            } else {
                this.stopFiring();
                this.stopBreathing();
            }
        }
    }

    public boolean hurtStop() {
        return this.f_19853_.m_46791_() == Difficulty.EASY && this.f_20916_ > 0;
    }

    @Override
    public void movement() {
        if (this.m_5448_() != null) {
            if (this.f_19796_.m_188499_() && !this.isBreathing() && this.m_5448_().m_20280_((Entity)this) <= (double)Mth.m_14207_((float)4.0f) && !this.hurtStop() && this.f_19797_ % 20 == 0) {
                this.startBreathing();
            } else if (!this.m_21573_().m_26572_()) {
                super.movement();
            }
        } else {
            super.movement();
        }
    }

    @Override
    public void magicFire(LivingEntity livingEntity) {
        WandUtil.spawn4x4IceBouquet(this.f_19853_, livingEntity.m_20182_(), (LivingEntity)this);
    }

    public void startBreathing() {
        if (!this.isBreathing()) {
            this.setBreathing(true);
            this.f_19853_.m_7605_((Entity)this, (byte)8);
            this.f_19853_.m_7605_((Entity)this, (byte)100);
            if (!this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.WRAITH_PUKE.get(), this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_((SoundEvent)ModSounds.WRAITH_PUKE.get(), 1.0f, 1.0f);
            }
        }
    }

    public void stopBreathing() {
        if (this.isBreathing()) {
            this.setBreathing(false);
            this.breathTick = 0;
            this.f_19853_.m_7605_((Entity)this, (byte)9);
        }
    }

    @Override
    public void m_7822_(byte pId) {
        if (pId == 8) {
            this.setBreathing(true);
            this.breathingAnimationState.m_216977_(this.f_19797_);
        }
        if (pId == 9) {
            this.setBreathing(false);
        }
        if (pId == 10) {
            Vec3 look = this.m_20154_();
            double dist = 0.9;
            double px = this.m_20185_() + look.m_7096_() * dist;
            double py = this.m_20188_() + look.m_7098_() * dist;
            double pz = this.m_20189_() + look.m_7094_() * dist;
            for (int i = 0; i < 16; ++i) {
                double dx = look.m_7096_();
                double dy = look.m_7098_();
                double dz = look.m_7094_();
                double spread = 10.0 + this.f_19796_.m_188500_() * 5.0;
                double velocity = 0.45 + this.f_19796_.m_188500_() * 0.45;
                dx += this.m_217043_().m_188583_() * 0.0075 * spread;
                dy += this.m_217043_().m_188583_() * 0.0075 * spread;
                dz += this.m_217043_().m_188583_() * 0.0075 * spread;
                this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.WRAITH_FIRE.get(), px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
            this.m_146850_(GameEvent.f_157778_);
        }
        super.m_7822_(pId);
    }

    @Override
    public void doBreathing(Entity target) {
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        if (damage < 1.0f) {
            damage = 1.0f;
        }
        if (this instanceof Enemy && target instanceof Enemy && this.m_5448_() != target) {
            return;
        }
        if (this.getTrueOwner() != null && (target.m_7307_((Entity)this.getTrueOwner()) || this.getTrueOwner().m_7307_(target) || target == this.getTrueOwner())) {
            return;
        }
        target.m_6469_(ModDamageSource.iceBouquet((Entity)this, (Entity)this), damage);
    }

    public static class WraithBreathingGoal<T extends AbstractBorderWraith>
    extends BreathingAttackGoal<T> {
        public AbstractBorderWraith wraith;

        public WraithBreathingGoal(T pLivingEntity, float pRange, int pSeconds, float pFloatChance) {
            super(pLivingEntity, pRange, pSeconds, pFloatChance);
            this.wraith = pLivingEntity;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !this.wraith.isFiring();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.wraith.fireTick = -30;
            this.wraith.f_19853_.m_7605_((Entity)this.wraith, (byte)8);
            this.wraith.f_19853_.m_7605_((Entity)this.wraith, (byte)100);
            if (!this.wraith.m_20067_()) {
                this.wraith.f_19853_.m_6263_((Player)null, this.wraith.m_20185_(), this.wraith.m_20186_(), this.wraith.m_20189_(), (SoundEvent)ModSounds.WRAITH_PUKE.get(), this.wraith.m_5720_(), 1.0f, 1.0f);
                this.wraith.m_5496_((SoundEvent)ModSounds.WRAITH_PUKE.get(), 1.0f, 1.0f);
            }
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.wraith.f_19853_.m_7605_((Entity)this.wraith, (byte)9);
        }
    }
}

