/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.servants;

import com.Polarice3.Goety.client.particles.PortalShockwaveParticleOption;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.boss.Apostle;
import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.neutral.ZPiglinBruteServant;
import com.Polarice3.Goety.common.entities.neutral.ZPiglinServant;
import com.Polarice3.Goety.common.entities.util.SummonCircle;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ObsidianMonolith
extends AbstractMonolith {
    public ObsidianMonolith(EntityType<? extends AbstractMonolith> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22284_, 12.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.m_5496_((SoundEvent)ModSounds.RUMBLE.get(), 10.0f, 1.0f);
        this.m_5496_(SoundEvents.f_12326_, 10.0f, 0.25f);
        return pSpawnData;
    }

    @Override
    public BlockState getState() {
        return Blocks.f_50080_.m_49966_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        int particles = 5;
        int efficiency = 0;
        boolean damage = false;
        if (!this.f_19853_.f_46443_ && !this.isEmerging()) {
            LivingEntity living;
            Entity entity;
            if (pSource.m_269533_(DamageTypeTags.f_268415_) || pSource.m_269533_(DamageTypeTags.f_268745_)) {
                return false;
            }
            if (ModDamageSource.physicalAttacks(pSource) && (entity = pSource.m_7640_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_().m_41735_(this.getState())) {
                damage = true;
                efficiency += EnchantmentHelper.m_44926_((LivingEntity)living);
            }
            if (damage) {
                pAmount *= 2.0f + (float)efficiency / 2.0f;
                particles = 20;
            }
            if ((entity = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)entity;
                for (int i = 0; i < particles; ++i) {
                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, this.getParticles(), (Entity)this);
                }
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void silentDie(DamageSource cause) {
        super.m_6667_(cause);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            Apostle apostle;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new PortalShockwaveParticleOption(0), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
            ServerParticleUtil.blockBreakParticles(this.getParticles(), BlockPos.m_274446_((Position)this.m_20182_()), this.getState(), serverLevel);
            ServerParticleUtil.blockBreakParticles(this.getParticles(), BlockPos.m_274446_((Position)this.m_20182_()).m_7494_(), this.getState(), serverLevel);
            ServerParticleUtil.blockBreakParticles(this.getParticles(), BlockPos.m_274446_((Position)this.m_20182_()).m_7494_().m_7494_(), Blocks.f_50723_.m_49966_(), serverLevel);
            for (Owned owned : this.f_19853_.m_45976_(Owned.class, this.m_20191_().m_82400_(16.0))) {
                if (owned.getTrueOwner() != this.getTrueOwner() || owned instanceof ObsidianMonolith || !owned.m_6469_(this.m_269291_().m_269425_(), (float)this.f_19853_.f_46441_.m_188503_(10) + 5.0f)) continue;
                owned.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.SAPPED.get(), 16000, 4));
                this.launch((Entity)owned, (LivingEntity)this);
            }
            LivingEntity livingEntity = this.getTrueOwner();
            if (livingEntity instanceof Apostle && (apostle = (Apostle)livingEntity).m_6084_()) {
                apostle.setMonolithCoolDown(apostle.getMonolithCoolDown() + MathHelper.secondsToTicks(45));
            }
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public void m_6667_(DamageSource cause) {
        this.m_5496_((SoundEvent)SoundEvents.f_12377_.get(), 5.0f, 0.5f);
        this.m_5496_(SoundEvents.f_12601_, 5.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        this.silentDie(cause);
    }

    protected void m_6668_(DamageSource p_21192_) {
        LivingEntity living;
        Entity entity;
        if (ModDamageSource.physicalAttacks(p_21192_) && (entity = p_21192_.m_7640_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_().m_41735_(this.getState())) {
            super.m_6668_(p_21192_);
        }
    }

    private void launch(Entity p_213688_1_, LivingEntity livingEntity) {
        double d0 = p_213688_1_.m_20185_() - livingEntity.m_20185_();
        double d1 = p_213688_1_.m_20189_() - livingEntity.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        MobUtil.push(p_213688_1_, d0 / d2 * 6.0, 0.4, d1 / d2 * 6.0);
    }

    public int m_8100_() {
        return 100;
    }

    protected SoundEvent m_7515_() {
        if (!this.isEmerging()) {
            return SoundEvents.f_12375_;
        }
        return null;
    }

    protected SoundEvent m_7975_(DamageSource p_34154_) {
        LivingEntity living;
        Entity entity;
        if (ModDamageSource.physicalAttacks(p_34154_) && (entity = p_34154_.m_7640_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_().m_41735_(this.getState())) {
            return SoundEvents.f_12600_;
        }
        return SoundEvents.f_12198_;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    @Override
    public boolean canSpawn(Level level) {
        return true;
    }

    @Override
    public void m_8107_() {
        block14: {
            LivingEntity i3;
            super.m_8107_();
            if (this.isEmerging()) break block14;
            if (this.f_19853_.f_46443_) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
                }
                if (this.getCrackiness() != AbstractMonolith.Crackiness.NONE && this.f_19853_.f_46441_.m_188503_(5) == 0) {
                    int j = this.getCrackiness() == AbstractMonolith.Crackiness.LOW ? 1 : (this.getCrackiness() == AbstractMonolith.Crackiness.MEDIUM ? 3 : 5);
                    for (int i3 = 0; i3 < j; ++i3) {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123786_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
                    }
                }
            }
            if (!this.isActivate()) {
                this.m_5496_(SoundEvents.f_12376_, 1.0f, 0.5f);
                this.setActivate(true);
            }
            if ((i3 = this.getTrueOwner()) instanceof Apostle) {
                int j;
                Apostle apostle = (Apostle)i3;
                if (apostle.m_21224_()) {
                    this.silentDie(this.m_269291_().m_269064_());
                }
                if (this.m_20270_((Entity)apostle) > 32.0f) {
                    this.teleportTowards((Entity)apostle);
                }
                int i4 = this.f_19853_.m_6443_(Owned.class, this.m_20191_().m_82400_(64.0), apostle.ZOMBIE_MINIONS).size();
                Integer[] difficulty = this.difficultyIntegerMap().get(this.f_19853_.m_46791_());
                int n = this.getCrackiness() == AbstractMonolith.Crackiness.NONE ? difficulty[0] : (this.getCrackiness() == AbstractMonolith.Crackiness.LOW ? difficulty[1] : (j = this.getCrackiness() == AbstractMonolith.Crackiness.MEDIUM ? difficulty[2] : 1));
                if (this.f_19797_ % 100 == 0 && i4 < j && this.f_19853_.f_46441_.m_188501_() <= 0.25f && !apostle.isSettingUpSecond() && !this.f_19853_.f_46443_) {
                    int numbers;
                    ServerLevel ServerLevel2 = (ServerLevel)this.f_19853_;
                    RandomSource r = this.f_19853_.f_46441_;
                    int n2 = numbers = apostle.isSecondPhase() ? 4 : 2;
                    if (this.f_19853_.m_46472_() != Level.f_46429_) {
                        for (int p = 0; p < r.m_188503_(numbers) + 1; ++p) {
                            int k = (12 + r.m_188503_(12)) * (r.m_188499_() ? -1 : 1);
                            int l = (12 + r.m_188503_(12)) * (r.m_188499_() ? -1 : 1);
                            BlockPos.MutableBlockPos blockpos$mutable = this.m_20183_().m_122032_().m_122184_(k, 0, l);
                            blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + r.m_188503_(5) - r.m_188503_(5));
                            blockpos$mutable.m_142448_((int)BlockFinder.moveDownToGround((Entity)this));
                            blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + r.m_188503_(5) - r.m_188503_(5));
                            ZPiglinServant summonedentity = !apostle.isSecondPhase() ? new ZPiglinServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.ZPIGLIN_SERVANT.get()), this.f_19853_) : new ZPiglinBruteServant((EntityType<? extends ZPiglinServant>)((EntityType)ModEntityType.ZPIGLIN_BRUTE_SERVANT.get()), this.f_19853_);
                            summonedentity.m_20035_((BlockPos)blockpos$mutable, 0.0f, 0.0f);
                            summonedentity.setTrueOwner((LivingEntity)apostle);
                            summonedentity.setLimitedLife(60 * (90 + this.f_19853_.f_46441_.m_188503_(180)));
                            ((Owned)summonedentity).m_6518_((ServerLevelAccessor)ServerLevel2, this.f_19853_.m_6436_((BlockPos)blockpos$mutable), MobSpawnType.MOB_SUMMONED, null, null);
                            summonedentity.m_6710_(apostle.m_5448_());
                            SummonCircle summonCircle = new SummonCircle(this.f_19853_, (BlockPos)blockpos$mutable, (Entity)summonedentity, false, true, (LivingEntity)apostle);
                            this.f_19853_.m_7967_((Entity)summonCircle);
                        }
                    } else {
                        for (ZombifiedPiglin zombifiedPiglin : this.f_19853_.m_45976_(ZombifiedPiglin.class, this.m_20191_().m_82400_(16.0))) {
                            if (zombifiedPiglin.m_5448_() == apostle.m_5448_()) continue;
                            zombifiedPiglin.m_6710_(apostle.m_5448_());
                        }
                        for (int p = 0; p < r.m_188503_(numbers) + 1; ++p) {
                            int k = (12 + r.m_188503_(12)) * (r.m_188499_() ? -1 : 1);
                            int l = (12 + r.m_188503_(12)) * (r.m_188499_() ? -1 : 1);
                            BlockPos.MutableBlockPos blockpos$mutable = this.m_20183_().m_122032_().m_122184_(k, 0, l);
                            blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + r.m_188503_(5) - r.m_188503_(5));
                            blockpos$mutable.m_142448_((int)BlockFinder.moveDownToGround((Entity)this));
                            blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + r.m_188503_(5) - r.m_188503_(5));
                            ZPiglinServant summonedentity = new ZPiglinServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.ZPIGLIN_SERVANT.get()), this.f_19853_);
                            summonedentity.m_20035_((BlockPos)blockpos$mutable, 0.0f, 0.0f);
                            summonedentity.setTrueOwner((LivingEntity)apostle);
                            summonedentity.setLimitedLife(60 * (90 + this.f_19853_.f_46441_.m_188503_(180)));
                            summonedentity.m_6518_((ServerLevelAccessor)ServerLevel2, this.f_19853_.m_6436_((BlockPos)blockpos$mutable), MobSpawnType.MOB_SUMMONED, null, null);
                            summonedentity.m_6710_(apostle.m_5448_());
                            SummonCircle summonCircle = new SummonCircle(this.f_19853_, (BlockPos)blockpos$mutable, (Entity)summonedentity, false, true, (LivingEntity)apostle);
                            this.f_19853_.m_7967_((Entity)summonCircle);
                        }
                    }
                }
            }
        }
    }

    public Map<Difficulty, Integer[]> difficultyIntegerMap() {
        HashMap<Difficulty, Integer[]> difficultyIntegerMap = new HashMap<Difficulty, Integer[]>();
        difficultyIntegerMap.put(Difficulty.PEACEFUL, new Integer[]{0, 0, 0});
        difficultyIntegerMap.put(Difficulty.EASY, new Integer[]{6, 4, 2});
        difficultyIntegerMap.put(Difficulty.NORMAL, new Integer[]{8, 6, 4});
        difficultyIntegerMap.put(Difficulty.HARD, new Integer[]{12, 10, 8});
        return difficultyIntegerMap;
    }

    private void teleportTowards(Entity entity) {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            for (int i = 0; i < 128; ++i) {
                double d3;
                double d2;
                Vec3 vector3d = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20227_(0.5) - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
                vector3d = vector3d.m_82541_();
                double d0 = 16.0;
                double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82479_ * d0;
                if (!this.m_20984_(d1, d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vector3d.f_82480_ * d0, d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82481_ * d0, false)) continue;
                this.teleportHits();
                break;
            }
        }
    }

    public void teleportHits() {
        this.f_19853_.m_7605_((Entity)this, (byte)5);
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
            this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
    }

    @Override
    public void m_7822_(byte pId) {
        if (pId == 5) {
            int i = 128;
            for (int j = 0; j < i; ++j) {
                double d0 = (double)j / (double)(i - 1);
                float f = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
                float f1 = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
                float f2 = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
                double d1 = Mth.m_14139_((double)d0, (double)this.f_19854_, (double)this.m_20185_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                double d2 = Mth.m_14139_((double)d0, (double)this.f_19855_, (double)this.m_20186_()) + this.f_19796_.m_188500_() * (double)this.m_20206_();
                double d3 = Mth.m_14139_((double)d0, (double)this.f_19856_, (double)this.m_20189_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d1, d2, d3, (double)f, (double)f1, (double)f2);
            }
        } else {
            super.m_7822_(pId);
        }
    }
}

