/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.servants;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.neutral.BlazeServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.HellBolt;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ModLootTables;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Inferno
extends BlazeServant {
    public Inferno(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void attackGoal() {
        this.f_21345_.m_25352_(4, (Goal)new InfernoAttackGoal(this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 48.0);
    }

    @Override
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.INFERNO_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_32235_) {
        return (SoundEvent)ModSounds.INFERNO_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.INFERNO_DEATH.get();
    }

    @Override
    public boolean m_6060_() {
        return false;
    }

    protected ResourceLocation m_7582_() {
        if (this.isNatural()) {
            return EntityType.f_20551_.m_20677_();
        }
        return super.m_7582_();
    }

    protected void m_7472_(DamageSource p_33574_, int p_33575_, boolean p_33576_) {
        super.m_7472_(p_33574_, p_33575_, p_33576_);
        if (this.isNatural() && this.f_19853_.m_7654_() != null) {
            LootTable loottable = this.f_19853_.m_7654_().m_278653_().m_278676_(ModLootTables.INFERNO);
            LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)this.f_19853_).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)p_33574_).m_287289_(LootContextParams.f_81458_, (Object)p_33574_.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)p_33574_.m_7640_());
            if (this.f_20889_ > 0 && this.f_20888_ != null) {
                lootparams$builder = lootparams$builder.m_287286_(LootContextParams.f_81456_, (Object)this.f_20888_).m_287239_(this.f_20888_.m_36336_());
            }
            LootParams lootparams = lootparams$builder.m_287235_(LootContextParamSets.f_81415_);
            loottable.m_287195_(lootparams).forEach(arg_0 -> ((Inferno)this).m_19983_(arg_0));
        }
    }

    @Override
    public void flyingTick() {
        LivingEntity livingentity = this.m_5448_();
        if (livingentity != null && livingentity.m_20188_() + 1.0 > this.m_20188_() && this.m_6779_(livingentity)) {
            Vec3 vec3 = this.m_20184_();
            this.m_20256_(this.m_20184_().m_82520_(0.0, ((double)0.3f - vec3.f_82480_) * (double)0.3f, 0.0));
            this.f_19812_ = true;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.floatInferno();
    }

    @Override
    public void clientTick() {
        if (this.f_19796_.m_188503_(24) == 0 && !this.m_20067_()) {
            this.f_19853_.m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
        }
        for (int i = 0; i < 2; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.BIG_FIRE.get(), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
    }

    public boolean m_203441_(FluidState p_204067_) {
        return p_204067_.m_205070_(FluidTags.f_13132_);
    }

    private void floatInferno() {
        if (this.m_20077_()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.f_19853_.m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.m_6853_(true);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
    }

    public float m_5610_(@NotNull BlockPos p_33895_, LevelReader p_33896_) {
        if (p_33896_.m_8055_(p_33895_).m_60819_().m_205070_(FluidTags.f_13132_)) {
            return 10.0f;
        }
        return this.m_20077_() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData spawnGroupData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (this.isNatural()) {
            this.setHostile(true);
        }
        if (this.isUpgraded()) {
            AttributeInstance armor = this.m_21051_(Attributes.f_22284_);
            AttributeInstance speed = this.m_21051_(Attributes.f_22279_);
            if (armor != null) {
                armor.m_22100_(11.0);
            }
            if (speed != null) {
                speed.m_22100_(0.45);
            }
        }
        return spawnGroupData;
    }

    @Override
    public boolean m_6126_() {
        return false;
    }

    protected boolean m_6129_() {
        return !this.m_20069_();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            this.m_5634_(amount);
            return false;
        }
        return super.m_6469_(source, amount);
    }

    static class InfernoAttackGoal
    extends Goal {
        private final Inferno blaze;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public InfernoAttackGoal(Inferno p_32247_) {
            this.blaze = p_32247_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.blaze.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.blaze.m_6779_(livingentity);
        }

        public void m_8056_() {
            this.attackStep = 0;
        }

        public void m_8041_() {
            this.blaze.setCharged(false);
            this.lastSeen = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity livingentity = this.blaze.m_5448_();
            if (livingentity != null) {
                boolean flag = this.blaze.m_21574_().m_148306_((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.blaze.m_20280_((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0 || this.blaze.isCharged()) {
                        this.attackTime = 20;
                        this.blaze.m_7327_((Entity)livingentity);
                    }
                    this.blaze.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.m_20185_() - this.blaze.m_20185_();
                    double d2 = livingentity.m_20227_(0.5) - this.blaze.m_20227_(0.5);
                    double d3 = livingentity.m_20189_() - this.blaze.m_20189_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 20;
                            this.blaze.setCharged(true);
                            if (!this.blaze.m_20067_()) {
                                this.blaze.m_5496_((SoundEvent)ModSounds.INFERNO_PRE_ATTACK.get(), 1.0f, 1.0f);
                            }
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = this.blaze.isUpgraded() ? MathHelper.secondsToTicks(1) : MathHelper.secondsToTicks(3);
                            this.attackStep = 0;
                            this.blaze.setCharged(false);
                        }
                        if (this.attackStep > 1) {
                            if (!this.blaze.m_20067_()) {
                                this.blaze.m_5496_((SoundEvent)ModSounds.HELL_BOLT_SHOOT.get(), 1.0f, 1.0f);
                            }
                            for (int i = 0; i < 1; ++i) {
                                HellBolt hellBolt = new HellBolt((LivingEntity)this.blaze, d1, d2, d3, this.blaze.f_19853_);
                                hellBolt.m_6034_(hellBolt.m_20185_(), this.blaze.m_20227_(0.5) + 0.5, hellBolt.m_20189_());
                                this.blaze.f_19853_.m_7967_((Entity)hellBolt);
                            }
                        }
                    }
                    this.blaze.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.blaze.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                }
                super.m_8037_();
            }
        }

        private double getFollowDistance() {
            return this.blaze.m_21133_(Attributes.f_22277_);
        }
    }
}

