/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.illagers;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.api.entities.ICustomAttributes;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class Tormentor
extends AbstractIllager
implements ICustomAttributes {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Tormentor.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private Mob owner;
    @Nullable
    private BlockPos boundOrigin;
    private boolean hasLimitedLife;
    private int limitedLifeTicks;

    public Tormentor(EntityType<? extends AbstractIllager> p_i50190_1_, Level p_i50190_2_) {
        super(p_i50190_1_, p_i50190_2_);
        this.f_21342_ = new MobUtil.MinionMoveControl((Mob)this);
        this.f_21364_ = 6;
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        super.m_6478_(typeIn, pos);
        this.m_20101_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new ChargeAttackGoal());
        this.f_21345_.m_25352_(8, (Goal)new MoveRandomGoal());
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new CopyOwnerTargetGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.TormentorHealth.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.TormentorDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.TormentorHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.TormentorDamage.get());
    }

    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
        if (this.hasLimitedLife && --this.limitedLifeTicks <= 0) {
            this.limitedLifeTicks = 20;
            this.m_6469_(this.m_269291_().m_269064_(), 1.0f);
        }
        if ((this.getOwner() == null || this.getOwner().m_21224_()) && this.f_19797_ % 20 == 0) {
            this.m_6469_(this.m_269291_().m_269064_(), this.m_21233_() / 4.0f);
        }
        if (!this.isCharging()) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 20, 0, false, false));
        } else {
            this.m_21195_(MobEffects.f_19609_);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public void m_7895_(int pWave, boolean p_213660_2_) {
    }

    private boolean getVexFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setVexFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("BoundX")) {
            this.boundOrigin = new BlockPos(pCompound.m_128451_("BoundX"), pCompound.m_128451_("BoundY"), pCompound.m_128451_("BoundZ"));
        }
        if (pCompound.m_128441_("LifeTicks")) {
            this.setLimitedLife(pCompound.m_128451_("LifeTicks"));
        }
        this.setConfigurableAttributes();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.boundOrigin != null) {
            pCompound.m_128405_("BoundX", this.boundOrigin.m_123341_());
            pCompound.m_128405_("BoundY", this.boundOrigin.m_123342_());
            pCompound.m_128405_("BoundZ", this.boundOrigin.m_123343_());
        }
        if (this.hasLimitedLife) {
            pCompound.m_128405_("LifeTicks", this.limitedLifeTicks);
        }
    }

    public Mob getOwner() {
        return this.owner;
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos pBoundOrigin) {
        this.boundOrigin = pBoundOrigin;
    }

    public boolean isCharging() {
        return this.getVexFlag(1);
    }

    public void setIsCharging(boolean charging) {
        this.setVexFlag(1, charging);
    }

    public void setOwner(Mob pOwner) {
        this.owner = pOwner;
    }

    public void setLimitedLife(int pLimitedLifeTicks) {
        this.hasLimitedLife = true;
        this.limitedLifeTicks = pLimitedLifeTicks;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.TORMENTOR_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.TORMENTOR_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.TORMENTOR_HURT.get();
    }

    public float getBrightness() {
        return 1.0f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        RandomSource randomSource = pLevel.m_213780_();
        this.m_213945_(randomSource, pDifficulty);
        this.m_213946_(randomSource, pDifficulty);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.TORMENTOR_CELEBRATE.get();
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance pDifficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42386_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    public boolean m_7490_() {
        return false;
    }

    class ChargeAttackGoal
    extends Goal {
        public ChargeAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (Tormentor.this.m_5448_() != null && !Tormentor.this.m_21566_().m_24995_() && Tormentor.this.f_19796_.m_188503_(7) == 0) {
                return Tormentor.this.m_20280_((Entity)Tormentor.this.m_5448_()) > 4.0;
            }
            return false;
        }

        public boolean m_8045_() {
            return Tormentor.this.m_21566_().m_24995_() && Tormentor.this.isCharging() && Tormentor.this.m_5448_() != null && Tormentor.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingentity = Tormentor.this.m_5448_();
            assert (livingentity != null);
            Vec3 vector3d = livingentity.m_20182_();
            Tormentor.this.f_21342_.m_6849_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 1.0);
            Tormentor.this.setIsCharging(true);
            Tormentor.this.m_5496_((SoundEvent)ModSounds.TORMENTOR_CHARGE.get(), 1.0f, 1.0f);
        }

        public void m_8041_() {
            Tormentor.this.setIsCharging(false);
        }

        public void m_8037_() {
            LivingEntity livingentity = Tormentor.this.m_5448_();
            assert (livingentity != null);
            if (Tormentor.this.m_20191_().m_82400_(1.0).m_82381_(livingentity.m_20191_())) {
                Tormentor.this.m_7327_((Entity)livingentity);
                Tormentor.this.setIsCharging(false);
            } else {
                double d0 = Tormentor.this.m_20280_((Entity)livingentity);
                if (d0 < 9.0) {
                    Vec3 vector3d = livingentity.m_20299_(1.0f);
                    Tormentor.this.f_21342_.m_6849_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 1.0);
                }
            }
        }
    }

    class MoveRandomGoal
    extends Goal {
        public MoveRandomGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !Tormentor.this.m_21566_().m_24995_() && Tormentor.this.f_19796_.m_188503_(7) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = Tormentor.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = Tormentor.this.m_20183_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(Tormentor.this.f_19796_.m_188503_(15) - 7, Tormentor.this.f_19796_.m_188503_(11) - 5, Tormentor.this.f_19796_.m_188503_(15) - 7);
                if (!Tormentor.this.f_19853_.m_46859_(blockpos1)) continue;
                Tormentor.this.f_21342_.m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                if (Tormentor.this.m_5448_() != null) break;
                Tormentor.this.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class CopyOwnerTargetGoal
    extends TargetGoal {
        private final TargetingConditions copyOwnerTargeting;

        public CopyOwnerTargetGoal(PathfinderMob p_i47231_2_) {
            super((Mob)p_i47231_2_, false);
            this.copyOwnerTargeting = TargetingConditions.m_148353_().m_148355_().m_26893_();
        }

        public boolean m_8036_() {
            return Tormentor.this.owner != null && Tormentor.this.owner.m_5448_() != null && this.m_26150_(Tormentor.this.owner.m_5448_(), this.copyOwnerTargeting);
        }

        public void m_8056_() {
            Tormentor.this.m_6710_(Tormentor.this.owner.m_5448_());
            super.m_8056_();
        }
    }
}

