/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.illagers;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.ShockwaveParticleOption;
import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.hostile.illagers.HuntingIllagerEntity;
import com.Polarice3.Goety.common.entities.projectiles.MonsoonCloud;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SLightningPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public class StormCaster
extends HuntingIllagerEntity {
    private static final EntityDataAccessor<Byte> IS_CASTING_SPELL = SynchedEntityData.m_135353_(StormCaster.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(StormCaster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected int castingTime;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState shockAnimationState = new AnimationState();
    public AnimationState cloudAnimationState = new AnimationState();
    public AnimationState dischargeAnimationState = new AnimationState();

    public StormCaster(EntityType<? extends HuntingIllagerEntity> p_i48551_1_, Level p_i48551_2_) {
        super(p_i48551_1_, p_i48551_2_);
        this.f_21364_ = 10;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new CastingSpellGoal());
        this.f_21345_.m_25352_(1, (Goal)new DischargeSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new MonsoonSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new ShockGoal());
        this.f_21345_.m_25352_(4, (Goal)new AvoidTargetGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 8.0f, 0.6, 1.0){

            public boolean m_8036_() {
                return super.m_8036_() && StormCaster.this.getCurrentAnimation() < 3;
            }
        });
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.StormCasterHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.StormCasterDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.StormCasterHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.StormCasterDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CASTING_SPELL, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag p_33732_) {
        super.m_7378_(p_33732_);
        this.castingTime = p_33732_.m_128451_("StormSpellTicks");
    }

    @Override
    public void m_7380_(CompoundTag p_33734_) {
        super.m_7380_(p_33734_);
        p_33734_.m_128405_("StormSpellTicks", this.castingTime);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 1;
        }
        if (Objects.equals(animation, "walk")) {
            return 2;
        }
        if (Objects.equals(animation, "shock")) {
            return 3;
        }
        if (Objects.equals(animation, "cloud")) {
            return 4;
        }
        if (Objects.equals(animation, "discharge")) {
            return 5;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.idleAnimationState);
        list.add(this.walkAnimationState);
        list.add(this.shockAnimationState);
        list.add(this.cloudAnimationState);
        list.add(this.dischargeAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.walkAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.walkAnimationState);
                    break;
                }
                case 3: {
                    this.shockAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.shockAnimationState);
                    break;
                }
                case 4: {
                    this.cloudAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.cloudAnimationState);
                    break;
                }
                case 5: {
                    this.dischargeAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.dischargeAnimationState);
                }
            }
        }
    }

    @Override
    public boolean m_33736_() {
        if (this.f_19853_.f_46443_) {
            return (Byte)this.f_19804_.m_135370_(IS_CASTING_SPELL) > 0;
        }
        return this.castingTime > 0;
    }

    public void setIsCastingSpell(int id) {
        this.f_19804_.m_135381_(IS_CASTING_SPELL, (Object)((byte)id));
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.castingTime > 0) {
            --this.castingTime;
        }
    }

    protected int m_33738_() {
        return this.castingTime;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.STORM_CASTER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.STORM_CASTER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.STORM_CASTER_HURT.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    public boolean isMoving() {
        return this.m_20184_().m_165925_() > 1.0E-6;
    }

    protected float m_6515_(DamageSource p_34149_, float p_34150_) {
        p_34150_ = super.m_6515_(p_34149_, p_34150_);
        if (p_34149_.m_7639_() == this) {
            p_34150_ = 0.0f;
        }
        if (ModDamageSource.shockAttacks(p_34149_) || p_34149_.m_269533_(DamageTypeTags.f_268725_)) {
            p_34150_ *= 0.15f;
        }
        if (p_34149_.m_269533_(DamageTypeTags.f_268725_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 300));
        }
        return p_34150_;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_7840_(double p_20809_, boolean p_20810_, BlockState p_20811_, BlockPos p_20812_) {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.m_6084_() && this.getCurrentAnimation() < 3) {
                if (this.isMoving()) {
                    this.setAnimationState("walk");
                } else {
                    this.setAnimationState("idle");
                }
            }
        } else {
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)ParticleTypes.f_123796_, (Entity)this, 1.0f);
                if (serverLevel.f_46441_.m_188503_(20) == 0) {
                    Vec3 vec3 = Vec3.m_82512_((Vec3i)this.m_20183_());
                    Vec3 vec31 = vec3.m_82520_(this.f_19796_.m_188500_(), 1.0, this.f_19796_.m_188500_());
                    ModNetwork.sendToALL(new SLightningPacket(vec3, vec31, 2));
                }
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        Vec3 vector3d = this.m_20184_();
        if (!this.m_20096_() && vector3d.f_82480_ < 0.0 && !this.m_20068_()) {
            this.m_20256_(vector3d.m_82542_(1.0, 0.6, 1.0));
        }
    }

    public boolean m_7307_(Entity pEntity) {
        Vex vex;
        if (pEntity == this) {
            return true;
        }
        if (super.m_7307_(pEntity)) {
            return true;
        }
        if (pEntity instanceof Vex && (vex = (Vex)pEntity).m_19749_() != null) {
            return this.m_7307_((Entity)vex.m_19749_());
        }
        if (pEntity instanceof LivingEntity && ((LivingEntity)pEntity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && pEntity.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7894_() {
        return (SoundEvent)ModSounds.WIND.get();
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.STORM_CASTER_CELEBRATE.get();
    }

    class CastingSpellGoal
    extends Goal {
        private CastingSpellGoal() {
        }

        public boolean m_8036_() {
            return StormCaster.this.m_33738_() > 0;
        }

        public void m_8056_() {
            super.m_8056_();
            StormCaster.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            super.m_8041_();
            StormCaster.this.setIsCastingSpell(0);
            StormCaster.this.setAnimationState("idle");
        }

        public void m_8037_() {
            if (StormCaster.this.m_5448_() != null) {
                StormCaster.this.m_21563_().m_24960_((Entity)StormCaster.this.m_5448_(), (float)StormCaster.this.m_8085_(), (float)StormCaster.this.m_8132_());
            }
        }
    }

    class DischargeSpellGoal
    extends StormCasterUseSpellGoal {
        DischargeSpellGoal() {
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && StormCaster.this.m_5448_() != null && (double)StormCaster.this.m_5448_().m_20270_((Entity)StormCaster.this) < 4.0;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            StormCaster.this.setAnimationState("discharge");
        }

        @Override
        protected void performSpellCasting() {
            Level level = StormCaster.this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                float damage = 6.0f;
                float maxDamage = 12.0f;
                if (StormCaster.this.m_5448_() != null) {
                    for (int i = -3; i < 3; ++i) {
                        for (int k = -3; k < 3; ++k) {
                            BlockPos blockPos = StormCaster.this.m_20183_().m_7918_(i, 0, k);
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.ELECTRIC.get()), (double)blockPos.m_123341_(), (double)((float)blockPos.m_123342_() + 0.5f), (double)blockPos.m_123343_(), 0, 0.0, 0.04, 0.0, 0.5);
                        }
                    }
                    StormCaster.this.m_216990_((SoundEvent)ModSounds.REDSTONE_EXPLODE.get());
                    serverLevel.m_8767_((ParticleOptions)new ShockwaveParticleOption(0), StormCaster.this.m_20185_(), StormCaster.this.m_20186_() + 0.5, StormCaster.this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                    float trueDamage = Mth.m_14036_((float)(damage + (float)serverLevel.f_46441_.m_188503_((int)(maxDamage - damage))), (float)damage, (float)maxDamage);
                    MobUtil.explosionDamage((Level)serverLevel, (Entity)StormCaster.this, ModDamageSource.indirectShock((Entity)StormCaster.this, (Entity)StormCaster.this), StormCaster.this.m_20183_(), 3.0f, trueDamage);
                    for (Entity entity : MobUtil.explosionRangeEntities((Level)serverLevel, (Entity)StormCaster.this, StormCaster.this.m_20183_(), 3.0f)) {
                        if (!(entity instanceof LivingEntity)) continue;
                        LivingEntity target = (LivingEntity)entity;
                        float chance = 0.25f;
                        if (!serverLevel.m_46470_() || !serverLevel.m_46758_(target.m_20183_()) || !(serverLevel.f_46441_.m_188501_() <= chance)) continue;
                        LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, (Level)serverLevel);
                        lightningBolt.m_146884_(target.m_20182_());
                        serverLevel.m_7967_((Entity)lightningBolt);
                    }
                }
            }
        }

        @Override
        protected int getCastingTime() {
            return 20;
        }

        @Override
        protected int getCastingInterval() {
            return 100;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.STORM_CASTER_DISCHARGE.get();
        }

        @Override
        protected int getCastWarmupTime() {
            return 10;
        }
    }

    class MonsoonSpellGoal
    extends StormCasterUseSpellGoal {
        MonsoonSpellGoal() {
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            StormCaster.this.setAnimationState("cloud");
        }

        @Override
        protected void performSpellCasting() {
            if (StormCaster.this.m_5448_() != null) {
                LivingEntity target = StormCaster.this.m_5448_();
                MonsoonCloud monsoonCloud = new MonsoonCloud(StormCaster.this.f_19853_, (LivingEntity)StormCaster.this, target);
                monsoonCloud.setStaff(true);
                StormCaster.this.f_19853_.m_7967_((Entity)monsoonCloud);
            }
        }

        @Override
        protected int getCastingTime() {
            return 22;
        }

        @Override
        protected int getCastingInterval() {
            return 100;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.STORM_CASTER_MONSOON.get();
        }
    }

    class ShockGoal
    extends Goal {
        protected int nextAttackTickCount;
        public int shockTime;

        ShockGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = StormCaster.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && StormCaster.this.m_142582_((Entity)livingentity)) {
                if (StormCaster.this.m_33736_()) {
                    return false;
                }
                return StormCaster.this.f_19797_ >= this.nextAttackTickCount;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = StormCaster.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && StormCaster.this.m_142582_((Entity)livingentity) && this.shockTime > 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            LivingEntity livingentity = StormCaster.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && StormCaster.this.m_142582_((Entity)livingentity)) {
                StormCaster.this.m_21563_().m_24960_((Entity)livingentity, (float)StormCaster.this.m_8085_(), (float)StormCaster.this.m_8132_());
            }
            StormCaster.this.f_21344_.m_26573_();
            StormCaster.this.setAnimationState("shock");
            this.nextAttackTickCount = StormCaster.this.f_19797_ + 100;
            this.shockTime = 30;
        }

        public void m_8041_() {
            super.m_8041_();
            StormCaster.this.setAnimationState("idle");
            this.shockTime = 0;
        }

        public void m_8037_() {
            super.m_8037_();
            if (StormCaster.this.m_5448_() != null) {
                StormCaster.this.m_21563_().m_24960_((Entity)StormCaster.this.m_5448_(), (float)StormCaster.this.m_8085_(), (float)StormCaster.this.m_8132_());
                if (this.shockTime > 0) {
                    --this.shockTime;
                    if (this.shockTime < 20 && MobUtil.hasVisualLineOfSight((LivingEntity)StormCaster.this, (Entity)StormCaster.this.m_5448_())) {
                        LivingEntity livingEntity;
                        Vec3 vec3 = StormCaster.this.m_146892_();
                        Entity target = MobUtil.getNearbyTarget(StormCaster.this.f_19853_, (LivingEntity)StormCaster.this, 20.0, 1.0);
                        if (target instanceof LivingEntity && !(livingEntity = (LivingEntity)target).m_21224_() && ForgeHooks.onLivingAttack((LivingEntity)livingEntity, (DamageSource)ModDamageSource.directShock((LivingEntity)StormCaster.this), (float)2.0f)) {
                            Vec3 vec31 = new Vec3(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_());
                            ModNetwork.sendToALL(new SLightningPacket(vec3, vec31, 5));
                            target.m_6469_(ModDamageSource.directShock((LivingEntity)StormCaster.this), 2.0f);
                            StormCaster.this.f_19853_.m_6263_(null, StormCaster.this.m_20185_(), StormCaster.this.m_20186_(), StormCaster.this.m_20189_(), (SoundEvent)ModSounds.ZAP.get(), StormCaster.this.m_5720_(), 1.0f, 1.0f);
                        }
                    }
                }
            }
        }
    }

    protected abstract class StormCasterUseSpellGoal
    extends Goal {
        protected int attackWarmupDelay;
        protected int nextAttackTickCount;

        protected StormCasterUseSpellGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = StormCaster.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && StormCaster.this.getCurrentAnimation() != StormCaster.this.getAnimationState("shock")) {
                if (StormCaster.this.m_33736_()) {
                    return false;
                }
                return StormCaster.this.f_19797_ >= this.nextAttackTickCount;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = StormCaster.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.attackWarmupDelay > 0;
        }

        public void m_8056_() {
            this.attackWarmupDelay = this.m_183277_(this.getCastWarmupTime());
            StormCaster.this.castingTime = this.getCastingTime();
            this.nextAttackTickCount = StormCaster.this.f_19797_ + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                StormCaster.this.m_5496_(soundevent, 1.0f, 1.0f);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            StormCaster.this.setAnimationState("idle");
        }

        public void m_8037_() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == 0) {
                this.performSpellCasting();
                StormCaster.this.m_5496_(StormCaster.this.m_7894_(), 1.0f, 1.0f);
            }
        }

        protected abstract void performSpellCasting();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        public boolean m_183429_() {
            return true;
        }
    }
}

