/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.illagers;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.FollowMobClassGoal;
import com.Polarice3.Goety.common.entities.hostile.illagers.Tormentor;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class Ripper
extends PatrollingMonster {
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(Ripper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean isWet;
    private boolean isShaking;
    private float shakeAnim;
    private float shakeAnimO;
    private int bitingTick;

    public Ripper(EntityType<? extends PatrollingMonster> p_37839_, Level p_37840_) {
        super(p_37839_, p_37840_);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new FollowMobClassGoal((Mob)this, 1.0, 4.0f, 32.0f, p_25278_ -> p_25278_ instanceof AbstractIllager && !(p_25278_ instanceof Tormentor) && this.m_5448_() == null && this.f_19796_.m_188501_() <= 0.05f));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22278_, 0.0).m_22266_(Attributes.f_22287_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_SIZE, (Object)0);
    }

    public void m_7380_(CompoundTag p_37870_) {
        super.m_7380_(p_37870_);
        p_37870_.m_128405_("BitingTick", this.bitingTick);
        p_37870_.m_128405_("Size", this.getRipperSize());
    }

    public void m_7378_(CompoundTag p_37862_) {
        super.m_7378_(p_37862_);
        this.bitingTick = p_37862_.m_128451_("BitingTick");
        this.setRipperSize(p_37862_.m_128451_("Size"));
    }

    public EntityDimensions m_6972_(Pose p_33113_) {
        float i = this.getRipperSize();
        EntityDimensions entitydimensions = super.m_6972_(p_33113_);
        float f = (entitydimensions.f_20377_ + 0.2f * i) / entitydimensions.f_20377_;
        return entitydimensions.m_20388_(f);
    }

    public void setRipperSize(int p_33109_) {
        this.f_19804_.m_135381_(ID_SIZE, (Object)Mth.m_14045_((int)p_33109_, (int)-16, (int)64));
    }

    private void updateRipperSizeInfo() {
        AttributeInstance health;
        this.m_6210_();
        AttributeInstance attack = this.m_21051_(Attributes.f_22281_);
        if (attack != null) {
            if (this.getRipperSize() < -1) {
                attack.m_22100_(0.5);
            } else {
                attack.m_22100_((double)(2 + this.getRipperSize()));
            }
        }
        if ((health = this.m_21051_(Attributes.f_22276_)) != null) {
            if (this.getRipperSize() < 0) {
                health.m_22100_((double)(16 + this.getRipperSize() * 4));
            } else {
                health.m_22100_((double)(16 + this.getRipperSize() * 2));
            }
        }
    }

    public int getRipperSize() {
        return (Integer)this.f_19804_.m_135370_(ID_SIZE);
    }

    public void m_7350_(EntityDataAccessor<?> p_33134_) {
        if (ID_SIZE.equals(p_33134_)) {
            this.updateRipperSizeInfo();
        }
        super.m_7350_(p_33134_);
    }

    protected void m_7355_(BlockPos p_30415_, BlockState p_30416_) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        if (this.m_5448_() != null) {
            return SoundEvents.f_12619_;
        }
        return SoundEvents.f_12617_;
    }

    protected SoundEvent m_7975_(DamageSource p_30424_) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12621_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public float m_6100_() {
        return super.m_6100_() - 0.25f;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.bitingTick > 0) {
            --this.bitingTick;
        }
        if (!this.f_19853_.f_46443_ && this.isWet && !this.isShaking && !this.m_21691_() && this.m_20096_()) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
            this.f_19853_.m_7605_((Entity)this, (byte)8);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            if (this.m_20071_()) {
                this.isWet = true;
                if (this.isShaking && !this.f_19853_.f_46443_) {
                    this.f_19853_.m_7605_((Entity)this, (byte)56);
                    this.cancelShake();
                }
            } else if ((this.isWet || this.isShaking) && this.isShaking) {
                if (this.shakeAnim == 0.0f) {
                    this.m_5496_(SoundEvents.f_12623_, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    this.m_146850_(GameEvent.f_223710_);
                }
                this.shakeAnimO = this.shakeAnim;
                this.shakeAnim += 0.05f;
                if (this.shakeAnimO >= 2.0f) {
                    this.isWet = false;
                    this.isShaking = false;
                    this.shakeAnimO = 0.0f;
                    this.shakeAnim = 0.0f;
                }
                if (this.shakeAnim > 0.4f) {
                    float f = (float)this.m_20186_();
                    int i = (int)(Mth.m_14031_((float)((this.shakeAnim - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vec3 vec3 = this.m_20184_();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        float f2 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    }
                }
            }
        }
    }

    private void cancelShake() {
        this.isShaking = false;
        this.shakeAnim = 0.0f;
        this.shakeAnimO = 0.0f;
    }

    public void m_6667_(DamageSource p_30384_) {
        this.isWet = false;
        this.isShaking = false;
        this.shakeAnimO = 0.0f;
        this.shakeAnim = 0.0f;
        super.m_6667_(p_30384_);
    }

    public int getBitingTick() {
        return this.bitingTick;
    }

    public int attackTotalTick() {
        return 10;
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag) {
            this.bitingTick = this.attackTotalTick();
            this.f_19853_.m_7605_((Entity)this, (byte)4);
            this.m_5496_(SoundEvents.f_11945_, this.m_6121_(), this.m_6100_());
            float f = this.f_19853_.m_6436_(this.m_20183_()).m_19056_();
            if (this.m_6060_() && this.f_19796_.m_188501_() < f * 0.3f) {
                entityIn.m_20254_(2 * (int)f);
            }
        }
        return flag;
    }

    public boolean isWet() {
        return this.isWet;
    }

    public float getWetShade(float p_30447_) {
        return Math.min(0.5f + Mth.m_14179_((float)p_30447_, (float)this.shakeAnimO, (float)this.shakeAnim) / 2.0f * 0.5f, 1.0f);
    }

    public float getBodyRollAngle(float p_30433_, float p_30434_) {
        float f = (Mth.m_14179_((float)p_30433_, (float)this.shakeAnimO, (float)this.shakeAnim) + p_30434_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return Mth.m_14031_((float)(f * (float)Math.PI)) * Mth.m_14031_((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    public float getTailAngle() {
        return 1.5393804f;
    }

    protected float m_6431_(Pose p_30409_, EntityDimensions p_30410_) {
        return p_30410_.f_20378_ * 0.8f;
    }

    public void m_7822_(byte p_30379_) {
        if (p_30379_ == 4) {
            this.bitingTick = this.attackTotalTick();
            this.m_5496_(SoundEvents.f_11945_, this.m_6121_(), this.m_6100_() * 2.0f);
        } else if (p_30379_ == 8) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
        } else if (p_30379_ == 56) {
            this.cancelShake();
        } else {
            super.m_7822_(p_30379_);
        }
    }

    public boolean m_7307_(Entity pEntity) {
        if (super.m_7307_(pEntity)) {
            return true;
        }
        if (pEntity instanceof LivingEntity && ((LivingEntity)pEntity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && pEntity.m_5647_() == null;
        }
        return false;
    }

    public boolean m_6469_(DamageSource p_34288_, float p_34289_) {
        Ripper ripper;
        if (!super.m_6469_(p_34288_, p_34289_)) {
            return false;
        }
        Level level = this.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverlevel = (ServerLevel)level;
        LivingEntity livingentity = this.m_5448_();
        if (livingentity == null && p_34288_.m_7639_() instanceof LivingEntity) {
            livingentity = (LivingEntity)p_34288_.m_7639_();
        }
        AttributeInstance spawnChance = this.m_21051_(Attributes.f_22287_);
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        if (spawnChance != null && livingentity != null && this.f_19796_.m_188500_() < spawnChance.m_22135_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46134_) && (ripper = (Ripper)((EntityType)ModEntityType.RIPPER.get()).m_20615_(this.f_19853_)) != null) {
            for (int l = 0; l < 50; ++l) {
                int i1 = i + Mth.m_216271_((RandomSource)this.f_19796_, (int)7, (int)40) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
                int j1 = j + Mth.m_216271_((RandomSource)this.f_19796_, (int)7, (int)40) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
                int k1 = k + Mth.m_216271_((RandomSource)this.f_19796_, (int)7, (int)40) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
                BlockPos blockpos = new BlockPos(i1, j1, k1);
                EntityType entitytype = ripper.m_6095_();
                SpawnPlacements.Type spawnplacements$type = SpawnPlacements.m_21752_((EntityType)entitytype);
                if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)spawnplacements$type, (LevelReader)this.f_19853_, (BlockPos)blockpos, (EntityType)entitytype) || !SpawnPlacements.m_217074_((EntityType)entitytype, (ServerLevelAccessor)serverlevel, (MobSpawnType)MobSpawnType.REINFORCEMENT, (BlockPos)blockpos, (RandomSource)this.f_19853_.f_46441_)) continue;
                ripper.m_6034_(i1, j1, k1);
                if (this.f_19853_.m_45914_((double)i1, (double)j1, (double)k1, 7.0) || !this.f_19853_.m_45784_((Entity)ripper) || !this.f_19853_.m_45786_((Entity)ripper) || this.f_19853_.m_46855_(ripper.m_20191_())) continue;
                ripper.m_6710_(livingentity);
                ripper.m_6518_((ServerLevelAccessor)serverlevel, this.f_19853_.m_6436_(ripper.m_20183_()), MobSpawnType.REINFORCEMENT, null, null);
                serverlevel.m_47205_((Entity)ripper);
                spawnChance.m_22125_(new AttributeModifier("Caller charge", (double)-0.05f, AttributeModifier.Operation.ADDITION));
                AttributeInstance spawnChance2 = ripper.m_21051_(Attributes.f_22287_);
                if (spawnChance2 == null) break;
                spawnChance2.m_22125_(new AttributeModifier("Callee charge", (double)-0.05f, AttributeModifier.Operation.ADDITION));
                break;
            }
        }
        return true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34297_, DifficultyInstance p_34298_, MobSpawnType p_34299_, @Nullable SpawnGroupData p_34300_, @Nullable CompoundTag p_34301_) {
        p_34300_ = super.m_6518_(p_34297_, p_34298_, p_34299_, p_34300_, p_34301_);
        float f = p_34298_.m_19057_();
        this.handleAttributes(f);
        return p_34300_;
    }

    protected void handleAttributes(float p_34340_) {
        this.randomizeReinforcementsChance();
        AttributeInstance speed = this.m_21051_(Attributes.f_22279_);
        AttributeInstance knockResist = this.m_21051_(Attributes.f_22278_);
        AttributeInstance spawnChance = this.m_21051_(Attributes.f_22287_);
        if (speed != null) {
            speed.m_22125_(new AttributeModifier("Random spawn speed bonus", this.f_19796_.m_188500_() * 0.05, AttributeModifier.Operation.ADDITION));
        }
        if (knockResist != null) {
            knockResist.m_22125_(new AttributeModifier("Random spawn bonus", this.f_19796_.m_188500_() * 0.05, AttributeModifier.Operation.ADDITION));
        }
        if (this.f_19796_.m_188501_() < p_34340_ * 0.05f) {
            if (spawnChance != null) {
                spawnChance.m_22125_(new AttributeModifier("Leader Ripper bonus", this.f_19796_.m_188500_() * 0.25 + 0.5, AttributeModifier.Operation.ADDITION));
            }
            this.setRipperSize(2);
        } else {
            this.setRipperSize(this.f_19796_.m_216332_(-1, 1));
        }
    }

    protected void randomizeReinforcementsChance() {
        AttributeInstance spawnChance = this.m_21051_(Attributes.f_22287_);
        if (spawnChance != null) {
            spawnChance.m_22100_(this.f_19796_.m_188500_() * 0.1);
        }
    }

    public boolean m_7490_() {
        return false;
    }
}

