/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.illagers;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ai.FollowMobClassGoal;
import com.Polarice3.Goety.common.entities.hostile.illagers.HuntingIllagerEntity;
import com.Polarice3.Goety.common.entities.hostile.illagers.Tormentor;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class Preacher
extends HuntingIllagerEntity {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Preacher.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public int healTick;
    public int healCool;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState healAnimationState = new AnimationState();

    public Preacher(EntityType<? extends HuntingIllagerEntity> p_i48551_1_, Level p_i48551_2_) {
        super(p_i48551_1_, p_i48551_2_);
        this.f_21364_ = 10;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new PreacherHealGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FollowMobClassGoal((Mob)this, 1.0, 8.0f, 16.0f, p_25278_ -> p_25278_ instanceof Raider && p_25278_.getClass() != this.getClass() && p_25278_.m_21223_() < p_25278_.m_21233_() && !(p_25278_ instanceof Tormentor)));
        this.f_21345_.m_25352_(3, (Goal)new FollowMobClassGoal((Mob)this, 1.0, 8.0f, 16.0f, p_25278_ -> p_25278_ instanceof Raider && p_25278_.getClass() != this.getClass() && !(p_25278_ instanceof Tormentor)));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
    }

    @Override
    public void extraGoals() {
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.PreacherHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.35);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.PreacherHealth.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Cooldown")) {
            this.healCool = pCompound.m_128451_("Cooldown");
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Cooldown", this.healCool);
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.walkAnimationState);
        animationStates.add(this.healAnimationState);
        return animationStates;
    }

    public void stopAllAnimations() {
        for (AnimationState animationState : this.getAnimations()) {
            animationState.m_216973_();
        }
    }

    public boolean isMoving() {
        return this.m_20184_().m_165925_() > 1.0E-6;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.m_6084_()) {
            if (!this.isHealing()) {
                this.healAnimationState.m_216973_();
                if (!this.isMoving()) {
                    this.walkAnimationState.m_216973_();
                    this.idleAnimationState.m_216982_(this.f_19797_);
                } else {
                    this.idleAnimationState.m_216973_();
                    this.walkAnimationState.m_216982_(this.f_19797_);
                }
            } else {
                this.idleAnimationState.m_216973_();
                this.walkAnimationState.m_216973_();
            }
        }
        if (this.isHealing()) {
            ++this.healTick;
        }
        if (this.healTick > 20) {
            this.setHealing(false);
            this.healTick = 0;
        }
        if (!this.f_19853_.f_46443_ && this.healCool > 0) {
            --this.healCool;
        }
    }

    private boolean getFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isHealing() {
        return this.getFlag(1);
    }

    public void setHealing(boolean attacking) {
        this.setFlag(1, attacking);
        this.healTick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.PREACHER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.PREACHER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.PREACHER_HURT.get();
    }

    public boolean m_7307_(Entity pEntity) {
        if (super.m_7307_(pEntity)) {
            return true;
        }
        if (pEntity instanceof LivingEntity && ((LivingEntity)pEntity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && pEntity.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7894_() {
        return (SoundEvent)ModSounds.PREACHER_CAST.get();
    }

    public boolean m_21531_() {
        return false;
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public boolean m_7490_() {
        return false;
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.stopAllAnimations();
            this.healAnimationState.m_216977_(this.f_19797_);
            this.setHealing(true);
        } else if (p_21375_ == 5) {
            this.healTick = 0;
        } else {
            super.m_7822_(p_21375_);
        }
    }

    public SoundEvent m_7930_() {
        return null;
    }

    public class PreacherHealGoal
    extends Goal {
        protected final Preacher preacher;
        public Raider target;

        public PreacherHealGoal(Preacher preacher) {
            this.preacher = preacher;
        }

        public boolean m_8036_() {
            this.findTarget();
            return this.target != null && this.preacher.healCool <= 0;
        }

        public boolean m_8045_() {
            return this.preacher.healTick < 20;
        }

        protected AABB getTargetSearchArea(double p_26069_) {
            return this.preacher.m_20191_().m_82377_(p_26069_, 4.0, p_26069_);
        }

        protected double getFollowDistance() {
            return this.preacher.m_21133_(Attributes.f_22277_);
        }

        protected void findTarget() {
            TargetingConditions targetConditions = TargetingConditions.m_148353_().m_26883_(this.getFollowDistance()).m_26888_(p_26058_ -> {
                if (!(p_26058_ instanceof Raider)) return false;
                Raider illager = (Raider)p_26058_;
                if (p_26058_.getClass() == this.preacher.getClass()) return false;
                if (!(p_26058_.m_21223_() < p_26058_.m_21233_())) return false;
                if (!p_26058_.m_6084_()) return false;
                if (p_26058_ instanceof Tormentor) return false;
                if (!this.preacher.m_142582_((Entity)illager)) return false;
                if (illager.m_5448_() == this.preacher) return false;
                return true;
            });
            this.target = (Raider)this.preacher.f_19853_.m_45982_(this.preacher.f_19853_.m_6443_(Raider.class, this.getTargetSearchArea(this.getFollowDistance()), p_148152_ -> true), targetConditions, (LivingEntity)this.preacher, this.preacher.m_20185_(), this.preacher.m_20188_(), this.preacher.m_20189_());
        }

        public void m_8056_() {
            super.m_8056_();
            this.preacher.f_19853_.m_7605_((Entity)this.preacher, (byte)4);
            this.preacher.setHealing(true);
            this.preacher.m_5496_(this.preacher.m_7894_(), this.preacher.m_6121_(), this.preacher.m_6100_());
        }

        public void m_8037_() {
            super.m_8037_();
            this.preacher.f_21344_.m_26573_();
            if (this.target != null && !this.target.m_21224_()) {
                MobUtil.instaLook((Mob)this.preacher, (LivingEntity)this.target);
                if (this.preacher.healTick == 10) {
                    this.target.m_5634_(((Double)AttributesConfig.PreacherHeal.get()).floatValue());
                    if (!this.preacher.f_19853_.f_46443_) {
                        ServerLevel serverWorld = (ServerLevel)this.preacher.f_19853_;
                        for (int i = 0; i < serverWorld.f_46441_.m_188503_(10) + 10; ++i) {
                            serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT_2.get()), this.target.m_20208_(1.5), this.target.m_20187_(), this.target.m_20262_(1.5), 0, 0.0, 1.0, 0.0, 1.0);
                        }
                        this.target.m_5496_((SoundEvent)ModSounds.HEAL_SPELL.get(), this.preacher.m_6121_(), this.preacher.m_6100_());
                    }
                    this.preacher.healCool = 20;
                }
            }
        }
    }
}

