/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.illagers;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.hostile.illagers.HuntingIllagerEntity;
import com.Polarice3.Goety.common.entities.hostile.illagers.Tormentor;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class Inquillager
extends HuntingIllagerEntity {
    public int coolDown;
    public int healTimes;

    public Inquillager(EntityType<? extends Inquillager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.f_21364_ = 20;
        this.coolDown = 0;
        this.healTimes = 0;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new CastingSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new HealingSelfSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new ThrowPotionGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.InquillagerHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.InquillagerDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.InquillagerHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.InquillagerDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.coolDown = pCompound.m_128451_("Cooldown");
        this.healTimes = pCompound.m_128451_("HealTimes");
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Cooldown", this.coolDown);
        pCompound.m_128405_("HealTimes", this.healTimes);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.coolDown > 0) {
            --this.coolDown;
        }
    }

    protected void m_8024_() {
        super.m_8024_();
    }

    public void setCoolDown(int coolDown) {
        this.coolDown = coolDown;
    }

    public int getCoolDown() {
        return this.coolDown;
    }

    public void increaseHealTimes() {
        ++this.healTimes;
    }

    public void setHealTimes(int healTimes) {
        this.healTimes = healTimes;
    }

    public int getHealTimes() {
        return this.healTimes;
    }

    protected SoundEvent m_7894_() {
        return SoundEvents.f_11862_;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData ilivingentitydata = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        RandomSource randomSource = pLevel.m_213780_();
        this.m_213945_(randomSource, pDifficulty);
        this.m_213946_(randomSource, pDifficulty);
        return ilivingentitydata;
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268731_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance pDifficulty) {
        if (this.m_37885_() == null) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        }
    }

    protected void m_214095_(RandomSource randomSource, float p_241844_1_) {
        super.m_214095_(randomSource, p_241844_1_);
        ItemStack itemstack = this.m_21205_();
        if (itemstack.m_41720_() == Items.f_42383_) {
            Map map = EnchantmentHelper.m_44831_((ItemStack)itemstack);
            map.putIfAbsent(Enchantments.f_44981_, 2);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_33736_()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        if (this.m_5912_()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public boolean m_7307_(Entity pEntity) {
        Vex vex;
        if (pEntity == this) {
            return true;
        }
        if (super.m_7307_(pEntity)) {
            return true;
        }
        if (pEntity instanceof Vex && (vex = (Vex)pEntity).m_19749_() != null) {
            return this.m_7307_((Entity)vex.m_19749_());
        }
        if (pEntity instanceof LivingEntity && ((LivingEntity)pEntity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && pEntity.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.INQUILLAGER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.INQUILLAGER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.INQUILLAGER_HURT.get();
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.INQUILLAGER_CELEBRATE.get();
    }

    public void m_7895_(int pWave, boolean p_213660_2_) {
        boolean flag;
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42383_);
        Raid raid = this.m_37885_();
        int i = 2;
        if (pWave > raid.m_37724_(Difficulty.NORMAL)) {
            i = 4;
        }
        boolean bl = flag = this.f_19796_.m_188501_() <= raid.m_37783_();
        if (flag) {
            HashMap map = Maps.newHashMap();
            map.put(Enchantments.f_44977_, i);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
    }

    class CastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        private CastingSpellGoal() {
            super((SpellcasterIllager)Inquillager.this);
        }

        public void m_8037_() {
            if (Inquillager.this.m_5448_() != null) {
                Inquillager.this.m_21563_().m_24960_((Entity)Inquillager.this.m_5448_(), (float)Inquillager.this.m_8085_(), (float)Inquillager.this.m_8132_());
            }
        }
    }

    class HealingSelfSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private HealingSelfSpellGoal() {
            super((SpellcasterIllager)Inquillager.this);
        }

        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            return Inquillager.this.m_21223_() < Inquillager.this.m_21233_() / 2.0f && Inquillager.this.getCoolDown() <= 0;
        }

        protected int m_8089_() {
            return 20;
        }

        protected int m_8067_() {
            return 20;
        }

        protected void m_8130_() {
            Inquillager.this.m_5634_(Inquillager.this.m_21233_());
            if (!Inquillager.this.f_19853_.f_46443_) {
                ServerLevel serverWorld = (ServerLevel)Inquillager.this.f_19853_;
                for (int i = 0; i < 5; ++i) {
                    double d0 = Inquillager.this.f_19796_.m_188583_() * 0.02;
                    double d1 = Inquillager.this.f_19796_.m_188583_() * 0.02;
                    double d2 = Inquillager.this.f_19796_.m_188583_() * 0.02;
                    serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), Inquillager.this.m_20208_(1.0), Inquillager.this.m_20187_() + 1.0, Inquillager.this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
            }
            Inquillager.this.m_5496_(SoundEvents.f_12644_, 1.0f, 2.0f);
            if (Inquillager.this.getHealTimes() > 3) {
                Inquillager.this.setHealTimes(0);
                Inquillager.this.setCoolDown(600);
            } else {
                Inquillager.this.increaseHealTimes();
                Inquillager.this.setCoolDown(100);
            }
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_11868_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    static class ThrowPotionGoal
    extends Goal {
        public int bombTimer;
        public Inquillager inquillager;

        public ThrowPotionGoal(Inquillager inquillager) {
            this.inquillager = inquillager;
        }

        public boolean m_8036_() {
            if (this.inquillager.m_5448_() != null) {
                LivingEntity livingEntity = this.inquillager.m_5448_();
                boolean noRaiders = livingEntity.f_19853_.m_6443_(Raider.class, livingEntity.m_20191_().m_82400_(5.0), entity -> !(entity instanceof Inquillager) && !(entity instanceof Tormentor)).isEmpty();
                boolean noRaiders2 = this.inquillager.f_19853_.m_6443_(Raider.class, this.inquillager.m_20191_().m_82400_(5.0), entity -> !(entity instanceof Inquillager) && !(entity instanceof Tormentor)).isEmpty();
                return (double)this.inquillager.m_20270_((Entity)livingEntity) > 4.0 && this.inquillager.m_20270_((Entity)livingEntity) <= 10.0f && this.inquillager.m_21574_().m_148306_((Entity)livingEntity) && noRaiders && noRaiders2;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.inquillager.m_5448_() != null && !this.inquillager.m_5448_().m_21224_();
        }

        public void m_8041_() {
            this.bombTimer = 0;
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity livingEntity = this.inquillager.m_5448_();
            if (livingEntity != null) {
                ++this.bombTimer;
                if (this.bombTimer >= 60) {
                    Vec3 vector3d = livingEntity.m_20184_();
                    double d0 = livingEntity.m_20185_() + vector3d.f_82479_ - this.inquillager.m_20185_();
                    double d1 = livingEntity.m_20188_() - (double)1.1f - this.inquillager.m_20186_();
                    double d2 = livingEntity.m_20189_() + vector3d.f_82481_ - this.inquillager.m_20189_();
                    float f = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
                    Potion potion = livingEntity.m_21222_() ? Potions.f_43623_ : Potions.f_43582_;
                    ThrownPotion potionentity = new ThrownPotion(this.inquillager.f_19853_, (LivingEntity)this.inquillager);
                    potionentity.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)potion));
                    potionentity.m_146926_(potionentity.m_146909_() - -20.0f);
                    potionentity.m_6686_(d0, d1 + (double)(f * 0.2f), d2, 0.75f, 8.0f);
                    if (!this.inquillager.m_20067_()) {
                        this.inquillager.f_19853_.m_6263_((Player)null, this.inquillager.m_20185_(), this.inquillager.m_20186_(), this.inquillager.m_20189_(), SoundEvents.f_12553_, this.inquillager.m_5720_(), 1.0f, 0.8f + this.inquillager.f_19796_.m_188501_() * 0.4f);
                    }
                    this.inquillager.f_19853_.m_7967_((Entity)potionentity);
                    this.bombTimer = 0;
                }
            }
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(Inquillager p_i50577_2_) {
            super((PathfinderMob)p_i50577_2_, 1.0, false);
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            if (this.f_25540_.m_20202_() instanceof Ravager) {
                float f = this.f_25540_.m_20202_().m_20205_() - 0.1f;
                return f * 2.0f * f * 2.0f + pAttackTarget.m_20205_();
            }
            return super.m_6639_(pAttackTarget);
        }
    }
}

