/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.illagers;

import com.Polarice3.Goety.MainConfig;
import com.Polarice3.Goety.api.entities.ICustomAttributes;
import com.Polarice3.Goety.api.items.magic.ITotem;
import com.Polarice3.Goety.common.entities.ai.StealTotemGoal;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public abstract class HuntingIllagerEntity
extends SpellcasterIllager
implements ICustomAttributes {
    private static final EntityDataAccessor<Boolean> RIDER = SynchedEntityData.m_135353_(HuntingIllagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> FLAGS = SynchedEntityData.m_135353_(HuntingIllagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public final Predicate<Entity> field_213690_b = Entity::m_6084_;
    public final SimpleContainer inventory = new SimpleContainer(1);

    protected HuntingIllagerEntity(EntityType<? extends HuntingIllagerEntity> p_i48551_1_, Level p_i48551_2_) {
        super(p_i48551_1_, p_i48551_2_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
        this.extraGoals();
    }

    public void extraGoals() {
        this.f_21345_.m_25352_(1, new StealTotemGoal<HuntingIllagerEntity>(this));
    }

    @Override
    public void setConfigurableAttributes() {
    }

    public void m_8119_() {
        super.m_8119_();
        EquipmentSlot equipmentslottype = EquipmentSlot.OFFHAND;
        ItemStack itemstack1 = this.m_6844_(equipmentslottype);
        if (itemstack1.m_41619_() && !this.inventory.m_7983_()) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41720_() != Items.f_42747_) continue;
                this.m_8061_(equipmentslottype, itemstack);
            }
        }
        for (LivingEntity entity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(8.0), this.field_213690_b)) {
            Ravager ravagerEntity;
            if (!this.isRider() || !(entity instanceof Ravager) || (ravagerEntity = (Ravager)entity).m_20160_() || this.m_20159_()) continue;
            this.m_7998_((Entity)ravagerEntity, true);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RIDER, (Object)false);
        this.f_19804_.m_135372_(FLAGS, (Object)0);
    }

    private boolean getFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(FLAGS);
        return (i & mask) != 0;
    }

    private void setFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public void setCasting(boolean casting) {
        this.setFlag(1, casting);
    }

    public boolean isCasting() {
        return this.getFlag(1);
    }

    public boolean isRider() {
        return (Boolean)this.f_19804_.m_135370_(RIDER);
    }

    public void setRider(boolean pIsRider) {
        this.f_19804_.m_135381_(RIDER, (Object)pIsRider);
    }

    public boolean m_33736_() {
        return super.m_33736_() || this.isCasting();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            listnbt.add((Object)itemstack.m_41739_(new CompoundTag()));
        }
        pCompound.m_128365_("Inventory", (Tag)listnbt);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        ListTag listnbt = pCompound.m_128437_("Inventory", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)listnbt.m_128728_(i));
            if (itemstack.m_41619_()) continue;
            this.inventory.m_19173_(itemstack);
        }
        this.m_21553_(true);
        this.setConfigurableAttributes();
    }

    public void m_7581_(ItemEntity pItemEntity) {
        ItemStack itemstack = pItemEntity.m_32055_();
        if (itemstack.m_41720_() instanceof ITotem) {
            if (this.inventory.m_19183_(itemstack)) {
                this.m_21053_(pItemEntity);
                this.inventory.m_19173_(itemstack);
                this.m_7938_((Entity)pItemEntity, itemstack.m_41613_());
                pItemEntity.m_146870_();
            } else {
                super.m_7581_(pItemEntity);
            }
        } else if (itemstack.m_41720_() == Items.f_42747_) {
            EquipmentSlot equipmentslottype = EquipmentSlot.OFFHAND;
            ItemStack itemstack1 = this.m_6844_(equipmentslottype);
            if (itemstack1.m_41619_()) {
                this.m_21053_(pItemEntity);
                this.m_8061_(equipmentslottype, itemstack);
                this.m_7938_((Entity)pItemEntity, itemstack.m_41613_());
                pItemEntity.m_146870_();
            } else if (this.inventory.m_19183_(itemstack)) {
                this.m_21053_(pItemEntity);
                this.inventory.m_19173_(itemstack);
                this.m_7938_((Entity)pItemEntity, itemstack.m_41613_());
                pItemEntity.m_146870_();
            } else {
                super.m_7581_(pItemEntity);
            }
        } else {
            super.m_7581_(pItemEntity);
        }
    }

    public SlotAccess m_141942_(int p_149743_) {
        int i = p_149743_ - 300;
        return i >= 0 && i < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)i) : super.m_141942_(p_149743_);
    }

    public void m_6667_(DamageSource pCause) {
        if (!this.inventory.m_7983_()) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack == ItemStack.f_41583_) continue;
                if (itemstack.m_41720_() instanceof ITotem) {
                    ITotem.increaseSouls(itemstack, (Integer)MainConfig.IllagerSouls.get());
                }
                ItemEntity itemEntity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), itemstack);
                itemEntity.m_32060_();
                this.f_19853_.m_7967_((Entity)itemEntity);
            }
        }
        super.m_6667_(pCause);
    }
}

