/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.illagers;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.MainConfig;
import com.Polarice3.Goety.api.entities.hostile.IBoss;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.hostile.illagers.HostileGolem;
import com.Polarice3.Goety.common.entities.projectiles.ScatterMine;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SAddBossPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkDirection;

public class HostileRedstoneGolem
extends HostileGolem
implements IBoss {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(HostileRedstoneGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static float SUMMON_SECONDS_TIME = 5.15f;
    private int activateTick;
    private int idleTime;
    public int summonTick;
    private int summonCool;
    private int mineCount;
    public int attackTick;
    public int postAttackTick;
    public float getGlow;
    public float glowAmount = 0.03f;
    public int noveltyTick;
    public int deathTime = 0;
    public float deathRotation = 0.0f;
    public boolean isNovelty = false;
    public boolean isPostAttack = false;
    public boolean isFlash = false;
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(false).m_7006_(false);
    private UUID bossInfoUUID = this.bossInfo.m_18860_();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState noveltyAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState summonAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();

    public HostileRedstoneGolem(EntityType<? extends HostileGolem> p_37839_, Level p_37840_) {
        super(p_37839_, p_37840_);
        this.f_21364_ = 99;
        if (this.f_19853_.f_46443_) {
            Goety.PROXY.addBoss((Mob)this);
        }
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new SummonMinesGoal());
        this.f_21345_.m_25352_(2, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(5, (Goal)new AttackGoal(1.2));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.RedstoneGolemHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 3.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.RedstoneGolemDamage.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0);
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.RedstoneGolemHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.RedstoneGolemDamage.get());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    protected Component m_5677_() {
        return ((EntityType)ModEntityType.REDSTONE_GOLEM.get()).m_20676_();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("ActivateTick", this.activateTick);
        pCompound.m_128405_("SummonTick", this.summonTick);
        pCompound.m_128405_("CoolDown", this.summonCool);
        pCompound.m_128405_("MineCount", this.mineCount);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("ActivateTick")) {
            this.activateTick = pCompound.m_128451_("ActivateTick");
        }
        if (pCompound.m_128441_("SummonTick")) {
            this.summonTick = pCompound.m_128451_("SummonTick");
        }
        if (pCompound.m_128441_("CoolDown")) {
            this.summonCool = pCompound.m_128451_("CoolDown");
        }
        if (pCompound.m_128441_("MineCount")) {
            this.mineCount = pCompound.m_128451_("MineCount");
        }
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public boolean m_7307_(Entity pEntity) {
        Vex vex;
        if (pEntity == this) {
            return true;
        }
        if (super.m_7307_(pEntity)) {
            return true;
        }
        if (pEntity instanceof Vex && (vex = (Vex)pEntity).m_19749_() != null) {
            return this.m_7307_((Entity)vex.m_19749_());
        }
        if (pEntity instanceof LivingEntity && ((LivingEntity)pEntity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && pEntity.m_5647_() == null;
        }
        return false;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_8321_(((Boolean)MainConfig.SpecialBossBar.get()).booleanValue());
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (((Boolean)MainConfig.SpecialBossBar.get()).booleanValue()) {
            this.bossInfo.m_6543_(pPlayer);
        }
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossInfo.m_6539_(pPlayer);
    }

    public void m_142687_(Entity.RemovalReason p_146834_) {
        if (this.f_19853_.f_46443_) {
            Goety.PROXY.removeBoss((Mob)this);
        }
        super.m_142687_(p_146834_);
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.REDSTONE_GOLEM_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.REDSTONE_GOLEM_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.REDSTONE_GOLEM_HURT.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_STEP.get());
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.REDSTONE_GOLEM_DEATH.get();
    }

    private boolean getGolemFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setGolemFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isMeleeAttacking() {
        return this.getGolemFlag(1);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.setGolemFlags(1, attacking);
        this.attackTick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isSummoning();
    }

    public boolean m_142582_(Entity p_149755_) {
        return this.summonTick <= 0 && super.m_142582_(p_149755_);
    }

    public boolean isSummoning() {
        return this.summonTick > 0;
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.noveltyAnimationState);
        animationStates.add(this.summonAnimationState);
        animationStates.add(this.walkAnimationState);
        animationStates.add(this.deathAnimationState);
        return animationStates;
    }

    protected void m_6153_() {
        ++this.deathTime;
        if (this.deathTime >= 30) {
            this.m_21373_();
            ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.REDSTONE_GOLEM_SKULL_ITEM.get());
            if (this.f_19853_.f_46441_.m_188501_() <= 0.11f) {
                this.m_19983_(itemStack);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.f_20916_ = 1;
        this.m_146922_(this.deathRotation);
        this.m_5618_(this.deathRotation);
    }

    public void m_6667_(DamageSource p_21014_) {
        this.f_19853_.m_7605_((Entity)this, (byte)7);
        this.deathRotation = this.m_146908_();
        super.m_6667_(p_21014_);
    }

    public void stopMostAnimations(AnimationState animationState0) {
        for (AnimationState animationState : this.getAnimations()) {
            if (animationState == animationState0) continue;
            animationState.m_216973_();
        }
    }

    public void stopAnimations() {
        for (AnimationState animationState : this.getAnimations()) {
            animationState.m_216973_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21224_()) {
            this.stopMostAnimations(this.deathAnimationState);
            this.m_146922_(this.deathRotation);
            this.m_5618_(this.deathRotation);
        }
        if (this.f_19853_.m_5776_() && this.m_6084_()) {
            if (!this.isSummoning()) {
                this.summonAnimationState.m_216973_();
                this.glow();
            }
            if (!(this.isMeleeAttacking() || this.isSummoning() || this.isMoving())) {
                this.walkAnimationState.m_216973_();
                this.idleAnimationState.m_216982_(this.f_19797_);
            } else {
                this.noveltyAnimationState.m_216973_();
                this.idleAnimationState.m_216973_();
            }
            if (!this.isMeleeAttacking() && !this.isSummoning()) {
                if (this.isMoving()) {
                    this.walkAnimationState.m_216982_(this.f_19797_);
                } else {
                    this.walkAnimationState.m_216973_();
                }
            } else {
                this.walkAnimationState.m_216973_();
            }
            if (this.isMeleeAttacking()) {
                ++this.attackTick;
            }
            if (this.summonTick > 0) {
                this.isFlash = this.summonTick < 60 && this.summonTick > 55 || this.summonTick < 52 && this.summonTick > 47 || this.summonTick < 45 && this.summonTick > 40 || this.summonTick < 38 && this.summonTick > 20;
                --this.summonTick;
            } else {
                this.summonAnimationState.m_216973_();
                this.isFlash = false;
            }
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            if (this.isNovelty) {
                this.f_20899_ = false;
                this.f_20900_ = 0.0f;
                this.f_20902_ = 0.0f;
                ++this.noveltyTick;
                if (this.noveltyTick == 8 || this.noveltyTick == 13 || this.noveltyTick == 18 || this.noveltyTick == 23 || this.noveltyTick == 28 || this.noveltyTick == 33) {
                    this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_CHEST.get());
                }
                if (this.noveltyTick == 42) {
                    this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_GROWL.get());
                    this.m_146852_(GameEvent.f_223709_, (Entity)this);
                }
                if (this.noveltyTick >= 92 || this.m_5448_() != null || this.f_20916_ > 0) {
                    this.isNovelty = false;
                }
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)10);
                this.noveltyTick = 0;
            }
            if (!(this.isMeleeAttacking() || this.isSummoning() || this.isMoving())) {
                ++this.idleTime;
                if (this.f_19853_.f_46441_.m_188501_() <= 0.05f && this.f_20916_ <= 0 && (this.m_5448_() == null || this.m_5448_().m_21224_()) && !this.isNovelty && this.idleTime >= MathHelper.minutesToTicks(1)) {
                    this.idleTime = 0;
                    this.isNovelty = true;
                    this.f_19853_.m_7605_((Entity)this, (byte)9);
                }
            } else {
                this.idleTime = 0;
                this.isNovelty = false;
            }
            if (this.summonTick > 0) {
                --this.summonTick;
            }
            if (this.summonCool > 0) {
                --this.summonCool;
            }
            if (this.isMeleeAttacking()) {
                ++this.attackTick;
            }
            if (this.isPostAttack) {
                ++this.postAttackTick;
            }
            if (this.postAttackTick >= 15) {
                this.f_19853_.m_7605_((Entity)this, (byte)11);
                this.postAttackTick = 0;
                this.isPostAttack = false;
            }
            if (this.isSummoning()) {
                int time;
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 5; ++i) {
                        double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
                        double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
                        double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_ELECTRIC.get()), this.m_20208_(0.5), this.m_20188_() - (double)serverLevel.f_46441_.m_188503_(5), this.m_20262_(0.5), 0, d0, d1, d2, 0.5);
                    }
                }
                if ((float)this.summonTick <= MathHelper.secondsToTicks(SUMMON_SECONDS_TIME - 1.0f) && this.mineCount > 0 && this.f_19797_ % (time = (int)(MathHelper.secondsToTicks(SUMMON_SECONDS_TIME - 1.0f) / 14.0f)) == 0 && this.m_20096_()) {
                    BlockPos blockPos = this.m_20183_();
                    blockPos = blockPos.m_7918_(-8 + this.f_19853_.f_46441_.m_188503_(16), 0, -8 + this.f_19853_.f_46441_.m_188503_(16));
                    BlockPos blockPos2 = this.m_20183_().m_7918_(-8 + this.f_19853_.f_46441_.m_188503_(16), 0, -8 + this.f_19853_.f_46441_.m_188503_(16));
                    ScatterMine scatterMine = new ScatterMine(this.f_19853_, (LivingEntity)this, blockPos);
                    if (!this.f_19853_.m_45976_(ScatterMine.class, new AABB(blockPos)).isEmpty()) {
                        scatterMine.m_6034_(blockPos2.m_123341_(), blockPos2.m_123342_(), blockPos2.m_123343_());
                    }
                    if (this.f_19853_.m_7967_((Entity)scatterMine)) {
                        if (this.f_19853_.f_46441_.m_188499_()) {
                            scatterMine.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_MINE_SPAWN.get());
                        }
                        --this.mineCount;
                    }
                }
            }
        }
    }

    private void glow() {
        this.getGlow = Mth.m_14036_((float)(this.getGlow + this.glowAmount), (float)0.0f, (float)1.0f);
        if (this.getGlow == 0.0f || this.getGlow == 1.0f) {
            this.glowAmount *= -1.0f;
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.stopAnimations();
            this.summonAnimationState.m_216977_(this.f_19797_);
            this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_SUMMON.get());
            this.summonTick = (int)(MathHelper.secondsToTicks(SUMMON_SECONDS_TIME) + 5.0f);
            this.getGlow = 1.0f;
        } else if (pId == 5) {
            this.attackTick = 0;
        } else if (pId == 6) {
            this.stopAnimations();
            this.attackAnimationState.m_216977_(this.f_19797_);
            this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_ATTACK.get());
        } else if (pId == 7) {
            this.stopAnimations();
            this.deathAnimationState.m_216977_(this.f_19797_);
            this.deathRotation = this.m_146908_();
            this.m_5496_((SoundEvent)ModSounds.REDSTONE_GOLEM_DEATH.get(), 1.0f, 1.0f);
        } else if (pId == 8) {
            this.stopAnimations();
        } else if (pId == 9) {
            this.stopAnimations();
            this.noveltyAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 10) {
            this.noveltyAnimationState.m_216973_();
        } else if (pId == 11) {
            this.attackAnimationState.m_216973_();
        } else {
            super.m_7822_(pId);
        }
    }

    @Override
    public double getAttackReachSqr(LivingEntity enemy) {
        return (double)(this.m_20205_() * 6.0f + enemy.m_20205_()) + 1.0;
    }

    @Override
    public boolean targetClose(LivingEntity enemy, double distToEnemySqr) {
        double reach = this.getAttackReachSqr(enemy);
        return distToEnemySqr <= reach || this.m_20191_().m_82381_(enemy.m_20191_());
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.f_19853_.f_46443_ && !this.isMeleeAttacking()) {
            this.m_5496_((SoundEvent)ModSounds.REDSTONE_GOLEM_PRE_ATTACK.get(), 1.5f, 1.0f);
            this.setMeleeAttacking(true);
        }
        return true;
    }

    @Override
    public UUID getBossInfoUUID() {
        return this.bossInfoUUID;
    }

    @Override
    public void setBossInfoUUID(UUID bossInfoUUID) {
        this.bossInfoUUID = bossInfoUUID;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return ModNetwork.INSTANCE.toVanillaPacket((Object)new SAddBossPacket(new ClientboundAddEntityPacket((Entity)this), this.bossInfoUUID), NetworkDirection.PLAY_TO_CLIENT);
    }

    public class SummonMinesGoal
    extends Goal {
        public boolean m_8036_() {
            LivingEntity livingentity = HostileRedstoneGolem.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                double d0 = HostileRedstoneGolem.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                return HostileRedstoneGolem.this.summonCool <= 0 && HostileRedstoneGolem.this.m_20096_() && HostileRedstoneGolem.this.targetClose(livingentity, d0);
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            HostileRedstoneGolem.this.m_5496_((SoundEvent)ModSounds.REDSTONE_GOLEM_SUMMON.get(), HostileRedstoneGolem.this.m_6121_(), HostileRedstoneGolem.this.m_6100_());
            HostileRedstoneGolem.this.f_19853_.m_7605_((Entity)HostileRedstoneGolem.this, (byte)4);
            HostileRedstoneGolem.this.summonTick = (int)MathHelper.secondsToTicks(SUMMON_SECONDS_TIME);
            HostileRedstoneGolem.this.summonCool = (int)MathHelper.secondsToTicks(10.0f + SUMMON_SECONDS_TIME);
            HostileRedstoneGolem.this.mineCount = 14;
        }
    }

    class MeleeGoal
    extends Goal {
        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return HostileRedstoneGolem.this.m_5448_() != null && HostileRedstoneGolem.this.isMeleeAttacking();
        }

        public boolean m_8045_() {
            return HostileRedstoneGolem.this.attackTick < 5;
        }

        public void m_8056_() {
            HostileRedstoneGolem.this.setMeleeAttacking(true);
        }

        public void m_8041_() {
            HostileRedstoneGolem.this.setMeleeAttacking(false);
            HostileRedstoneGolem.this.isPostAttack = true;
        }

        public void m_8037_() {
            if (HostileRedstoneGolem.this.m_5448_() != null && HostileRedstoneGolem.this.m_5448_().m_6084_()) {
                LivingEntity livingentity = HostileRedstoneGolem.this.m_5448_();
                double d0 = HostileRedstoneGolem.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                HostileRedstoneGolem.this.m_21563_().m_24960_((Entity)livingentity, (float)HostileRedstoneGolem.this.m_8085_(), (float)HostileRedstoneGolem.this.m_8132_());
                if (HostileRedstoneGolem.this.targetClose(livingentity, d0)) {
                    HostileRedstoneGolem.this.m_5618_(HostileRedstoneGolem.this.m_6080_());
                    if (HostileRedstoneGolem.this.attackTick == 1) {
                        HostileRedstoneGolem.this.m_216990_((SoundEvent)ModSounds.REDSTONE_GOLEM_ATTACK.get());
                        HostileRedstoneGolem.this.f_19853_.m_7605_((Entity)HostileRedstoneGolem.this, (byte)6);
                    }
                    if (HostileRedstoneGolem.this.attackTick == 3 && HostileRedstoneGolem.this.targetClose(livingentity, d0)) {
                        this.hurtTarget((Entity)livingentity);
                        this.massiveSweep((LivingEntity)HostileRedstoneGolem.this, livingentity, 3.0, 100.0);
                    }
                }
            }
        }

        public void hurtTarget(Entity target) {
            float f = (float)HostileRedstoneGolem.this.m_21133_(Attributes.f_22281_);
            float f1 = (float)HostileRedstoneGolem.this.m_21133_(Attributes.f_22282_);
            boolean flag = target.m_6469_(HostileRedstoneGolem.this.m_269291_().m_269333_((LivingEntity)HostileRedstoneGolem.this), f);
            if (flag) {
                if (f1 > 0.0f && target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    if (livingEntity.m_20191_().m_82309_() > HostileRedstoneGolem.this.m_20191_().m_82309_()) {
                        livingEntity.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(HostileRedstoneGolem.this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(HostileRedstoneGolem.this.m_146908_() * ((float)Math.PI / 180)))));
                    } else {
                        MobUtil.forcefulKnockBack(livingEntity, f1 * 0.5f, Mth.m_14031_((float)(HostileRedstoneGolem.this.m_146908_() * ((float)Math.PI / 180))), -Mth.m_14089_((float)(HostileRedstoneGolem.this.m_146908_() * ((float)Math.PI / 180))), 0.5);
                    }
                    HostileRedstoneGolem.this.m_20256_(HostileRedstoneGolem.this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                HostileRedstoneGolem.this.m_19970_((LivingEntity)HostileRedstoneGolem.this, target);
                HostileRedstoneGolem.this.m_21335_(target);
            }
        }

        public void massiveSweep(LivingEntity source, LivingEntity exempt, double range, double arc) {
            List<LivingEntity> hits = MobUtil.getAttackableLivingEntitiesNearby(source, range, 1.0, range, range);
            for (LivingEntity target : hits) {
                float targetAngle = (float)((Math.atan2(target.m_20189_() - source.m_20189_(), target.m_20185_() - source.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float attackAngle = source.f_20883_ % 360.0f;
                if (targetAngle < 0.0f) {
                    targetAngle += 360.0f;
                }
                if (attackAngle < 0.0f) {
                    attackAngle += 360.0f;
                }
                float relativeAngle = targetAngle - attackAngle;
                float hitDistance = (float)Math.sqrt((target.m_20189_() - source.m_20189_()) * (target.m_20189_() - source.m_20189_()) + (target.m_20185_() - source.m_20185_()) * (target.m_20185_() - source.m_20185_())) - target.m_20205_() / 2.0f;
                if (target == exempt || !((double)hitDistance <= range && (double)relativeAngle <= arc / 2.0 && (double)relativeAngle >= -arc / 2.0 || (double)relativeAngle >= 360.0 - arc / 2.0) && !((double)relativeAngle <= -360.0 + arc / 2.0)) continue;
                this.hurtTarget((Entity)target);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        private final double moveSpeed;
        private int delayCounter;

        public AttackGoal(double moveSpeed) {
            super((PathfinderMob)HostileRedstoneGolem.this, moveSpeed, true);
            this.moveSpeed = moveSpeed;
        }

        public boolean m_8036_() {
            return HostileRedstoneGolem.this.m_5448_() != null && HostileRedstoneGolem.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            HostileRedstoneGolem.this.m_21561_(true);
            this.delayCounter = 0;
        }

        public void m_8041_() {
            HostileRedstoneGolem.this.m_21573_().m_26573_();
            if (HostileRedstoneGolem.this.m_5448_() == null) {
                HostileRedstoneGolem.this.m_21561_(false);
            }
        }

        public void m_8037_() {
            LivingEntity livingentity = HostileRedstoneGolem.this.m_5448_();
            if (livingentity == null) {
                return;
            }
            HostileRedstoneGolem.this.m_21563_().m_24960_((Entity)livingentity, (float)HostileRedstoneGolem.this.m_8085_(), (float)HostileRedstoneGolem.this.m_8132_());
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                HostileRedstoneGolem.this.m_21573_().m_5624_((Entity)livingentity, this.moveSpeed);
            }
            this.m_6739_(livingentity, HostileRedstoneGolem.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_()));
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            if (HostileRedstoneGolem.this.targetClose(enemy, distToEnemySqr) && !HostileRedstoneGolem.this.isPostAttack) {
                HostileRedstoneGolem.this.m_7327_((Entity)enemy);
            }
        }
    }
}

