/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.illagers;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.MobsConfig;
import com.Polarice3.Goety.api.entities.IBreathing;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.ai.BreathingAttackGoal;
import com.Polarice3.Goety.common.entities.hostile.illagers.HuntingIllagerEntity;
import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.entities.projectiles.HailCloud;
import com.Polarice3.Goety.common.entities.projectiles.IceChunk;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Cryologer
extends HuntingIllagerEntity
implements IBreathing {
    private static final EntityDataAccessor<Byte> IS_CASTING_SPELL = SynchedEntityData.m_135353_(Cryologer.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(Cryologer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> BREATHING = SynchedEntityData.m_135353_(Cryologer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected int castingTime;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState breathAnimationState = new AnimationState();
    public AnimationState cloudAnimationState = new AnimationState();
    public AnimationState wallAnimationState = new AnimationState();
    public AnimationState chunkAnimationState = new AnimationState();

    public Cryologer(EntityType<? extends HuntingIllagerEntity> p_i48551_1_, Level p_i48551_2_) {
        super(p_i48551_1_, p_i48551_2_);
        this.f_21364_ = 10;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new CastingSpellGoal());
        this.f_21345_.m_25352_(1, (Goal)new WallSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new HailSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new ChunkSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new BreathGoal());
        this.f_21345_.m_25352_(4, (Goal)new AvoidTargetGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 8.0f, 0.6, 1.0){

            public boolean m_8036_() {
                return super.m_8036_() && Cryologer.this.getCurrentAnimation() < 2;
            }
        });
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.CryologerHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.CryologerDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.CryologerHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.CryologerDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CASTING_SPELL, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
        this.f_19804_.m_135372_(BREATHING, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag p_33732_) {
        super.m_7378_(p_33732_);
        this.castingTime = p_33732_.m_128451_("FrostSpellTicks");
    }

    @Override
    public void m_7380_(CompoundTag p_33734_) {
        super.m_7380_(p_33734_);
        p_33734_.m_128405_("FrostSpellTicks", this.castingTime);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 1;
        }
        if (Objects.equals(animation, "breath")) {
            return 2;
        }
        if (Objects.equals(animation, "cloud")) {
            return 3;
        }
        if (Objects.equals(animation, "wall")) {
            return 4;
        }
        if (Objects.equals(animation, "chunk")) {
            return 5;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.idleAnimationState);
        list.add(this.breathAnimationState);
        list.add(this.cloudAnimationState);
        list.add(this.wallAnimationState);
        list.add(this.chunkAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.breathAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.breathAnimationState);
                    break;
                }
                case 3: {
                    this.cloudAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.cloudAnimationState);
                    break;
                }
                case 4: {
                    this.wallAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.wallAnimationState);
                    break;
                }
                case 5: {
                    this.chunkAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.chunkAnimationState);
                }
            }
        }
    }

    @Override
    public boolean m_33736_() {
        if (this.f_19853_.f_46443_) {
            return (Byte)this.f_19804_.m_135370_(IS_CASTING_SPELL) > 0;
        }
        return this.castingTime > 0;
    }

    public void setIsCastingSpell(int id) {
        this.f_19804_.m_135381_(IS_CASTING_SPELL, (Object)((byte)id));
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.castingTime > 0) {
            --this.castingTime;
        }
    }

    protected int m_33738_() {
        return this.castingTime;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.CRYOLOGER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.CRYOLOGER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.CRYOLOGER_HURT.get();
    }

    public boolean isMoving() {
        return this.m_20184_().m_165925_() > 1.0E-6;
    }

    protected float m_6515_(DamageSource p_34149_, float p_34150_) {
        p_34150_ = super.m_6515_(p_34149_, p_34150_);
        if (p_34149_.m_7639_() == this) {
            p_34150_ = 0.0f;
        }
        if (ModDamageSource.freezeAttacks(p_34149_) || p_34149_.m_269533_(DamageTypeTags.f_268419_)) {
            p_34150_ *= 0.15f;
        }
        return p_34150_;
    }

    public void m_7601_(BlockState p_33796_, Vec3 p_33797_) {
        if (!p_33796_.m_60713_(Blocks.f_152499_)) {
            super.m_7601_(p_33796_, p_33797_);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.m_6084_()) {
            if (this.getCurrentAnimation() < 2 && this.getCurrentAnimation() != 1) {
                this.setAnimationState("idle");
            }
            if (this.isBreathing()) {
                Vec3 look = this.m_20154_();
                double dist = 0.9;
                double px = this.m_20185_() + look.m_7096_() * dist;
                double py = this.m_20188_() + look.m_7098_() * dist;
                double pz = this.m_20189_() + look.m_7094_() * dist;
                for (int i = 0; i < 2; ++i) {
                    double spread = 5.0 + this.m_217043_().m_188500_() * 2.5;
                    double velocity = 0.15 + this.m_217043_().m_188500_() * 0.15;
                    Vec3 vecSpread = new Vec3(this.m_217043_().m_188583_() * 0.0075 * spread, this.m_217043_().m_188583_() * 0.0075 * spread, this.m_217043_().m_188583_() * 0.0075 * spread);
                    Vec3 vec3 = look.m_82549_(vecSpread).m_82542_(velocity, velocity, velocity);
                    this.f_19853_.m_7107_((ParticleOptions)ParticleTypes.f_123796_, px, py, pz, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
            }
        }
    }

    public boolean m_7307_(Entity pEntity) {
        Vex vex;
        if (pEntity == this) {
            return true;
        }
        if (super.m_7307_(pEntity)) {
            return true;
        }
        if (pEntity instanceof Vex && (vex = (Vex)pEntity).m_19749_() != null) {
            return this.m_7307_((Entity)vex.m_19749_());
        }
        if (pEntity instanceof LivingEntity && ((LivingEntity)pEntity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && pEntity.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7894_() {
        return SoundEvents.f_144205_;
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.CRYOLOGER_CELEBRATE.get();
    }

    @Override
    public boolean isBreathing() {
        return (Boolean)this.f_19804_.m_135370_(BREATHING);
    }

    @Override
    public void setBreathing(boolean flag) {
        this.f_19804_.m_135381_(BREATHING, (Object)flag);
    }

    @Override
    public void doBreathing(Entity target) {
        this.m_5496_(SoundEvents.f_12320_, this.f_19796_.m_188501_() * 0.5f, this.f_19796_.m_188501_() * 0.5f);
        float damage = 1.0f;
        if (target.m_6095_().m_204039_(EntityTypeTags.f_144295_)) {
            damage *= 2.0f;
        }
        if (target.m_6469_(ModDamageSource.frostBreath((Entity)this, (Entity)this), damage) && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.FREEZING.get(), MathHelper.secondsToTicks(1)));
        }
    }

    class CastingSpellGoal
    extends Goal {
        private CastingSpellGoal() {
        }

        public boolean m_8036_() {
            return Cryologer.this.m_33738_() > 0;
        }

        public void m_8056_() {
            super.m_8056_();
            Cryologer.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            super.m_8041_();
            Cryologer.this.setIsCastingSpell(0);
            Cryologer.this.setAnimationState("idle");
        }

        public void m_8037_() {
            if (Cryologer.this.m_5448_() != null) {
                Cryologer.this.m_21563_().m_24960_((Entity)Cryologer.this.m_5448_(), (float)Cryologer.this.m_8085_(), (float)Cryologer.this.m_8132_());
            }
        }
    }

    class WallSpellGoal
    extends CryologerUseSpellGoal {
        WallSpellGoal() {
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            Cryologer.this.setAnimationState("wall");
        }

        @Override
        protected void performSpellCasting() {
            if (Cryologer.this.m_5448_() != null) {
                LivingEntity target = Cryologer.this.m_5448_();
                int random = Cryologer.this.f_19796_.m_188503_(3);
                if (random == 0) {
                    int[] rowToRemove = (int[])Util.m_214670_((Object[])WandUtil.CONFIG_1_ROWS, (RandomSource)Cryologer.this.m_217043_());
                    Direction direction = Direction.m_122364_((double)target.m_6080_());
                    switch (direction) {
                        case NORTH: {
                            rowToRemove = WandUtil.CONFIG_1_NORTH_ROW;
                            break;
                        }
                        case SOUTH: {
                            rowToRemove = WandUtil.CONFIG_1_SOUTH_ROW;
                            break;
                        }
                        case WEST: {
                            rowToRemove = WandUtil.CONFIG_1_WEST_ROW;
                            break;
                        }
                        case EAST: {
                            rowToRemove = WandUtil.CONFIG_1_EAST_ROW;
                        }
                    }
                    WandUtil.summonLesserSquareTrap((LivingEntity)Cryologer.this, target.m_20183_(), (EntityType<? extends AbstractMonolith>)((EntityType)ModEntityType.GLACIAL_WALL.get()), rowToRemove, 1);
                } else if (random == 1) {
                    WandUtil.summonWallTrap((LivingEntity)Cryologer.this, (Entity)target, (EntityType<? extends AbstractMonolith>)((EntityType)ModEntityType.GLACIAL_WALL.get()), 3, 1);
                } else {
                    WandUtil.summonRandomPillarsTrap((LivingEntity)Cryologer.this, (Entity)target, (EntityType<? extends AbstractMonolith>)((EntityType)ModEntityType.GLACIAL_WALL.get()), 6, 1);
                }
            }
        }

        @Override
        protected int getCastingTime() {
            return 20;
        }

        @Override
        protected int getCastingInterval() {
            return 80;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.CRYOLOGER_WALL.get();
        }
    }

    class HailSpellGoal
    extends CryologerUseSpellGoal {
        HailSpellGoal() {
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            Cryologer.this.setAnimationState("cloud");
        }

        @Override
        protected void performSpellCasting() {
            if (Cryologer.this.m_5448_() != null) {
                LivingEntity target = Cryologer.this.m_5448_();
                HailCloud hailCloud = new HailCloud(Cryologer.this.f_19853_, (LivingEntity)Cryologer.this, target);
                Cryologer.this.f_19853_.m_7967_((Entity)hailCloud);
            }
        }

        @Override
        protected int getCastingTime() {
            return 22;
        }

        @Override
        protected int getCastingInterval() {
            return 100;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.CRYOLOGER_HAIL.get();
        }
    }

    class ChunkSpellGoal
    extends CryologerUseSpellGoal {
        ChunkSpellGoal() {
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && Cryologer.this.f_19853_.m_46791_() == Difficulty.HARD && (Boolean)MobsConfig.CryologerIceChunk.get() != false;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            Cryologer.this.setAnimationState("chunk");
            if (Cryologer.this.m_5448_() != null) {
                LivingEntity target = Cryologer.this.m_5448_();
                IceChunk iceChunk = new IceChunk(Cryologer.this.f_19853_, (LivingEntity)Cryologer.this, target);
                iceChunk.m_5496_((SoundEvent)ModSounds.ICE_CHUNK_SUMMON.get(), 1.0f, 1.0f);
                Cryologer.this.f_19853_.m_7967_((Entity)iceChunk);
            }
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
        }

        @Override
        protected void performSpellCasting() {
        }

        @Override
        protected int getCastWarmupTime() {
            return 50;
        }

        @Override
        protected int getCastingTime() {
            return 50;
        }

        @Override
        protected int getCastingInterval() {
            return 100;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.CRYOLOGER_CHUNK.get();
        }
    }

    class BreathGoal
    extends BreathingAttackGoal<Cryologer> {
        protected int nextAttackTickCount;
        protected int breathTime;

        public BreathGoal() {
            super(Cryologer.this, 8.0f, 20, 1.0f);
        }

        public boolean noWall() {
            return MobUtil.getTargets(Cryologer.this.f_19853_, (LivingEntity)Cryologer.this, 16.0, 3.0, EntitySelector.f_20406_).stream().noneMatch(entity -> entity instanceof AbstractMonolith);
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && !Cryologer.this.m_33736_() && Cryologer.this.f_19797_ >= this.nextAttackTickCount && this.noWall();
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_() && this.noWall();
        }

        public boolean m_183429_() {
            return true;
        }

        @Override
        public void m_8056_() {
            if (this.attackTarget != null) {
                this.spewX = this.attackTarget.m_20185_();
                this.spewY = this.attackTarget.m_20186_() + (double)this.attackTarget.m_20192_();
                this.spewZ = this.attackTarget.m_20189_();
            }
            this.durationLeft = this.maxDuration;
            ((Cryologer)this.attacker).f_21344_.m_26573_();
            ((Cryologer)this.attacker).setAnimationState("breath");
            this.nextAttackTickCount = Cryologer.this.f_19797_ + 100;
            this.breathTime = 10;
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            ((Cryologer)this.attacker).setAnimationState("idle");
            this.breathTime = 0;
        }

        @Override
        public void m_8037_() {
            if (this.breathTime > 0) {
                --this.breathTime;
                ((Cryologer)this.attacker).m_21563_().m_24950_(this.spewX, this.spewY, this.spewZ, 500.0f, 500.0f);
                this.rotateAttacker(this.spewX, this.spewY, this.spewZ, 500.0f, 500.0f);
            } else {
                super.m_8037_();
                if (!((Cryologer)this.attacker).isBreathing()) {
                    ((Cryologer)this.attacker).setBreathing(true);
                }
            }
        }
    }

    protected abstract class CryologerUseSpellGoal
    extends Goal {
        protected int attackWarmupDelay;
        protected int nextAttackTickCount;

        protected CryologerUseSpellGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = Cryologer.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && Cryologer.this.getCurrentAnimation() != Cryologer.this.getAnimationState("breath")) {
                if (Cryologer.this.m_33736_()) {
                    return false;
                }
                return Cryologer.this.f_19797_ >= this.nextAttackTickCount;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = Cryologer.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.attackWarmupDelay > 0;
        }

        public void m_8056_() {
            this.attackWarmupDelay = this.m_183277_(this.getCastWarmupTime());
            Cryologer.this.castingTime = this.getCastingTime();
            this.nextAttackTickCount = Cryologer.this.f_19797_ + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                Cryologer.this.m_5496_(soundevent, 1.0f, 1.0f);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            Cryologer.this.setAnimationState("idle");
        }

        public void m_8037_() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == 0) {
                this.performSpellCasting();
                Cryologer.this.m_5496_(Cryologer.this.m_7894_(), 1.0f, 1.0f);
            }
        }

        protected abstract void performSpellCasting();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        public boolean m_183429_() {
            return true;
        }
    }
}

