/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.illagers;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.common.entities.hostile.illagers.HuntingIllagerEntity;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SLightningBoltPacket;
import com.Polarice3.Goety.common.network.server.SThunderBoltPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.Vec3Util;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Crusher
extends HuntingIllagerEntity {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Crusher.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(Crusher.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> STORM = SynchedEntityData.m_135353_(Crusher.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int attackTick;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState runAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();

    public Crusher(EntityType<? extends HuntingIllagerEntity> p_i48551_1_, Level p_i48551_2_) {
        super(p_i48551_1_, p_i48551_2_);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(4, (Goal)new AttackGoal(1.0));
    }

    @Override
    public void extraGoals() {
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.CrusherHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.CrusherDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.CrusherHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.CrusherDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
        this.f_19804_.m_135372_(STORM, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Storm", this.isStorm());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Storm")) {
            this.setStorm(pCompound.m_128471_("Storm"));
        }
    }

    protected SoundEvent m_7894_() {
        return null;
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
        boolean flag;
        Raid raid = this.m_37885_();
        int i = 0;
        if (p_37844_ > raid.m_37724_(Difficulty.NORMAL)) {
            i = 1;
        }
        boolean bl = flag = this.f_19796_.m_188501_() <= raid.m_37783_();
        if (flag) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, -1, i));
        }
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 1;
        }
        if (Objects.equals(animation, "walk")) {
            return 2;
        }
        if (Objects.equals(animation, "run")) {
            return 3;
        }
        if (Objects.equals(animation, "attack")) {
            return 4;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.walkAnimationState);
        animationStates.add(this.runAnimationState);
        animationStates.add(this.attackAnimationState);
        return animationStates;
    }

    public void stopAllAnimations() {
        for (AnimationState animationState : this.getAllAnimations()) {
            animationState.m_216973_();
        }
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.walkAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.walkAnimationState);
                    break;
                }
                case 3: {
                    this.runAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.runAnimationState);
                    break;
                }
                case 4: {
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
    }

    public void m_8038_(ServerLevel p_19927_, LightningBolt p_19928_) {
        if (!this.isStorm()) {
            this.setStorm(true);
        } else {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 600));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.m_6084_() && this.getCurrentAnimation() != this.getAnimationState("attack")) {
            if (!this.isMoving()) {
                this.setAnimationState("idle");
            } else if (!this.m_5912_()) {
                this.setAnimationState("walk");
            } else {
                this.setAnimationState("run");
            }
        }
        if (this.isMeleeAttacking()) {
            ++this.attackTick;
        }
    }

    private boolean getFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isMeleeAttacking() {
        return this.getFlag(1);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.setFlag(1, attacking);
        this.attackTick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    public boolean isStorm() {
        return (Boolean)this.f_19804_.m_135370_(STORM);
    }

    public void setStorm(boolean storm) {
        this.f_19804_.m_135381_(STORM, (Object)storm);
    }

    public float m_6100_() {
        return 0.75f;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12576_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12578_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12579_;
    }

    public boolean isMoving() {
        return this.m_20184_().m_165925_() > 1.0E-6;
    }

    public boolean m_7307_(Entity pEntity) {
        Vex vex;
        if (pEntity == this) {
            return true;
        }
        if (super.m_7307_(pEntity)) {
            return true;
        }
        if (pEntity instanceof Vex && (vex = (Vex)pEntity).m_19749_() != null) {
            return this.m_7307_((Entity)vex.m_19749_());
        }
        if (pEntity instanceof LivingEntity && ((LivingEntity)pEntity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && pEntity.m_5647_() == null;
        }
        return false;
    }

    public boolean m_21531_() {
        return false;
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 5) {
            this.attackTick = 0;
        } else if (p_21375_ == 6) {
            this.m_21561_(true);
        } else if (p_21375_ == 7) {
            this.m_21561_(false);
        } else if (p_21375_ == 8) {
            this.setMeleeAttacking(true);
        } else if (p_21375_ == 9) {
            this.setMeleeAttacking(false);
        } else {
            super.m_7822_(p_21375_);
        }
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12577_;
    }

    public Vec3 getHorizontalLookAngle() {
        return this.m_20171_(0.0f, this.m_146908_());
    }

    public double getAttackReachSqr(LivingEntity enemy) {
        return this.m_20205_() * 4.0f * this.m_20205_() * 4.0f + enemy.m_20205_();
    }

    public boolean targetClose(LivingEntity enemy, double distToEnemySqr) {
        double reach = this.getAttackReachSqr(enemy);
        return distToEnemySqr <= reach || this.m_20191_().m_82381_(enemy.m_20191_());
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.f_19853_.f_46443_ && !this.isMeleeAttacking()) {
            this.setMeleeAttacking(true);
            this.f_19853_.m_7605_((Entity)this, (byte)8);
        }
        return true;
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_) && pRecentlyHit && this.f_19853_.f_46441_.m_188501_() < 0.025f + (float)pLooting * 0.01f) {
            Item item = (Item)ModItems.GREAT_HAMMER.get();
            if (this.isStorm()) {
                item = (Item)ModItems.STORMLANDER.get();
            }
            this.m_19998_((ItemLike)item);
        }
    }

    public int m_213860_() {
        if (this.isStorm()) {
            return super.m_213860_() * 3;
        }
        return super.m_213860_();
    }

    class MeleeGoal
    extends Goal {
        private float yRot;

        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Crusher.this.m_5448_() != null && Crusher.this.isMeleeAttacking();
        }

        public boolean m_8045_() {
            return (float)Crusher.this.attackTick < MathHelper.secondsToTicks(1.3333f);
        }

        public void m_8056_() {
            Crusher.this.setMeleeAttacking(true);
            Crusher.this.f_19853_.m_7605_((Entity)Crusher.this, (byte)8);
            if (Crusher.this.m_5448_() != null) {
                MobUtil.instaLook((Mob)Crusher.this, Crusher.this.m_5448_());
            }
            this.yRot = Crusher.this.f_20883_;
        }

        public void m_8041_() {
            Crusher.this.setAnimationState("idle");
            Crusher.this.setMeleeAttacking(false);
            Crusher.this.f_19853_.m_7605_((Entity)Crusher.this, (byte)9);
        }

        public void m_8037_() {
            Crusher.this.m_146922_(this.yRot);
            Crusher.this.f_20883_ = this.yRot;
            Crusher.this.m_21573_().m_26573_();
            if (Crusher.this.attackTick == 1) {
                Crusher.this.m_5496_(SoundEvents.f_12576_, 1.0f, Crusher.this.isStorm() ? 0.75f : 1.25f);
                Crusher.this.setAnimationState("attack");
            }
            if (Crusher.this.attackTick == 11) {
                Crusher.this.m_216990_((SoundEvent)ModSounds.HAMMER_SWING.get());
            }
            if (Crusher.this.attackTick == 13) {
                LivingEntity target2;
                AABB aabb = MeleeGoal.makeAttackRange(Crusher.this.m_20185_() + Crusher.this.getHorizontalLookAngle().f_82479_ * 2.0, Crusher.this.m_20186_(), Crusher.this.m_20189_() + Crusher.this.getHorizontalLookAngle().f_82481_ * 2.0, 3.0, 1.0, 3.0);
                for (LivingEntity target2 : Crusher.this.f_19853_.m_45976_(LivingEntity.class, aabb)) {
                    if (target2 == Crusher.this || target2.m_7307_((Entity)Crusher.this) || Crusher.this.m_7307_((Entity)target2)) continue;
                    this.hurtTarget((Entity)target2);
                }
                Crusher.this.m_216990_((SoundEvent)ModSounds.HAMMER_IMPACT.get());
                Crusher.this.m_216990_((SoundEvent)ModSounds.DIRT_DEBRIS.get());
                if (Crusher.this.isStorm()) {
                    Crusher.this.m_216990_((SoundEvent)ModSounds.THUNDER_STRIKE_FAST.get());
                }
                if ((target2 = Crusher.this.f_19853_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)target2;
                    BlockPos blockPos = BlockPos.m_274561_((double)(Crusher.this.m_20185_() + Crusher.this.getHorizontalLookAngle().f_82479_ * 2.0), (double)(Crusher.this.m_20186_() - 1.0), (double)(Crusher.this.m_20189_() + Crusher.this.getHorizontalLookAngle().f_82481_ * 2.0));
                    BlockParticleOption option = new BlockParticleOption(ParticleTypes.f_123794_, serverLevel.m_8055_(blockPos));
                    for (int i = 0; i < 8; ++i) {
                        ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)option, Crusher.this.m_20185_() + Crusher.this.getHorizontalLookAngle().f_82479_ * 2.0, Crusher.this.m_20186_() + 0.25, Crusher.this.m_20189_() + Crusher.this.getHorizontalLookAngle().f_82481_ * 2.0, 1.5f);
                    }
                }
            }
        }

        public void hurtTarget(Entity target) {
            Level level;
            float f = (float)Crusher.this.m_21133_(Attributes.f_22281_);
            float f1 = (float)Crusher.this.m_21133_(Attributes.f_22282_);
            DamageSource damageSource = Crusher.this.isStorm() ? ModDamageSource.directShock((LivingEntity)Crusher.this) : Crusher.this.m_269291_().m_269333_((LivingEntity)Crusher.this);
            boolean flag = target.m_6469_(damageSource, f);
            if (flag) {
                if (f1 > 0.0f && target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    livingEntity.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(Crusher.this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(Crusher.this.m_146908_() * ((float)Math.PI / 180)))));
                    Crusher.this.m_20256_(Crusher.this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                Crusher.this.m_19970_((LivingEntity)Crusher.this, target);
                Crusher.this.m_21335_(target);
            }
            if ((level = Crusher.this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (Crusher.this.isStorm() && target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    BlockHitResult rayTraceResult = this.blockResult((Level)serverLevel, (Entity)Crusher.this, 16.0);
                    Optional<BlockPos> lightningRod = BlockFinder.findLightningRod(serverLevel, BlockPos.m_274446_((Position)rayTraceResult.m_82450_()), 16);
                    if (lightningRod.isPresent()) {
                        BlockPos blockPos1 = lightningRod.get();
                        ModNetwork.sendToALL(new SLightningBoltPacket(new Vec3((double)blockPos1.m_123341_(), (double)(blockPos1.m_123342_() + 250), (double)blockPos1.m_123343_()), new Vec3((double)blockPos1.m_123341_(), (double)blockPos1.m_123342_(), (double)blockPos1.m_123343_()), 10));
                        serverLevel.m_6263_(null, Crusher.this.m_20185_(), Crusher.this.m_20186_(), Crusher.this.m_20189_(), (SoundEvent)ModSounds.THUNDERBOLT.get(), Crusher.this.m_5720_(), 1.0f, 1.0f);
                    } else {
                        Vec3 vec31 = new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_() + (double)(livingEntity.m_20206_() / 2.0f), livingEntity.m_20189_());
                        ModNetwork.sendToALL(new SLightningBoltPacket(new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_() + 250.0, livingEntity.m_20189_()), vec31, 10));
                        this.chain(livingEntity, (LivingEntity)Crusher.this);
                        serverLevel.m_6263_(null, Crusher.this.m_20185_(), Crusher.this.m_20186_(), Crusher.this.m_20189_(), (SoundEvent)ModSounds.THUNDERBOLT.get(), Crusher.this.m_5720_(), 1.0f, 1.0f);
                    }
                }
            }
        }

        public void chain(LivingEntity pTarget, LivingEntity pAttacker) {
            double range = 6.0;
            Level level = pAttacker.f_19853_;
            float oDamage = (float)pAttacker.m_21133_(Attributes.f_22281_);
            ArrayList<LivingEntity> harmed = new ArrayList<LivingEntity>();
            Predicate<Entity> selector = entity -> {
                LivingEntity livingEntity;
                return entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity) != pAttacker && !harmed.contains(livingEntity) && MobUtil.canAttack((LivingEntity)Crusher.this, livingEntity);
            };
            LivingEntity prevTarget = pTarget;
            float damage = level.m_46470_() ? oDamage : oDamage / 2.0f;
            for (int i = 0; i < 4; ++i) {
                AABB aabb = new AABB(Vec3Util.subtract(prevTarget.m_20182_(), range), Vec3Util.add(prevTarget.m_20182_(), range));
                List entities = level.m_6249_((Entity)prevTarget, aabb, selector);
                if (entities.isEmpty()) continue;
                LivingEntity target = (LivingEntity)entities.get(level.m_213780_().m_188503_(entities.size()));
                if (target.m_6469_(ModDamageSource.directShock(pAttacker), damage) && prevTarget != target) {
                    Vec3 vec3 = prevTarget.m_146892_();
                    Vec3 vec31 = target.m_146892_();
                    ModNetwork.sendToALL(new SThunderBoltPacket(vec3, vec31, 8));
                }
                harmed.add(target);
                prevTarget = target;
                damage -= 1.0f;
            }
        }

        public BlockHitResult blockResult(Level worldIn, Entity entity, double range) {
            float f = entity.m_146909_();
            float f1 = entity.m_146908_();
            Vec3 vector3d = entity.m_20299_(1.0f);
            float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
            float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
            float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
            float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
            float f6 = f3 * f4;
            float f7 = f2 * f4;
            Vec3 vector3d1 = vector3d.m_82520_((double)f6 * range, (double)f5 * range, (double)f7 * range);
            return worldIn.m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity));
        }

        public static AABB makeAttackRange(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
            return new AABB(x - sizeX / 2.0, y - sizeY / 2.0, z - sizeZ / 2.0, x + sizeX / 2.0, y + sizeY / 2.0, z + sizeZ / 2.0);
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        private final double moveSpeed;
        private int delayCounter;

        public AttackGoal(double moveSpeed) {
            super((PathfinderMob)Crusher.this, moveSpeed, true);
            this.moveSpeed = moveSpeed;
        }

        public boolean m_8036_() {
            return Crusher.this.m_5448_() != null && Crusher.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            Crusher.this.m_21561_(true);
            Crusher.this.f_19853_.m_7605_((Entity)Crusher.this, (byte)6);
            this.delayCounter = 0;
        }

        public void m_8041_() {
            Crusher.this.m_21573_().m_26573_();
            Crusher.this.m_21561_(false);
            Crusher.this.f_19853_.m_7605_((Entity)Crusher.this, (byte)7);
        }

        public void m_8037_() {
            LivingEntity livingentity = Crusher.this.m_5448_();
            if (livingentity == null) {
                return;
            }
            Crusher.this.m_21563_().m_24960_((Entity)livingentity, (float)Crusher.this.m_8085_(), (float)Crusher.this.m_8132_());
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                Crusher.this.m_21573_().m_5624_((Entity)livingentity, this.moveSpeed);
            }
            this.m_6739_(livingentity, Crusher.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_()));
        }

        protected void m_6739_(@NotNull LivingEntity enemy, double distToEnemySqr) {
            if (Crusher.this.targetClose(enemy, distToEnemySqr)) {
                Crusher.this.m_7327_((Entity)enemy);
            }
        }
    }
}

