/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.illagers;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.hostile.illagers.HuntingIllagerEntity;
import com.Polarice3.Goety.common.entities.hostile.illagers.Tormentor;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class Conquillager
extends HuntingIllagerEntity
implements CrossbowAttackMob {
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(Conquillager.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Conquillager(EntityType<? extends Conquillager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.f_21364_ = 20;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new IllagerCrossbowGoal(this, (PathfinderMob)this, 1.0, 16.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.ConquillagerHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 5.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.ConquillagerHealth.get());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        for (LivingEntity entity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(8.0), this.field_213690_b)) {
            if (entity instanceof PatrollingMonster || entity.m_6336_() == MobType.f_21641_ || this.f_19797_ % 100 != 0 || this.m_217043_().m_188503_(20) != 0) continue;
            if (entity instanceof Player) {
                if (((Player)entity).m_7500_()) continue;
                entity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.ILLAGUE.get(), 2000, 0, false, false));
                continue;
            }
            entity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.ILLAGUE.get(), 2000, 0, false, false));
        }
        if (this.f_19853_.f_46443_ && this.f_19797_ % 20 == 0) {
            for (int i = 0; i < 8; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.PLAGUE_EFFECT.get(), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.5, 0.0);
            }
        }
    }

    protected SoundEvent m_7894_() {
        return null;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
    }

    public boolean m_5886_(ProjectileWeaponItem p_230280_1_) {
        return p_230280_1_ == Items.f_42717_;
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean pIsCharging) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)pIsCharging);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.isChargingCrossbow()) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE;
        }
        if (this.m_21093_(item -> item.m_41720_() instanceof CrossbowItem)) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_HOLD;
        }
        return this.m_5912_() ? AbstractIllager.IllagerArmPose.ATTACKING : AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    public float m_5610_(BlockPos pPos, LevelReader pLevel) {
        BlockState blockstate = pLevel.m_8055_(pPos.m_7495_());
        return !blockstate.m_60713_(Blocks.f_50440_) && !blockstate.m_60713_(Blocks.f_49992_) ? 0.5f - pLevel.m_220419_(pPos) : 10.0f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33282_, DifficultyInstance p_33283_, MobSpawnType p_33284_, @Nullable SpawnGroupData p_33285_, @Nullable CompoundTag p_33286_) {
        RandomSource randomsource = p_33282_.m_213780_();
        this.m_213945_(randomsource, p_33283_);
        this.m_213946_(randomsource, p_33283_);
        return super.m_6518_(p_33282_, p_33283_, p_33284_, p_33285_, p_33286_);
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance pDifficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
    }

    protected void m_214095_(RandomSource randomsource, float p_241844_1_) {
        super.m_214095_(randomsource, p_241844_1_);
        ItemStack itemstack = this.m_21205_();
        if (itemstack.m_41720_() == Items.f_42717_) {
            Map map = EnchantmentHelper.m_44831_((ItemStack)itemstack);
            map.putIfAbsent(Enchantments.f_44961_, 4);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    public boolean m_7307_(Entity pEntity) {
        if (super.m_7307_(pEntity)) {
            return true;
        }
        if (pEntity instanceof LivingEntity && ((LivingEntity)pEntity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && pEntity.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.CONQUILLAGER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.CONQUILLAGER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.CONQUILLAGER_HURT.get();
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        this.m_32336_((LivingEntity)this, 1.6f);
    }

    public void m_5811_(LivingEntity shooter, ItemStack itemStack, Projectile projectileEntity, float p_230284_4_) {
        this.m_32322_((LivingEntity)this, shooter, projectileEntity, p_230284_4_, 1.6f);
    }

    public void m_32336_(LivingEntity shooter, float velocity) {
        InteractionHand hand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)shooter, item -> item instanceof CrossbowItem);
        ItemStack itemstack = shooter.m_21120_(hand);
        if (shooter.m_21093_(itemStack -> itemStack.m_41720_() instanceof CrossbowItem)) {
            CrossbowItem.m_40887_((Level)shooter.f_19853_, (LivingEntity)shooter, (InteractionHand)hand, (ItemStack)itemstack, (float)velocity, (float)(14 - shooter.f_19853_.m_46791_().m_19028_() * 4));
        }
        this.m_5847_();
    }

    public void m_32322_(LivingEntity shooter, LivingEntity target, Projectile projectileEntity, float p_234279_4_, float velocity) {
        double d0 = target.m_20185_() - shooter.m_20185_();
        double d1 = target.m_20227_(0.5) - shooter.m_20227_(0.5);
        double d2 = target.m_20189_() - shooter.m_20189_();
        Vector3f vector3f = this.m_252851_(shooter, new Vec3(d0, d1, d2), p_234279_4_);
        projectileEntity.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), velocity, (float)(14 - shooter.f_19853_.m_46791_().m_19028_() * 4));
        shooter.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (shooter.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    public ItemStack m_6298_(ItemStack pShootable) {
        int difficulty = this.f_19853_.m_6436_(this.m_20183_()).m_19048_().m_19028_();
        return MobUtil.createFirework(difficulty * 2, DyeColor.values());
    }

    public void m_7895_(int pWave, boolean p_213660_2_) {
        boolean flag;
        Raid raid = this.m_37885_();
        boolean bl = flag = this.f_19796_.m_188501_() <= raid.m_37783_();
        if (flag) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42717_);
            HashMap map = Maps.newHashMap();
            if (pWave > raid.m_37724_(Difficulty.NORMAL)) {
                map.put(Enchantments.f_44960_, 3);
            } else if (pWave > raid.m_37724_(Difficulty.EASY)) {
                map.put(Enchantments.f_44960_, 2);
            }
            map.put(Enchantments.f_44959_, 1);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.CONQUILLAGER_CELEBRATE.get();
    }

    public class IllagerCrossbowGoal<T extends PathfinderMob & CrossbowAttackMob>
    extends Goal {
        private final T mob;
        private CrossbowState crossbowState = CrossbowState.UNCHARGED;
        private final double speedModifier;
        private final float attackRadiusSqr;
        private int seeTime;
        private int attackDelay;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        final /* synthetic */ Conquillager this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public IllagerCrossbowGoal(T t, double p_i50322_4_, float f) {
            void p_i50322_1_;
            this.this$0 = (Conquillager)this$0;
            this.mob = p_i50322_1_;
            this.speedModifier = p_i50322_2_;
            this.attackRadiusSqr = (float)(p_i50322_4_ * p_i50322_4_);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.isValidTarget() && this.isHoldingCrossbow();
        }

        private boolean isHoldingCrossbow() {
            return this.mob.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
        }

        public boolean m_8045_() {
            return this.isValidTarget() && (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingCrossbow();
        }

        private boolean isValidTarget() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.m_21561_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.m_21561_(false);
            this.mob.m_6710_((LivingEntity)null);
            this.seeTime = 0;
            if (this.mob.m_6117_()) {
                this.mob.m_5810_();
                ((CrossbowAttackMob)this.mob).m_6136_(false);
                CrossbowItem.m_40884_((ItemStack)this.mob.m_21211_(), (boolean)false);
            }
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                boolean flag2;
                boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
                boolean flag1 = this.seeTime > 0;
                boolean noRaiders = livingentity.f_19853_.m_6443_(Raider.class, livingentity.m_20191_().m_82400_(5.0), entity -> entity != this.mob && !(entity instanceof Tormentor)).isEmpty();
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                double d0 = this.mob.m_20280_((Entity)livingentity);
                boolean bl = flag2 = (d0 > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
                if (d0 < (double)this.attackRadiusSqr && this.seeTime >= 20) {
                    this.mob.m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    this.strafingBackwards = d0 < (double)(this.attackRadiusSqr * 0.25f);
                    this.mob.m_21566_().m_24988_(this.strafingBackwards ? (float)(-this.speedModifier) : (float)this.speedModifier, 0.0f);
                    this.mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                }
                if (this.crossbowState == CrossbowState.UNCHARGED) {
                    if (!flag2) {
                        this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                        this.crossbowState = CrossbowState.CHARGING;
                        ((CrossbowAttackMob)this.mob).m_6136_(true);
                    }
                } else if (this.crossbowState == CrossbowState.CHARGING) {
                    ItemStack itemstack;
                    int i;
                    if (!this.mob.m_6117_()) {
                        this.crossbowState = CrossbowState.UNCHARGED;
                    }
                    if ((i = this.mob.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)(itemstack = this.mob.m_21211_()))) {
                        this.mob.m_21253_();
                        this.crossbowState = CrossbowState.CHARGED;
                        this.attackDelay = 20 + this.mob.m_217043_().m_188503_(20);
                        ((CrossbowAttackMob)this.mob).m_6136_(false);
                    }
                } else if (this.crossbowState == CrossbowState.CHARGED) {
                    --this.attackDelay;
                    if (this.attackDelay == 0) {
                        this.crossbowState = CrossbowState.READY_TO_ATTACK;
                    }
                } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && flag && noRaiders) {
                    ((RangedAttackMob)this.mob).m_6504_(livingentity, 1.0f);
                    ItemStack itemstack1 = this.mob.m_21120_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                    CrossbowItem.m_40884_((ItemStack)itemstack1, (boolean)false);
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
            }
        }

        static enum CrossbowState {
            UNCHARGED,
            CHARGING,
            CHARGED,
            READY_TO_ATTACK;

        }
    }
}

