/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.cultists;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.WitchBarterGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.hostile.cultists.Cultist;
import com.Polarice3.Goety.common.entities.neutral.Wartling;
import com.Polarice3.Goety.common.entities.projectiles.BerserkFungus;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableWitchTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestHealableRaiderTargetGoal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Warlock
extends Cultist
implements RangedAttackMob {
    private int coolDown;
    private int totalCool;
    private NearestHealableRaiderTargetGoal<Raider> healRaidersGoal;
    private NearestAttackableWitchTargetGoal<Player> attackPlayersGoal;

    public Warlock(EntityType<? extends Cultist> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.healRaidersGoal = new NearestHealableRaiderTargetGoal((Raider)this, Raider.class, true, target -> target != null && this.m_37886_() && target.m_6095_() != EntityType.f_20495_ && target.m_6095_() != ModEntityType.WARLOCK.get());
        this.attackPlayersGoal = new NearestAttackableWitchTargetGoal((Raider)this, Player.class, 10, true, false, (Predicate)null);
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 40, 10.0f));
        this.f_21345_.m_25352_(1, (Goal)new WitchBarterGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}));
        this.f_21346_.m_25352_(2, this.healRaidersGoal);
        this.f_21346_.m_25352_(3, this.attackPlayersGoal);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public void m_7380_(CompoundTag p_33353_) {
        super.m_7380_(p_33353_);
        p_33353_.m_128405_("CoolDown", this.coolDown);
        p_33353_.m_128405_("TotalCool", this.totalCool);
    }

    @Override
    public void m_7378_(CompoundTag p_33344_) {
        super.m_7378_(p_33344_);
        this.coolDown = p_33344_.m_128451_("CoolDown");
        this.totalCool = p_33344_.m_128451_("TotalCool");
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.WARLOCK_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_34154_) {
        return (SoundEvent)ModSounds.WARLOCK_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.WARLOCK_DEATH.get();
    }

    @Override
    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.WARLOCK_CELEBRATE.get();
    }

    public void m_142687_(Entity.RemovalReason p_146834_) {
        AbstractHorse donkey;
        Entity entity;
        if (this.m_20159_() && this.m_20202_() != null && (entity = this.m_20202_()) instanceof AbstractHorse && (donkey = (AbstractHorse)entity).m_21805_() != null && donkey.m_21805_() == this.m_20148_()) {
            donkey.m_6074_();
        }
        super.m_142687_(p_146834_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
        if (p_37858_ == MobSpawnType.EVENT && p_37856_.m_6018_().f_46441_.m_188501_() <= 0.25f) {
            Donkey donkey = new Donkey(EntityType.f_20560_, (Level)p_37856_.m_6018_());
            if (p_37856_.m_6018_().f_46441_.m_188501_() <= 0.25f) {
                donkey = new Mule(EntityType.f_20503_, (Level)p_37856_.m_6018_());
            }
            donkey.m_6518_(p_37856_, p_37856_.m_6018_().m_6436_(this.m_20183_()), MobSpawnType.EVENT, null, null);
            donkey.m_146762_(0);
            donkey.m_30651_(true);
            donkey.m_30586_(this.m_20148_());
            donkey.m_146884_(this.m_20182_());
            p_37856_.m_6018_().m_7967_((Entity)donkey);
            this.m_20329_((Entity)donkey);
        }
        return super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.coolDown > 0) {
            --this.coolDown;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.m_6084_()) {
                this.healRaidersGoal.m_26094_();
                this.attackPlayersGoal.m_26083_(this.healRaidersGoal.m_26093_() <= 0);
            }
            if (this.f_19796_.m_188501_() < 7.5E-4f) {
                this.f_19853_.m_7605_((Entity)this, (byte)15);
            }
            if (this.m_5448_() != null) {
                if (!(this.m_5448_() instanceof Raider)) {
                    if (this.m_5448_().m_20270_((Entity)this) < 6.0f && this.coolDown <= this.totalCool / 2) {
                        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.SNAP_FUNGUS.get()));
                    } else {
                        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    }
                } else {
                    this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.BERSERK_FUNGUS.get()));
                }
            } else {
                if (this.m_21205_().m_150930_((Item)ModItems.SNAP_FUNGUS.get()) || this.m_21205_().m_150930_((Item)ModItems.BERSERK_FUNGUS.get())) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                }
                boolean flag = false;
                if (!this.m_20077_()) {
                    if (this.m_21223_() < this.m_21233_()) {
                        flag = true;
                    }
                    if (!this.m_21220_().isEmpty() && this.m_21220_().stream().anyMatch(mobEffectInstance -> mobEffectInstance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL)) {
                        flag = true;
                    }
                    if (flag && this.f_19797_ % 60 == 0) {
                        Wartling wartling = new Wartling((EntityType<? extends Summoned>)((EntityType)ModEntityType.WARTLING.get()), this.f_19853_);
                        wartling.m_20035_(this.m_20183_(), this.m_146908_(), this.m_146909_());
                        this.summonWartlings(wartling);
                    }
                }
            }
        }
    }

    public void m_7822_(byte p_34138_) {
        if (p_34138_ == 15) {
            for (int i = 0; i < this.f_19796_.m_188503_(35) + 10; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.WARLOCK.get(), this.m_20185_() + this.f_19796_.m_188583_() * (double)0.13f, this.m_20191_().f_82292_ + this.f_19796_.m_188583_() * (double)0.13f, this.m_20189_() + this.f_19796_.m_188583_() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.m_7822_(p_34138_);
        }
    }

    protected float m_6515_(DamageSource damageSource, float damage) {
        damage = super.m_6515_(damageSource, damage);
        if (damageSource.m_7639_() == this) {
            damage = 0.0f;
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268415_)) {
            damage *= 0.15f;
        }
        return damage;
    }

    public void m_6504_(LivingEntity p_33317_, float p_33318_) {
        if (p_33317_.m_20270_((Entity)this) < 6.0f && this.coolDown <= 0 && this.f_19853_.m_8055_(this.m_20183_().m_6630_(2)).m_60795_() && !(this.m_5448_() instanceof Raider)) {
            this.totalCool = Mth.m_216271_((RandomSource)this.f_19796_, (int)6, (int)10);
            for (int i = 0; i < this.totalCool; ++i) {
                MobUtil.throwSnapFungus((LivingEntity)this, this.f_19853_);
            }
            this.coolDown = MathHelper.secondsToTicks(this.totalCool);
            if (!this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.BLAST_FUNGUS_THROW.get(), this.m_5720_(), 2.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
        } else {
            if (this.m_5448_() instanceof Raider && !this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.BLAST_FUNGUS_THROW.get(), this.m_5720_(), 2.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
            if (this.f_19853_ instanceof ServerLevel) {
                LivingEntity livingEntity = this.m_5448_();
                if (livingEntity instanceof Raider) {
                    Raider raider = (Raider)livingEntity;
                    Vec3 vec3 = raider.m_20184_();
                    double d0 = raider.m_20185_() + vec3.f_82479_ - this.m_20185_();
                    double d1 = raider.m_20188_() - (double)1.1f - this.m_20186_();
                    double d2 = raider.m_20189_() + vec3.f_82481_ - this.m_20189_();
                    double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                    BerserkFungus berserkFungus = new BerserkFungus((LivingEntity)this, this.f_19853_);
                    berserkFungus.m_146926_(berserkFungus.m_146909_() - 20.0f);
                    berserkFungus.m_6686_(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
                    this.f_19853_.m_7967_((Entity)berserkFungus);
                } else {
                    Wartling wartling = new Wartling((EntityType<? extends Summoned>)((EntityType)ModEntityType.WARTLING.get()), this.f_19853_);
                    wartling.m_6710_(p_33317_);
                    if (this.isInFluidType()) {
                        wartling.m_6034_(this.m_20185_(), this.m_20227_(0.5), this.m_20189_());
                        wartling.m_146926_(this.m_146909_());
                        wartling.m_146922_(this.m_146908_());
                        double d0 = p_33317_.m_20185_() - wartling.m_20185_();
                        double d1 = p_33317_.m_20227_(0.3333333333333333) - wartling.m_20186_();
                        double d2 = p_33317_.m_20189_() - wartling.m_20189_();
                        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
                        MobUtil.shoot((LivingEntity)wartling, d0, d1 + d3 * (double)0.2f, d2, 1.6f, 1.0f);
                    } else {
                        wartling.m_20035_(this.m_20183_(), this.m_146908_(), this.m_146909_());
                    }
                    this.summonWartlings(wartling);
                }
            }
        }
    }

    private void summonWartlings(Wartling wartling) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            wartling.setTrueOwner((LivingEntity)this);
            wartling.setLimitedLife(MathHelper.secondsToTicks(9));
            this.m_21220_().stream().filter(mobEffect -> mobEffect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL && !mobEffect.m_19544_().getCurativeItems().isEmpty()).findFirst().ifPresent(effect -> {
                wartling.setStoredEffect((MobEffectInstance)effect);
                this.m_21195_(effect.m_19544_());
            });
            wartling.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            this.f_19853_.m_7967_((Entity)wartling);
        }
    }
}

