/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.cultists;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.MainConfig;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.effects.brew.BatsBrewEffect;
import com.Polarice3.Goety.common.effects.brew.BeesBrewEffect;
import com.Polarice3.Goety.common.effects.brew.BlindJumpBrewEffect;
import com.Polarice3.Goety.common.effects.brew.BrewEffectInstance;
import com.Polarice3.Goety.common.effects.brew.LaunchBrewEffect;
import com.Polarice3.Goety.common.effects.brew.PurifyBrewEffect;
import com.Polarice3.Goety.common.effects.brew.StripBrewEffect;
import com.Polarice3.Goety.common.effects.brew.ThornTrapBrewEffect;
import com.Polarice3.Goety.common.effects.brew.TransposeBrewEffect;
import com.Polarice3.Goety.common.effects.brew.WebbedBrewEffect;
import com.Polarice3.Goety.common.effects.brew.block.HarvestBlockEffect;
import com.Polarice3.Goety.common.effects.brew.block.SweetBerriedEffect;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.WitchBarterGoal;
import com.Polarice3.Goety.common.entities.hostile.cultists.Cultist;
import com.Polarice3.Goety.common.entities.neutral.VampireBat;
import com.Polarice3.Goety.common.entities.projectiles.ThrownBrew;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.brew.BrewItem;
import com.Polarice3.Goety.common.network.ModServerBossInfo;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BrewUtils;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableWitchTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestHealableRaiderTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class Crone
extends Cultist
implements RangedAttackMob {
    private static final UUID SPEED_MODIFIER_DRINKING_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier SPEED_MODIFIER_DRINKING = new AttributeModifier(SPEED_MODIFIER_DRINKING_UUID, "Drinking speed penalty", -0.25, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Boolean> DATA_USING_ITEM = SynchedEntityData.m_135353_(Crone.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int usingTime;
    private int hitTimes;
    private int lastHitTime;
    private int overwhelmed;
    private final ModServerBossInfo bossInfo = new ModServerBossInfo(this.m_20148_(), (Mob)this, BossEvent.BossBarColor.GREEN, false, false);
    private NearestHealableRaiderTargetGoal<Raider> healRaidersGoal;
    private NearestAttackableWitchTargetGoal<Player> attackPlayersGoal;

    public Crone(EntityType<? extends Cultist> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 99;
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        if (this.f_19853_.f_46443_) {
            Goety.PROXY.addBoss((Mob)this);
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.healRaidersGoal = new NearestHealableRaiderTargetGoal((Raider)this, Raider.class, true, target -> target != null && this.m_37886_() && target.m_6095_() != EntityType.f_20495_ && target.m_6095_() != ModEntityType.CRONE.get() && target.m_6095_() != ModEntityType.WARLOCK.get());
        this.attackPlayersGoal = new NearestAttackableWitchTargetGoal((Raider)this, Player.class, 10, true, false, (Predicate)null);
        this.f_21345_.m_25352_(2, (Goal)new BrewThrowsGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FastBrewThrowsGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new WitchBarterGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new CroneTeleportGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}));
        this.f_21346_.m_25352_(2, this.healRaidersGoal);
        this.f_21346_.m_25352_(3, this.attackPlayersGoal);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.CroneHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.CroneHealth.get());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_USING_ITEM, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("hitTimes", this.hitTimes);
        pCompound.m_128405_("lastHitTime", this.lastHitTime);
        pCompound.m_128405_("overwhelmed", this.overwhelmed);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.hitTimes = pCompound.m_128451_("hitTimes");
        this.lastHitTime = pCompound.m_128451_("lastHitTime");
        this.overwhelmed = pCompound.m_128451_("overwhelmed");
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.bossInfo.setId(this.m_20148_());
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (((Boolean)MainConfig.SpecialBossBar.get()).booleanValue()) {
            this.bossInfo.m_6543_(pPlayer);
        }
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossInfo.m_6539_(pPlayer);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.m_213945_(worldIn.m_213780_(), difficultyIn);
        this.m_213946_(worldIn.m_213780_(), difficultyIn);
        if (!this.m_8077_()) {
            int random = this.f_19796_.m_188503_(4);
            int random2 = random == 0 ? 12 + this.f_19796_.m_188503_(6) : this.f_19796_.m_188503_(12);
            MutableComponent component = Component.m_237115_((String)("title.goety.crone." + random));
            MutableComponent component1 = Component.m_237115_((String)("name.goety.crone." + random2));
            this.m_6593_((Component)Component.m_237115_((String)(component.getString() + " " + component1.getString())));
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.CRONE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_34154_) {
        return SoundEvents.f_12552_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.CRONE_DEATH.get();
    }

    public void setUsingItem(boolean p_34164_) {
        this.m_20088_().m_135381_(DATA_USING_ITEM, (Object)p_34164_);
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.m_20088_().m_135370_(DATA_USING_ITEM);
    }

    public void m_6667_(DamageSource p_37847_) {
        Entity entity;
        if (p_37847_.m_7639_() != null && (entity = p_37847_.m_7639_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.CURSED.get(), MathHelper.minutesToTicks(1)));
        }
        super.m_6667_(p_37847_);
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        ItemEntity itementity = this.m_19998_((ItemLike)ModItems.CRONE_HAT.get());
        if (itementity != null) {
            itementity.m_32064_();
        }
    }

    public void m_142687_(Entity.RemovalReason p_146834_) {
        if (this.f_19853_.f_46443_) {
            Goety.PROXY.removeBoss((Mob)this);
        }
        super.m_142687_(p_146834_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 5 == 0) {
            this.bossInfo.update();
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_8107_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            if (this.lastHitTime > 0) {
                --this.lastHitTime;
            }
            this.healRaidersGoal.m_26094_();
            this.attackPlayersGoal.m_26083_(this.healRaidersGoal.m_26093_() <= 0);
            if (this.isDrinkingPotion()) {
                if (this.usingTime-- <= 0) {
                    this.setUsingItem(false);
                    ItemStack itemstack = this.m_21205_();
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    if (itemstack.m_150930_((Item)ModItems.BREW.get())) {
                        List list = PotionUtils.m_43547_((ItemStack)itemstack);
                        for (Object mobeffectinstance : list) {
                            this.m_7292_(new MobEffectInstance((MobEffectInstance)mobeffectinstance));
                        }
                        List<BrewEffectInstance> list1 = BrewUtils.getBrewEffects(itemstack);
                        for (BrewEffectInstance brewEffectInstance : list1) {
                            brewEffectInstance.getEffect().drinkBlockEffect((Entity)this, (Entity)this, (LivingEntity)this, brewEffectInstance.getAmplifier(), BrewUtils.getAreaOfEffect(itemstack));
                        }
                    }
                    this.m_21051_(Attributes.f_22279_).m_22130_(SPEED_MODIFIER_DRINKING);
                }
            } else {
                int amp = 0;
                if (this.f_19853_.f_46441_.m_188501_() <= 0.05f && this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    amp = 2;
                } else if (this.f_19853_.f_46441_.m_188501_() <= 0.25f) {
                    amp = 1;
                }
                ArrayList<MobEffectInstance> mobEffectInstance = new ArrayList<MobEffectInstance>();
                ArrayList<BrewEffectInstance> brewEffectInstance = new ArrayList<BrewEffectInstance>();
                if (this.f_19796_.m_188501_() < 0.15f && (this.m_5830_() || this.m_21225_() != null && this.m_21225_().m_276093_(DamageTypes.f_268612_))) {
                    brewEffectInstance.add(new BrewEffectInstance(new BlindJumpBrewEffect(0), 1, amp));
                } else if (this.f_19796_.m_188501_() < 0.15f && this.m_21225_() != null && (this.m_21225_().m_276093_(DamageTypes.f_268585_) || this.m_21225_().m_276093_(DamageTypes.f_268469_))) {
                    brewEffectInstance.add(new BrewEffectInstance(new HarvestBlockEffect()));
                } else if (this.f_19796_.m_188501_() < 0.15f && this.m_21223_() < this.m_21233_() && (this.m_5448_() == null || this.lastHitTime == 0)) {
                    mobEffectInstance.add(new MobEffectInstance(MobEffects.f_19601_, 1, amp));
                } else if (this.f_19796_.m_188501_() < 0.15f && this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !this.m_21023_(MobEffects.f_19608_)) {
                    mobEffectInstance.add(new MobEffectInstance(MobEffects.f_19608_, 3600));
                    mobEffectInstance.add(new MobEffectInstance((MobEffect)GoetyEffects.SWIFT_SWIM.get(), 3600));
                } else if (this.f_19796_.m_188501_() < 0.15f && (this.m_6060_() || this.m_21225_() != null && this.m_21225_().m_269533_(DamageTypeTags.f_268745_)) && !this.m_21023_(MobEffects.f_19607_)) {
                    mobEffectInstance.add(new MobEffectInstance(MobEffects.f_19607_, 3600));
                } else if (this.f_19796_.m_188501_() < 0.15f && this.m_21225_() != null && this.m_21225_().m_269533_(DamageTypeTags.f_268549_) && !this.m_21023_(MobEffects.f_19591_)) {
                    mobEffectInstance.add(new MobEffectInstance(MobEffects.f_19591_, 3600));
                } else if (this.f_19796_.m_188501_() < 0.15f && this.m_21225_() != null && ModDamageSource.physicalAttacks(this.m_21225_()) && !this.m_21023_((MobEffect)GoetyEffects.REPULSIVE.get())) {
                    mobEffectInstance.add(new MobEffectInstance((MobEffect)GoetyEffects.REPULSIVE.get(), 1800 / (amp + 1), amp));
                } else if (this.f_19796_.m_188501_() < 0.15f && this.m_5448_() != null) {
                    if (this.f_19796_.m_188501_() <= 0.15f && this.m_5448_().m_20270_((Entity)this) <= 4.0f || this.m_21223_() <= 15.0f) {
                        brewEffectInstance.add(new BrewEffectInstance(new BlindJumpBrewEffect(0), 1, amp));
                    } else if (this.f_19796_.m_188501_() <= 0.15f && !this.m_21023_(MobEffects.f_19605_)) {
                        mobEffectInstance.add(new MobEffectInstance(MobEffects.f_19605_, 900 / (amp + 1), amp));
                        if (this.f_19796_.m_188501_() < 0.25f && MobUtil.isInSunlight((LivingEntity)this) && !this.m_21023_((MobEffect)GoetyEffects.PHOTOSYNTHESIS.get())) {
                            mobEffectInstance.add(new MobEffectInstance((MobEffect)GoetyEffects.PHOTOSYNTHESIS.get(), 1800));
                        }
                    } else if (this.f_19796_.m_188501_() < 0.05f && !this.m_21023_(MobEffects.f_19606_)) {
                        mobEffectInstance.add(new MobEffectInstance(MobEffects.f_19606_, 1800));
                    } else if (this.f_19796_.m_188501_() < 0.05f && !this.m_21023_((MobEffect)GoetyEffects.FROSTY_AURA.get()) && !this.m_21023_((MobEffect)GoetyEffects.FIERY_AURA.get())) {
                        if (this.f_19796_.m_188499_()) {
                            if (!(this.m_5448_().m_21023_((MobEffect)GoetyEffects.FREEZING.get()) || this.m_5448_().m_21023_(MobEffects.f_19607_) || this.m_5448_().m_5825_())) {
                                mobEffectInstance.add(new MobEffectInstance((MobEffect)GoetyEffects.FIERY_AURA.get(), 1800 / (amp + 1), amp));
                            }
                        } else if (!this.m_5448_().m_6060_() && this.m_5448_().m_142079_()) {
                            mobEffectInstance.add(new MobEffectInstance((MobEffect)GoetyEffects.FROSTY_AURA.get(), 1800 / (amp + 1), amp));
                        }
                    }
                } else if (this.f_19796_.m_188501_() <= 0.15f && MobUtil.isInWeb((LivingEntity)this) && !this.m_21023_((MobEffect)GoetyEffects.CLIMBING.get())) {
                    mobEffectInstance.add(new MobEffectInstance((MobEffect)GoetyEffects.CLIMBING.get(), 3600));
                } else if (this.f_19796_.m_188501_() < 0.05f && MobUtil.hasLongNegativeEffects((LivingEntity)this)) {
                    brewEffectInstance.add(new BrewEffectInstance(new PurifyBrewEffect("purify_debuff", 0, 0, MobEffectCategory.BENEFICIAL, 0x385858, true)));
                }
                if (!mobEffectInstance.isEmpty() || !brewEffectInstance.isEmpty()) {
                    ItemStack brew = BrewUtils.setCustomEffects(new ItemStack((ItemLike)ModItems.BREW.get()), mobEffectInstance, brewEffectInstance);
                    BrewUtils.setAreaOfEffect(brew, this.f_19853_.f_46441_.m_188503_(amp + 1));
                    brew.m_41784_().m_128405_("CustomPotionColor", BrewUtils.getColor(mobEffectInstance, brewEffectInstance));
                    this.m_8061_(EquipmentSlot.MAINHAND, brew);
                    this.usingTime = this.overwhelmed > 0 ? this.m_21205_().m_41779_() / 2 : this.m_21205_().m_41779_();
                    this.setUsingItem(true);
                    if (!this.m_20067_()) {
                        this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12551_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                    }
                    AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
                    attributeinstance.m_22130_(SPEED_MODIFIER_DRINKING);
                    attributeinstance.m_22118_(SPEED_MODIFIER_DRINKING);
                } else if (this.m_21205_().m_41720_() instanceof BrewItem) {
                    this.usingTime = this.overwhelmed > 0 ? this.m_21205_().m_41779_() / 2 : this.m_21205_().m_41779_();
                    this.setUsingItem(true);
                    AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
                    attributeinstance.m_22130_(SPEED_MODIFIER_DRINKING);
                    attributeinstance.m_22118_(SPEED_MODIFIER_DRINKING);
                }
            }
            if (this.f_19796_.m_188501_() < 7.5E-4f) {
                this.f_19853_.m_7605_((Entity)this, (byte)15);
            }
        }
        super.m_8107_();
    }

    @Override
    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.CRONE_LAUGH.get();
    }

    public void m_7822_(byte p_34138_) {
        if (p_34138_ == 15) {
            for (int i = 0; i < this.f_19796_.m_188503_(35) + 10; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_() + this.f_19796_.m_188583_() * (double)0.13f, this.m_20191_().f_82292_ + 0.5 + this.f_19796_.m_188583_() * (double)0.13f, this.m_20189_() + this.f_19796_.m_188583_() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else if (p_34138_ == 46) {
            int i = 128;
            for (int j = 0; j < i; ++j) {
                double d0 = (double)j / 127.0;
                float f = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
                float f1 = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
                float f2 = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
                double d1 = Mth.m_14139_((double)d0, (double)this.f_19854_, (double)this.m_20185_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                double d2 = Mth.m_14139_((double)d0, (double)this.f_19855_, (double)this.m_20186_()) + this.f_19796_.m_188500_() * (double)this.m_20206_();
                double d3 = Mth.m_14139_((double)d0, (double)this.f_19856_, (double)this.m_20189_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d1, d2, d3, (double)f, (double)f1, (double)f2);
            }
        } else {
            super.m_7822_(p_34138_);
        }
    }

    protected float m_6515_(DamageSource p_34149_, float p_34150_) {
        p_34150_ = super.m_6515_(p_34149_, p_34150_);
        if (p_34149_.m_7639_() == this) {
            p_34150_ = 0.0f;
        }
        if (p_34149_.m_269533_(DamageTypeTags.f_268731_)) {
            p_34150_ *= 0.15f;
        }
        return p_34150_;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_6504_(LivingEntity target, float p_34144_) {
        block31: {
            ArrayList<BrewEffectInstance> brewEffectInstance;
            ArrayList<MobEffectInstance> mobEffectInstance;
            int amp;
            double d3;
            double d2;
            double d1;
            double d0;
            block33: {
                block42: {
                    block41: {
                        block38: {
                            block40: {
                                block39: {
                                    block37: {
                                        block35: {
                                            block36: {
                                                block34: {
                                                    block32: {
                                                        if (this.isDrinkingPotion()) break block31;
                                                        Vec3 vec3 = target.m_20184_();
                                                        d0 = target.m_20185_() + vec3.f_82479_ - this.m_20185_();
                                                        d1 = target.m_20188_() - (double)1.1f - this.m_20186_();
                                                        d2 = target.m_20189_() + vec3.f_82481_ - this.m_20189_();
                                                        d3 = Math.sqrt(d0 * d0 + d2 * d2);
                                                        amp = 0;
                                                        if (this.f_19853_.f_46441_.m_188501_() <= 0.05f && this.f_19853_.m_46791_() != Difficulty.EASY) {
                                                            amp = 2;
                                                        } else if (this.f_19853_.f_46441_.m_188501_() <= 0.25f) {
                                                            amp = 1;
                                                        }
                                                        mobEffectInstance = new ArrayList<MobEffectInstance>();
                                                        brewEffectInstance = new ArrayList<BrewEffectInstance>();
                                                        if (!(target instanceof Raider)) break block32;
                                                        Raider raider = (Raider)target;
                                                        if (!this.m_37886_() || raider.m_5448_() == this) break block32;
                                                        if (target.m_21223_() <= 4.0f) {
                                                            mobEffectInstance.add(new MobEffectInstance(MobEffects.f_19601_, 1));
                                                        } else {
                                                            mobEffectInstance.add(new MobEffectInstance(MobEffects.f_19605_, 900));
                                                            if (this.f_19796_.m_188501_() <= 0.05f) {
                                                                mobEffectInstance.add(new MobEffectInstance(MobEffects.f_19617_, 1800));
                                                            }
                                                        }
                                                        this.m_6710_(null);
                                                        break block33;
                                                    }
                                                    if (!(d3 >= 8.0) || target.m_21023_(MobEffects.f_19597_)) break block34;
                                                    mobEffectInstance.add(new MobEffectInstance(MobEffects.f_19597_, 1800 / (amp + 1), amp));
                                                    if (this.f_19796_.m_188501_() <= 0.25f && target.m_20096_()) {
                                                        brewEffectInstance.add(new BrewEffectInstance(new SweetBerriedEffect(), 1, amp));
                                                    }
                                                    if (this.f_19796_.m_188501_() <= 0.25f && this.noBrewMinions(target)) {
                                                        brewEffectInstance.add(new BrewEffectInstance(new WebbedBrewEffect(0, 0), 1, amp));
                                                        break block33;
                                                    } else if (this.f_19796_.m_188501_() <= 0.5f && this.f_19796_.m_188499_()) {
                                                        brewEffectInstance.add(new BrewEffectInstance(new TransposeBrewEffect()));
                                                    }
                                                    break block33;
                                                }
                                                if (!(target.m_21223_() >= 8.0f) || target.m_21023_(MobEffects.f_19614_) && target.m_21023_((MobEffect)GoetyEffects.SAPPED.get())) break block35;
                                                if (!target.m_21023_(MobEffects.f_19614_) && target.m_7301_(new MobEffectInstance(MobEffects.f_19614_))) {
                                                    mobEffectInstance.add(new MobEffectInstance(MobEffects.f_19614_, 900 / (amp + 1), amp));
                                                } else {
                                                    mobEffectInstance.add(new MobEffectInstance((MobEffect)GoetyEffects.SAPPED.get(), 1800 / (amp + 1), amp));
                                                }
                                                if (!(this.f_19796_.m_188501_() <= 0.25f) || this.m_21023_((MobEffect)GoetyEffects.FIERY_AURA.get()) || target.m_21023_((MobEffect)GoetyEffects.FREEZING.get())) break block36;
                                                mobEffectInstance.add(new MobEffectInstance((MobEffect)GoetyEffects.FREEZING.get(), 900 / (amp + 1), amp));
                                                break block33;
                                            }
                                            if (this.f_19796_.m_188501_() <= 0.25f && !this.m_21023_((MobEffect)GoetyEffects.FROSTY_AURA.get()) && !target.m_21023_((MobEffect)GoetyEffects.FLAMMABLE.get()) && !target.m_21023_(MobEffects.f_19607_)) {
                                                mobEffectInstance.add(new MobEffectInstance((MobEffect)GoetyEffects.FLAMMABLE.get(), 900 / (amp + 1), amp));
                                                break block33;
                                            } else if (this.f_19796_.m_188501_() <= 0.5f && !target.m_21023_((MobEffect)GoetyEffects.TRIPPING.get())) {
                                                mobEffectInstance.add(new MobEffectInstance((MobEffect)GoetyEffects.TRIPPING.get(), 1800 / (amp + 1), amp));
                                            }
                                            break block33;
                                        }
                                        if (!target.m_21023_(MobEffects.f_19605_) || target.m_21023_((MobEffect)GoetyEffects.CURSED.get())) break block37;
                                        mobEffectInstance.add(new MobEffectInstance((MobEffect)GoetyEffects.CURSED.get(), 600, 0));
                                        break block33;
                                    }
                                    if (this.m_21225_() == null || !ModDamageSource.physicalAttacks(this.m_21225_()) || target.m_21023_(MobEffects.f_19613_) || !(this.f_19796_.m_188501_() < 0.25f)) break block38;
                                    mobEffectInstance.add(new MobEffectInstance(MobEffects.f_19613_, 1800 / (amp + 1), amp));
                                    if (!(this.f_19796_.m_188501_() <= 0.25f)) break block39;
                                    brewEffectInstance.add(new BrewEffectInstance(new TransposeBrewEffect(), 1, amp));
                                    break block33;
                                }
                                if (!(this.f_19796_.m_188501_() <= 0.5f) || target.m_5825_() || !MobUtil.isInSunlight(target) || target.m_21023_(MobEffects.f_19607_) || target.m_21023_((MobEffect)GoetyEffects.SUN_ALLERGY.get())) break block40;
                                mobEffectInstance.add(new MobEffectInstance((MobEffect)GoetyEffects.SUN_ALLERGY.get(), 3600 / (amp + 1), amp));
                                break block33;
                            }
                            if (this.f_19796_.m_188501_() <= 0.75f && target.f_19853_.m_46803_(target.m_20183_()) < 2 && !target.m_21023_((MobEffect)GoetyEffects.NYCTOPHOBIA.get())) {
                                mobEffectInstance.add(new MobEffectInstance((MobEffect)GoetyEffects.NYCTOPHOBIA.get(), 1800 / (amp + 1), amp));
                                break block33;
                            } else if (!target.m_21023_((MobEffect)GoetyEffects.SAPPED.get())) {
                                mobEffectInstance.add(new MobEffectInstance((MobEffect)GoetyEffects.SAPPED.get(), 1800 / (amp + 1), amp));
                            }
                            break block33;
                        }
                        if (!(this.f_19796_.m_188501_() <= 0.05f)) break block41;
                        brewEffectInstance.add(new BrewEffectInstance(new StripBrewEffect(0, 0)));
                        break block33;
                    }
                    if (!(this.f_19796_.m_188501_() <= 0.25f)) break block42;
                    if (target.m_20096_()) {
                        brewEffectInstance.add(new BrewEffectInstance(new ThornTrapBrewEffect(0), 1, amp));
                        break block33;
                    } else if (!target.m_21023_(MobEffects.f_19620_)) {
                        mobEffectInstance.add(new MobEffectInstance((MobEffect)GoetyEffects.PLUNGE.get(), 900 / (amp + 1), amp));
                    }
                    break block33;
                }
                if (this.f_19796_.m_188501_() <= 0.35f && !target.m_21023_(MobEffects.f_19610_) && !MobUtil.isInWeb(target) && target.m_21233_() > 10.0f && this.noBrewMinions(target)) {
                    mobEffectInstance.add(new MobEffectInstance(MobEffects.f_19610_, MathHelper.secondsToTicks(5)));
                    brewEffectInstance.add(new BrewEffectInstance(new BatsBrewEffect(0, 0)));
                } else if (this.f_19796_.m_188501_() <= 0.55f) {
                    brewEffectInstance.add(new BrewEffectInstance(new LaunchBrewEffect(), 1));
                } else if (this.f_19796_.m_188501_() <= 0.75f && !MobUtil.isInWeb(target) && target.m_21233_() > 10.0f && this.noBrewMinions(target)) {
                    brewEffectInstance.add(new BrewEffectInstance(new BeesBrewEffect(0, 0)));
                } else {
                    mobEffectInstance.add(new MobEffectInstance(MobEffects.f_19602_, 1, amp));
                }
            }
            if (!mobEffectInstance.isEmpty() || !brewEffectInstance.isEmpty()) {
                ThrownBrew thrownBrew = new ThrownBrew(this.f_19853_, (LivingEntity)this);
                ItemStack brew0 = this.f_19853_.f_46441_.m_188501_() <= 0.15f && this.f_19853_.m_46791_() == Difficulty.HARD ? new ItemStack((ItemLike)ModItems.GAS_BREW.get()) : new ItemStack((ItemLike)ModItems.SPLASH_BREW.get());
                ItemStack brew = BrewUtils.setCustomEffects(brew0, mobEffectInstance, brewEffectInstance);
                BrewUtils.setAreaOfEffect(brew, this.f_19853_.f_46441_.m_188503_(amp + 1));
                brew.m_41784_().m_128405_("CustomPotionColor", BrewUtils.getColor(mobEffectInstance, brewEffectInstance));
                thrownBrew.m_37446_(brew);
                float velocity = 0.75f;
                if (target.m_20270_((Entity)this) >= 4.0f) {
                    thrownBrew.m_146926_(thrownBrew.m_146909_() + 20.0f);
                } else {
                    thrownBrew.m_146926_(thrownBrew.m_146909_());
                    velocity = 1.0f;
                }
                thrownBrew.m_6686_(d0, d1 + d3 * 0.2, d2, velocity, 8.0f);
                if (!this.m_20067_()) {
                    this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12553_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                }
                this.f_19853_.m_7967_((Entity)thrownBrew);
            }
        }
    }

    public boolean noBrewMinions(LivingEntity livingEntity) {
        return this.f_19853_.m_45976_(VampireBat.class, livingEntity.m_20191_().m_82400_(2.0)).isEmpty() && this.f_19853_.m_45976_(Bee.class, livingEntity.m_20191_().m_82400_(2.0)).isEmpty();
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        LivingEntity livingentity;
        if (this.m_21223_() <= 10.0f && (pSource.m_276093_(DamageTypes.f_268585_) || pSource.m_276093_(DamageTypes.f_268469_) || pSource.m_269533_(DamageTypeTags.f_268731_))) {
            return false;
        }
        Entity entity = pSource.m_7639_();
        if (entity instanceof LivingEntity && (livingentity = (LivingEntity)entity) != this) {
            this.lastHitTime = MathHelper.secondsToTicks(15);
            if (!pSource.m_269533_(DamageTypeTags.f_268640_) && !pSource.m_276093_(DamageTypes.f_268440_)) {
                float thorn = 2.0f;
                if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    thorn *= 2.0f;
                }
                livingentity.m_6469_(this.m_269291_().m_269374_((Entity)this), thorn);
            }
            if (pAmount >= 15.0f) {
                this.overwhelmed = MathHelper.secondsToTicks(15);
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected void teleport() {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            for (int i = 0; i < 128; ++i) {
                double d3 = this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * 32.0;
                double d4 = this.m_20186_();
                if (this.m_5448_() != null) {
                    d4 = this.m_5448_().m_20186_();
                }
                double d5 = this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * 32.0;
                if (this.m_21223_() <= 0.0f) break;
                if (!this.m_20984_(d3, d4, d5, false)) continue;
                this.teleportHits();
                break;
            }
        }
    }

    private boolean teleportTowards(Entity entity) {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            for (int i = 0; i < 128; ++i) {
                Vec3 vector3d = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20227_(0.5) - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
                vector3d = vector3d.m_82541_();
                double d0 = 16.0;
                double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82479_ * d0;
                double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vector3d.f_82480_ * d0;
                double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82481_ * d0;
                if (this.m_21223_() <= 0.0f) {
                    return false;
                }
                if (!this.m_20984_(d1, d2, d3, true)) continue;
                this.teleportHits();
                return true;
            }
        }
        return false;
    }

    public void teleportHits() {
        this.f_19853_.m_7605_((Entity)this, (byte)46);
        this.f_19853_.m_214171_(GameEvent.f_238175_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)this));
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 0.75f);
            this.m_5496_(SoundEvents.f_11852_, 1.0f, 0.75f);
        }
    }

    static class BrewThrowsGoal
    extends RangedAttackGoal {
        public Crone crone;

        public BrewThrowsGoal(Crone p_25773_) {
            super((RangedAttackMob)p_25773_, 1.0, 20, 40, 10.0f);
            this.crone = p_25773_;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.crone.m_21223_() >= this.crone.m_21233_() / 4.0f;
        }
    }

    static class FastBrewThrowsGoal
    extends RangedAttackGoal {
        public Crone crone;

        public FastBrewThrowsGoal(Crone p_25773_) {
            super((RangedAttackMob)p_25773_, 1.0, 15, 30, 10.0f);
            this.crone = p_25773_;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.crone.m_21223_() < this.crone.m_21233_() / 4.0f;
        }
    }

    static class CroneTeleportGoal
    extends Goal {
        private final Crone crone;
        private int teleportTime;

        public CroneTeleportGoal(Crone p_32573_) {
            this.crone = p_32573_;
        }

        public boolean m_8036_() {
            return this.crone.m_5448_() != null;
        }

        public void m_8056_() {
            super.m_8056_();
            this.teleportTime = 0;
        }

        public boolean m_8045_() {
            return this.crone.m_5448_() != null;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.crone.m_5448_() != null && !this.crone.m_20159_() && (this.crone.m_5448_().m_20280_((Entity)this.crone) > 256.0 || !MobUtil.hasVisualLineOfSight((LivingEntity)this.crone, (Entity)this.crone.m_5448_())) && this.teleportTime++ >= this.m_183277_(30) && this.crone.teleportTowards((Entity)this.crone.m_5448_())) {
                this.teleportTime = 0;
            }
        }
    }
}

