/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.cultists;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.MainConfig;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.WitchBarterGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.hostile.cultists.Cultist;
import com.Polarice3.Goety.common.entities.neutral.Wartling;
import com.Polarice3.Goety.common.entities.projectiles.BerserkFungus;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.network.ModServerBossInfo;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableWitchTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestHealableRaiderTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class Codger
extends Cultist
implements RangedAttackMob {
    private int coolDown;
    private int totalCool;
    private int hitTimes;
    private int lastHitTime;
    private int overwhelmed;
    private boolean isSpecial;
    private boolean isShaking;
    private float shakeAnim;
    private float shakeAnimO;
    private final ModServerBossInfo bossInfo = new ModServerBossInfo(this.m_20148_(), (Mob)this, BossEvent.BossBarColor.GREEN, false, false);
    private NearestHealableRaiderTargetGoal<Raider> healRaidersGoal;
    private NearestAttackableWitchTargetGoal<Player> attackPlayersGoal;

    public Codger(EntityType<? extends Cultist> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 99;
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        if (this.f_19853_.f_46443_) {
            Goety.PROXY.addBoss((Mob)this);
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.healRaidersGoal = new NearestHealableRaiderTargetGoal((Raider)this, Raider.class, true, target -> target != null && this.m_37886_() && target.m_6095_() != EntityType.f_20495_ && target.m_6095_() != ModEntityType.WARLOCK.get());
        this.attackPlayersGoal = new NearestAttackableWitchTargetGoal((Raider)this, Player.class, 10, true, false, (Predicate)null);
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 40, 10.0f));
        this.f_21345_.m_25352_(1, (Goal)new WitchBarterGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new CodgerTeleportGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}));
        this.f_21346_.m_25352_(2, this.healRaidersGoal);
        this.f_21346_.m_25352_(3, this.attackPlayersGoal);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.CroneHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.CroneHealth.get());
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("hitTimes", this.hitTimes);
        pCompound.m_128405_("lastHitTime", this.lastHitTime);
        pCompound.m_128405_("overwhelmed", this.overwhelmed);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.hitTimes = pCompound.m_128451_("hitTimes");
        this.lastHitTime = pCompound.m_128451_("lastHitTime");
        this.overwhelmed = pCompound.m_128451_("overwhelmed");
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.bossInfo.setId(this.m_20148_());
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.WARLOCK_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_34154_) {
        return (SoundEvent)ModSounds.WARLOCK_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.WARLOCK_DEATH.get();
    }

    @Override
    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.WARLOCK_CELEBRATE.get();
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (((Boolean)MainConfig.SpecialBossBar.get()).booleanValue()) {
            this.bossInfo.m_6543_(pPlayer);
        }
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossInfo.m_6539_(pPlayer);
    }

    public void m_142687_(Entity.RemovalReason p_146834_) {
        if (this.f_19853_.f_46443_) {
            Goety.PROXY.removeBoss((Mob)this);
        }
        super.m_142687_(p_146834_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 5 == 0) {
            this.bossInfo.update();
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.isSpecial && !this.isShaking && !this.m_21691_() && this.m_20096_()) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
            this.f_19853_.m_7605_((Entity)this, (byte)8);
        }
        if (this.coolDown > 0) {
            --this.coolDown;
        }
        if (this.m_5448_() != null) {
            if ((this.isSpecial || this.isShaking) && this.isShaking) {
                if (this.shakeAnim == 0.0f) {
                    this.m_5496_(SoundEvents.f_12194_, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    this.m_146850_(GameEvent.f_223710_);
                }
                this.m_6504_(this.m_5448_(), 1.0f);
                this.shakeAnimO = this.shakeAnim;
                this.shakeAnim += 0.05f;
                if (this.shakeAnimO >= 2.0f) {
                    this.isSpecial = false;
                    this.isShaking = false;
                    this.shakeAnimO = 0.0f;
                    this.shakeAnim = 0.0f;
                }
                if (this.shakeAnim > 0.4f) {
                    float f = (float)this.m_20186_();
                    int i = (int)(Mth.m_14031_((float)((this.shakeAnim - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vec3 vec3 = this.m_20184_();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        float f2 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123784_, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    }
                }
            }
        } else {
            this.isSpecial = false;
            this.isShaking = false;
            this.shakeAnimO = 0.0f;
            this.shakeAnim = 0.0f;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.m_6084_()) {
                this.healRaidersGoal.m_26094_();
                this.attackPlayersGoal.m_26083_(this.healRaidersGoal.m_26093_() <= 0);
            }
            if (this.f_19796_.m_188501_() < 7.5E-4f) {
                this.f_19853_.m_7605_((Entity)this, (byte)15);
            }
            if (this.m_5448_() != null) {
                if (!(this.m_5448_() instanceof Raider)) {
                    if (this.m_5448_().m_20270_((Entity)this) < 6.0f && this.coolDown <= this.totalCool / 2) {
                        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.BLAST_FUNGUS.get()));
                    } else {
                        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    }
                    if (this.m_21223_() <= this.m_21233_() / 4.0f && this.f_19797_ % 10 == 0 && this.f_19796_.m_188499_()) {
                        MobUtil.throwBlastFungus((LivingEntity)this, this.f_19853_);
                    }
                    if (this.f_19797_ % 100 == 0 && this.f_19796_.m_188501_() <= 0.25f && !this.isSpecial && !this.isShaking) {
                        this.isSpecial = true;
                        this.f_19853_.m_7605_((Entity)this, (byte)7);
                    }
                } else {
                    this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.BERSERK_FUNGUS.get()));
                }
            } else {
                if (this.m_21205_().m_150930_((Item)ModItems.BLAST_FUNGUS.get()) || this.m_21205_().m_150930_((Item)ModItems.BERSERK_FUNGUS.get())) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                }
                boolean flag = false;
                if (!this.m_20077_()) {
                    if (this.m_21223_() < this.m_21233_()) {
                        flag = true;
                    }
                    if (!this.m_21220_().isEmpty() && this.m_21220_().stream().anyMatch(mobEffectInstance -> mobEffectInstance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL)) {
                        flag = true;
                    }
                    if (flag && this.f_19797_ % 60 == 0) {
                        Wartling wartling = new Wartling((EntityType<? extends Summoned>)((EntityType)ModEntityType.WARTLING.get()), this.f_19853_);
                        wartling.m_20035_(this.m_20183_(), this.m_146908_(), this.m_146909_());
                        this.summonWartlings(wartling);
                    }
                }
            }
        }
    }

    private void cancelShake() {
        this.isShaking = false;
        this.shakeAnim = 0.0f;
        this.shakeAnimO = 0.0f;
    }

    public float getBodyRollAngle(float p_30433_, float p_30434_) {
        float f = (Mth.m_14179_((float)p_30433_, (float)this.shakeAnimO, (float)this.shakeAnim) + p_30434_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return Mth.m_14031_((float)(f * (float)Math.PI)) * Mth.m_14031_((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    public void m_7822_(byte p_34138_) {
        if (p_34138_ == 7) {
            this.isSpecial = true;
        } else if (p_34138_ == 8) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
        } else if (p_34138_ == 56) {
            this.cancelShake();
        } else if (p_34138_ == 15) {
            for (int i = 0; i < this.f_19796_.m_188503_(35) + 10; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.WARLOCK.get(), this.m_20185_() + this.f_19796_.m_188583_() * (double)0.13f, this.m_20191_().f_82292_ + this.f_19796_.m_188583_() * (double)0.13f, this.m_20189_() + this.f_19796_.m_188583_() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.m_7822_(p_34138_);
        }
    }

    protected float m_6515_(DamageSource damageSource, float damage) {
        damage = super.m_6515_(damageSource, damage);
        if (damageSource.m_7639_() == this) {
            damage = 0.0f;
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268415_)) {
            damage *= 0.15f;
        }
        return damage;
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        LivingEntity livingentity;
        Entity entity;
        this.lastHitTime = MathHelper.secondsToTicks(15);
        if (pAmount >= 15.0f) {
            this.overwhelmed = MathHelper.secondsToTicks(15);
        }
        if (this.m_21223_() <= 10.0f && pSource.m_269533_(DamageTypeTags.f_268415_)) {
            return false;
        }
        if (!pSource.m_269533_(DamageTypeTags.f_268640_) && !pSource.m_276093_(DamageTypes.f_268440_) && (entity = pSource.m_7639_()) instanceof LivingEntity && (livingentity = (LivingEntity)entity) != this) {
            float thorn = 2.0f;
            if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                thorn *= 2.0f;
            }
            livingentity.m_6469_(this.m_269291_().m_269374_((Entity)this), thorn);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6504_(LivingEntity p_33317_, float p_33318_) {
        if (p_33317_.m_20270_((Entity)this) < 6.0f && this.coolDown <= 0 && this.f_19853_.m_8055_(this.m_20183_().m_6630_(2)).m_60795_() && !(this.m_5448_() instanceof Raider)) {
            this.totalCool = Mth.m_216271_((RandomSource)this.f_19796_, (int)6, (int)10);
            for (int i = 0; i < this.totalCool; ++i) {
                MobUtil.throwBlastFungus((LivingEntity)this, this.f_19853_);
            }
            this.coolDown = this.m_21223_() <= this.m_21233_() / 2.0f ? MathHelper.secondsToTicks(this.totalCool / 2) : MathHelper.secondsToTicks(this.totalCool);
            if (!this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.BLAST_FUNGUS_THROW.get(), this.m_5720_(), 2.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
        } else {
            if (this.m_5448_() instanceof Raider && !this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.BLAST_FUNGUS_THROW.get(), this.m_5720_(), 2.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
            if (this.f_19853_ instanceof ServerLevel) {
                LivingEntity livingEntity = this.m_5448_();
                if (livingEntity instanceof Raider) {
                    Raider raider = (Raider)livingEntity;
                    Vec3 vec3 = raider.m_20184_();
                    double d0 = raider.m_20185_() + vec3.f_82479_ - this.m_20185_();
                    double d1 = raider.m_20188_() - (double)1.1f - this.m_20186_();
                    double d2 = raider.m_20189_() + vec3.f_82481_ - this.m_20189_();
                    double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                    BerserkFungus berserkFungus = new BerserkFungus((LivingEntity)this, this.f_19853_);
                    berserkFungus.m_146926_(berserkFungus.m_146909_() - 20.0f);
                    berserkFungus.m_6686_(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
                    this.f_19853_.m_7967_((Entity)berserkFungus);
                } else {
                    Wartling wartling = new Wartling((EntityType<? extends Summoned>)((EntityType)ModEntityType.WARTLING.get()), this.f_19853_);
                    wartling.m_6710_(p_33317_);
                    if (this.isInFluidType()) {
                        wartling.m_6034_(this.m_20185_(), this.m_20227_(0.5), this.m_20189_());
                        wartling.m_146926_(this.m_146909_());
                        wartling.m_146922_(this.m_146908_());
                        double d0 = p_33317_.m_20185_() - wartling.m_20185_();
                        double d1 = p_33317_.m_20227_(0.3333333333333333) - wartling.m_20186_();
                        double d2 = p_33317_.m_20189_() - wartling.m_20189_();
                        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
                        MobUtil.shoot((LivingEntity)wartling, d0, d1 + d3 * (double)0.2f, d2, 1.6f, 1.0f);
                    } else {
                        wartling.m_20035_(this.m_20183_(), this.m_146908_(), this.m_146909_());
                    }
                    this.summonWartlings(wartling);
                }
            }
        }
    }

    private void summonWartlings(Wartling wartling) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            wartling.setTrueOwner((LivingEntity)this);
            wartling.setLimitedLife(MathHelper.secondsToTicks(9));
            this.m_21220_().stream().filter(mobEffect -> mobEffect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL && !mobEffect.m_19544_().getCurativeItems().isEmpty()).findFirst().ifPresent(effect -> {
                wartling.setStoredEffect((MobEffectInstance)effect);
                this.m_21195_(effect.m_19544_());
            });
            wartling.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            wartling.setMega();
            this.f_19853_.m_7967_((Entity)wartling);
        }
    }

    private boolean teleportTowards(Entity entity) {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            for (int i = 0; i < 128; ++i) {
                Vec3 vector3d = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20227_(0.5) - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
                vector3d = vector3d.m_82541_();
                double d0 = 16.0;
                double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82479_ * d0;
                double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vector3d.f_82480_ * d0;
                double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82481_ * d0;
                if (this.m_21223_() <= 0.0f) {
                    return false;
                }
                if (!this.m_20984_(d1, d2, d3, true)) continue;
                this.teleportHits();
                return true;
            }
        }
        return false;
    }

    public void teleportHits() {
        this.f_19853_.m_7605_((Entity)this, (byte)46);
        this.f_19853_.m_214171_(GameEvent.f_238175_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)this));
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 0.75f);
            this.m_5496_(SoundEvents.f_11852_, 1.0f, 0.75f);
        }
    }

    static class CodgerTeleportGoal
    extends Goal {
        private final Codger codger;
        private int teleportTime;

        public CodgerTeleportGoal(Codger p_32573_) {
            this.codger = p_32573_;
        }

        public boolean m_8036_() {
            return this.codger.m_5448_() != null;
        }

        public void m_8056_() {
            super.m_8056_();
            this.teleportTime = 0;
        }

        public boolean m_8045_() {
            return this.codger.m_5448_() != null;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.codger.m_5448_() != null && !this.codger.m_20159_() && (this.codger.m_5448_().m_20280_((Entity)this.codger) > 256.0 || !MobUtil.hasVisualLineOfSight((LivingEntity)this.codger, (Entity)this.codger.m_5448_())) && this.teleportTime++ >= this.m_183277_(30) && this.codger.teleportTowards((Entity)this.codger.m_5448_())) {
                this.teleportTime = 0;
            }
        }
    }
}

