/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.MainConfig;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.AbstractSkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.SkeletonServant;
import com.Polarice3.Goety.common.entities.neutral.AbstractNecromancer;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.neutral.Volcano;
import com.Polarice3.Goety.common.entities.projectiles.HellBolt;
import com.Polarice3.Goety.common.network.ModServerBossInfo;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WitherNecromancer
extends AbstractNecromancer
implements Enemy {
    private final ModServerBossInfo bossInfo = new ModServerBossInfo(this.m_20148_(), (Mob)this, BossEvent.BossBarColor.PURPLE, false, false);

    public WitherNecromancer(EntityType<? extends AbstractNecromancer> type, Level level) {
        super((EntityType<? extends AbstractSkeletonServant>)type, level);
        this.setHostile(true);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        if (this.f_19853_.f_46443_) {
            Goety.PROXY.addBoss((Mob)this);
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractPiglin.class, true));
    }

    @Override
    public void summonSpells(int priority) {
        this.f_21345_.m_25352_(priority, (Goal)new SummonServantSpell());
        this.f_21345_.m_25352_(priority + 1, (Goal)new SummonVolcanosGoal());
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 160.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.NecromancerDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), 160.0);
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.NecromancerDamage.get());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setConfigurableAttributes();
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.bossInfo.setId(this.m_20148_());
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (((Boolean)MainConfig.SpecialBossBar.get()).booleanValue()) {
            this.bossInfo.m_6543_(pPlayer);
        }
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossInfo.m_6539_(pPlayer);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 5 == 0) {
            this.bossInfo.update();
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    @Override
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12559_;
    }

    @Override
    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return SoundEvents.f_12561_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12560_;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundEvents.f_12562_;
    }

    @Override
    public void spellCastParticles() {
        for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.TOTEM_EFFECT.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.45, 0.45, 0.45);
        }
    }

    @Override
    public void m_6504_(@NotNull LivingEntity p_33317_, float p_33318_) {
        Vec3 vector3d = this.m_20252_(1.0f);
        HellBolt hellBolt = new HellBolt((LivingEntity)this, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, this.f_19853_);
        hellBolt.m_6034_(this.m_20185_() + vector3d.f_82479_ / 2.0, this.m_20188_() - 0.2, this.m_20189_() + vector3d.f_82481_ / 2.0);
        hellBolt.rotateToMatchMovement();
        if (this.f_19853_.m_7967_((Entity)hellBolt)) {
            this.m_5496_(SoundEvents.f_12558_, 0.5f, 0.25f);
            this.m_216990_((SoundEvent)ModSounds.HELL_BOLT_SHOOT.get());
            this.m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    @Override
    public boolean m_7327_(Entity p_34169_) {
        if (!super.m_7327_(p_34169_)) {
            return false;
        }
        if (p_34169_ instanceof LivingEntity) {
            ((LivingEntity)p_34169_).m_147207_(new MobEffectInstance(MobEffects.f_19615_, 200), (Entity)this);
        }
        return true;
    }

    @Override
    public boolean m_7301_(MobEffectInstance p_34192_) {
        return p_34192_.m_19544_() != MobEffects.f_19615_ && super.m_7301_(p_34192_);
    }

    public void m_142687_(Entity.RemovalReason p_146834_) {
        if (this.f_19853_.f_46443_) {
            Goety.PROXY.removeBoss((Mob)this);
        }
        super.m_142687_(p_146834_);
    }

    public class SummonServantSpell
    extends AbstractNecromancer.SummoningSpellGoal {
        public SummonServantSpell() {
            super(WitherNecromancer.this);
        }

        @Override
        public boolean m_8036_() {
            Predicate<Entity> predicate = entity -> {
                IOwned owned;
                return entity.m_6084_() && entity instanceof IOwned && (owned = (IOwned)entity).getTrueOwner() == WitherNecromancer.this;
            };
            int i = WitherNecromancer.this.f_19853_.m_6443_(LivingEntity.class, WitherNecromancer.this.m_20191_().m_82377_(64.0, 16.0, 64.0), predicate).size();
            return super.m_8036_() && i < 2;
        }

        @Override
        public void m_8037_() {
            --this.spellTime;
            if (this.spellTime == 10) {
                if (this.getCastSound() != null) {
                    WitherNecromancer.this.m_5496_(this.getCastSound(), 1.0f, 1.0f);
                }
                WitherNecromancer.this.m_5496_((SoundEvent)ModSounds.NECROMANCER_LAUGH.get(), 2.0f, 0.05f);
                this.castSpell();
                WitherNecromancer.this.setNecromancerSpellType(AbstractNecromancer.NecromancerSpellType.NONE);
            }
        }

        @Override
        protected void castSpell() {
            Level level = WitherNecromancer.this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i1 = 0; i1 < 1 + serverLevel.f_46441_.m_188503_(3); ++i1) {
                    SkeletonServant summoned = new SkeletonServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.SKELETON_SERVANT.get()), (Level)serverLevel);
                    BlockPos blockPos = BlockFinder.SummonRadius((LivingEntity)WitherNecromancer.this, (Level)serverLevel);
                    summoned.setTrueOwner((LivingEntity)WitherNecromancer.this);
                    summoned.m_20035_(blockPos, 0.0f, 0.0f);
                    MobUtil.moveDownToGround((Entity)summoned);
                    ((Summoned)summoned).m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(WitherNecromancer.this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    summoned.m_21530_();
                    if (!serverLevel.m_7967_((Entity)summoned)) continue;
                    summoned.m_5496_((SoundEvent)ModSounds.SUMMON_SPELL.get(), 1.0f, 1.0f);
                }
            }
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.PREPARE_SUMMON.get();
        }

        @Override
        protected AbstractNecromancer.NecromancerSpellType getNecromancerSpellType() {
            return AbstractNecromancer.NecromancerSpellType.ZOMBIE;
        }
    }

    public class SummonVolcanosGoal
    extends Goal {
        protected int spellTime;

        public boolean m_8036_() {
            LivingEntity target = WitherNecromancer.this.m_5448_();
            if (WitherNecromancer.this.isShooting()) {
                return false;
            }
            if (WitherNecromancer.this.isSpellCasting()) {
                return false;
            }
            return target != null && target.m_6084_() && WitherNecromancer.this.idleSpellCool <= 0;
        }

        public boolean m_8045_() {
            LivingEntity target = WitherNecromancer.this.m_5448_();
            return this.spellTime > 0 && target != null && target.m_6084_();
        }

        public void m_8056_() {
            this.spellTime = 29;
            WitherNecromancer.this.setSpellCooldown(100);
            WitherNecromancer.this.m_5496_((SoundEvent)ModSounds.PREPARE_SUMMON.get(), 1.0f, 1.0f);
            WitherNecromancer.this.setSpellCasting(true);
            WitherNecromancer.this.setNecromancerSpellType(AbstractNecromancer.NecromancerSpellType.CLOUD);
            WitherNecromancer.this.f_19853_.m_7605_((Entity)WitherNecromancer.this, (byte)6);
            Level level = WitherNecromancer.this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                LivingEntity target = WitherNecromancer.this.m_5448_();
                if (target != null) {
                    Volcano volcano;
                    float f2;
                    int k;
                    float f = (float)Mth.m_14136_((double)(target.m_20189_() - WitherNecromancer.this.m_20189_()), (double)(target.m_20185_() - WitherNecromancer.this.m_20185_()));
                    for (k = 0; k < 4; ++k) {
                        f2 = f + (float)k * (float)Math.PI * 0.25f + 3.0f;
                        volcano = new Volcano((EntityType<? extends Owned>)((EntityType)ModEntityType.VOLCANO.get()), (Level)serverLevel);
                        volcano.setTrueOwner((LivingEntity)WitherNecromancer.this);
                        volcano.m_6034_(WitherNecromancer.this.m_20185_() + (double)Mth.m_14089_((float)f2) * 3.0, WitherNecromancer.this.m_20186_() + 4.0, WitherNecromancer.this.m_20189_() + (double)Mth.m_14031_((float)f2) * 3.0);
                        volcano.setExplosionPower(1.5f);
                        volcano.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(WitherNecromancer.this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                        serverLevel.m_7967_((Entity)volcano);
                    }
                    for (k = 0; k < 8; ++k) {
                        f2 = f + (float)k * (float)Math.PI * 0.25f + 6.0f;
                        volcano = new Volcano((EntityType<? extends Owned>)((EntityType)ModEntityType.VOLCANO.get()), (Level)serverLevel);
                        volcano.setTrueOwner((LivingEntity)WitherNecromancer.this);
                        volcano.m_6034_(WitherNecromancer.this.m_20185_() + (double)Mth.m_14089_((float)f2) * 6.0, WitherNecromancer.this.m_20186_() + 4.0, WitherNecromancer.this.m_20189_() + (double)Mth.m_14031_((float)f2) * 6.0);
                        volcano.setExplosionPower(1.5f);
                        volcano.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(WitherNecromancer.this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                        serverLevel.m_7967_((Entity)volcano);
                    }
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            WitherNecromancer.this.setSpellCasting(false);
            WitherNecromancer.this.f_19853_.m_7605_((Entity)WitherNecromancer.this, (byte)7);
        }

        public void m_8037_() {
            --this.spellTime;
            if (this.spellTime == 0) {
                WitherNecromancer.this.setNecromancerSpellType(AbstractNecromancer.NecromancerSpellType.NONE);
                WitherNecromancer.this.idleSpellCool = MathHelper.secondsToTicks(10);
            }
        }
    }
}

