/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.MainConfig;
import com.Polarice3.Goety.api.entities.ICustomAttributes;
import com.Polarice3.Goety.api.entities.hostile.IBoss;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.entities.PithosBlockEntity;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.undead.HauntedSkull;
import com.Polarice3.Goety.common.entities.hostile.BoneLord;
import com.Polarice3.Goety.common.entities.neutral.Minion;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.HauntedSkullProjectile;
import com.Polarice3.Goety.common.entities.util.SkullLaser;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SAddBossPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;

public class SkullLord
extends Monster
implements ICustomAttributes,
IBoss {
    protected static final EntityDataAccessor<Byte> FLAGS = SynchedEntityData.m_135353_(SkullLord.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Optional<UUID>> BONE_LORD = SynchedEntityData.m_135353_(SkullLord.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> LASER = SynchedEntityData.m_135353_(SkullLord.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(false).m_7006_(false);
    private UUID bossInfoUUID = this.bossInfo.m_18860_();
    @Nullable
    private BlockPos boundOrigin;
    private int shootTime;
    private int spawnDelay = 100;
    private int spawnNumber = 0;
    private int chargeTime = 0;
    private int laserTime = 0;
    public float explosionRadius = 1.5f;
    public int boneLordRegen;
    private int hitTimes;
    private int stuckTime = 0;

    public SkullLord(EntityType<? extends SkullLord> p_i50190_1_, Level p_i50190_2_) {
        super(p_i50190_1_, p_i50190_2_);
        this.f_21344_ = this.m_6037_(p_i50190_2_);
        this.shootTime = 0;
        this.f_21342_ = new MobUtil.MinionMoveControl((Mob)this);
        this.hitTimes = 0;
        this.f_21364_ = 70;
        if (this.f_19853_.f_46443_) {
            Goety.PROXY.addBoss((Mob)this);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new SoulSkullGoal());
        this.f_21345_.m_25352_(4, (Goal)new ChargeAttackGoal());
        this.f_21345_.m_25352_(8, (Goal)new MoveRandomGoal());
        this.f_21345_.m_25352_(9, (Goal)new SkullLordLookGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.SkullLordDamage.get()).doubleValue()).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.SkullLordHealth.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.SkullLordHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.SkullLordDamage.get());
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        super.m_6478_(typeIn, pos);
        this.m_20101_();
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn);
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_26443_(false);
        return flyingpathnavigator;
    }

    public BlockEntity getPithos() {
        if (this.getBoundOrigin() != null) {
            return this.f_19853_.m_7702_(this.getBoundOrigin());
        }
        return null;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_20147_()) {
            return false;
        }
        if (this.isCharging()) {
            this.chargeTime += 100;
        }
        ++this.hitTimes;
        if (this.hitTimes > 3 || pAmount >= 20.0f) {
            pAmount /= 2.0f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6043_() {
        this.setIsDespawn(true);
        super.m_6043_();
    }

    public boolean m_5825_() {
        return this.m_20147_();
    }

    protected boolean m_6129_() {
        return false;
    }

    public void m_8119_() {
        BlockPos blockPos;
        super.m_8119_();
        this.m_20242_(true);
        int delay = switch (this.f_19853_.m_46791_()) {
            case Difficulty.NORMAL -> 200;
            case Difficulty.HARD -> 100;
            default -> 400;
        };
        Vec3 vector3d = this.m_20184_();
        double d0 = this.m_20185_() + vector3d.f_82479_;
        double d1 = this.m_20186_() + vector3d.f_82480_;
        double d2 = this.m_20189_() + vector3d.f_82481_;
        SimpleParticleType particleData = ParticleTypes.f_123762_;
        if (this.m_20147_()) {
            particleData = ParticleTypes.f_123759_;
        } else if (this.isCharging() || this.isLasering()) {
            particleData = ParticleTypes.f_123745_;
        }
        this.f_19853_.m_7106_((ParticleOptions)particleData, d0 + this.f_19796_.m_188583_() * (double)0.3f, d1 + this.f_19796_.m_188583_() * (double)0.3f, d2 + this.f_19796_.m_188583_() * (double)0.3f, 0.0, 0.0, 0.0);
        if (this.shootTime > 0) {
            --this.shootTime;
        }
        if (this.m_20147_()) {
            if (this.f_19797_ % 20 == 0) {
                this.m_5634_(1.0f);
            }
            if (this.getLaser() != null) {
                this.getLaser().m_146870_();
            }
        }
        if (this.m_6060_() && (this.f_19797_ % 100 == 0 || this.m_20147_())) {
            this.m_20095_();
        }
        if (this.getLaser() != null) {
            this.f_21365_.m_24960_((Entity)this.getLaser(), 90.0f, 90.0f);
            if (!this.f_19853_.f_46443_) {
                if (this.f_19797_ % 20 == 0 && this.f_19796_.m_188501_() <= 0.25f && this.isHalfHealth()) {
                    BlockPos blockpos = this.m_20183_().m_7918_(-2 + this.m_217043_().m_188503_(5), 1, -2 + this.m_217043_().m_188503_(5));
                    HauntedSkull summonedentity = new HauntedSkull((EntityType<? extends Minion>)((EntityType)ModEntityType.HAUNTED_SKULL.get()), this.f_19853_);
                    summonedentity.setTrueOwner((LivingEntity)this);
                    summonedentity.m_20035_(blockpos, 0.0f, 0.0f);
                    summonedentity.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                    summonedentity.setBoundOrigin(blockpos);
                    summonedentity.setLimitedLife(MathHelper.minutesToTicks(1));
                    summonedentity.m_6710_(this.m_5448_());
                    this.f_19853_.m_7967_((Entity)summonedentity);
                }
                this.drawParticleBeam((LivingEntity)this, (LivingEntity)this.getLaser());
            }
        }
        if (this.getPithos() != null && this.m_20275_((blockPos = this.getPithos().m_58899_()).m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()) > 1024.0) {
            this.m_20035_(blockPos, 0.0f, 0.0f);
            if (this.getBoneLord() != null) {
                this.getBoneLord().m_20035_(blockPos, 0.0f, 0.0f);
            }
        }
        if (this.m_5448_() != null) {
            if (this.m_5448_().m_21224_() || this.m_5448_().m_213877_()) {
                this.m_6710_(null);
            } else {
                Vec3 vector3d1 = this.m_5448_().m_20299_(1.0f);
                if (!this.m_20147_()) {
                    if (!this.isLasering()) {
                        int cooldown;
                        int n = cooldown = this.isHalfHealth() ? 350 : 500;
                        if (this.f_19797_ % cooldown == 0) {
                            this.setLaserTime(true);
                        }
                    }
                } else {
                    this.setLaserTime(false);
                }
                if (this.isLaserTime()) {
                    if (!this.isCharging()) {
                        SkullLaser skullLaser;
                        ++this.laserTime;
                        if ((double)this.m_20270_((Entity)this.m_5448_()) <= 4.0) {
                            double nx = this.m_5448_().m_20185_() - this.m_20185_();
                            double nz = this.m_5448_().m_20189_() - this.m_20189_();
                            this.f_21342_.m_6849_(nx, vector3d1.f_82480_, nz, 0.25);
                        } else {
                            this.f_21342_.m_6849_(vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, 0.25);
                        }
                        if (this.laserTime == 20) {
                            this.m_5496_((SoundEvent)ModSounds.SKULL_LORD_LASER_BEGIN.get(), 2.0f, 1.0f);
                            if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                                this.spawnMobs();
                            }
                        }
                        if (this.laserTime >= 20 && !this.f_19853_.f_46443_) {
                            ServerLevel serverWorld = (ServerLevel)this.f_19853_;
                            ServerParticleUtil.gatheringParticles((ParticleOptions)ModParticleTypes.LASER_GATHER.get(), (Entity)this, serverWorld);
                        }
                        if (this.laserTime >= MathHelper.secondsToTicks(5) && (skullLaser = (SkullLaser)((EntityType)ModEntityType.LASER.get()).m_20615_(this.f_19853_)) != null) {
                            this.m_5496_((SoundEvent)ModSounds.SKULL_LORD_LASER_START.get(), 3.0f, 1.0f);
                            this.setLaserTime(false);
                            skullLaser.setSkullLord(this);
                            skullLaser.setDuration(200);
                            skullLaser.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                            skullLaser.m_6710_(this.m_5448_());
                            this.setLaser(skullLaser);
                            this.f_19853_.m_7967_((Entity)skullLaser);
                        }
                    }
                } else {
                    if (this.m_20096_() || this.m_5448_().m_20188_() > this.m_20186_()) {
                        this.f_21342_.m_6849_(this.m_20185_(), this.m_5448_().m_20188_() + 1.0, this.m_20189_(), 1.0);
                    }
                    this.laserTime = 0;
                }
                boolean flag = false;
                if (this.f_19790_ == this.m_20185_() && this.f_19791_ == this.m_20186_() && this.f_19792_ == this.m_20189_() || this.m_5830_()) {
                    ++this.stuckTime;
                    if (this.stuckTime >= 100) {
                        flag = true;
                        if (!this.m_20147_() && !this.isLasering() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_)) {
                            this.f_19853_.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, Level.ExplosionInteraction.MOB);
                        }
                        this.stuckTime = 0;
                    }
                } else {
                    this.stuckTime = 0;
                }
                if (!this.f_19853_.m_8055_(this.m_20183_().m_121945_(Direction.WEST)).m_60795_() && !this.f_19853_.m_8055_(this.m_20183_().m_121945_(Direction.NORTH)).m_60795_()) {
                    flag = true;
                }
                if (!this.f_19853_.m_8055_(this.m_20183_().m_121945_(Direction.WEST)).m_60795_() && !this.f_19853_.m_8055_(this.m_20183_().m_121945_(Direction.SOUTH)).m_60795_()) {
                    flag = true;
                }
                if (!this.f_19853_.m_8055_(this.m_20183_().m_121945_(Direction.EAST)).m_60795_() && !this.f_19853_.m_8055_(this.m_20183_().m_121945_(Direction.SOUTH)).m_60795_()) {
                    flag = true;
                }
                if (!this.f_19853_.m_8055_(this.m_20183_().m_121945_(Direction.EAST)).m_60795_() && !this.f_19853_.m_8055_(this.m_20183_().m_121945_(Direction.SOUTH)).m_60795_()) {
                    flag = true;
                }
                if (flag) {
                    if (!this.m_20147_() || this.isLaserTime() || this.isLasering()) {
                        if (this.m_20280_((Entity)this.m_5448_()) > 4.0) {
                            this.f_21342_.m_6849_(vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, 1.0);
                        } else {
                            double nx = this.m_5448_().m_20185_() - this.m_20185_();
                            double nz = this.m_5448_().m_20189_() - this.m_20189_();
                            this.f_21342_.m_6849_(nx, vector3d1.f_82480_, nz, 1.0);
                        }
                    } else {
                        this.f_21342_.m_6849_(vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, 1.0);
                    }
                }
            }
        } else {
            Player player2;
            for (Player player2 : this.f_19853_.m_6443_(Player.class, this.m_20191_().m_82400_(4.0), EntitySelector.f_20406_)) {
                this.m_6710_((LivingEntity)player2);
            }
            if (this.getPithos() != null && (player2 = this.getPithos()) instanceof PithosBlockEntity) {
                PithosBlockEntity pithosTile = (PithosBlockEntity)player2;
                if (this.f_19797_ % 100 == 0 && this.f_19853_.m_46749_(pithosTile.m_58899_())) {
                    this.setIsDespawn(true);
                    pithosTile.lock();
                    if (this.getBoneLord() != null) {
                        this.getBoneLord().m_146870_();
                    }
                    if (this.getLaser() != null) {
                        this.getLaser().m_146870_();
                    }
                    this.m_146870_();
                }
            }
        }
        if (!this.f_19853_.f_46443_) {
            int k;
            int j;
            ServerLevel serverWorld = (ServerLevel)this.f_19853_;
            int i = this.m_20183_().m_123341_();
            List list = this.f_19853_.m_6443_(Owned.class, new AABB((double)i, (double)(j = this.m_20183_().m_123342_()), (double)(k = this.m_20183_().m_123343_()), (double)i, (double)(j - 4), (double)k).m_82377_(8.0, 8.0, 8.0), owned -> owned.getTrueOwner() == this);
            if (list.size() < 8 && this.m_5448_() != null && !this.isLasering()) {
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                } else {
                    this.spawnDelay = this.f_19853_.f_46441_.m_188503_(delay) + delay;
                    this.spawnMobs();
                }
            }
            if (this.getBoneLord() == null || this.getBoneLord() != null && this.getBoneLord().m_21224_()) {
                BoneLord boneLord;
                if (!this.isLaserTime()) {
                    --this.boneLordRegen;
                }
                this.setIsInvulnerable(false);
                this.f_19853_.m_7605_((Entity)this, (byte)5);
                for (BoneLord boneLord2 : this.f_19853_.m_45976_(BoneLord.class, this.m_20191_().m_82400_(32.0))) {
                    if (boneLord2.getSkullLord() != this) continue;
                    this.setBoneLord(boneLord2);
                }
                if (this.boneLordRegen <= 0 && !this.isLasering() && (boneLord = (BoneLord)((EntityType)ModEntityType.BONE_LORD.get()).m_20615_(this.f_19853_)) != null) {
                    boneLord.m_6518_((ServerLevelAccessor)serverWorld, this.f_19853_.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    boneLord.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    boneLord.setSkullLord(this);
                    this.setBoneLord(boneLord);
                    this.f_19853_.m_7967_((Entity)boneLord);
                }
            } else if (this.getBoneLord() != null) {
                this.drawAttachParticleBeam((LivingEntity)this, (LivingEntity)this.getBoneLord());
                if (this.getBoneLord().m_5448_() != null && this.m_5448_() == null) {
                    this.m_6710_(this.getBoneLord().m_5448_());
                }
                if (this.m_20280_((Entity)this.getBoneLord()) > (double)Mth.m_144944_((int)16)) {
                    this.m_20219_(this.getBoneLord().m_20182_());
                }
                this.setIsInvulnerable(true);
                this.f_19853_.m_7605_((Entity)this, (byte)4);
                this.hitTimes = 0;
                this.boneLordRegen = delay * 2;
            }
            if (this.isCharging()) {
                ++this.chargeTime;
                for (LivingEntity livingEntity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(2.0))) {
                    if (livingEntity instanceof BoneLord || livingEntity == this || livingEntity == this.m_5448_() || !this.m_20191_().m_82381_(livingEntity.m_20191_())) continue;
                    this.f_19853_.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionRadius, Level.ExplosionInteraction.NONE);
                    if (!(this.f_19796_.m_188501_() < 0.25f)) continue;
                    this.setIsCharging(false);
                }
                if (this.f_19862_ || this.f_19863_) {
                    this.f_19853_.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionRadius, Level.ExplosionInteraction.NONE);
                    this.setIsCharging(false);
                }
                if (this.chargeTime >= 200) {
                    this.setIsCharging(false);
                }
            } else {
                this.chargeTime = 0;
            }
        }
    }

    private void drawAttachParticleBeam(LivingEntity pSource, LivingEntity pTarget) {
        double d0 = pTarget.m_20185_() - pSource.m_20185_();
        double d1 = pTarget.m_20188_() - pSource.m_20186_();
        double d2 = pTarget.m_20189_() - pSource.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        d0 /= d3;
        d1 /= d3;
        d2 /= d3;
        double d4 = pSource.f_19853_.f_46441_.m_188500_();
        if (!pSource.f_19853_.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)pSource.f_19853_;
            while (d4 < d3) {
                serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BONE.get()), pSource.m_20185_() + d0 * (d4 += 1.0), pSource.m_20186_() + d1 * d4, pSource.m_20189_() + d2 * d4, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void drawParticleBeam(LivingEntity pSource, LivingEntity pTarget) {
        double d0 = pTarget.m_20185_() - pSource.m_20185_();
        double d1 = pTarget.m_20186_() + (double)pTarget.m_20206_() * 0.5 - (pSource.m_20186_() + (double)pSource.m_20206_() * 0.5);
        double d2 = pTarget.m_20189_() - pSource.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        d0 /= d3;
        d1 /= d3;
        d2 /= d3;
        double d4 = pSource.f_19853_.f_46441_.m_188500_();
        if (!pSource.f_19853_.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)pSource.f_19853_;
            while (d4 < d3) {
                serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.LASER_POINT.get()), pSource.m_20185_() + d0 * (d4 += 1.0), pSource.m_20186_() + d1 * d4 + (double)pSource.m_20192_() * 0.5, pSource.m_20189_() + d2 * d4, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void spawnMobs() {
        int spawnRange = 2;
        boolean random = this.f_19853_.f_46441_.m_188499_();
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double d0 = (double)this.m_20183_().m_123341_() + this.f_19853_.f_46441_.m_188500_();
            double d1 = (double)this.m_20183_().m_123342_() + this.f_19853_.f_46441_.m_188500_();
            double d2 = (double)this.m_20183_().m_123343_() + this.f_19853_.f_46441_.m_188500_();
            for (int p = 0; p < 4; ++p) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 1, 0.0, 5.0E-4, 0.0, 5.0E-4);
            }
            for (int i = 0; i < 1 + serverLevel.f_46441_.m_188503_(2); ++i) {
                double d3 = (double)this.m_20183_().m_123341_() + (serverLevel.f_46441_.m_188500_() - serverLevel.f_46441_.m_188500_()) * (double)spawnRange + 0.5;
                double d4 = this.m_20183_().m_123342_() + serverLevel.f_46441_.m_188503_(3);
                double d5 = (double)this.m_20183_().m_123343_() + (serverLevel.f_46441_.m_188500_() - serverLevel.f_46441_.m_188500_()) * (double)spawnRange + 0.5;
                Owned owned = this.m_5842_() ? (Owned)((EntityType)ModEntityType.DROWNED_SERVANT.get()).m_20615_((Level)serverLevel) : (random ? (Owned)((EntityType)ModEntityType.ZOMBIE_SERVANT.get()).m_20615_((Level)serverLevel) : (Owned)((EntityType)ModEntityType.SKELETON_SERVANT.get()).m_20615_((Level)serverLevel));
                if (owned == null) continue;
                BlockPos blockPos = BlockPos.m_274561_((double)d3, (double)d4, (double)d5);
                owned.setTrueOwner((LivingEntity)this);
                owned.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 100, 0, false, false));
                if (!serverLevel.m_8055_(blockPos).m_60795_()) {
                    owned.m_6027_(this.m_20183_().m_123341_(), this.m_20183_().m_123342_(), this.m_20183_().m_123343_());
                } else {
                    owned.m_6027_(d3, d4, d5);
                }
                owned.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(owned.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                serverLevel.m_47205_((Entity)owned);
            }
        }
    }

    public void m_6667_(DamageSource cause) {
        BlockEntity blockEntity;
        super.m_6667_(cause);
        for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
            float f11 = this.f_19796_.m_188501_() - 0.5f;
            float f13 = this.f_19796_.m_188501_() - 0.5f;
            float f14 = this.f_19796_.m_188501_() - 0.5f;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + (double)f11, this.m_20186_() + 2.0 + (double)f13, this.m_20189_() + (double)f14, 0.0, 0.0, 0.0);
        }
        if (this.getBoneLord() != null) {
            this.getBoneLord().m_6667_(cause);
        }
        if (this.getLaser() != null) {
            this.getLaser().m_146870_();
        }
        if (this.getPithos() != null && (blockEntity = this.getPithos()) instanceof PithosBlockEntity) {
            PithosBlockEntity pithosTile = (PithosBlockEntity)blockEntity;
            pithosTile.unlock();
        }
    }

    public void m_142687_(Entity.RemovalReason p_146834_) {
        if (this.f_19853_.f_46443_) {
            Goety.PROXY.removeBoss((Mob)this);
        }
        super.m_142687_(p_146834_);
    }

    public void onRemovedFromWorld() {
        BlockEntity blockEntity;
        super.onRemovedFromWorld();
        if (this.getBoneLord() != null) {
            this.getBoneLord().m_146870_();
        }
        if (this.getLaser() != null) {
            this.getLaser().m_146870_();
        }
        if (!this.isDespawn() && this.getPithos() != null && (blockEntity = this.getPithos()) instanceof PithosBlockEntity) {
            PithosBlockEntity pithosTile = (PithosBlockEntity)blockEntity;
            pithosTile.unlock();
        }
    }

    public void m_7601_(BlockState pState, Vec3 pMotionMultiplier) {
        if (!pState.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(pState, pMotionMultiplier);
        }
    }

    public boolean m_142535_(float p_146828_, float p_146829_, DamageSource p_146830_) {
        return false;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SKULL_LORD_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.SKULL_LORD_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SKULL_LORD_DEATH.get();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_7307_(Entity entityIn) {
        Monster monster;
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof Monster && (monster = (Monster)entityIn).m_6336_() == MobType.f_21641_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLAGS, (Object)0);
        this.f_19804_.m_135372_(BONE_LORD, Optional.empty());
        this.f_19804_.m_135372_(LASER, Optional.empty());
    }

    private boolean geFlags(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(FLAGS);
        return (i & mask) != 0;
    }

    private void setFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(FLAGS, (Object)((byte)(i & 0xFF)));
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos pBoundOrigin) {
        this.boundOrigin = pBoundOrigin;
    }

    @Nullable
    public BoneLord getBoneLord() {
        try {
            UUID uuid = this.getBoneLordUUID();
            if (uuid != null && EntityFinder.getLivingEntityByUuiD(uuid) instanceof BoneLord) {
                return (BoneLord)EntityFinder.getLivingEntityByUuiD(uuid);
            }
            return null;
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getBoneLordUUID() {
        return ((Optional)this.f_19804_.m_135370_(BONE_LORD)).orElse(null);
    }

    public void setBoneLordUUID(UUID uuid) {
        this.f_19804_.m_135381_(BONE_LORD, Optional.ofNullable(uuid));
    }

    public void setBoneLord(BoneLord boneLord) {
        this.setBoneLordUUID(boneLord.m_20148_());
    }

    public boolean isLasering() {
        return this.getLaser() != null;
    }

    @Nullable
    public SkullLaser getLaser() {
        try {
            UUID uuid = this.getLaserUUID();
            if (uuid != null && EntityFinder.getLivingEntityByUuiD(uuid) instanceof SkullLaser) {
                return (SkullLaser)EntityFinder.getLivingEntityByUuiD(uuid);
            }
            return null;
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getLaserUUID() {
        return ((Optional)this.f_19804_.m_135370_(LASER)).orElse(null);
    }

    public void setLaserUUID(UUID uuid) {
        this.f_19804_.m_135381_(LASER, Optional.ofNullable(uuid));
    }

    public void setLaser(SkullLaser laser) {
        this.setLaserUUID(laser.m_20148_());
    }

    public boolean isCharging() {
        return this.geFlags(1);
    }

    public void setIsCharging(boolean charging) {
        this.setFlags(1, charging);
    }

    public boolean m_20147_() {
        return this.geFlags(2);
    }

    public void setIsInvulnerable(boolean invulnerable) {
        this.setFlags(2, invulnerable);
    }

    public boolean isDespawn() {
        return this.geFlags(4);
    }

    public void setIsDespawn(boolean despawn) {
        this.setFlags(4, despawn);
    }

    public boolean isLaserTime() {
        return this.geFlags(8);
    }

    public void setLaserTime(boolean laserTime) {
        this.setFlags(8, laserTime);
    }

    public void m_7378_(CompoundTag pCompound) {
        String s2;
        UUID uuid;
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("BoundX")) {
            this.boundOrigin = new BlockPos(pCompound.m_128451_("BoundX"), pCompound.m_128451_("BoundY"), pCompound.m_128451_("BoundZ"));
        }
        if (pCompound.m_128403_("boneLord")) {
            uuid = pCompound.m_128342_("boneLord");
        } else {
            s2 = pCompound.m_128461_("boneLord");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s2);
        }
        if (uuid != null) {
            try {
                this.setBoneLordUUID(uuid);
            }
            catch (Throwable s2) {
                // empty catch block
            }
        }
        if (pCompound.m_128403_("laser")) {
            uuid = pCompound.m_128342_("laser");
        } else {
            s2 = pCompound.m_128461_("laser");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s2);
        }
        if (uuid != null) {
            try {
                this.setLaserUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.shootTime = pCompound.m_128451_("shootTime");
        this.hitTimes = pCompound.m_128451_("hitTimes");
        this.boneLordRegen = pCompound.m_128451_("boneLordRegen");
        this.spawnDelay = pCompound.m_128451_("spawnDelay");
        this.spawnNumber = pCompound.m_128451_("spawnNumber");
        this.laserTime = pCompound.m_128451_("laserTime");
        this.stuckTime = pCompound.m_128451_("stuckTime");
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.setConfigurableAttributes();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.boundOrigin != null) {
            pCompound.m_128405_("BoundX", this.boundOrigin.m_123341_());
            pCompound.m_128405_("BoundY", this.boundOrigin.m_123342_());
            pCompound.m_128405_("BoundZ", this.boundOrigin.m_123343_());
        }
        if (this.getBoneLordUUID() != null) {
            pCompound.m_128362_("boneLord", this.getBoneLordUUID());
        }
        if (this.getLaserUUID() != null) {
            pCompound.m_128362_("laser", this.getLaserUUID());
        }
        pCompound.m_128405_("shootTime", this.shootTime);
        pCompound.m_128405_("hitTimes", this.hitTimes);
        pCompound.m_128405_("boneLordRegen", this.boneLordRegen);
        pCompound.m_128405_("spawnDelay", this.spawnDelay);
        pCompound.m_128405_("spawnNumber", this.spawnNumber);
        pCompound.m_128405_("laserTime", this.laserTime);
        pCompound.m_128405_("stuckTime", this.stuckTime);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_8321_(((Boolean)MainConfig.SpecialBossBar.get()).booleanValue());
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (((Boolean)MainConfig.SpecialBossBar.get()).booleanValue()) {
            this.bossInfo.m_6543_(pPlayer);
        }
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossInfo.m_6539_(pPlayer);
    }

    public float m_213856_() {
        return 1.0f;
    }

    public boolean isHalfHealth() {
        return this.m_21223_() <= this.m_21233_() / 2.0f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_213945_(pLevel.m_213780_(), pDifficulty);
        this.m_213946_(pLevel.m_213780_(), pDifficulty);
        BoneLord boneLord = (BoneLord)((EntityType)ModEntityType.BONE_LORD.get()).m_20615_((Level)pLevel);
        if (boneLord != null) {
            boneLord.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
            boneLord.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            boneLord.setSkullLord(this);
            this.setBoneLord(boneLord);
            pLevel.m_7967_((Entity)boneLord);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public UUID getBossInfoUUID() {
        return this.bossInfoUUID;
    }

    @Override
    public void setBossInfoUUID(UUID bossInfoUUID) {
        this.bossInfoUUID = bossInfoUUID;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return ModNetwork.INSTANCE.toVanillaPacket((Object)new SAddBossPacket(new ClientboundAddEntityPacket((Entity)this), this.bossInfoUUID), NetworkDirection.PLAY_TO_CLIENT);
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.setIsInvulnerable(true);
        } else if (p_21375_ == 5) {
            this.setIsInvulnerable(false);
        } else {
            super.m_7822_(p_21375_);
        }
    }

    class SoulSkullGoal
    extends Goal {
        public SoulSkullGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (SkullLord.this.m_5448_() != null && !SkullLord.this.m_21566_().m_24995_() && SkullLord.this.m_20147_()) {
                return !SkullLord.this.m_5448_().m_7307_((Entity)SkullLord.this);
            }
            return false;
        }

        public boolean m_8045_() {
            return SkullLord.this.m_21566_().m_24995_() && SkullLord.this.m_5448_() != null && SkullLord.this.m_5448_().m_6084_() && SkullLord.this.getBoneLord() != null;
        }

        public void m_8037_() {
            LivingEntity livingentity = SkullLord.this.m_5448_();
            if (livingentity != null) {
                int shoot = 45;
                if (SkullLord.this.isHalfHealth()) {
                    shoot = 30;
                }
                if (SkullLord.this.shootTime == 0) {
                    double d1 = livingentity.m_20185_() - SkullLord.this.m_20185_();
                    double d2 = livingentity.m_20227_(0.5) - SkullLord.this.m_20227_(0.5);
                    double d3 = livingentity.m_20189_() - SkullLord.this.m_20189_();
                    HauntedSkullProjectile soulSkull = new HauntedSkullProjectile((LivingEntity)SkullLord.this, d1, d2, d3, SkullLord.this.f_19853_);
                    soulSkull.m_6034_(soulSkull.m_20185_(), SkullLord.this.m_20227_(0.75), soulSkull.m_20189_());
                    soulSkull.m_146922_(SkullLord.this.m_146908_());
                    soulSkull.m_146926_(SkullLord.this.m_146909_());
                    if (SkullLord.this.f_19853_.f_46441_.m_188501_() <= 0.05f) {
                        soulSkull.setDangerous(true);
                        SkullLord.this.shootTime = shoot + 40;
                    } else {
                        SkullLord.this.shootTime = shoot;
                    }
                    SkullLord.this.f_19853_.m_7967_((Entity)soulSkull);
                    SkullLord.this.m_5496_((SoundEvent)ModSounds.SKULL_LORD_SHOOT.get(), 1.0f, 1.0f);
                }
                double d2 = SkullLord.this.m_5448_().m_20185_() - SkullLord.this.m_20185_();
                double d1 = SkullLord.this.m_5448_().m_20189_() - SkullLord.this.m_20189_();
                SkullLord.this.m_146922_(-((float)MathHelper.m_14136_((double)d2, (double)d1)) * 57.295776f);
                SkullLord.this.f_20883_ = SkullLord.this.m_146908_();
            }
        }
    }

    class ChargeAttackGoal
    extends Goal {
        public ChargeAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!(SkullLord.this.m_5448_() == null || SkullLord.this.m_21566_().m_24995_() || SkullLord.this.getBoneLord() != null || SkullLord.this.isLaserTime() || SkullLord.this.isLasering())) {
                if (!SkullLord.this.isHalfHealth()) {
                    return SkullLord.this.f_19796_.m_188503_(7) == 0;
                }
                return SkullLord.this.f_19796_.m_188503_(3) == 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return SkullLord.this.m_21566_().m_24995_() && SkullLord.this.isCharging() && SkullLord.this.m_5448_() != null && SkullLord.this.getBoneLord() == null && SkullLord.this.m_5448_().m_6084_() && !SkullLord.this.isLaserTime() && !SkullLord.this.isLasering();
        }

        public void m_8056_() {
            LivingEntity livingentity = SkullLord.this.m_5448_();
            if (livingentity != null) {
                Vec3 vector3d = livingentity.m_20299_(1.0f);
                SkullLord.this.f_21342_.m_6849_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, SkullLord.this.isHalfHealth() ? 1.25 : 1.0);
                SkullLord.this.setIsCharging(true);
                SkullLord.this.m_5496_((SoundEvent)ModSounds.SKULL_LORD_CHARGE.get(), 1.0f, 1.0f);
            }
        }

        public void m_8041_() {
            SkullLord.this.setIsCharging(false);
        }

        public void m_8037_() {
            SkullLord skullLord = SkullLord.this;
            LivingEntity livingentity = SkullLord.this.m_5448_();
            if (livingentity != null) {
                if (skullLord.m_20191_().m_82381_(livingentity.m_20191_())) {
                    if (livingentity.m_6469_(skullLord.m_269291_().m_269104_((Entity)skullLord, (Entity)skullLord), (float)skullLord.m_21133_(Attributes.f_22281_))) {
                        if (skullLord.m_6060_()) {
                            livingentity.m_20254_(5);
                        }
                        skullLord.f_19853_.m_254849_((Entity)skullLord, skullLord.m_20185_(), skullLord.m_20186_(), skullLord.m_20189_(), skullLord.explosionRadius, Level.ExplosionInteraction.NONE);
                        skullLord.setIsCharging(false);
                    }
                } else {
                    double d0 = skullLord.m_20280_((Entity)livingentity);
                    if (d0 < 9.0) {
                        Vec3 vector3d = livingentity.m_20299_(1.0f);
                        skullLord.f_21342_.m_6849_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, SkullLord.this.isHalfHealth() ? 1.25 : 1.0);
                    }
                }
            }
        }
    }

    class MoveRandomGoal
    extends Goal {
        public MoveRandomGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !SkullLord.this.m_21566_().m_24995_() && SkullLord.this.f_19796_.m_188503_(7) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = SkullLord.this.m_20183_();
            if (SkullLord.this.getBoundOrigin() != null) {
                blockpos = SkullLord.this.getBoundOrigin();
            } else if (SkullLord.this.getBoneLord() != null) {
                blockpos = SkullLord.this.getBoneLord().m_20183_();
            } else if (SkullLord.this.m_5448_() != null) {
                blockpos = SkullLord.this.m_5448_().m_20183_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(SkullLord.this.f_19796_.m_188503_(15) - 7, SkullLord.this.f_19796_.m_188503_(11) - 5, SkullLord.this.f_19796_.m_188503_(15) - 7);
                if (!SkullLord.this.f_19853_.m_46859_(blockpos1)) continue;
                SkullLord.this.m_216990_((SoundEvent)ModSounds.SKULL_LORD_FLY.get());
                SkullLord.this.f_21342_.m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                if (SkullLord.this.m_5448_() != null) break;
                SkullLord.this.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    static class SkullLordLookGoal
    extends LookAtPlayerGoal {
        private final SkullLord skullLord;

        public SkullLordLookGoal(SkullLord p_i1631_1_) {
            super((Mob)p_i1631_1_, Player.class, 3.0f, 1.0f);
            this.skullLord = p_i1631_1_;
        }

        public boolean m_8036_() {
            if (this.skullLord.getLaser() != null) {
                return false;
            }
            return super.m_8036_();
        }
    }
}

