/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile;

import com.Polarice3.Goety.MobsConfig;
import com.Polarice3.Goety.common.entities.neutral.Minion;
import com.Polarice3.Goety.common.entities.projectiles.SoulBullet;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class Irk
extends Minion
implements Enemy {
    private int shootTime;

    public Irk(EntityType<? extends Irk> p_i50190_1_, Level p_i50190_2_) {
        super((EntityType<? extends Minion>)p_i50190_1_, p_i50190_2_);
        this.setHostile(true);
        this.shootTime = 0;
        this.f_21344_ = this.m_6037_(p_i50190_2_);
    }

    @Override
    public int xpReward() {
        return 3;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn);
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.shootTime > 0) {
            --this.shootTime;
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new OutofBoundsGoal());
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal(this, 0.5, 6.0f, 3.0f, true));
        this.f_21345_.m_25352_(4, (Goal)new ChargeAttackGoal());
        this.f_21345_.m_25352_(8, (Goal)new MoveRandomGoal());
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    public void m_6667_(DamageSource cause) {
        Entity entity = cause.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_5634_(2.0f);
        }
        super.m_6667_(cause);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.shootTime = compound.m_128451_("shootTime");
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("shootTime", this.shootTime);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity = source.m_7639_();
        if (entity instanceof Irk) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public boolean m_7307_(Entity entityIn) {
        if (entityIn == this) {
            return true;
        }
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof Irk) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    private boolean getVexFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(VEX_FLAGS);
        return (i & mask) != 0;
    }

    private void setVexFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(VEX_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(VEX_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    @Override
    public boolean isCharging() {
        return this.getVexFlag(1);
    }

    @Override
    public void setIsCharging(boolean charging) {
        this.setVexFlag(1, charging);
    }

    @Override
    public void setLimitedLife(int limitedLifeTicksIn) {
        this.limitedLifespan = true;
        this.limitedLifeTicks = limitedLifeTicksIn;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12499_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12501_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12502_;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_213945_(pLevel.m_213780_(), pDifficulty);
        this.m_213946_(pLevel.m_213780_(), pDifficulty);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public static double getHorizontalDistanceSqr(Vec3 pVector) {
        return pVector.f_82479_ * pVector.f_82479_ + pVector.f_82481_ * pVector.f_82481_;
    }

    class OutofBoundsGoal
    extends Goal {
        public OutofBoundsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Irk.this.m_5830_() && !Irk.this.m_21566_().m_24995_();
        }

        public boolean m_8045_() {
            return Irk.this.m_5830_() && !Irk.this.m_21566_().m_24995_();
        }

        public void m_8037_() {
            BlockPos.MutableBlockPos blockpos$mutable = Irk.this.m_20183_().m_122032_();
            blockpos$mutable.m_142448_(Irk.this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)blockpos$mutable).m_123342_());
            Irk.this.m_21566_().m_6849_((double)blockpos$mutable.m_123341_(), (double)blockpos$mutable.m_123342_(), (double)blockpos$mutable.m_123343_(), 1.0);
        }
    }

    static class FollowOwnerGoal
    extends Goal {
        private final Irk summonedEntity;
        private LivingEntity owner;
        private final LevelReader level;
        private final double followSpeed;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float maxDist;
        private final float minDist;
        private float oldWaterCost;
        private final boolean teleportToLeaves;

        public FollowOwnerGoal(Irk summonedEntity, double speed, float minDist, float maxDist, boolean teleportToLeaves) {
            this.summonedEntity = summonedEntity;
            this.level = summonedEntity.f_19853_;
            this.followSpeed = speed;
            this.navigation = summonedEntity.m_21573_();
            this.minDist = minDist;
            this.maxDist = maxDist;
            this.teleportToLeaves = teleportToLeaves;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(summonedEntity.m_21573_() instanceof GroundPathNavigation) && !(summonedEntity.m_21573_() instanceof FlyingPathNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.summonedEntity.getTrueOwner();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            if (this.summonedEntity.m_20280_((Entity)livingentity) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            if (this.summonedEntity.m_5448_() != null) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean m_8045_() {
            if (this.summonedEntity.m_5448_() != null) {
                return false;
            }
            if (this.navigation.m_26571_()) {
                return false;
            }
            return !(this.summonedEntity.m_20280_((Entity)this.owner) <= (double)(this.maxDist * this.maxDist));
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.summonedEntity.m_21439_(BlockPathTypes.WATER);
            this.summonedEntity.m_21441_(BlockPathTypes.WATER, 0.0f);
        }

        public void m_8041_() {
            this.navigation.m_26573_();
            this.summonedEntity.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        }

        public void m_8037_() {
            this.summonedEntity.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.summonedEntity.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if ((double)this.summonedEntity.m_20270_((Entity)this.owner) > 8.0) {
                    double x = Mth.m_14107_((double)this.owner.m_20185_()) - 2;
                    double y = Mth.m_14107_((double)this.owner.m_20191_().f_82289_);
                    double z = Mth.m_14107_((double)this.owner.m_20189_()) - 2;
                    for (int l = 0; l <= 4; ++l) {
                        for (int i1 = 0; i1 <= 4; ++i1) {
                            if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.ValidPosition(BlockPos.m_274561_((double)(x + (double)l), (double)(y + 2.0), (double)(z + (double)i1)))) continue;
                            float a = (float)(x + (double)l + 0.5);
                            float b = (float)(z + (double)i1 + 0.5);
                            this.summonedEntity.m_21566_().m_6849_((double)a, y, (double)b, this.followSpeed);
                            this.navigation.m_26573_();
                        }
                    }
                }
                if (this.summonedEntity.m_20280_((Entity)this.owner) > 144.0 && ((Boolean)MobsConfig.VexTeleport.get()).booleanValue()) {
                    this.tryToTeleportNearEntity();
                }
            }
        }

        private void tryToTeleportNearEntity() {
            BlockPos blockpos = this.owner.m_20183_();
            for (int i = 0; i < 10; ++i) {
                int j = this.getRandomNumber(-3, 3);
                int k = this.getRandomNumber(-1, 1);
                int l = this.getRandomNumber(-3, 3);
                boolean flag = this.tryToTeleportToLocation(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
                if (!flag) continue;
                return;
            }
        }

        private boolean tryToTeleportToLocation(int x, int y, int z) {
            if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
                return false;
            }
            if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
                return false;
            }
            this.summonedEntity.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.summonedEntity.m_146908_(), this.summonedEntity.m_146909_());
            this.navigation.m_26573_();
            return true;
        }

        private boolean isTeleportFriendlyBlock(BlockPos pos) {
            BlockPathTypes pathnodetype = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
            if (pathnodetype != BlockPathTypes.WALKABLE) {
                return false;
            }
            BlockState blockstate = this.level.m_8055_(pos.m_7495_());
            if (!this.teleportToLeaves && blockstate.m_60734_() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockpos = pos.m_121996_((Vec3i)this.summonedEntity.m_20183_());
            return this.level.m_45756_((Entity)this.summonedEntity, this.summonedEntity.m_20191_().m_82338_(blockpos));
        }

        protected boolean ValidPosition(BlockPos pos) {
            BlockState blockstate = this.level.m_8055_(pos);
            return blockstate.m_60710_(this.level, pos) && this.level.m_46859_(pos.m_7494_()) && this.level.m_46859_(pos.m_6630_(2));
        }

        private int getRandomNumber(int min, int max) {
            return this.summonedEntity.m_217043_().m_188503_(max - min + 1) + min;
        }
    }

    class ChargeAttackGoal
    extends Goal {
        public ChargeAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (Irk.this.m_5448_() != null && !Irk.this.m_21566_().m_24995_()) {
                return !Irk.this.m_5448_().m_7307_((Entity)Irk.this);
            }
            return false;
        }

        public boolean m_8045_() {
            return Irk.this.m_21566_().m_24995_() && Irk.this.isCharging() && Irk.this.m_5448_() != null && Irk.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingentity = Irk.this.m_5448_();
            assert (livingentity != null);
            Vec3 vector3d = livingentity.m_20299_(1.0f);
            if (Irk.this.m_20270_((Entity)livingentity) > 4.0f) {
                Irk.this.m_21566_().m_6849_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 1.0);
            }
        }

        public void m_8041_() {
            Irk.this.setIsCharging(false);
        }

        public void m_8037_() {
            LivingEntity livingentity = Irk.this.m_5448_();
            if (livingentity != null) {
                if (Irk.this.shootTime == 10) {
                    double d1 = livingentity.m_20185_() - Irk.this.m_20185_();
                    double d2 = livingentity.m_20227_(0.5) - Irk.this.m_20227_(0.5);
                    double d3 = livingentity.m_20189_() - Irk.this.m_20189_();
                    SoulBullet smallFireballEntity = new SoulBullet(Irk.this.f_19853_, (LivingEntity)Irk.this, d1, d2, d3);
                    smallFireballEntity.m_6034_(smallFireballEntity.m_20185_(), Irk.this.m_20227_(0.5), smallFireballEntity.m_20189_());
                    Irk.this.f_19853_.m_7967_((Entity)smallFireballEntity);
                    Irk.this.m_5496_(SoundEvents.f_12500_, 1.0f, 2.0f);
                }
                Irk.this.setIsCharging(Irk.this.shootTime <= 10);
                if (Irk.this.shootTime == 0) {
                    Irk.this.shootTime = 20;
                } else {
                    Vec3 vector3d0 = livingentity.m_20299_(1.0f);
                    Vec3 vector3d = Irk.this.m_20184_().m_82542_(1.0, 0.6, 1.0);
                    double d0 = vector3d.f_82480_;
                    if (Irk.this.m_20186_() < vector3d0.f_82480_) {
                        d0 = Math.max(0.0, d0);
                        d0 += 0.3 - d0 * (double)0.6f;
                    }
                    vector3d = new Vec3(vector3d.f_82479_, d0, vector3d.f_82481_);
                    Vec3 vector3d1 = new Vec3(vector3d0.f_82479_ - Irk.this.m_20185_(), 0.0, vector3d0.f_82481_ - Irk.this.m_20189_());
                    if (Irk.getHorizontalDistanceSqr(vector3d1) > 9.0) {
                        Vec3 vector3d2 = vector3d1.m_82541_();
                        vector3d = vector3d.m_82520_(vector3d2.f_82479_ * 0.3 - vector3d.f_82479_ * 0.6, 0.0, vector3d2.f_82481_ * 0.3 - vector3d.f_82481_ * 0.6);
                    }
                    Irk.this.m_20256_(vector3d);
                }
                double d2 = Irk.this.m_5448_().m_20185_() - Irk.this.m_20185_();
                double d1 = Irk.this.m_5448_().m_20189_() - Irk.this.m_20189_();
                Irk.this.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                Irk.this.f_20883_ = Irk.this.m_146908_();
            } else {
                Irk.this.setIsCharging(false);
            }
        }
    }

    class MoveRandomGoal
    extends Goal {
        public MoveRandomGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !Irk.this.m_21566_().m_24995_() && Irk.this.f_19796_.m_188503_(7) == 0 && !Irk.this.isCharging();
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = Irk.this.m_20183_();
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(Irk.this.f_19796_.m_188503_(8) - 4, Irk.this.f_19796_.m_188503_(6) - 2, Irk.this.f_19796_.m_188503_(8) - 4);
                if (!Irk.this.f_19853_.m_46859_(blockpos1)) continue;
                Irk.this.f_21342_.m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                if (Irk.this.m_5448_() != null) break;
                Irk.this.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

