/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.AbstractSkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.SkeletonServant;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieServant;
import com.Polarice3.Goety.common.entities.neutral.AbstractNecromancer;
import com.Polarice3.Goety.common.entities.projectiles.IceSpike;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.world.structures.ModStructures;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;

public class CairnNecromancer
extends AbstractNecromancer
implements Enemy {
    public CairnNecromancer(EntityType<? extends AbstractNecromancer> type, Level level) {
        super((EntityType<? extends AbstractSkeletonServant>)type, level);
        this.setHostile(true);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(4, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    @Override
    public void projectileGoal(int priority) {
        this.f_21345_.m_25352_(priority, (Goal)new AbstractNecromancer.NecromancerRangedGoal(this, 1.0, 20, 10.0f));
    }

    @Override
    public void summonSpells(int priority) {
        this.f_21345_.m_25352_(priority, (Goal)new SummonServantSpell());
    }

    public float m_6100_() {
        return 0.75f;
    }

    @Override
    public void m_6504_(@NotNull LivingEntity p_33317_, float p_33318_) {
        IceSpike iceSpike = new IceSpike((LivingEntity)this, this.f_19853_);
        double d0 = p_33317_.m_20185_() - this.m_20185_();
        double d1 = p_33317_.m_20227_(0.3333333333333333) - iceSpike.m_20186_();
        double d2 = p_33317_.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        iceSpike.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 1.0f);
        if (this.f_19853_.m_7967_((Entity)iceSpike)) {
            this.m_216990_((SoundEvent)ModSounds.CAST_SPELL.get());
            this.m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    @Override
    public Summoned getDefaultSummon() {
        return new SkeletonServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.SKELETON_SERVANT.get()), this.f_19853_);
    }

    public class SummonServantSpell
    extends AbstractNecromancer.SummoningSpellGoal {
        public SummonServantSpell() {
            super(CairnNecromancer.this);
        }

        @Override
        public boolean m_8036_() {
            Predicate<Entity> predicate = entity -> {
                IOwned owned;
                return entity.m_6084_() && entity instanceof IOwned && (owned = (IOwned)entity).getTrueOwner() instanceof AbstractNecromancer;
            };
            int i = CairnNecromancer.this.f_19853_.m_6443_(LivingEntity.class, CairnNecromancer.this.m_20191_().m_82377_(64.0, 16.0, 64.0), predicate).size();
            return super.m_8036_() && i < 2;
        }

        @Override
        protected void castSpell() {
            Level level = CairnNecromancer.this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i1 = 0; i1 < 1 + serverLevel.f_46441_.m_188503_(3); ++i1) {
                    Summoned summonedentity = new SkeletonServant((EntityType<? extends AbstractSkeletonServant>)((EntityType)ModEntityType.SKELETON_SERVANT.get()), (Level)serverLevel);
                    if (CairnNecromancer.this.getSummonList().contains(ModEntityType.ZOMBIE_SERVANT.get()) && serverLevel.f_46441_.m_188499_()) {
                        summonedentity = new ZombieServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.ZOMBIE_SERVANT.get()), (Level)serverLevel);
                    }
                    BlockPos blockPos = BlockFinder.SummonRadius((LivingEntity)CairnNecromancer.this, (Level)serverLevel);
                    summonedentity.setTrueOwner((LivingEntity)CairnNecromancer.this);
                    summonedentity.m_20035_(blockPos, 0.0f, 0.0f);
                    MobUtil.moveDownToGround((Entity)summonedentity);
                    summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)serverLevel));
                    summonedentity.m_21530_();
                    summonedentity.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(CairnNecromancer.this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    if (BlockFinder.findStructure(serverLevel, (LivingEntity)CairnNecromancer.this, ModStructures.CRYPT_KEY)) {
                        for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
                            Item item;
                            ItemStack itemstack;
                            if (equipmentslottype.m_20743_() == EquipmentSlot.Type.ARMOR && (itemstack = summonedentity.m_6844_(equipmentslottype)).m_41619_() && (item = this.cursedKnightArmor(equipmentslottype)) != null && serverLevel.f_46441_.m_188501_() <= 0.25f) {
                                summonedentity.m_8061_(equipmentslottype, new ItemStack((ItemLike)item));
                            }
                            summonedentity.m_21409_(equipmentslottype, 0.0f);
                        }
                        summonedentity.m_21008_(InteractionHand.MAIN_HAND, Items.f_42383_.m_7968_());
                        summonedentity.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
                    }
                    if (!serverLevel.m_7967_((Entity)summonedentity)) continue;
                    summonedentity.m_5496_((SoundEvent)ModSounds.SUMMON_SPELL.get(), 1.0f, 1.0f);
                    for (int i = 0; i < serverLevel.f_46441_.m_188503_(35) + 10; ++i) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, summonedentity.m_20185_(), summonedentity.m_20188_(), summonedentity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }

        @Nullable
        public Item cursedKnightArmor(EquipmentSlot pSlot) {
            return switch (pSlot) {
                case EquipmentSlot.HEAD -> Items.f_42464_;
                case EquipmentSlot.CHEST -> (Item)ModItems.CURSED_KNIGHT_CHESTPLATE.get();
                case EquipmentSlot.LEGS -> Items.f_42466_;
                case EquipmentSlot.FEET -> (Item)ModItems.CURSED_KNIGHT_BOOTS.get();
                default -> null;
            };
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.PREPARE_SUMMON.get();
        }

        @Override
        protected AbstractNecromancer.NecromancerSpellType getNecromancerSpellType() {
            return AbstractNecromancer.NecromancerSpellType.ZOMBIE;
        }
    }
}

