/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.boss;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.MobsConfig;
import com.Polarice3.Goety.api.entities.ICustomAttributes;
import com.Polarice3.Goety.api.entities.hostile.IBoss;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.hostile.Irk;
import com.Polarice3.Goety.common.entities.projectiles.Spike;
import com.Polarice3.Goety.common.entities.projectiles.SwordProjectile;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SAddBossPacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;

@OnlyIn(value=Dist.CLIENT, _interface=PowerableMob.class)
public class Vizier
extends SpellcasterIllager
implements PowerableMob,
ICustomAttributes,
IBoss {
    private static final Predicate<Entity> field_213690_b = p_213685_0_ -> p_213685_0_.m_6084_() && !(p_213685_0_ instanceof Vizier);
    protected static final EntityDataAccessor<Byte> VIZIER_FLAGS = SynchedEntityData.m_135353_(Vizier.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Integer> CAST_TIMES = SynchedEntityData.m_135353_(Vizier.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> CASTING = SynchedEntityData.m_135353_(Vizier.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CONFUSED = SynchedEntityData.m_135353_(Vizier.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(Vizier.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS);
    private UUID bossInfoUUID = this.bossInfo.m_18860_();
    public float oBob;
    public float bob;
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;
    public boolean flyWarn;
    public int airBound;
    public int deathTime = 0;
    public AnimationState introAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();

    public Vizier(EntityType<? extends Vizier> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MobUtil.MinionMoveControl((Mob)this);
        this.f_21364_ = 50;
        if (this.f_19853_.f_46443_) {
            Goety.PROXY.addBoss((Mob)this);
        }
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        super.m_6478_(typeIn, pos);
        this.m_20101_();
    }

    public void m_8119_() {
        double d0;
        if (this.getInvulnerableTicks() > 0) {
            double d2;
            double d1;
            int i;
            this.setAnimationState("intro");
            this.m_20256_(Vec3.f_82478_);
            int j1 = this.getInvulnerableTicks() - 1;
            if (j1 == 30) {
                for (i = 0; i < 5; ++i) {
                    d0 = this.f_19796_.m_188583_() * 0.02;
                    d1 = this.f_19796_.m_188583_() * 0.02;
                    d2 = this.f_19796_.m_188583_() * 0.02;
                    this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.CONFUSED.get(), this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
                }
                this.m_5496_((SoundEvent)ModSounds.VIZIER_CONFUSE.get(), 1.0f, 1.0f);
            }
            if (j1 == 10) {
                for (i = 0; i < 5; ++i) {
                    d0 = this.f_19796_.m_188583_() * 0.02;
                    d1 = this.f_19796_.m_188583_() * 0.02;
                    d2 = this.f_19796_.m_188583_() * 0.02;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
                }
                this.m_5496_((SoundEvent)ModSounds.VIZIER_RAGE.get(), 1.0f, 1.0f);
            }
            this.setInvulnerableTicks(j1);
        } else if (!this.m_21224_()) {
            this.setAnimationState(0);
        }
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
        this.oBob = this.bob;
        float f = Math.min(0.1f, Mth.m_14116_((float)((float)Vizier.getHorizontalDistanceSqr(this.m_20184_()))));
        this.bob += (f - this.bob) * 0.4f;
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (!this.isSpellcasting()) {
            this.setCasting(this.getCasting() + 1);
        } else if (this.getCastTimes() == 3) {
            this.m_20256_(Vec3.f_82478_);
        } else {
            Vec3 vector3d = this.m_20184_().m_82542_(1.0, 0.6, 1.0);
            if (!this.f_19853_.f_46443_ && this.m_5448_() != null) {
                d0 = vector3d.f_82480_;
                if (this.m_20186_() < this.m_5448_().m_20186_() + 3.0) {
                    d0 = Math.max(0.0, d0);
                    d0 += 0.3 - d0 * (double)0.6f;
                }
                vector3d = new Vec3(vector3d.f_82479_, d0, vector3d.f_82481_);
                Vec3 vector3d1 = new Vec3(this.m_5448_().m_20185_() - this.m_20185_(), 0.0, this.m_5448_().m_20189_() - this.m_20189_());
                if (Vizier.getHorizontalDistanceSqr(vector3d1) > 9.0) {
                    Vec3 vector3d2 = vector3d1.m_82541_();
                    vector3d = vector3d.m_82520_(vector3d2.f_82479_ * 0.3 - vector3d.f_82479_ * 0.6, 0.0, vector3d2.f_82481_ * 0.3 - vector3d.f_82481_ * 0.6);
                }
            }
            this.m_20256_(vector3d);
            if (Vizier.getHorizontalDistanceSqr(vector3d) > 0.05) {
                this.m_146922_((float)Mth.m_14136_((double)vector3d.f_82481_, (double)vector3d.f_82479_) * 57.295776f - 90.0f);
            }
        }
        if (this.getCasting() >= 300) {
            this.setCasting(0);
        }
        int i = this.f_19853_.m_45976_(Irk.class, this.m_20191_().m_82400_(64.0)).size();
        if (((Boolean)MobsConfig.VizierMinion.get()).booleanValue()) {
            i = this.f_19853_.m_45976_(Vex.class, this.m_20191_().m_82400_(64.0)).size();
        }
        if (this.getCastTimes() == 1) {
            if (i >= 2) {
                if (this.f_19853_.f_46441_.m_188499_()) {
                    this.setCastTimes(2);
                } else {
                    this.setCastTimes(3);
                }
            } else {
                this.setCastTimes(3);
            }
        }
        this.moveCloak();
        if (this.m_5448_() == null) {
            for (LivingEntity livingEntity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(32.0), EntitySelector.f_20406_)) {
                if (!(livingEntity instanceof Player) && !(livingEntity instanceof AbstractVillager) && !(livingEntity instanceof IronGolem) || !this.m_6779_(livingEntity)) continue;
                this.m_6710_(livingEntity);
            }
        } else {
            this.airBound = !this.m_5448_().m_20096_() ? ++this.airBound : 0;
        }
    }

    public static double getHorizontalDistanceSqr(Vec3 pVector) {
        return pVector.f_82479_ * pVector.f_82479_ + pVector.f_82481_ * pVector.f_82481_;
    }

    private void moveCloak() {
        this.xCloakO = this.xCloak;
        this.yCloakO = this.yCloak;
        this.zCloakO = this.zCloak;
        double d0 = this.m_20185_() - this.xCloak;
        double d1 = this.m_20186_() - this.yCloak;
        double d2 = this.m_20189_() - this.zCloak;
        double d3 = 10.0;
        if (d0 > d3) {
            this.xCloakO = this.xCloak = this.m_20185_();
        }
        if (d2 > d3) {
            this.zCloakO = this.zCloak = this.m_20189_();
        }
        if (d1 > d3) {
            this.yCloakO = this.yCloak = this.m_20186_();
        }
        if (d0 < -d3) {
            this.xCloakO = this.xCloak = this.m_20185_();
        }
        if (d2 < -d3) {
            this.zCloakO = this.zCloak = this.m_20189_();
        }
        if (d1 < -d3) {
            this.yCloakO = this.yCloak = this.m_20186_();
        }
        this.xCloak += d0 * 0.25;
        this.zCloak += d2 * 0.25;
        this.yCloak += d1 * 0.25;
    }

    protected SoundEvent m_7894_() {
        return SoundEvents.f_11862_;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new DoNothingGoal());
        this.f_21345_.m_25352_(1, (Goal)new FangsSpellGoal());
        this.f_21345_.m_25352_(1, (Goal)new HealGoal());
        this.f_21345_.m_25352_(1, (Goal)new SpikesGoal());
        this.f_21345_.m_25352_(1, (Goal)new MoveRandomGoal());
        this.f_21345_.m_25352_(4, (Goal)new ChargeAttackGoal());
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.VizierHealth.get()).doubleValue()).m_22268_(Attributes.f_22281_, 5.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.VizierHealth.get());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VIZIER_FLAGS, (Object)0);
        this.f_19804_.m_135372_(CAST_TIMES, (Object)0);
        this.f_19804_.m_135372_(CASTING, (Object)0);
        this.f_19804_.m_135372_(CONFUSED, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "intro")) {
            return 1;
        }
        if (Objects.equals(animation, "death")) {
            return 2;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.introAnimationState);
        list.add(this.deathAnimationState);
        return list;
    }

    public void stopAnimations() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAnimations();
                    break;
                }
                case 1: {
                    this.introAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.introAnimationState);
                    break;
                }
                case 2: {
                    this.deathAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deathAnimationState);
                }
            }
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.VIZIER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.VIZIER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.VIZIER_HURT.get();
    }

    public int getInvulnerableTicks() {
        return (Integer)this.f_19804_.m_135370_(CONFUSED);
    }

    public void setInvulnerableTicks(int pTime) {
        this.f_19804_.m_135381_(CONFUSED, (Object)pTime);
    }

    public int getCastTimes() {
        return (Integer)this.f_19804_.m_135370_(CAST_TIMES);
    }

    public void setCastTimes(int pTime) {
        this.f_19804_.m_135381_(CAST_TIMES, (Object)pTime);
    }

    public int getCasting() {
        return (Integer)this.f_19804_.m_135370_(CASTING);
    }

    public void setCasting(int pTime) {
        this.f_19804_.m_135381_(CASTING, (Object)pTime);
    }

    public void makeInvulnerable() {
        this.setInvulnerableTicks(40);
    }

    public boolean m_7490_() {
        return false;
    }

    public void m_6667_(DamageSource cause) {
        Irk ally2;
        this.m_5496_((SoundEvent)ModSounds.VIZIER_SCREAM.get(), 4.0f, 1.0f);
        if (!((Boolean)MobsConfig.VizierMinion.get()).booleanValue()) {
            for (Irk ally2 : this.f_19853_.m_6443_(Irk.class, this.m_20191_().m_82400_(64.0), field_213690_b)) {
                ally2.m_6469_(ally2.m_269291_().m_269064_(), 200.0f);
            }
        } else {
            for (Irk ally2 : this.f_19853_.m_6443_(Vex.class, this.m_20191_().m_82400_(64.0), field_213690_b)) {
                ally2.m_6469_(ally2.m_269291_().m_269064_(), 200.0f);
            }
        }
        if (cause.m_7639_() != null && (ally2 = cause.m_7639_()) instanceof Player) {
            Player player = (Player)ally2;
            MobEffectInstance effectinstance = new MobEffectInstance(MobEffects.f_19594_, 120000, 4, false, false, true);
            if (!this.f_19853_.m_46469_().m_46207_(GameRules.f_46154_)) {
                player.m_7292_(effectinstance);
            }
        }
        super.m_6667_(cause);
    }

    protected void m_6153_() {
        double d2;
        double d1;
        double d0;
        int p;
        ServerLevel serverWorld;
        ++this.deathTime;
        if (this.deathTime > 0) {
            this.setAnimationState("death");
            if (!this.f_19853_.f_46443_) {
                serverWorld = (ServerLevel)this.f_19853_;
                for (p = 0; p < 8; ++p) {
                    d0 = this.m_20185_() + this.f_19853_.f_46441_.m_188500_();
                    d1 = this.m_20186_() + this.f_19853_.f_46441_.m_188500_();
                    d2 = this.m_20189_() + this.f_19853_.f_46441_.m_188500_();
                    serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BULLET_EFFECT.get()), d0, d1, d2, 0, 0.45, 0.45, 0.45, 0.5);
                }
            }
        }
        if (this.deathTime == 40) {
            this.m_5496_(SoundEvents.f_11913_, 2.0f, (1.0f + (this.f_19853_.f_46441_.m_188501_() - this.f_19853_.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            if (!this.f_19853_.f_46443_) {
                serverWorld = (ServerLevel)this.f_19853_;
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                for (p = 0; p < 32; ++p) {
                    d0 = this.m_20185_() + this.f_19853_.f_46441_.m_188500_();
                    d1 = this.m_20186_() + this.f_19853_.f_46441_.m_188500_();
                    d2 = this.m_20189_() + this.f_19853_.f_46441_.m_188500_();
                    this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.BULLET_EFFECT.get(), d0, d1, d2, 0.45, 0.45, 0.45);
                    serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BULLET_EFFECT.get()), d0, d1, d2, 0, 0.45, 0.45, 0.45, 0.5);
                }
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected boolean m_8028_() {
        return false;
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        if (this.f_19853_.f_46443_) {
            Goety.PROXY.removeBoss((Mob)this);
        }
        super.m_142687_(removalReason);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        LivingEntity livingEntity = this.m_5448_();
        if (this.getInvulnerableTicks() > 0 && !pSource.m_276093_(DamageTypes.f_268724_)) {
            return false;
        }
        if (livingEntity != null) {
            if (pSource.m_7639_() instanceof Irk) {
                return false;
            }
            if (!((Boolean)MobsConfig.VizierMinion.get()).booleanValue()) {
                int irks = this.f_19853_.m_45976_(Irk.class, this.m_20191_().m_82400_(32.0)).size();
                if ((this.f_19853_.f_46441_.m_188499_() || this.m_21223_() < this.m_21233_() / 2.0f) && irks < 16) {
                    Irk irk = new Irk((EntityType<? extends Irk>)((EntityType)ModEntityType.IRK.get()), this.f_19853_);
                    irk.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    irk.setLimitedLife(MobUtil.getSummonLifespan(this.f_19853_));
                    irk.setTrueOwner((LivingEntity)this);
                    this.f_19853_.m_7967_((Entity)irk);
                }
            } else {
                int vexes = this.f_19853_.m_45976_(Vex.class, this.m_20191_().m_82400_(32.0)).size();
                if ((this.f_19853_.f_46441_.m_188499_() || this.m_21223_() < this.m_21233_() / 2.0f) && vexes < 16 && !this.f_19853_.f_46443_) {
                    Vex irk = new Vex(EntityType.f_20491_, this.f_19853_);
                    irk.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    irk.m_33987_(MobUtil.getSummonLifespan(this.f_19853_));
                    irk.m_33994_((Mob)this);
                    irk.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    this.f_19853_.m_7967_((Entity)irk);
                }
            }
        }
        if (pAmount > (float)((Integer)AttributesConfig.VizierDamageCap.get()).intValue() && !pSource.m_276093_(DamageTypes.f_268724_)) {
            return super.m_6469_(pSource, (float)((Integer)AttributesConfig.VizierDamageCap.get()).intValue());
        }
        if (this.isSpellcasting() && !pSource.m_276093_(DamageTypes.f_268724_)) {
            return super.m_6469_(pSource, pAmount / 2.0f);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6074_() {
        this.m_21153_(0.0f);
    }

    public boolean m_7307_(Entity pEntity) {
        if (pEntity == this) {
            return true;
        }
        if (super.m_7307_(pEntity)) {
            return true;
        }
        if (pEntity instanceof Irk) {
            return this.m_7307_((Entity)((Irk)pEntity).getTrueOwner());
        }
        if (pEntity instanceof LivingEntity && ((LivingEntity)pEntity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && pEntity.m_5647_() == null;
        }
        return false;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Confused", this.getInvulnerableTicks());
        compound.m_128405_("Casting", this.getCasting());
        compound.m_128405_("CastTimes", this.getCastTimes());
        compound.m_128379_("FlyWarn", this.flyWarn);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setInvulnerableTicks(compound.m_128451_("Confused"));
        this.setCasting(compound.m_128451_("Casting"));
        this.setCastTimes(compound.m_128451_("CastTimes"));
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.flyWarn = compound.m_128471_("FlyWarn");
        this.setConfigurableAttributes();
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_8321_(this.getInvulnerableTicks() <= 0);
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossInfo.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossInfo.m_6539_(pPlayer);
    }

    private boolean getVizierFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(VIZIER_FLAGS);
        return (i & mask) != 0;
    }

    private void setVizierFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(VIZIER_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(VIZIER_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getVizierFlag(1);
    }

    public void setCharging(boolean charging) {
        this.setVizierFlag(1, charging);
    }

    public boolean isSpellcasting() {
        return this.getVizierFlag(2);
    }

    public void setSpellcasting(boolean spellcasting) {
        this.setVizierFlag(2, spellcasting);
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.isCharging()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        if (this.isSpellcasting()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
        this.m_213945_(p_37856_.m_213780_(), p_37857_);
        this.m_213946_(p_37856_.m_213780_(), p_37857_);
        return super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        ItemEntity itementity = this.m_19998_((ItemLike)ModItems.SOUL_RUBY.get());
        if (itementity != null) {
            itementity.m_32064_();
        }
    }

    public void m_7895_(int wave, boolean p_213660_2_) {
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.VIZIER_CELEBRATE.get();
    }

    public boolean m_7090_() {
        return this.isSpellcasting();
    }

    @Override
    public UUID getBossInfoUUID() {
        return this.bossInfoUUID;
    }

    @Override
    public void setBossInfoUUID(UUID bossInfoUUID) {
        this.bossInfoUUID = bossInfoUUID;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return ModNetwork.INSTANCE.toVanillaPacket((Object)new SAddBossPacket(new ClientboundAddEntityPacket((Entity)this), this.bossInfoUUID), NetworkDirection.PLAY_TO_CLIENT);
    }

    public boolean m_6072_() {
        return false;
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return Vizier.this.getInvulnerableTicks() > 0;
        }
    }

    class FangsSpellGoal
    extends Goal {
        int duration;
        int duration2;

        private FangsSpellGoal() {
        }

        public boolean m_8036_() {
            return Vizier.this.getCasting() >= 200 && Vizier.this.m_5448_() != null && !Vizier.this.isCharging() && Vizier.this.getCastTimes() == 0;
        }

        public void m_8056_() {
            Vizier.this.m_5496_(SoundEvents.f_11867_, 1.0f, 1.0f);
            Vizier.this.setSpellcasting(true);
            Vizier.this.airBound = 0;
        }

        public void m_8041_() {
            Vizier.this.setSpellcasting(false);
            Vizier.this.setCasting(0);
            Vizier.this.setCastTimes(1);
            this.duration2 = 0;
            this.duration = 0;
        }

        public void m_8037_() {
            LivingEntity livingentity = Vizier.this.m_5448_();
            if (livingentity != null) {
                ++this.duration;
                ++this.duration2;
                if (Vizier.this.airBound > 20 && !Vizier.this.f_19853_.f_46443_) {
                    ServerLevel serverWorld = (ServerLevel)Vizier.this.f_19853_;
                    for (int i = 0; i < 5; ++i) {
                        double d0 = serverWorld.f_46441_.m_188583_() * 0.02;
                        double d1 = serverWorld.f_46441_.m_188583_() * 0.02;
                        double d2 = serverWorld.f_46441_.m_188583_() * 0.02;
                        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123809_, Vizier.this.m_20208_(1.0), Vizier.this.m_20187_() + 1.0, Vizier.this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                int time = Vizier.this.m_21223_() <= Vizier.this.m_21233_() / 2.0f ? 5 : 10;
                int n = time = Vizier.this.airBound > 20 ? time * 2 : time;
                if (this.duration >= time) {
                    this.duration = 0;
                    if (Vizier.this.airBound > 20 && !Vizier.this.flyWarn) {
                        Vizier.this.m_5496_((SoundEvent)ModSounds.VIZIER_CELEBRATE.get(), 1.0f, 1.5f);
                        Vizier.this.flyWarn = true;
                    } else {
                        this.attack(livingentity);
                    }
                }
                if (this.duration2 >= 160) {
                    Vizier.this.setSpellcasting(false);
                    Vizier.this.setCasting(0);
                    Vizier.this.setCastTimes(1);
                    this.duration2 = 0;
                    this.duration = 0;
                }
            } else {
                this.m_8041_();
            }
        }

        private void attack(LivingEntity livingEntity) {
            if (Vizier.this.airBound < 20) {
                float f = (float)Mth.m_14136_((double)(livingEntity.m_20189_() - Vizier.this.m_20189_()), (double)(livingEntity.m_20185_() - Vizier.this.m_20185_()));
                this.spawnFangs(livingEntity.m_20185_(), livingEntity.m_20189_(), livingEntity.m_20186_(), livingEntity.m_20186_() + 1.0, f, 1);
            } else {
                SwordProjectile swordProjectile = new SwordProjectile((LivingEntity)Vizier.this, Vizier.this.f_19853_, Vizier.this.m_21205_());
                double d0 = livingEntity.m_20185_() - Vizier.this.m_20185_();
                double d1 = livingEntity.m_20227_(0.3333333333333333) - swordProjectile.m_20186_();
                double d2 = livingEntity.m_20189_() - Vizier.this.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
                swordProjectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                swordProjectile.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 1.0f);
                if (!Vizier.this.m_21574_().m_148306_((Entity)livingEntity)) {
                    swordProjectile.m_36790_(true);
                }
                Vizier.this.f_19853_.m_7967_((Entity)swordProjectile);
                if (!Vizier.this.m_20067_()) {
                    Vizier.this.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f);
                }
            }
        }

        private void spawnFangs(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = BlockPos.m_274561_((double)p_190876_1_, (double)p_190876_7_, (double)p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = Vizier.this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)Vizier.this.f_19853_, blockpos1, Direction.UP)) continue;
                if (!Vizier.this.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = Vizier.this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)Vizier.this.f_19853_, blockpos)).m_83281_()) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_190876_5_) - 1);
            if (flag) {
                Vizier.this.f_19853_.m_7967_((Entity)new EvokerFangs(Vizier.this.f_19853_, p_190876_1_, (double)blockpos.m_123342_() + d0, p_190876_3_, p_190876_9_, p_190876_10_, (LivingEntity)Vizier.this));
            }
        }
    }

    class HealGoal
    extends Goal {
        int duration3;

        private HealGoal() {
        }

        public boolean m_8036_() {
            return Vizier.this.m_5448_() != null && !Vizier.this.isCharging() && Vizier.this.getCasting() >= 100 && Vizier.this.getCastTimes() == 2;
        }

        public void m_8056_() {
            int i = 0;
            for (Mob ally : Vizier.this.f_19853_.m_6443_(Mob.class, Vizier.this.m_20191_().m_82400_(64.0), field_213690_b)) {
                if (!(ally instanceof Vex) && !(ally instanceof Irk)) continue;
                ++i;
            }
            if (i >= 2) {
                Vizier.this.m_5496_(SoundEvents.f_11868_, 1.0f, 1.0f);
                Vizier.this.m_5496_((SoundEvent)ModSounds.VIZIER_CELEBRATE.get(), 1.0f, 1.0f);
                Vizier.this.setSpellcasting(true);
            } else {
                Vizier.this.setCastTimes(0);
                Vizier.this.setCasting(0);
                this.duration3 = 0;
            }
        }

        public void m_8041_() {
            Vizier.this.setSpellcasting(false);
            Vizier.this.setCastTimes(0);
            Vizier.this.setCasting(0);
            this.duration3 = 0;
        }

        public void m_8037_() {
            int i = 0;
            ++this.duration3;
            if (this.duration3 >= 60) {
                for (Mob ally : Vizier.this.f_19853_.m_6443_(Mob.class, Vizier.this.m_20191_().m_82400_(64.0), field_213690_b)) {
                    if (!(ally instanceof Vex) && !(ally instanceof Irk)) continue;
                    Vizier.this.m_5634_(ally.m_21223_());
                    ++i;
                    ally.m_6469_(ally.m_269291_().m_269064_(), 200.0f);
                }
                if (i != 0) {
                    Vizier.this.m_5496_(SoundEvents.f_12513_, 1.0f, 1.0f);
                }
                this.duration3 = 0;
                Vizier.this.setSpellcasting(false);
                Vizier.this.setCastTimes(0);
                Vizier.this.setCasting(0);
            }
        }
    }

    class SpikesGoal
    extends Goal {
        int duration;

        SpikesGoal() {
        }

        public boolean m_8036_() {
            return Vizier.this.m_5448_() != null && !Vizier.this.isCharging() && Vizier.this.getCasting() >= 100 && Vizier.this.getCastTimes() == 3;
        }

        public void m_8056_() {
            Vizier.this.m_5496_(SoundEvents.f_11868_, 1.0f, 0.5f);
            Vizier.this.setSpellcasting(true);
        }

        public void m_8041_() {
            Vizier.this.setSpellcasting(false);
            Vizier.this.setCastTimes(0);
            Vizier.this.setCasting(0);
            this.duration = 0;
        }

        public void m_8037_() {
            if (!Vizier.this.f_19853_.f_46443_) {
                LivingEntity livingentity = Vizier.this.m_5448_();
                if (livingentity != null) {
                    double d2;
                    Vizier.this.m_21563_().m_24960_((Entity)livingentity, (float)Vizier.this.m_8132_(), (float)Vizier.this.m_8085_());
                    double d0 = Math.min(livingentity.m_20186_(), Vizier.this.m_20186_());
                    double d1 = Math.max(livingentity.m_20186_(), Vizier.this.m_20186_()) + 1.0;
                    float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - Vizier.this.m_20189_()), (double)(livingentity.m_20185_() - Vizier.this.m_20185_()));
                    ++this.duration;
                    if (Vizier.this.airBound > 20 && !Vizier.this.f_19853_.f_46443_) {
                        ServerLevel serverWorld = (ServerLevel)Vizier.this.f_19853_;
                        for (int i = 0; i < 5; ++i) {
                            double d3 = serverWorld.f_46441_.m_188583_() * 0.02;
                            double d4 = serverWorld.f_46441_.m_188583_() * 0.02;
                            d2 = serverWorld.f_46441_.m_188583_() * 0.02;
                            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123809_, Vizier.this.m_20208_(1.0), Vizier.this.m_20187_() + 1.0, Vizier.this.m_20262_(1.0), 0, d3, d4, d2, 0.5);
                        }
                    }
                    if (this.duration >= 40) {
                        if (Vizier.this.airBound < 20) {
                            for (int l = 0; l < 16; ++l) {
                                double d22 = 1.25 * (double)(l + 1);
                                this.createSpellEntity(Vizier.this.m_20185_() + (double)Mth.m_14089_((float)f) * d22, Vizier.this.m_20189_() + (double)Mth.m_14031_((float)f) * d22, d0, d1, f, l * 2);
                            }
                        } else {
                            for (int j = 0; j < 3; ++j) {
                                SwordProjectile swordProjectile = new SwordProjectile((LivingEntity)Vizier.this, Vizier.this.f_19853_, Vizier.this.m_21205_());
                                double d4 = livingentity.m_20185_() - Vizier.this.m_20185_();
                                double d5 = livingentity.m_20227_(0.3333333333333333) - swordProjectile.m_20186_();
                                d2 = livingentity.m_20189_() - Vizier.this.m_20189_();
                                double d3 = Mth.m_14116_((float)((float)(d4 * d4 + d2 * d2)));
                                swordProjectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                                swordProjectile.m_6686_(d4 + Vizier.this.f_19796_.m_188583_(), d5 + d3 * (double)0.2f, d2 + Vizier.this.f_19796_.m_188583_(), 1.6f, 0.6f);
                                if (!Vizier.this.m_21574_().m_148306_((Entity)livingentity)) {
                                    swordProjectile.m_36790_(true);
                                }
                                Vizier.this.f_19853_.m_7967_((Entity)swordProjectile);
                            }
                            if (!Vizier.this.m_20067_()) {
                                Vizier.this.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f);
                            }
                        }
                        this.duration = 0;
                        Vizier.this.setSpellcasting(false);
                        Vizier.this.setCastTimes(0);
                        Vizier.this.setCasting(0);
                        Vizier.this.m_5496_(SoundEvents.f_11862_, 1.0f, 0.5f);
                    }
                } else {
                    this.m_8041_();
                }
            }
        }

        private void createSpellEntity(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = BlockPos.m_274561_((double)p_190876_1_, (double)p_190876_7_, (double)p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = Vizier.this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)Vizier.this.f_19853_, blockpos1, Direction.UP)) continue;
                if (!Vizier.this.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = Vizier.this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)Vizier.this.f_19853_, blockpos)).m_83281_()) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_190876_5_) - 1);
            if (flag) {
                Spike spikeEntity = new Spike(Vizier.this.f_19853_, p_190876_1_, (double)blockpos.m_123342_() + d0, p_190876_3_, p_190876_9_, p_190876_10_, (LivingEntity)Vizier.this);
                Vizier.this.f_19853_.m_7967_((Entity)spikeEntity);
            }
        }
    }

    class MoveRandomGoal
    extends Goal {
        public MoveRandomGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !Vizier.this.m_21566_().m_24995_() && Vizier.this.f_19796_.m_188503_(7) == 0 && !Vizier.this.isCharging() && Vizier.this.m_5448_() == null;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = Vizier.this.m_20183_();
            if (Vizier.this.m_5448_() != null) {
                blockpos = Vizier.this.m_5448_().m_20183_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(Vizier.this.f_19796_.m_188503_(8) - 4, Vizier.this.f_19796_.m_188503_(6) - 2, Vizier.this.f_19796_.m_188503_(8) - 4);
                if (!Vizier.this.f_19853_.m_46859_(blockpos1)) continue;
                Vizier.this.f_21342_.m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                if (Vizier.this.m_5448_() != null) break;
                Vizier.this.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class ChargeAttackGoal
    extends Goal {
        public ChargeAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (Vizier.this.m_5448_() != null && !Vizier.this.m_21566_().m_24995_() && !Vizier.this.isSpellcasting() && Vizier.this.f_19796_.m_188503_(7) == 0) {
                return Vizier.this.m_20280_((Entity)Vizier.this.m_5448_()) > 4.0;
            }
            return false;
        }

        public boolean m_8045_() {
            return Vizier.this.m_21566_().m_24995_() && Vizier.this.isCharging() && !Vizier.this.isSpellcasting() && Vizier.this.m_5448_() != null && Vizier.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingentity = Vizier.this.m_5448_();
            if (livingentity != null) {
                Vec3 vector3d = livingentity.m_20182_();
                Vizier.this.f_21342_.m_6849_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 1.0);
                Vizier.this.setCharging(true);
                Vizier.this.m_5496_((SoundEvent)ModSounds.VIZIER_CELEBRATE.get(), 1.0f, 1.0f);
            }
        }

        public void m_8041_() {
            Vizier.this.setCharging(false);
        }

        public void m_8037_() {
            LivingEntity livingentity = Vizier.this.m_5448_();
            if (livingentity != null) {
                Vizier.this.m_21563_().m_24964_(livingentity.m_20182_());
                if (Vizier.this.m_20191_().m_82400_(1.0).m_82381_(livingentity.m_20191_())) {
                    Vizier.this.m_7327_((Entity)livingentity);
                    Vizier.this.setCharging(false);
                } else {
                    double d0 = Vizier.this.m_20280_((Entity)livingentity);
                    if (d0 < 9.0) {
                        Vec3 vector3d = livingentity.m_20299_(1.0f);
                        Vizier.this.f_21342_.m_6849_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 1.0);
                    }
                }
            }
        }
    }
}

