/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.boss;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.MainConfig;
import com.Polarice3.Goety.MobsConfig;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.hostile.cultists.Cultist;
import com.Polarice3.Goety.common.entities.hostile.cultists.SpellCastingCultist;
import com.Polarice3.Goety.common.entities.hostile.servants.Inferno;
import com.Polarice3.Goety.common.entities.hostile.servants.Malghast;
import com.Polarice3.Goety.common.entities.hostile.servants.ObsidianMonolith;
import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.neutral.OwnedFlying;
import com.Polarice3.Goety.common.entities.neutral.ZPiglinBruteServant;
import com.Polarice3.Goety.common.entities.neutral.ZPiglinServant;
import com.Polarice3.Goety.common.entities.projectiles.DeathArrow;
import com.Polarice3.Goety.common.entities.projectiles.ExplosiveProjectile;
import com.Polarice3.Goety.common.entities.projectiles.FireTornado;
import com.Polarice3.Goety.common.entities.projectiles.GrandLavaball;
import com.Polarice3.Goety.common.entities.projectiles.HellBlast;
import com.Polarice3.Goety.common.entities.projectiles.NetherMeteor;
import com.Polarice3.Goety.common.entities.util.AbstractTrap;
import com.Polarice3.Goety.common.entities.util.ArrowRainTrap;
import com.Polarice3.Goety.common.entities.util.FireBlastTrap;
import com.Polarice3.Goety.common.entities.util.FireRainTrap;
import com.Polarice3.Goety.common.entities.util.FireTornadoTrap;
import com.Polarice3.Goety.common.entities.util.LightningTrap;
import com.Polarice3.Goety.common.entities.util.SummonCircle;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.ModServerBossInfo;
import com.Polarice3.Goety.common.network.server.SApostleSmitePacket;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModLootTables;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;

public class Apostle
extends SpellCastingCultist
implements RangedAttackMob {
    private int f;
    private int hitTimes;
    private int coolDown;
    private int tornadoCoolDown;
    private int monolithCoolDown;
    private int spellCycle;
    private int titleNumber;
    private final Predicate<Entity> ALIVE = Entity::m_6084_;
    private boolean roarParticles;
    private boolean fireArrows;
    private boolean regen;
    private MobEffect arrowEffect;
    private static final UUID SPEED_MODIFIER_CASTING_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier SPEED_MODIFIER_CASTING = new AttributeModifier(SPEED_MODIFIER_CASTING_UUID, "Casting speed penalty", -1.0, AttributeModifier.Operation.ADDITION);
    protected static final EntityDataAccessor<Byte> BOSS_FLAGS = SynchedEntityData.m_135353_(Apostle.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Float> SPIN = SynchedEntityData.m_135353_(Apostle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final ModServerBossInfo bossInfo;
    public Predicate<Owned> ZOMBIE_MINIONS = owned -> owned instanceof ZPiglinServant && owned.getTrueOwner() == this;
    private final Predicate<LivingEntity> MONOLITHS = livingEntity -> {
        ObsidianMonolith monolith;
        return livingEntity instanceof ObsidianMonolith && (monolith = (ObsidianMonolith)livingEntity).getTrueOwner() == this;
    };
    private final Predicate<Owned> RANGED_MINIONS = owned -> (owned instanceof Inferno || owned instanceof Malghast) && owned.getTrueOwner() == this;
    private final Predicate<Entity> OWNED_TRAPS = entity -> {
        AbstractTrap abstractTrap;
        return entity instanceof AbstractTrap && (abstractTrap = (AbstractTrap)((Object)entity)).getOwner() == this;
    };
    public int antiRegen;
    public int antiRegenTotal;
    public int deathTime = 0;
    public int moddedInvul = 0;
    public DamageSource deathBlow = this.m_269291_().m_269264_();

    public Apostle(EntityType<? extends SpellCastingCultist> type, Level worldIn) {
        super(type, worldIn);
        this.bossInfo = new ModServerBossInfo(this.m_20148_(), (Mob)this, BossEvent.BossBarColor.RED, true, true);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21364_ = 1000;
        this.f = 0;
        this.coolDown = 100;
        this.spellCycle = 0;
        this.hitTimes = 0;
        this.antiRegen = 0;
        if (this.f_19853_.f_46443_) {
            Goety.PROXY.addBoss((Mob)this);
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new SecondPhaseIndicator());
        this.f_21345_.m_25352_(2, new ApostleBowGoal<Apostle>(this, 30.0f));
        this.f_21345_.m_25352_(3, (Goal)new CastingSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new FireballSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new ZombieSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new FireRainSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new RangedSummonSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new FireTornadoSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new RoarSpellGoal());
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    public void extraGoal() {
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.ApostleHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.ApostleArmor.get()).doubleValue()).m_22268_(Attributes.f_22285_, ((Double)AttributesConfig.ApostleToughness.get()).doubleValue()).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22277_, 40.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.ApostleHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.ApostleArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22285_), (Double)AttributesConfig.ApostleToughness.get());
    }

    protected PathNavigation m_6037_(Level p_33913_) {
        return new ApostlePathNavigation(this, p_33913_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOSS_FLAGS, (Object)0);
        this.f_19804_.m_135372_(SPIN, (Object)Float.valueOf(0.0f));
    }

    private boolean getBossFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(BOSS_FLAGS);
        return (i & mask) != 0;
    }

    private void setBossFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(BOSS_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(BOSS_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean m_203441_(FluidState p_204067_) {
        return p_204067_.m_205070_(FluidTags.f_13132_);
    }

    private void floatApostle() {
        if (this.m_20077_()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.f_19853_.m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.m_6853_(true);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
    }

    public float m_5610_(BlockPos p_33895_, LevelReader p_33896_) {
        if (p_33896_.m_8055_(p_33895_).m_60819_().m_205070_(FluidTags.f_13132_)) {
            return 10.0f;
        }
        return this.m_20077_() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    public int m_8100_() {
        return 200;
    }

    protected SoundEvent m_7515_() {
        if (this.m_5448_() != null || this.m_5912_()) {
            return (SoundEvent)ModSounds.APOSTLE_AMBIENT.get();
        }
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.APOSTLE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.APOSTLE_PREDEATH.get();
    }

    protected SoundEvent getTrueDeathSound() {
        return (SoundEvent)ModSounds.APOSTLE_DEATH.get();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_7301_(MobEffectInstance pPotioneffect) {
        return pPotioneffect.m_19544_() != GoetyEffects.BURN_HEX.get() && pPotioneffect.m_19544_() != MobEffects.f_19615_ && super.m_7301_(pPotioneffect);
    }

    public int m_213860_() {
        if (this.f_19853_.m_46472_() == Level.f_46429_) {
            return this.f_21364_ * 12;
        }
        return this.f_21364_;
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("firing", this.f);
        pCompound.m_128405_("coolDown", this.coolDown);
        pCompound.m_128405_("tornadoCoolDown", this.tornadoCoolDown);
        pCompound.m_128405_("monolithCoolDown", this.monolithCoolDown);
        pCompound.m_128405_("spellCycle", this.spellCycle);
        pCompound.m_128405_("hitTimes", this.hitTimes);
        pCompound.m_128405_("antiRegen", this.antiRegen);
        pCompound.m_128405_("antiRegenTotal", this.antiRegenTotal);
        pCompound.m_128405_("titleNumber", this.titleNumber);
        pCompound.m_128405_("moddedInvul", this.moddedInvul);
        pCompound.m_128379_("fireArrows", this.fireArrows);
        pCompound.m_128379_("secondPhase", this.isSecondPhase());
        pCompound.m_128379_("settingSecondPhase", this.isSettingUpSecond());
        pCompound.m_128379_("regen", this.regen);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f = pCompound.m_128451_("firing");
        this.coolDown = pCompound.m_128451_("coolDown");
        this.tornadoCoolDown = pCompound.m_128451_("tornadoCoolDown");
        this.monolithCoolDown = pCompound.m_128451_("monolithCoolDown");
        this.spellCycle = pCompound.m_128451_("spellCycle");
        this.hitTimes = pCompound.m_128451_("hitTimes");
        this.antiRegen = pCompound.m_128451_("antiRegen");
        this.antiRegenTotal = pCompound.m_128451_("antiRegenTotal");
        this.titleNumber = pCompound.m_128451_("titleNumber");
        this.moddedInvul = pCompound.m_128451_("moddedInvul");
        this.fireArrows = pCompound.m_128471_("fireArrows");
        this.regen = pCompound.m_128471_("regen");
        this.setTitleNumber(this.titleNumber);
        this.TitleEffect(this.titleNumber);
        this.setSecondPhase(pCompound.m_128471_("secondPhase"));
        this.setSettingUpSecond(pCompound.m_128471_("settingSecondPhase"));
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.bossInfo.setId(this.m_20148_());
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossInfo.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossInfo.m_6539_(pPlayer);
    }

    protected boolean m_6129_() {
        return false;
    }

    @Override
    public boolean m_7307_(Entity entityIn) {
        if (entityIn instanceof WitherBoss) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return super.m_7307_(entityIn);
    }

    public void m_6667_(DamageSource cause) {
        if (this.deathTime > 0) {
            super.m_6667_(cause);
        }
    }

    protected void m_6153_() {
        ++this.deathTime;
        if (this.deathTime == 1) {
            this.antiRegen = 0;
            this.antiRegenTotal = 0;
            for (AbstractTrap trapEntity : this.f_19853_.m_45976_(AbstractTrap.class, this.m_20191_().m_82400_(64.0))) {
                if (trapEntity.getOwner() != this) continue;
                trapEntity.m_146870_();
            }
            for (FireTornado fireTornadoEntity : this.f_19853_.m_45976_(FireTornado.class, this.m_20191_().m_82400_(64.0))) {
                fireTornadoEntity.m_146870_();
            }
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        if (((Boolean)MobsConfig.FancierApostleDeath.get()).booleanValue() || this.f_19853_.m_46472_() == Level.f_46429_) {
            this.m_20242_(true);
            if (this.m_21232_() instanceof Player) {
                this.f_20889_ = 100;
            }
            if (this.deathTime < 180) {
                if (this.deathTime > 20) {
                    this.m_6478_(MoverType.SELF, new Vec3(0.0, 0.1, 0.0));
                }
                this.f_19853_.m_254849_((Entity)this, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0f, Level.ExplosionInteraction.NONE);
            } else if (this.deathTime != 200) {
                this.m_6478_(MoverType.SELF, new Vec3(0.0, 0.0, 0.0));
            }
            if (this.deathTime >= 200) {
                this.m_6478_(MoverType.SELF, new Vec3(0.0, -4.0, 0.0));
                if (this.m_20096_() || this.m_20186_() <= 0.0) {
                    if (!this.f_19853_.f_46443_) {
                        ServerLevel = (ServerLevel)this.f_19853_;
                        if (ServerLevel.m_6106_().m_6534_()) {
                            ServerLevel.m_8606_(6000, 0, false, false);
                        }
                        for (int k = 0; k < 200; ++k) {
                            float f2 = this.f_19796_.m_188501_() * 4.0f;
                            float f1 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                            double d1 = Mth.m_14089_((float)f1) * f2;
                            double d2 = 0.01 + this.f_19796_.m_188500_() * 0.5;
                            double d3 = Mth.m_14031_((float)f1) * f2;
                            ServerLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + d1 * 0.1, this.m_20186_() + 0.3, this.m_20189_() + d3 * 0.1, 0, d1, d2, d3, 0.5);
                            ServerLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + d1 * 0.1, this.m_20186_() + 0.3, this.m_20189_() + d3 * 0.1, 0, d1, d2, d3, 0.5);
                        }
                        ServerLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 1.0, 0.0, 0.0, 0.5);
                    }
                    this.m_5496_(SoundEvents.f_11913_, 4.0f, (1.0f + (this.f_19853_.f_46441_.m_188501_() - this.f_19853_.f_46441_.m_188501_()) * 0.2f) * 0.7f);
                    this.m_5496_(this.getTrueDeathSound(), 5.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    this.m_6667_(this.deathBlow);
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
            }
        } else {
            this.m_6478_(MoverType.SELF, new Vec3(0.0, 0.0, 0.0));
            if (this.deathTime == 1) {
                if (!this.f_19853_.f_46443_) {
                    ServerLevel = (ServerLevel)this.f_19853_;
                    if (ServerLevel.m_6106_().m_6534_()) {
                        ServerLevel.m_8606_(6000, 0, false, false);
                    }
                    for (int k = 0; k < 200; ++k) {
                        float f2 = this.f_19796_.m_188501_() * 4.0f;
                        float f1 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                        double d1 = Mth.m_14089_((float)f1) * f2;
                        double d2 = 0.01 + this.f_19796_.m_188500_() * 0.5;
                        double d3 = Mth.m_14031_((float)f1) * f2;
                        ServerLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + d1 * 0.1, this.m_20186_() + 0.3, this.m_20189_() + d3 * 0.1, 0, d1, d2, d3, 0.5);
                        ServerLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + d1 * 0.1, this.m_20186_() + 0.3, this.m_20189_() + d3 * 0.1, 0, d1, d2, d3, 0.5);
                    }
                    for (int l = 0; l < 16; ++l) {
                        ServerLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(1.0), this.m_20187_() - 0.25, this.m_20262_(1.0), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                this.m_6667_(this.deathBlow);
                this.m_5496_(this.getTrueDeathSound(), 5.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            }
            if (this.deathTime >= 30) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    protected boolean m_8028_() {
        return false;
    }

    public void m_142687_(Entity.RemovalReason p_146834_) {
        if (this.f_19853_.f_46443_) {
            Goety.PROXY.removeBoss((Mob)this);
        } else {
            ServerLevel ServerLevel2 = (ServerLevel)this.f_19853_;
            if (ServerLevel2.m_6106_().m_6534_()) {
                ServerLevel2.m_8606_(6000, 0, false, false);
            }
        }
        super.m_142687_(p_146834_);
    }

    protected ResourceLocation m_7582_() {
        if (this.f_19853_.m_46472_() == Level.f_46429_) {
            return ModLootTables.APOSTLE_HARD;
        }
        return super.m_7582_();
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        ItemEntity itementity2;
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        ItemEntity itementity = this.m_19998_((ItemLike)ModItems.UNHOLY_BLOOD.get());
        if (itementity != null) {
            itementity.m_32064_();
        }
        if (this.f_19853_.m_46472_() == Level.f_46429_ && ((Boolean)MainConfig.EnableNightBeacon.get()).booleanValue() && (itementity2 = this.m_19998_((ItemLike)((Block)ModBlocks.NIGHT_BEACON.get()).m_5456_())) != null) {
            itementity2.m_32064_();
        }
    }

    protected float m_6515_(DamageSource source, float damage) {
        damage = super.m_6515_(source, damage);
        if (source.m_7639_() == this) {
            damage = 0.0f;
        }
        if (source.m_7640_() instanceof ExplosiveProjectile || source.m_7640_() instanceof Fireball) {
            damage = (float)((double)damage * 0.15);
        }
        if (this.f_19853_.m_46791_() == Difficulty.HARD && source.m_269533_(DamageTypeTags.f_268731_)) {
            damage = (float)((double)damage * 0.15);
        }
        return damage;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.m_213945_(worldIn.m_213780_(), difficultyIn);
        this.m_213946_(worldIn.m_213780_(), difficultyIn);
        if (!this.m_8077_()) {
            int random = this.f_19796_.m_188503_(18);
            int random2 = this.f_19796_.m_188503_(12);
            this.setTitleNumber(random2);
            this.TitleEffect(random2);
            MutableComponent component = Component.m_237115_((String)("name.goety.apostle." + random));
            MutableComponent component1 = Component.m_237115_((String)("title.goety." + random2));
            if (random2 == 1) {
                this.m_21153_(this.m_21233_());
            }
            this.m_6593_((Component)Component.m_237115_((String)(component.getString() + component1.getString())));
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void setTitleNumber(Integer integer) {
        this.titleNumber = integer;
    }

    public void TitleEffect(Integer integer) {
        switch (integer) {
            case 0: {
                this.setRegen(true);
                break;
            }
            case 1: {
                this.setArrowEffect(MobEffects.f_19602_);
                break;
            }
            case 2: {
                this.setArrowEffect(MobEffects.f_19614_);
                break;
            }
            case 3: {
                this.setArrowEffect(MobEffects.f_19615_);
                break;
            }
            case 4: {
                this.setArrowEffect(MobEffects.f_216964_);
                break;
            }
            case 5: {
                this.setArrowEffect(MobEffects.f_19613_);
                break;
            }
            case 6: {
                this.setFireArrow(true);
                this.setArrowEffect((MobEffect)GoetyEffects.BURN_HEX.get());
                break;
            }
            case 7: {
                this.setArrowEffect(MobEffects.f_19612_);
                break;
            }
            case 8: {
                this.setArrowEffect(MobEffects.f_19597_);
                break;
            }
            case 9: {
                this.m_147207_(new MobEffectInstance(MobEffects.f_19596_, -1, 1, false, false), (Entity)this);
                break;
            }
            case 10: {
                this.m_147207_(new MobEffectInstance(MobEffects.f_19606_, -1, 0, false, false), (Entity)this);
                break;
            }
            case 11: {
                this.setArrowEffect((MobEffect)GoetyEffects.SAPPED.get());
            }
        }
    }

    public boolean m_147207_(MobEffectInstance p_182397_, @Nullable Entity p_182398_) {
        if (p_182398_ == this) {
            return super.m_147207_(p_182397_, p_182398_);
        }
        return p_182397_.m_19544_().m_19486_();
    }

    public void setRegen(boolean regen) {
        this.regen = regen;
    }

    public boolean Regen() {
        return this.regen;
    }

    public void setFireArrow(boolean fireArrow) {
        this.fireArrows = fireArrow;
    }

    public boolean getFireArrow() {
        return this.fireArrows;
    }

    public void setArrowEffect(MobEffect effect) {
        this.arrowEffect = effect;
    }

    public MobEffect getArrowEffect() {
        return this.arrowEffect;
    }

    public void setSecondPhase(boolean secondPhase) {
        this.setBossFlag(1, secondPhase);
    }

    public boolean isSecondPhase() {
        return this.getBossFlag(1);
    }

    public void setSettingUpSecond(boolean settingupSecond) {
        this.setBossFlag(2, settingupSecond);
    }

    public boolean isSettingUpSecond() {
        return this.getBossFlag(2);
    }

    public void setCasting(boolean casting) {
        this.setBossFlag(4, casting);
    }

    public boolean isCasting() {
        return this.getBossFlag(4);
    }

    public void setSpin(float spin) {
        this.f_19804_.m_135381_(SPIN, (Object)Float.valueOf(spin));
    }

    public float getSpin() {
        return ((Float)this.f_19804_.m_135370_(SPIN)).floatValue();
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
    }

    @Override
    public Cultist.CultistArmPose getArmPose() {
        if (this.m_21224_()) {
            return Cultist.CultistArmPose.DYING;
        }
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            if (this.m_5912_() && !this.isSpellcasting() && !this.isSettingUpSecond()) {
                return Cultist.CultistArmPose.BOW_AND_ARROW;
            }
            if (this.isSpellcasting()) {
                return Cultist.CultistArmPose.SPELL_AND_WEAPON;
            }
            if (this.isSettingUpSecond()) {
                return Cultist.CultistArmPose.SPELL_AND_WEAPON;
            }
            return Cultist.CultistArmPose.CROSSED;
        }
        return Cultist.CultistArmPose.CROSSED;
    }

    public boolean isFiring() {
        return this.roarParticles;
    }

    public void setFiring(boolean firing) {
        this.roarParticles = firing;
    }

    public int hitTimeTeleport() {
        return this.isSecondPhase() ? 2 : 4;
    }

    public void resetHitTime() {
        this.hitTimes = 0;
    }

    public void increaseHitTime() {
        ++this.hitTimes;
    }

    public int getHitTimes() {
        return this.hitTimes;
    }

    public void resetCoolDown() {
        this.setCoolDown(0);
    }

    public void setCoolDown(int coolDown) {
        this.coolDown = coolDown;
    }

    public int getCoolDown() {
        return this.coolDown;
    }

    public void setTornadoCoolDown(int coolDown) {
        this.tornadoCoolDown = coolDown;
    }

    public int getTornadoCoolDown() {
        return this.tornadoCoolDown;
    }

    public void setMonolithCoolDown(int coolDown) {
        this.monolithCoolDown = coolDown;
    }

    public int getMonolithCoolDown() {
        return this.monolithCoolDown;
    }

    public int getAntiRegen() {
        return this.antiRegen;
    }

    public int getAntiRegenTotal() {
        return this.antiRegenTotal;
    }

    public boolean isSmited() {
        return this.antiRegen > 0;
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        float trueAmount;
        LivingEntity living;
        int smite;
        Entity entity;
        LivingEntity livingEntity = this.m_5448_();
        if (!this.f_19853_.f_46443_ && livingEntity != null && pSource.m_7639_() instanceof LivingEntity) {
            this.increaseHitTime();
        }
        if ((entity = pSource.m_7640_()) instanceof LivingEntity && (smite = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44978_, (LivingEntity)(living = (LivingEntity)entity))) > 0) {
            int smite2 = Mth.m_14045_((int)smite, (int)1, (int)5);
            int duration = MathHelper.secondsToTicks(smite2);
            if (this.Regen()) {
                duration /= 2;
            }
            this.antiRegenTotal = duration;
            this.antiRegen = duration;
            if (this.f_19853_ instanceof ServerLevel) {
                ModNetwork.sendToALL(new SApostleSmitePacket(this.m_19879_(), duration));
                if (this.getCoolDown() < this.coolDownLimit()) {
                    this.coolDown += 10;
                }
            }
        }
        if (pSource.m_276093_(DamageTypes.f_268450_) || pSource.m_276093_(DamageTypes.f_268671_) || pSource.m_276093_(DamageTypes.f_268612_)) {
            return false;
        }
        if (pSource.m_7640_() instanceof AbstractArrow && ((AbstractArrow)pSource.m_7640_()).m_19749_() == this) {
            return false;
        }
        if (this.isSettingUpSecond()) {
            return false;
        }
        if (pSource.m_7640_() instanceof NetherMeteor || pSource.m_7639_() instanceof NetherMeteor) {
            return false;
        }
        if (this.moddedInvul > 0) {
            return false;
        }
        float f = trueAmount = this.f_19853_.m_46472_() == Level.f_46429_ ? pAmount / 2.0f : pAmount;
        if (pSource.m_276093_(DamageTypes.f_268724_) && pSource.m_7639_() == null) {
            this.m_146870_();
        }
        if (this.getHitTimes() >= this.hitTimeTeleport()) {
            trueAmount /= 2.0f;
            this.teleport();
        }
        if (!this.f_19853_.m_45955_(TargetingConditions.m_148352_().m_26888_(MobUtil.NO_CREATIVE_OR_SPECTATOR), (LivingEntity)this, this.m_20191_().m_82400_(32.0)).isEmpty() && !(pSource.m_7639_() instanceof Player)) {
            trueAmount /= 2.0f;
        }
        if (this.m_21224_()) {
            this.deathBlow = pSource;
        }
        return super.m_6469_(pSource, Math.min(trueAmount, (float)((Integer)AttributesConfig.ApostleDamageCap.get()).intValue()));
    }

    protected void m_6475_(DamageSource p_21240_, float p_21241_) {
        if (p_21240_.m_269533_(DamageTypeTags.f_273918_) || p_21240_.m_276093_(DamageTypes.f_268724_) && p_21240_.m_7639_() != null) {
            this.moddedInvul = 20;
        }
        super.m_6475_(p_21240_, p_21241_);
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource damageSource) {
        return false;
    }

    protected void teleport() {
        if (!this.f_19853_.m_5776_() && this.m_6084_() && !this.isSettingUpSecond() && !this.isCasting()) {
            for (int i = 0; i < 128; ++i) {
                double d5;
                double d3 = this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * 32.0;
                double d4 = this.m_20186_();
                if (this.m_5448_() != null) {
                    d4 = this.m_5448_().m_20186_();
                }
                if (!this.m_20984_(d3, d4, d5 = this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * 32.0, false)) continue;
                this.teleportHits();
                this.resetHitTime();
                break;
            }
        }
    }

    private void teleportTowards(Entity entity) {
        if (!this.f_19853_.m_5776_() && this.m_6084_() && !this.isSettingUpSecond()) {
            for (int i = 0; i < 128; ++i) {
                double d3;
                double d2;
                Vec3 vector3d = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20227_(0.5) - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
                vector3d = vector3d.m_82541_();
                double d0 = 16.0;
                double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82479_ * d0;
                if (!this.m_20984_(d1, d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vector3d.f_82480_ * d0, d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82481_ * d0, false)) continue;
                this.teleportHits();
                break;
            }
        }
    }

    public void teleportHits() {
        this.f_19853_.m_7605_((Entity)this, (byte)100);
        this.f_19853_.m_214171_(GameEvent.f_238175_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)this));
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, (SoundEvent)ModSounds.APOSTLE_TELEPORT.get(), this.m_5720_(), 1.0f, 1.0f);
            this.m_5496_((SoundEvent)ModSounds.APOSTLE_TELEPORT.get(), 1.0f, 1.0f);
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 100) {
            int i = 128;
            for (int j = 0; j < i; ++j) {
                double d0 = (double)j / (double)(i - 1);
                float f = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
                float f1 = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
                float f2 = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
                double d1 = Mth.m_14139_((double)d0, (double)this.f_19854_, (double)this.m_20185_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                double d2 = Mth.m_14139_((double)d0, (double)this.f_19855_, (double)this.m_20186_()) + this.f_19796_.m_188500_() * (double)this.m_20206_();
                double d3 = Mth.m_14139_((double)d0, (double)this.f_19856_, (double)this.m_20189_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d1, d2, d3, (double)f, (double)f1, (double)f2);
            }
        } else {
            super.m_7822_(pId);
        }
    }

    @Override
    protected SoundEvent getCastingSoundEvent() {
        return (SoundEvent)ModSounds.APOSTLE_CAST_SPELL.get();
    }

    public void setSpellCycle(int spellCycle) {
        this.spellCycle = spellCycle;
    }

    public int getSpellCycle() {
        return this.spellCycle;
    }

    protected boolean m_7341_(Entity pEntity) {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.floatApostle();
        if (this.f_19797_ % 5 == 0) {
            this.bossInfo.update();
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_8107_() {
        AttributeInstance attributeinstance;
        super.m_8107_();
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.moddedInvul > 0) {
            --this.moddedInvul;
        }
        if (this.f_19853_.f_46443_) {
            if (this.m_6084_()) {
                if (this.getSpin() < 3.14f) {
                    this.setSpin(this.getSpin() + 0.01f);
                } else {
                    this.setSpin(-3.14f);
                }
            }
            if (this.isSettingUpSecond()) {
                for (int i = 0; i < 40; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.2;
                    double d1 = this.f_19796_.m_188583_() * 0.2;
                    double d2 = this.f_19796_.m_188583_() * 0.2;
                    this.f_19853_.m_7107_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), d0, d1, d2);
                }
            }
        }
        if (!this.f_19853_.f_46443_ && (attributeinstance = this.m_21051_(Attributes.f_22279_)) != null) {
            if (attributeinstance.m_22109_(SPEED_MODIFIER_CASTING)) {
                attributeinstance.m_22130_(SPEED_MODIFIER_CASTING);
            }
            if (this.isCasting() && this.f_19853_.m_46472_() != Level.f_46429_) {
                attributeinstance.m_22118_(SPEED_MODIFIER_CASTING);
            }
        }
        if (this.isSettingUpSecond()) {
            this.setFiring(false);
            this.f = 0;
            this.m_5634_(1.0f);
            for (Entity entity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(3.0), this.ALIVE)) {
                if (entity.m_7307_((Entity)this)) continue;
                this.barrier(entity, (LivingEntity)this);
            }
            if (!this.f_19853_.f_46443_) {
                this.resetHitTime();
            }
            if (this.m_21223_() >= this.m_21233_()) {
                if (!this.f_19853_.f_46443_) {
                    ServerLevel serverLevel = (ServerLevel)this.f_19853_;
                    if (!serverLevel.m_46470_()) {
                        serverLevel.m_8606_(0, 6000, true, true);
                    }
                    for (int k = 0; k < 60; ++k) {
                        float f2 = this.f_19796_.m_188501_() * 4.0f;
                        float f1 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                        double d1 = Mth.m_14089_((float)f1) * f2;
                        double d2 = 0.01 + this.f_19796_.m_188500_() * 0.5;
                        double d3 = Mth.m_14031_((float)f1) * f2;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + d1 * 0.1, this.m_20186_() + 0.3, this.m_20189_() + d3 * 0.1, 0, d1, d2, d3, 0.25);
                    }
                }
                this.setSettingUpSecond(false);
                this.setSecondPhase(true);
            }
        }
        LivingEntity target = this.m_5448_();
        if (this.m_21205_().m_41619_() && this.m_6084_()) {
            this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42411_));
        }
        if (this.isSmited()) {
            --this.antiRegen;
        }
        if (this.getTornadoCoolDown() > 0) {
            --this.tornadoCoolDown;
        }
        if (this.getMonolithCoolDown() > 0) {
            --this.monolithCoolDown;
        }
        if (this.isSecondPhase()) {
            if (!this.isSmited()) {
                if (this.Regen()) {
                    if (this.f_19797_ % 10 == 0 && this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(1.0f);
                    }
                } else if (this.f_19797_ % 20 == 0 && this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(1.0f);
                }
            }
            if (this.f_19797_ % 100 == 0 && !this.m_21224_() && !this.f_19853_.f_46443_) {
                ServerLevel ServerLevel2 = (ServerLevel)this.f_19853_;
                ServerLevel2.m_8606_(0, 6000, true, true);
            }
            if (!this.f_19853_.f_46443_) {
                if (this.getCoolDown() < this.coolDownLimit()) {
                    ++this.coolDown;
                } else {
                    this.setSpellCycle(1);
                }
            }
            if (this.f_19853_.m_46472_() != Level.f_46429_ && this.f_19797_ % 20 == 0) {
                BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(this.m_20208_(0.2), this.m_20186_(), this.m_20262_(0.2));
                while ((double)blockPos.m_123342_() < this.m_20186_() + 64.0 && !this.f_19853_.m_8055_((BlockPos)blockPos).m_60804_((BlockGetter)this.f_19853_, (BlockPos)blockPos)) {
                    blockPos.m_122173_(Direction.UP);
                }
                if ((double)blockPos.m_123342_() > this.m_20186_() + 32.0) {
                    int range = this.m_21223_() < this.m_21233_() / 2.0f ? 450 : 900;
                    int trueRange = this.m_21223_() < this.m_21223_() / 4.0f ? range / 2 : range;
                    RandomSource random = this.f_19853_.f_46441_;
                    double d = random.m_188499_() ? 1 : -1;
                    double e = random.m_188499_() ? 1 : -1;
                    double d2 = (double)random.m_188503_(trueRange) * d;
                    double d3 = -900.0;
                    double d4 = (double)random.m_188503_(trueRange) * e;
                    NetherMeteor fireball = new NetherMeteor(this.f_19853_, (LivingEntity)this, d2, d3, d4);
                    fireball.setDangerous(ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) && (Boolean)MobsConfig.ApocalypseMode.get() != false);
                    fireball.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                    this.f_19853_.m_7967_((Entity)fireball);
                }
            }
        } else {
            if (!this.isSmited()) {
                if (this.Regen()) {
                    if (this.f_19797_ % 20 == 0 && this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(1.0f);
                    }
                } else if (this.f_19797_ % 40 == 0 && this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(1.0f);
                }
            }
            if (!this.f_19853_.f_46443_) {
                if (this.getCoolDown() < this.coolDownLimit()) {
                    ++this.coolDown;
                } else {
                    this.setSpellCycle(0);
                }
            }
        }
        if (!this.f_19853_.f_46443_ && this.getSpellCycle() < 2) {
            if (this.f_19853_.f_46441_.m_188499_()) {
                this.setSpellCycle(2);
            } else {
                this.setSpellCycle(3);
            }
        }
        for (LivingEntity living : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(32.0))) {
            if (!(living instanceof Cultist || living instanceof Witch || living instanceof IOwned && ((IOwned)living).getTrueOwner() == this || !living.m_20069_())) {
                living.m_6469_(living.m_269291_().m_269047_(), 1.0f);
            }
            if (!(living instanceof Player)) continue;
            Player player = (Player)living;
            player.m_150110_().f_35935_ &= player.m_7500_();
        }
        if (target == null) {
            this.resetHitTime();
            for (Player player : this.f_19853_.m_6443_(Player.class, this.m_20191_().m_82400_(64.0), EntitySelector.f_20406_)) {
                this.m_6710_((LivingEntity)player);
            }
            for (Mob mob : this.f_19853_.m_6443_(Mob.class, this.m_20191_().m_82400_(this.m_21133_(Attributes.f_22277_)), EntitySelector.f_20403_)) {
                if (mob.m_5448_() != this || this.m_5448_() != null) continue;
                this.m_6710_((LivingEntity)mob);
            }
        } else {
            IOwned owned;
            if (target instanceof IOwned && (owned = (IOwned)target).getTrueOwner() != null && this.m_6779_(owned.getTrueOwner()) && EntitySelector.f_20406_.test(owned.getTrueOwner())) {
                this.m_6710_(owned.getTrueOwner());
            }
            int i = this.f_19853_.m_6443_(Owned.class, this.m_20191_().m_82400_(64.0), this.ZOMBIE_MINIONS).size();
            if (this.f_19797_ % 100 == 0 && i < 16 && this.f_19853_.f_46441_.m_188501_() <= 0.25f && !this.isSettingUpSecond() && !this.f_19853_.f_46443_) {
                int numbers;
                ServerLevel ServerLevel3 = (ServerLevel)this.f_19853_;
                RandomSource r = this.f_19853_.f_46441_;
                int n = numbers = this.isSecondPhase() ? 4 : 2;
                if (this.f_19853_.m_46472_() == Level.f_46429_) {
                    for (ZombifiedPiglin zombifiedPiglin : this.f_19853_.m_45976_(ZombifiedPiglin.class, this.m_20191_().m_82400_(16.0))) {
                        if (zombifiedPiglin.m_5448_() == this.m_5448_()) continue;
                        zombifiedPiglin.m_6710_(this.m_5448_());
                    }
                    for (int p = 0; p < r.m_188503_(numbers) + 1; ++p) {
                        int k = (12 + r.m_188503_(12)) * (r.m_188499_() ? -1 : 1);
                        int l = (12 + r.m_188503_(12)) * (r.m_188499_() ? -1 : 1);
                        BlockPos.MutableBlockPos blockpos$mutable = this.m_20183_().m_122032_().m_122184_(k, 0, l);
                        blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + r.m_188503_(5) - r.m_188503_(5));
                        blockpos$mutable.m_142448_((int)BlockFinder.moveDownToGround((Entity)this));
                        blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + r.m_188503_(5) - r.m_188503_(5));
                        ZPiglinServant summonedentity = new ZPiglinServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.ZPIGLIN_SERVANT.get()), this.f_19853_);
                        summonedentity.m_20035_((BlockPos)blockpos$mutable, 0.0f, 0.0f);
                        summonedentity.setTrueOwner((LivingEntity)this);
                        summonedentity.setLimitedLife(60 * (90 + this.f_19853_.f_46441_.m_188503_(180)));
                        summonedentity.m_6518_((ServerLevelAccessor)ServerLevel3, this.f_19853_.m_6436_((BlockPos)blockpos$mutable), MobSpawnType.MOB_SUMMONED, null, null);
                        summonedentity.m_6710_(this.m_5448_());
                        SummonCircle summonCircle = new SummonCircle(this.f_19853_, (BlockPos)blockpos$mutable, (Entity)summonedentity, false, true, (LivingEntity)this);
                        this.f_19853_.m_7967_((Entity)summonCircle);
                    }
                }
            }
            if (this.isSecondPhase()) {
                int count;
                if (this.m_21223_() <= this.m_21233_() / 8.0f && this.f_19797_ % 100 == 0) {
                    this.teleport();
                }
                if (MobUtil.isInRain((Entity)target) && this.f_19797_ % (count = 100 * (this.f_19796_.m_188503_(5) + 1)) == 0) {
                    BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(target.m_20185_(), target.m_20186_(), target.m_20189_());
                    while (blockpos$mutable.m_123342_() > 0 && !this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_280555_()) {
                        blockpos$mutable.m_122173_(Direction.DOWN);
                    }
                    LightningTrap lightningTrap = new LightningTrap(this.f_19853_, blockpos$mutable.m_123341_(), blockpos$mutable.m_123342_() + 1, blockpos$mutable.m_123343_());
                    lightningTrap.setOwner((LivingEntity)this);
                    lightningTrap.setDuration(50);
                    this.f_19853_.m_7967_((Entity)lightningTrap);
                }
            }
            if ((target.m_20280_((Entity)this) > 1024.0 || !this.m_21574_().m_148306_((Entity)target)) && target.m_20096_() && !this.isSettingUpSecond()) {
                this.teleportTowards((Entity)target);
            }
        }
        if (this.isFiring() && !this.isSettingUpSecond()) {
            ++this.f;
            if (this.f % 2 == 0 && this.f < 10) {
                for (Entity entity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(4.0), this.ALIVE)) {
                    if (entity instanceof Cultist || entity instanceof Witch || entity instanceof IOwned && ((IOwned)entity).getTrueOwner() == this) continue;
                    entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), ((Double)AttributesConfig.ApostleMagicDamage.get()).floatValue());
                    this.launch(entity, (LivingEntity)this);
                }
                if (!this.f_19853_.f_46443_) {
                    this.serverRoarParticles();
                }
            }
            if (this.f >= 10) {
                if (this.teleportChance()) {
                    this.teleport();
                }
                this.setFiring(false);
                this.f = 0;
            }
        }
        if (this.m_20069_() || this.m_20077_() || this.m_5830_()) {
            this.teleport();
        }
        if (this.f_19853_.m_46472_() == Level.f_46429_ && target != null) {
            target.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BURN_HEX.get(), 100));
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isSettingUpSecond();
    }

    public boolean m_142582_(Entity p_149755_) {
        return !this.isSettingUpSecond() && super.m_142582_(p_149755_);
    }

    private void serverRoarParticles() {
        ServerLevel ServerLevel2 = (ServerLevel)this.f_19853_;
        ServerLevel2.m_8767_((ParticleOptions)ParticleTypes.f_123747_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        Vec3 vector3d = this.m_20191_().m_82399_();
        for (int i = 0; i < 40; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.2;
            double d1 = this.f_19796_.m_188583_() * 0.2;
            double d2 = this.f_19796_.m_188583_() * 0.2;
            ServerLevel2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 0, d0, d1, d2, 0.5);
        }
    }

    private void launch(Entity p_213688_1_, LivingEntity livingEntity) {
        double d0 = p_213688_1_.m_20185_() - livingEntity.m_20185_();
        double d1 = p_213688_1_.m_20189_() - livingEntity.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        MobUtil.push(p_213688_1_, d0 / d2 * 6.0, 0.4, d1 / d2 * 6.0);
    }

    private void barrier(Entity p_213688_1_, LivingEntity livingEntity) {
        double d0 = p_213688_1_.m_20185_() - livingEntity.m_20185_();
        double d1 = p_213688_1_.m_20189_() - livingEntity.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        MobUtil.push(p_213688_1_, d0 / d2 * 2.0, 0.1, d1 / d2 * 2.0);
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrowentity = this.getArrow(itemstack, pDistanceFactor * (float)((Integer)AttributesConfig.ApostleBowDamage.get()).intValue());
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrowentity);
        }
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - abstractarrowentity.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)abstractarrowentity);
    }

    public AbstractArrow getArrow(ItemStack pArrowStack, float pDistanceFactor) {
        DeathArrow deathArrow = new DeathArrow(this.f_19853_, (LivingEntity)this);
        deathArrow.m_36878_(pArrowStack);
        deathArrow.m_36745_((LivingEntity)this, pDistanceFactor);
        if (this.getArrowEffect() != null) {
            MobEffect mobEffect = this.getArrowEffect();
            int amp = this.isSecondPhase() && this.getArrowEffect() != MobEffects.f_19602_ ? 1 : 0;
            if (this.m_5448_() != null && this.getArrowEffect() == MobEffects.f_19602_ && this.m_5448_().m_21222_()) {
                mobEffect = MobEffects.f_19601_;
            }
            if (this.isSecondPhase() && this.getArrowEffect() == MobEffects.f_216964_) {
                mobEffect = MobEffects.f_19610_;
            }
            deathArrow.m_36870_(new MobEffectInstance(mobEffect, mobEffect.m_8093_() ? 1 : 200, amp));
        }
        if (this.getFireArrow()) {
            deathArrow.m_7311_(100);
        }
        if (this.f_19853_.m_46472_() == Level.f_46429_) {
            deathArrow.m_36767_((byte)5);
            deathArrow.m_36762_(true);
        } else {
            float critChance = 0.05f;
            if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                critChance += 0.25f;
            }
            if (this.isSecondPhase()) {
                critChance += 0.1f;
            }
            if (this.isSecondPhase() && this.m_21223_() <= this.m_21233_() / 4.0f) {
                critChance += 0.25f;
            }
            if (this.f_19853_.f_46441_.m_188501_() <= critChance) {
                deathArrow.m_36762_(true);
            }
        }
        return deathArrow;
    }

    public boolean m_5886_(ProjectileWeaponItem p_230280_1_) {
        return p_230280_1_ instanceof BowItem;
    }

    public ItemStack m_6298_(ItemStack shootable) {
        if (shootable.m_41720_() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)shootable.m_41720_()).m_6442_();
            ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
            return itemstack.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : itemstack;
        }
        return ItemStack.f_41583_;
    }

    public boolean teleportChance() {
        return this.f_19853_.f_46441_.m_188501_() <= 0.25f;
    }

    public int spellStart() {
        return this.isSecondPhase() && this.m_21223_() <= this.m_21233_() / 4.0f ? 12 : (this.isSecondPhase() ? 20 : 40);
    }

    public int coolDownLimit() {
        return this.isSecondPhase() && this.m_21223_() <= this.m_21233_() / 4.0f ? 20 : (this.isSecondPhase() ? 25 : 50);
    }

    public void postSpellCast() {
        if (this.teleportChance()) {
            this.teleport();
        }
        this.resetCoolDown();
        this.setSpellCycle(0);
    }

    public boolean m_6072_() {
        return false;
    }

    class SecondPhaseIndicator
    extends Goal {
        private SecondPhaseIndicator() {
        }

        public boolean m_8036_() {
            return Apostle.this.m_21223_() <= Apostle.this.m_21233_() / 2.0f && Apostle.this.m_5448_() != null && !Apostle.this.isSecondPhase() && !Apostle.this.isSettingUpSecond();
        }

        public void m_8037_() {
            Apostle.this.setSettingUpSecond(true);
        }
    }

    static class ApostleBowGoal<T extends Apostle>
    extends Goal {
        private final T mob;
        private final float attackRadiusSqr;
        private int attackTime = -1;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;

        public ApostleBowGoal(T p_25792_, float p_25795_) {
            this.mob = p_25792_;
            this.attackRadiusSqr = p_25795_ * p_25795_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.HaveBow() && !((Apostle)this.mob).isSettingUpSecond();
        }

        public boolean m_8045_() {
            return (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.HaveBow() && !((Apostle)this.mob).isCasting();
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.m_21561_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.m_21561_(false);
            this.seeTime = 0;
            this.attackTime = -1;
            this.mob.m_5810_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                boolean flag1;
                double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                    this.mob.m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    this.mob.m_21573_().m_5624_((Entity)livingentity, 1.0);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.attackRadiusSqr * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.attackRadiusSqr * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    this.mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                }
                if (this.mob.m_6117_()) {
                    int i;
                    if (!flag && this.seeTime < -60) {
                        this.mob.m_5810_();
                    } else if (flag && (i = this.mob.m_21252_()) >= 20) {
                        int attackIntervalMin;
                        this.mob.m_5810_();
                        ((Apostle)this.mob).m_6504_(livingentity, BowItem.m_40661_((int)i));
                        Difficulty difficulty = ((Apostle)this.mob).f_19853_.m_46791_();
                        int n = attackIntervalMin = difficulty != Difficulty.HARD ? 10 : 5;
                        if (((Apostle)this.mob).isSecondPhase() || ((Apostle)this.mob).f_19853_.m_46472_() == Level.f_46429_) {
                            attackIntervalMin = 0;
                        }
                        this.attackTime = attackIntervalMin;
                    }
                } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                    this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof BowItem));
                }
            }
        }

        protected boolean HaveBow() {
            return this.mob.m_21093_(item -> item.m_41720_() instanceof BowItem);
        }
    }

    class CastingSpellGoal
    extends SpellCastingCultist.CastingASpellGoal {
        private CastingSpellGoal() {
            super(Apostle.this);
        }

        @Override
        public void m_8037_() {
            if (Apostle.this.m_5448_() != null) {
                Apostle.this.m_21563_().m_24960_((Entity)Apostle.this.m_5448_(), (float)Apostle.this.m_8085_(), (float)Apostle.this.m_8132_());
            }
        }
    }

    class FireballSpellGoal
    extends CastingGoal {
        private FireballSpellGoal() {
        }

        @Override
        public boolean m_8036_() {
            LivingEntity livingentity = Apostle.this.m_5448_();
            if (!super.m_8036_()) {
                return false;
            }
            if (livingentity == null) {
                return false;
            }
            return Apostle.this.getSpellCycle() == 0 && !Apostle.this.isSettingUpSecond() && !Apostle.this.isSecondPhase() && Apostle.this.m_21574_().m_148306_((Entity)livingentity);
        }

        @Override
        protected int getCastingTime() {
            return 20;
        }

        @Override
        public void castSpell() {
            LivingEntity livingentity = Apostle.this.m_5448_();
            if (livingentity != null) {
                double d1 = livingentity.m_20185_() - Apostle.this.m_20185_();
                double d2 = livingentity.m_20227_(0.5) - Apostle.this.m_20227_(0.5);
                double d3 = livingentity.m_20189_() - Apostle.this.m_20189_();
                Object fireballEntity = Apostle.this.f_19853_.m_46791_() != Difficulty.EASY ? new HellBlast((LivingEntity)Apostle.this, d1, d2, d3, Apostle.this.f_19853_) : new GrandLavaball(Apostle.this.f_19853_, (LivingEntity)Apostle.this, d1, d2, d3);
                if (fireballEntity instanceof ExplosiveProjectile) {
                    ExplosiveProjectile fireball = (ExplosiveProjectile)((Object)fireballEntity);
                    fireball.setDangerous(ForgeEventFactory.getMobGriefingEvent((Level)Apostle.this.f_19853_, (Entity)Apostle.this));
                }
                fireballEntity.m_6034_(fireballEntity.m_20185_(), Apostle.this.m_20227_(0.5), fireballEntity.m_20189_());
                Apostle.this.f_19853_.m_7967_((Entity)fireballEntity);
                if (!Apostle.this.m_20067_()) {
                    Apostle.this.f_19853_.m_5898_(null, 1016, Apostle.this.m_20183_(), 0);
                }
                if (Apostle.this.teleportChance()) {
                    Apostle.this.teleport();
                }
                Apostle.this.resetCoolDown();
                Apostle.this.setSpellCycle(1);
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.APOSTLE_PREPARE_SPELL.get();
        }

        @Override
        protected SpellCastingCultist.SpellType getSpellType() {
            return SpellCastingCultist.SpellType.FIRE;
        }
    }

    class ZombieSpellGoal
    extends CastingGoal {
        private ZombieSpellGoal() {
        }

        @Override
        public boolean m_8036_() {
            int i = Apostle.this.f_19853_.m_6443_(Owned.class, Apostle.this.m_20191_().m_82400_(64.0), Apostle.this.ZOMBIE_MINIONS).size();
            int j = Apostle.this.f_19853_.m_6443_(Owned.class, Apostle.this.m_20191_().m_82400_(64.0), Apostle.this.MONOLITHS).size();
            if (!super.m_8036_()) {
                return false;
            }
            int cool = Apostle.this.spellStart();
            return Apostle.this.getCoolDown() >= cool && Apostle.this.getSpellCycle() == 2 && Apostle.this.getMonolithCoolDown() <= 0 && !Apostle.this.isSettingUpSecond() && i < 4 && j < 4;
        }

        @Override
        protected int getCastingTime() {
            return 20;
        }

        @Override
        public void castSpell() {
            if (!Apostle.this.f_19853_.f_46443_) {
                ServerLevel serverLevel = (ServerLevel)Apostle.this.f_19853_;
                LivingEntity livingentity = Apostle.this.m_5448_();
                RandomSource randomSource = serverLevel.f_46441_;
                if (livingentity != null) {
                    BlockPos blockpos = Apostle.this.m_20183_();
                    if (randomSource.m_188499_()) {
                        ZPiglinServant summonedentity = new ZPiglinServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.ZPIGLIN_SERVANT.get()), Apostle.this.f_19853_);
                        if (Apostle.this.isSecondPhase()) {
                            summonedentity = new ZPiglinBruteServant((EntityType<? extends ZPiglinServant>)((EntityType)ModEntityType.ZPIGLIN_BRUTE_SERVANT.get()), Apostle.this.f_19853_);
                        }
                        summonedentity.m_20035_(blockpos, 0.0f, 0.0f);
                        summonedentity.setTrueOwner((LivingEntity)Apostle.this);
                        summonedentity.setLimitedLife(60 * (90 + serverLevel.f_46441_.m_188503_(180)));
                        for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
                            ItemStack itemstack;
                            if (equipmentslottype.m_20743_() == EquipmentSlot.Type.ARMOR && (itemstack = summonedentity.m_6844_(equipmentslottype)).m_41619_()) {
                                Item item = Mob.m_21412_((EquipmentSlot)equipmentslottype, (int)1);
                                if (serverLevel.m_46791_() == Difficulty.HARD && Apostle.this.isSecondPhase()) {
                                    item = this.netheriteArmor(equipmentslottype);
                                }
                                if (item != null) {
                                    summonedentity.m_8061_(equipmentslottype, new ItemStack((ItemLike)item));
                                }
                            }
                            if (equipmentslottype == EquipmentSlot.MAINHAND && serverLevel.m_46791_() == Difficulty.HARD && Apostle.this.isSecondPhase()) {
                                summonedentity.m_8061_(equipmentslottype, new ItemStack((ItemLike)Items.f_42396_));
                            }
                            summonedentity.m_21409_(equipmentslottype, 0.0f);
                        }
                        summonedentity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, Integer.MAX_VALUE, 1, false, false));
                        summonedentity.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                        summonedentity.m_6710_(livingentity);
                        SummonCircle summonCircle = new SummonCircle((Level)serverLevel, blockpos, (Entity)summonedentity, false, true, (LivingEntity)Apostle.this);
                        serverLevel.m_7967_((Entity)summonCircle);
                    } else if (serverLevel.m_46472_() == Level.f_46429_) {
                        for (int p = 0; p < 3 + randomSource.m_188503_(6); ++p) {
                            int k = (12 + randomSource.m_188503_(12)) * (randomSource.m_188499_() ? -1 : 1);
                            int l = (12 + randomSource.m_188503_(12)) * (randomSource.m_188499_() ? -1 : 1);
                            BlockPos.MutableBlockPos blockpos$mutable = Apostle.this.m_20183_().m_122032_().m_122184_(k, 0, l);
                            blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + randomSource.m_188503_(5) - randomSource.m_188503_(5));
                            blockpos$mutable.m_142448_((int)BlockFinder.moveDownToGround((Entity)Apostle.this));
                            blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + randomSource.m_188503_(5) - randomSource.m_188503_(5));
                            ZPiglinServant summonedentity = new ZPiglinServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.ZPIGLIN_SERVANT.get()), Apostle.this.f_19853_);
                            if (Apostle.this.isSecondPhase()) {
                                summonedentity = new ZPiglinBruteServant((EntityType<? extends ZPiglinServant>)((EntityType)ModEntityType.ZPIGLIN_BRUTE_SERVANT.get()), Apostle.this.f_19853_);
                            }
                            summonedentity.m_20035_((BlockPos)blockpos$mutable, 0.0f, 0.0f);
                            summonedentity.setTrueOwner((LivingEntity)Apostle.this);
                            summonedentity.setLimitedLife(60 * (90 + serverLevel.f_46441_.m_188503_(180)));
                            summonedentity.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_((BlockPos)blockpos$mutable), MobSpawnType.MOB_SUMMONED, null, null);
                            summonedentity.m_6710_(livingentity);
                            SummonCircle summonCircle = new SummonCircle((Level)serverLevel, (BlockPos)blockpos$mutable, (Entity)summonedentity, false, true, (LivingEntity)Apostle.this);
                            serverLevel.m_7967_((Entity)summonCircle);
                        }
                    } else {
                        int k = (12 + randomSource.m_188503_(12)) * (randomSource.m_188499_() ? -1 : 1);
                        int l = (12 + randomSource.m_188503_(12)) * (randomSource.m_188499_() ? -1 : 1);
                        BlockPos.MutableBlockPos blockpos$mutable = Apostle.this.m_20183_().m_122032_().m_122184_(k, 0, l);
                        blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + randomSource.m_188503_(5) - randomSource.m_188503_(5));
                        blockpos$mutable.m_142448_((int)BlockFinder.moveDownToGround((Entity)Apostle.this));
                        blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + randomSource.m_188503_(5) - randomSource.m_188503_(5));
                        ObsidianMonolith summonedentity = new ObsidianMonolith((EntityType<? extends AbstractMonolith>)((EntityType)ModEntityType.OBSIDIAN_MONOLITH.get()), Apostle.this.f_19853_);
                        summonedentity.m_20035_((BlockPos)blockpos$mutable, 0.0f, 0.0f);
                        summonedentity.setTrueOwner((LivingEntity)Apostle.this);
                        summonedentity.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_((BlockPos)blockpos$mutable), MobSpawnType.MOB_SUMMONED, null, null);
                        serverLevel.m_7967_((Entity)summonedentity);
                    }
                    Apostle.this.postSpellCast();
                }
            }
        }

        @Nullable
        public Item netheriteArmor(EquipmentSlot pSlot) {
            return switch (pSlot) {
                case EquipmentSlot.HEAD -> Items.f_42480_;
                case EquipmentSlot.CHEST -> Items.f_42481_;
                case EquipmentSlot.LEGS -> Items.f_42482_;
                case EquipmentSlot.FEET -> Items.f_42483_;
                default -> null;
            };
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.APOSTLE_PREPARE_SUMMON.get();
        }

        @Override
        protected SpellCastingCultist.SpellType getSpellType() {
            return SpellCastingCultist.SpellType.ZOMBIE;
        }
    }

    class FireRainSpellGoal
    extends CastingGoal {
        private FireRainSpellGoal() {
        }

        @Override
        public boolean m_8036_() {
            int i = Apostle.this.f_19853_.m_6443_(Owned.class, Apostle.this.m_20191_().m_82400_(64.0), Apostle.this.ZOMBIE_MINIONS).size();
            int i2 = Apostle.this.f_19853_.m_6443_(AbstractTrap.class, Apostle.this.m_20191_().m_82400_(64.0), Apostle.this.OWNED_TRAPS).size();
            if (!super.m_8036_()) {
                return false;
            }
            int cool = Apostle.this.spellStart();
            return Apostle.this.getCoolDown() >= cool && Apostle.this.getSpellCycle() == 2 && !Apostle.this.isSettingUpSecond() && i > 4 && i2 < 2;
        }

        @Override
        protected int getCastingTime() {
            return 20;
        }

        @Override
        public void castSpell() {
            LivingEntity livingentity;
            if (!Apostle.this.f_19853_.f_46443_ && (livingentity = Apostle.this.m_5448_()) != null) {
                BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                while (blockpos$mutable.m_123342_() > 0 && !Apostle.this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_280555_()) {
                    blockpos$mutable.m_122173_(Direction.DOWN);
                }
                if (Apostle.this.isSecondPhase()) {
                    ArrowRainTrap fireRainTrap = new ArrowRainTrap(Apostle.this.f_19853_, blockpos$mutable.m_123341_(), blockpos$mutable.m_123342_() + 1, blockpos$mutable.m_123343_());
                    fireRainTrap.setOwner((LivingEntity)Apostle.this);
                    fireRainTrap.setDuration(100);
                    Apostle.this.f_19853_.m_7967_((Entity)fireRainTrap);
                } else {
                    FireRainTrap fireRainTrap = new FireRainTrap(Apostle.this.f_19853_, blockpos$mutable.m_123341_(), blockpos$mutable.m_123342_() + 1, blockpos$mutable.m_123343_());
                    fireRainTrap.setOwner((LivingEntity)Apostle.this);
                    fireRainTrap.setDuration(1200);
                    Apostle.this.f_19853_.m_7967_((Entity)fireRainTrap);
                }
                Apostle.this.postSpellCast();
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.APOSTLE_PREPARE_SUMMON.get();
        }

        @Override
        protected SpellCastingCultist.SpellType getSpellType() {
            return SpellCastingCultist.SpellType.FIRE;
        }
    }

    class RangedSummonSpellGoal
    extends CastingGoal {
        private RangedSummonSpellGoal() {
        }

        @Override
        public boolean m_8036_() {
            int i = Apostle.this.f_19853_.m_6443_(Owned.class, Apostle.this.m_20191_().m_82400_(64.0), Apostle.this.RANGED_MINIONS).size();
            if (!super.m_8036_()) {
                return false;
            }
            int cool = Apostle.this.spellStart();
            return Apostle.this.getCoolDown() >= cool && Apostle.this.getSpellCycle() == 3 && !Apostle.this.isSettingUpSecond() && i < 2;
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        public void castSpell() {
            if (!Apostle.this.f_19853_.f_46443_) {
                ServerLevel serverLevel = (ServerLevel)Apostle.this.f_19853_;
                LivingEntity livingentity = Apostle.this.m_5448_();
                RandomSource r = Apostle.this.f_19796_;
                if (livingentity != null) {
                    if (r.m_188499_()) {
                        if (Apostle.this.isSecondPhase()) {
                            int k = (12 + r.m_188503_(12)) * (r.m_188499_() ? -1 : 1);
                            int l = (12 + r.m_188503_(12)) * (r.m_188499_() ? -1 : 1);
                            BlockPos.MutableBlockPos blockpos$mutable = Apostle.this.m_20183_().m_122032_().m_122184_(k, 0, l);
                            blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + r.m_188503_(5) - r.m_188503_(5));
                            blockpos$mutable.m_142448_((int)BlockFinder.moveDownToGround((Entity)Apostle.this));
                            blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + r.m_188503_(5) - r.m_188503_(5));
                            Malghast summonedentity = new Malghast((EntityType<? extends OwnedFlying>)((EntityType)ModEntityType.MALGHAST.get()), Apostle.this.f_19853_);
                            if (serverLevel.m_45756_((Entity)summonedentity, summonedentity.m_20191_().m_82338_(blockpos$mutable.m_6630_(2)).m_82400_(0.25))) {
                                summonedentity.m_6034_(blockpos$mutable.m_123341_(), blockpos$mutable.m_123342_() + 2, blockpos$mutable.m_123343_());
                            } else {
                                blockpos$mutable = Apostle.this.m_20183_().m_122032_();
                                summonedentity.m_6034_(blockpos$mutable.m_123341_(), blockpos$mutable.m_123342_() + 2, blockpos$mutable.m_123343_());
                            }
                            summonedentity.setTrueOwner((LivingEntity)Apostle.this);
                            summonedentity.setLimitedLife(60 * (90 + Apostle.this.f_19853_.f_46441_.m_188503_(180)));
                            summonedentity.m_6518_((ServerLevelAccessor)serverLevel, Apostle.this.f_19853_.m_6436_(blockpos$mutable.m_6630_(2)), MobSpawnType.MOB_SUMMONED, null, null);
                            summonedentity.m_6710_(livingentity);
                            SummonCircle summonCircle = new SummonCircle(Apostle.this.f_19853_, (BlockPos)blockpos$mutable, (Entity)summonedentity, false, false, (LivingEntity)Apostle.this);
                            Apostle.this.f_19853_.m_7967_((Entity)summonCircle);
                        } else {
                            BlockPos blockpos = Apostle.this.m_20183_();
                            Inferno summonedentity = new Inferno((EntityType<? extends Owned>)((EntityType)ModEntityType.INFERNO.get()), Apostle.this.f_19853_);
                            summonedentity.m_20035_(blockpos, 0.0f, 0.0f);
                            summonedentity.setTrueOwner((LivingEntity)Apostle.this);
                            summonedentity.setLimitedLife(60 * (90 + Apostle.this.f_19853_.f_46441_.m_188503_(180)));
                            summonedentity.setUpgraded(true);
                            summonedentity.m_6518_((ServerLevelAccessor)serverLevel, Apostle.this.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                            summonedentity.m_6710_(livingentity);
                            SummonCircle summonCircle = new SummonCircle(Apostle.this.f_19853_, blockpos, (Entity)summonedentity, false, true, (LivingEntity)Apostle.this);
                            Apostle.this.f_19853_.m_7967_((Entity)summonCircle);
                        }
                    } else {
                        int p0 = serverLevel.m_46472_() == Level.f_46429_ ? 2 : 1;
                        for (int p = 0; p < p0 + r.m_188503_(1 + p0); ++p) {
                            int k = (12 + r.m_188503_(12)) * (r.m_188499_() ? -1 : 1);
                            int l = (12 + r.m_188503_(12)) * (r.m_188499_() ? -1 : 1);
                            BlockPos.MutableBlockPos blockpos$mutable = Apostle.this.m_20183_().m_122032_().m_122184_(k, 0, l);
                            blockpos$mutable.m_142451_(blockpos$mutable.m_123341_() + r.m_188503_(5) - r.m_188503_(5));
                            blockpos$mutable.m_142448_((int)BlockFinder.moveDownToGround((Entity)Apostle.this));
                            blockpos$mutable.m_142443_(blockpos$mutable.m_123343_() + r.m_188503_(5) - r.m_188503_(5));
                            Inferno summonedentity = new Inferno((EntityType<? extends Owned>)((EntityType)ModEntityType.INFERNO.get()), Apostle.this.f_19853_);
                            summonedentity.m_20035_((BlockPos)blockpos$mutable, 0.0f, 0.0f);
                            summonedentity.setTrueOwner((LivingEntity)Apostle.this);
                            summonedentity.setLimitedLife(60 * (90 + Apostle.this.f_19853_.f_46441_.m_188503_(180)));
                            summonedentity.m_6518_((ServerLevelAccessor)serverLevel, Apostle.this.f_19853_.m_6436_((BlockPos)blockpos$mutable), MobSpawnType.MOB_SUMMONED, null, null);
                            summonedentity.m_6710_(livingentity);
                            SummonCircle summonCircle = new SummonCircle(Apostle.this.f_19853_, (BlockPos)blockpos$mutable, (Entity)summonedentity, false, true, (LivingEntity)Apostle.this);
                            Apostle.this.f_19853_.m_7967_((Entity)summonCircle);
                        }
                    }
                    Apostle.this.postSpellCast();
                }
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.APOSTLE_PREPARE_SUMMON.get();
        }

        @Override
        protected SpellCastingCultist.SpellType getSpellType() {
            return SpellCastingCultist.SpellType.RANGED;
        }
    }

    class FireTornadoSpellGoal
    extends CastingGoal {
        private FireTornadoSpellGoal() {
        }

        @Override
        public boolean m_8036_() {
            int i = Apostle.this.f_19853_.m_6443_(Owned.class, Apostle.this.m_20191_().m_82400_(64.0), Apostle.this.RANGED_MINIONS).size();
            int i2 = Apostle.this.f_19853_.m_45976_(FireTornado.class, Apostle.this.m_20191_().m_82400_(64.0)).size();
            int cool = Apostle.this.spellStart();
            if (!super.m_8036_()) {
                return false;
            }
            if (Apostle.this.isSettingUpSecond()) {
                return false;
            }
            if (Apostle.this.getHitTimes() >= 6) {
                return i2 < 1;
            }
            return Apostle.this.getCoolDown() >= cool && Apostle.this.getTornadoCoolDown() <= 0 && Apostle.this.getSpellCycle() == 3 && i >= 2 && i2 < 1;
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        public void castSpell() {
            LivingEntity livingentity;
            if (!Apostle.this.f_19853_.f_46443_ && (livingentity = Apostle.this.m_5448_()) != null) {
                BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                while (blockpos$mutable.m_123342_() > 0 && !Apostle.this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_280555_()) {
                    blockpos$mutable.m_122173_(Direction.DOWN);
                }
                FireTornadoTrap fireTornadoTrapEntity = new FireTornadoTrap((EntityType)ModEntityType.FIRE_TORNADO_TRAP.get(), Apostle.this.f_19853_);
                fireTornadoTrapEntity.m_6034_(blockpos$mutable.m_123341_(), blockpos$mutable.m_123342_() + 1, blockpos$mutable.m_123343_());
                fireTornadoTrapEntity.setOwner((LivingEntity)Apostle.this);
                fireTornadoTrapEntity.setDuration(60);
                Apostle.this.f_19853_.m_7967_((Entity)fireTornadoTrapEntity);
                Apostle.this.postSpellCast();
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.APOSTLE_PREPARE_SUMMON.get();
        }

        @Override
        protected SpellCastingCultist.SpellType getSpellType() {
            return SpellCastingCultist.SpellType.TORNADO;
        }
    }

    class RoarSpellGoal
    extends CastingGoal {
        private RoarSpellGoal() {
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            if (Apostle.this.m_5448_() == null) {
                return false;
            }
            return Apostle.this.m_20270_((Entity)Apostle.this.m_5448_()) < 4.0f && !Apostle.this.isSettingUpSecond();
        }

        @Override
        protected int getCastingTime() {
            return 200;
        }

        @Override
        protected int getCastingInterval() {
            return 120;
        }

        @Override
        public void castSpell() {
            Apostle apostle = Apostle.this;
            apostle.resetHitTime();
            if (!apostle.isSecondPhase()) {
                apostle.setFiring(true);
                apostle.coolDown = 0;
                apostle.m_5496_((SoundEvent)ModSounds.ROAR_SPELL.get(), 1.0f, 1.0f);
            } else {
                float f2;
                int k;
                double d0 = Math.min(apostle.m_5448_().m_20186_(), apostle.m_20186_());
                double d1 = Math.max(apostle.m_5448_().m_20186_(), apostle.m_20186_()) + 1.0;
                for (int i = 0; i < 5; ++i) {
                    float f1 = (float)Apostle.this.f + (float)i * (float)Math.PI * 0.4f;
                    this.spawnBlasts((LivingEntity)apostle, apostle.m_20185_() + (double)Mth.m_14089_((float)f1) * 1.5, apostle.m_20189_() + (double)Mth.m_14031_((float)f1) * 1.5, d0, d1);
                }
                for (k = 0; k < 8; ++k) {
                    f2 = (float)Apostle.this.f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.spawnBlasts((LivingEntity)apostle, apostle.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, apostle.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, d0, d1);
                }
                if (apostle.m_21223_() < apostle.m_21233_() / 2.0f) {
                    for (k = 0; k < 11; ++k) {
                        f2 = (float)Apostle.this.f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                        this.spawnBlasts((LivingEntity)apostle, apostle.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, apostle.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, d0, d1);
                    }
                }
                if (apostle.m_21223_() < apostle.m_21233_() / 4.0f) {
                    for (k = 0; k < 14; ++k) {
                        f2 = (float)Apostle.this.f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                        this.spawnBlasts((LivingEntity)apostle, apostle.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, apostle.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, d0, d1);
                    }
                }
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.APOSTLE_PREPARE_SPELL.get();
        }

        @Override
        protected SpellCastingCultist.SpellType getSpellType() {
            return SpellCastingCultist.SpellType.ROAR;
        }

        public void spawnBlasts(LivingEntity livingEntity, double pPosX, double pPosZ, double PPPosY, double pOPosY) {
            BlockPos blockpos = BlockPos.m_274561_((double)pPosX, (double)pOPosY, (double)pPosZ);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = livingEntity.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)livingEntity.f_19853_, blockpos1, Direction.UP)) continue;
                if (!livingEntity.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = livingEntity.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)livingEntity.f_19853_, blockpos)).m_83281_()) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)PPPosY) - 1);
            if (flag) {
                FireBlastTrap fireBlastTrap = new FireBlastTrap(livingEntity.f_19853_, pPosX, (double)blockpos.m_123342_() + d0, pPosZ);
                fireBlastTrap.setOwner(livingEntity);
                livingEntity.f_19853_.m_7967_((Entity)fireBlastTrap);
            }
        }
    }

    static class ApostlePathNavigation
    extends GroundPathNavigation {
        ApostlePathNavigation(Apostle p_33969_, Level p_33970_) {
            super((Mob)p_33969_, p_33970_);
        }

        protected PathFinder m_5532_(int p_33972_) {
            this.f_26508_ = new WalkNodeEvaluator();
            this.f_26508_.m_77351_(true);
            return new PathFinder(this.f_26508_, p_33972_);
        }

        protected boolean m_7367_(BlockPathTypes p_33974_) {
            return p_33974_ == BlockPathTypes.LAVA || p_33974_ == BlockPathTypes.DAMAGE_FIRE || p_33974_ == BlockPathTypes.DANGER_FIRE || super.m_7367_(p_33974_);
        }

        public boolean m_6342_(BlockPos p_33976_) {
            return this.f_26495_.m_8055_(p_33976_).m_60713_(Blocks.f_49991_) || super.m_6342_(p_33976_);
        }
    }

    abstract class CastingGoal
    extends SpellCastingCultist.UseSpellGoal {
        CastingGoal() {
            super(Apostle.this);
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_() && !Apostle.this.isSettingUpSecond();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            Apostle.this.setCasting(true);
        }

        public void m_8041_() {
            super.m_8041_();
            Apostle.this.setCasting(false);
        }

        @Override
        protected int getCastingInterval() {
            return 0;
        }
    }
}

