/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead.zombie;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.NeutralZombieAttackGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieServant;
import com.Polarice3.Goety.common.entities.neutral.IRavager;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class ZombieVindicator
extends ZombieServant {
    public ZombieVindicator(EntityType<? extends ZombieServant> type, Level worldIn) {
        super((EntityType<? extends Summoned>)type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new ModMeleeAttackGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new Summoned.WanderGoal(this, 1.0, 10.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    @Override
    public void targetSelectGoal() {
        super.targetSelectGoal();
        this.f_21346_.m_25352_(1, new Summoned.NaturalAttackGoal<AbstractVillager>(this, AbstractVillager.class));
        this.f_21346_.m_25352_(1, new Summoned.NaturalAttackGoal<IronGolem>(this, IronGolem.class));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.ZombieVindicatorHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.ZombieVindicatorDamage.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.ZombieVindicatorArmor.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.ZombieVindicatorHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.ZombieVindicatorArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.ZombieVindicatorDamage.get());
    }

    @Override
    public boolean isUnderWaterConverting() {
        return false;
    }

    @Override
    public boolean m_6162_() {
        return false;
    }

    @Override
    public void m_6863_(boolean pChildZombie) {
    }

    @Override
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12615_;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12646_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12645_;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundEvents.f_12647_;
    }

    @Override
    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    protected boolean convertsInWater() {
        return false;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34088_, DifficultyInstance p_34089_, MobSpawnType p_34090_, @Nullable SpawnGroupData p_34091_, @Nullable CompoundTag p_34092_) {
        SpawnGroupData spawngroupdata = super.m_6518_(p_34088_, p_34089_, p_34090_, p_34091_, p_34092_);
        if (this.isNatural()) {
            this.setHostile(true);
        }
        return spawngroupdata;
    }

    @Override
    protected void handleAttributes(float difficulty) {
        Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22125_(new AttributeModifier("random spawn bonus", this.f_19796_.m_188500_() * (double)0.05f, AttributeModifier.Operation.ADDITION));
        double d0 = this.f_19796_.m_188500_() * 1.5 * (double)difficulty;
        if (d0 > 1.0) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22277_)).m_22125_(new AttributeModifier("random zombie-spawn bonus", d0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    @Override
    protected void m_213945_(RandomSource p_219149_, DifficultyInstance p_219150_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42386_));
    }

    @Override
    public boolean m_214076_(ServerLevel world, LivingEntity killedEntity) {
        boolean flag = super.m_214076_(world, killedEntity);
        float random = this.f_19853_.f_46441_.m_188501_();
        if (this.isUpgraded() && killedEntity instanceof Vindicator) {
            EntityType entityType;
            ZombieVindicator zombieVindicator;
            Vindicator vindicator = (Vindicator)killedEntity;
            if (random <= 0.5f && ForgeEventFactory.canLivingConvert((LivingEntity)killedEntity, (EntityType)((EntityType)ModEntityType.ZOMBIE_VINDICATOR.get()), timer -> {}) && (zombieVindicator = (ZombieVindicator)vindicator.m_21406_(entityType = (EntityType)ModEntityType.ZOMBIE_VINDICATOR.get(), false)) != null) {
                zombieVindicator.m_6518_((ServerLevelAccessor)world, this.f_19853_.m_6436_(zombieVindicator.m_20183_()), MobSpawnType.CONVERSION, null, null);
                zombieVindicator.setLimitedLife(10 * (15 + this.f_19853_.f_46441_.m_188503_(45)));
                if (this.getTrueOwner() != null) {
                    zombieVindicator.setTrueOwner(this.getTrueOwner());
                }
                ForgeEventFactory.onLivingConvert((LivingEntity)killedEntity, (LivingEntity)zombieVindicator);
                if (!this.m_20067_()) {
                    world.m_5898_((Player)null, 1026, this.m_20183_(), 0);
                }
            }
        }
        return flag;
    }

    static class ModMeleeAttackGoal
    extends NeutralZombieAttackGoal {
        public ModMeleeAttackGoal(ZombieVindicator p_34123_) {
            super(p_34123_, 1.0, false);
        }

        protected double m_6639_(LivingEntity p_34125_) {
            if (this.f_25540_.m_20202_() instanceof IRavager) {
                float f = this.f_25540_.m_20202_().m_20205_() - 0.1f;
                return f * 2.0f * f * 2.0f + p_34125_.m_20205_();
            }
            return super.m_6639_(p_34125_);
        }
    }
}

