/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead.zombie;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.MobsConfig;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.NeutralZombieAttackGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.DrownedServant;
import com.Polarice3.Goety.common.items.magic.DarkWand;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;

public class ZombieServant
extends Summoned {
    private static final UUID SPEED_MODIFIER_BABY_UUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_UUID, "Baby speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.m_135353_(ZombieServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_DROWNED_CONVERSION_ID = SynchedEntityData.m_135353_(ZombieServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int inWaterTime;
    private int conversionTime;

    public ZombieServant(EntityType<? extends Summoned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected boolean isSunSensitive() {
        return true;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new NeutralZombieAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new Summoned.WanderGoal(this, 1.0, 10.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.ZombieServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.ZombieServantDamage.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.ZombieServantArmor.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.ZombieServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.ZombieServantArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.ZombieServantDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_BABY_ID, (Object)false);
        this.m_20088_().m_135372_(DATA_DROWNED_CONVERSION_ID, (Object)false);
    }

    public boolean isUnderWaterConverting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_DROWNED_CONVERSION_ID);
    }

    public boolean m_6162_() {
        return (Boolean)this.m_20088_().m_135370_(DATA_BABY_ID);
    }

    public void m_6863_(boolean pChildZombie) {
        this.m_20088_().m_135381_(DATA_BABY_ID, (Object)pChildZombie);
        if (this.f_19853_ != null && !this.f_19853_.f_46443_) {
            AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
            modifiableattributeinstance.m_22130_(SPEED_MODIFIER_BABY);
            if (pChildZombie) {
                modifiableattributeinstance.m_22118_(SPEED_MODIFIER_BABY);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_BABY_ID.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsBaby", this.m_6162_());
        pCompound.m_128405_("InWaterTime", this.m_20069_() ? this.inWaterTime : -1);
        pCompound.m_128405_("DrownedConversionTime", this.isUnderWaterConverting() ? this.conversionTime : -1);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_6863_(pCompound.m_128471_("IsBaby"));
        this.inWaterTime = pCompound.m_128451_("InWaterTime");
        if (pCompound.m_128425_("DrownedConversionTime", 99) && pCompound.m_128451_("DrownedConversionTime") > -1) {
            this.startUnderWaterConversion(pCompound.m_128451_("DrownedConversionTime"));
        }
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return this.m_6162_() ? 0.93f : 1.74f;
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.45;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12598_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12608_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12603_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected boolean convertsInWater() {
        return true;
    }

    @Override
    public void m_8119_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && !this.m_21525_()) {
            if (this.isUnderWaterConverting()) {
                --this.conversionTime;
                if (this.conversionTime < 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)((EntityType)ModEntityType.ZOMBIE_SERVANT.get()), timer -> {
                    this.conversionTime = timer;
                })) {
                    this.doUnderWaterConversion();
                }
            } else if (this.convertsInWater()) {
                if (this.m_204029_(FluidTags.f_13131_)) {
                    ++this.inWaterTime;
                    if (this.inWaterTime >= 600) {
                        this.startUnderWaterConversion(300);
                    }
                } else {
                    this.inWaterTime = -1;
                }
            }
        }
        super.m_8119_();
    }

    protected void m_213945_(RandomSource p_217055_, DifficultyInstance difficulty) {
        super.m_213945_(p_217055_, difficulty);
        float f = this.f_19796_.m_188501_();
        float f2 = this.isUpgraded() ? 0.05f : 0.01f;
        if (f < f2) {
            int i = this.f_19796_.m_188503_(3);
            if (i == 0) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42384_));
            }
        }
    }

    @Override
    public EntityType<?> getVariant(Level level, BlockPos blockPos) {
        EntityType entityType = (EntityType)ModEntityType.ZOMBIE_SERVANT.get();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.m_46801_(blockPos)) {
                entityType = (EntityType)ModEntityType.DROWNED_SERVANT.get();
            } else if (level.m_204166_(blockPos).m_203656_(Tags.Biomes.IS_DESERT) && level.m_45527_(blockPos)) {
                entityType = (EntityType)ModEntityType.HUSK_SERVANT.get();
            } else if (level.m_46472_() == Level.f_46429_) {
                EntityType entityType1 = (EntityType)ModEntityType.ZPIGLIN_SERVANT.get();
                if (level.f_46441_.m_188501_() <= 0.25f && BlockFinder.findStructure(serverLevel, blockPos, (ResourceKey<Structure>)BuiltinStructures.f_209863_)) {
                    entityType1 = (EntityType)ModEntityType.ZPIGLIN_BRUTE_SERVANT.get();
                }
                entityType = entityType1;
            } else if (BlockFinder.findStructure(serverLevel, blockPos, (TagKey<Structure>)StructureTags.f_215884_)) {
                entityType = (EntityType)ModEntityType.ZOMBIE_VINDICATOR.get();
            } else if (((Biome)level.m_204166_(blockPos).get()).m_198904_(blockPos)) {
                entityType = (EntityType)ModEntityType.FROZEN_ZOMBIE_SERVANT.get();
            } else if (level.m_204166_(blockPos).m_203656_(BiomeTags.f_207610_) && level.f_46441_.m_188499_()) {
                entityType = (EntityType)ModEntityType.JUNGLE_ZOMBIE_SERVANT.get();
            }
        }
        return entityType;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        float f = difficultyIn.m_19057_();
        if (this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31 && this.f_19796_.m_188501_() < 0.25f) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(this.f_19796_.m_188501_() < 0.1f ? Blocks.f_50144_ : Blocks.f_50143_)));
                this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 0.0f;
            }
        }
        this.m_213945_(worldIn.m_213780_(), difficultyIn);
        this.m_213946_(worldIn.m_213780_(), difficultyIn);
        this.handleAttributes(f);
        this.m_6863_(ZombieServant.getSpawnAsBabyOdds(worldIn.m_213780_()));
        return spawnDataIn;
    }

    public static boolean getSpawnAsBabyOdds(RandomSource p_219163_) {
        return (double)p_219163_.m_188501_() < (Double)MobsConfig.ZombieServantBabyChance.get();
    }

    protected void handleAttributes(float difficulty) {
        Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22125_(new AttributeModifier("random spawn bonus", this.f_19796_.m_188500_() * (double)0.05f, AttributeModifier.Operation.ADDITION));
        double d0 = this.f_19796_.m_188500_() * 1.5 * (double)difficulty;
        if (d0 > 1.0) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22277_)).m_22125_(new AttributeModifier("random zombie-spawn bonus", d0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    public boolean m_214076_(ServerLevel world, LivingEntity killedEntity) {
        boolean flag = super.m_214076_(world, killedEntity);
        float random = this.f_19853_.f_46441_.m_188501_();
        if (this.isUpgraded() && killedEntity instanceof Zombie) {
            Zombie zombieEntity = (Zombie)killedEntity;
            if (random <= 0.5f && ForgeEventFactory.canLivingConvert((LivingEntity)killedEntity, (EntityType)((EntityType)ModEntityType.ZOMBIE_SERVANT.get()), timer -> {})) {
                EntityType entityType = (EntityType)ModEntityType.ZOMBIE_SERVANT.get();
                if (zombieEntity instanceof Husk) {
                    entityType = (EntityType)ModEntityType.HUSK_SERVANT.get();
                } else if (zombieEntity instanceof Drowned) {
                    entityType = (EntityType)ModEntityType.DROWNED_SERVANT.get();
                }
                ZombieServant zombieMinionEntity = (ZombieServant)zombieEntity.m_21406_(entityType, false);
                if (zombieMinionEntity != null) {
                    zombieMinionEntity.m_6518_((ServerLevelAccessor)world, this.f_19853_.m_6436_(zombieMinionEntity.m_20183_()), MobSpawnType.CONVERSION, null, null);
                    zombieMinionEntity.setLimitedLife(10 * (15 + this.f_19853_.f_46441_.m_188503_(45)));
                    if (this.getTrueOwner() != null) {
                        zombieMinionEntity.setTrueOwner(this.getTrueOwner());
                    }
                    ForgeEventFactory.onLivingConvert((LivingEntity)killedEntity, (LivingEntity)zombieMinionEntity);
                    if (!this.m_20067_()) {
                        world.m_5898_((Player)null, 1026, this.m_20183_(), 0);
                    }
                }
            }
        }
        return flag;
    }

    private void startUnderWaterConversion(int p_204704_1_) {
        this.conversionTime = p_204704_1_;
        this.m_20088_().m_135381_(DATA_DROWNED_CONVERSION_ID, (Object)true);
    }

    protected void doUnderWaterConversion() {
        this.convertToZombieType((EntityType<? extends ZombieServant>)((EntityType)ModEntityType.DROWNED_SERVANT.get()));
        if (!this.m_20067_()) {
            this.f_19853_.m_5898_((Player)null, 1040, this.m_20183_(), 0);
        }
    }

    protected void convertToZombieType(EntityType<? extends ZombieServant> p_234341_1_) {
        ZombieServant zombieentity = (ZombieServant)this.m_21406_(p_234341_1_, true);
        if (zombieentity != null) {
            zombieentity.handleAttributes(zombieentity.f_19853_.m_6436_(zombieentity.m_20183_()).m_19057_());
            if (this.getTrueOwner() != null) {
                zombieentity.setTrueOwner(this.getTrueOwner());
            }
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)zombieentity);
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
            Item item = itemstack.m_41720_();
            ItemStack itemstack2 = this.m_21205_();
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
                if (item == Items.f_42583_ && this.m_21223_() < this.m_21233_()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                    this.m_5634_(2.0f);
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.HEAL_EFFECT.get(), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                    }
                    return InteractionResult.CONSUME;
                }
                if (!(pPlayer.m_21206_().m_41720_() instanceof DarkWand)) {
                    if (item instanceof SwordItem) {
                        this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                        this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41777_());
                        this.dropEquipment(EquipmentSlot.MAINHAND, itemstack2);
                        this.m_21508_(EquipmentSlot.MAINHAND);
                        for (int i = 0; i < 7; ++i) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                        }
                        if (!pPlayer.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        EntityFinder.sendEntityUpdatePacket(pPlayer, (LivingEntity)this);
                        return InteractionResult.CONSUME;
                    }
                    if (item instanceof AxeItem) {
                        this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                        this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41777_());
                        this.dropEquipment(EquipmentSlot.MAINHAND, itemstack2);
                        this.m_21508_(EquipmentSlot.MAINHAND);
                        for (int i = 0; i < 7; ++i) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                        }
                        if (!pPlayer.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        EntityFinder.sendEntityUpdatePacket(pPlayer, (LivingEntity)this);
                        return InteractionResult.CONSUME;
                    }
                    if (item instanceof TridentItem && this instanceof DrownedServant) {
                        this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                        this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41777_());
                        this.dropEquipment(EquipmentSlot.MAINHAND, itemstack2);
                        this.m_21508_(EquipmentSlot.MAINHAND);
                        for (int i = 0; i < 7; ++i) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                        }
                        if (!pPlayer.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        EntityFinder.sendEntityUpdatePacket(pPlayer, (LivingEntity)this);
                        return InteractionResult.CONSUME;
                    }
                }
                if (item instanceof ArmorItem) {
                    ItemStack helmet = this.m_6844_(EquipmentSlot.HEAD);
                    ItemStack chestplate = this.m_6844_(EquipmentSlot.CHEST);
                    ItemStack legging = this.m_6844_(EquipmentSlot.LEGS);
                    ItemStack boots = this.m_6844_(EquipmentSlot.FEET);
                    this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                    if (((ArmorItem)item).m_266204_() == ArmorItem.Type.HELMET) {
                        this.m_8061_(EquipmentSlot.HEAD, itemstack.m_41777_());
                        this.dropEquipment(EquipmentSlot.HEAD, helmet);
                        this.m_21508_(EquipmentSlot.HEAD);
                    }
                    if (((ArmorItem)item).m_266204_() == ArmorItem.Type.CHESTPLATE) {
                        this.m_8061_(EquipmentSlot.CHEST, itemstack.m_41777_());
                        this.dropEquipment(EquipmentSlot.CHEST, chestplate);
                        this.m_21508_(EquipmentSlot.CHEST);
                    }
                    if (((ArmorItem)item).m_266204_() == ArmorItem.Type.LEGGINGS) {
                        this.m_8061_(EquipmentSlot.LEGS, itemstack.m_41777_());
                        this.dropEquipment(EquipmentSlot.LEGS, legging);
                        this.m_21508_(EquipmentSlot.LEGS);
                    }
                    if (((ArmorItem)item).m_266204_() == ArmorItem.Type.BOOTS) {
                        this.m_8061_(EquipmentSlot.FEET, itemstack.m_41777_());
                        this.dropEquipment(EquipmentSlot.FEET, boots);
                        this.m_21508_(EquipmentSlot.FEET);
                    }
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                    }
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    EntityFinder.sendEntityUpdatePacket(pPlayer, (LivingEntity)this);
                    return InteractionResult.CONSUME;
                }
            }
        }
        return super.m_6071_(pPlayer, p_230254_2_);
    }
}

