/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.client.render.HauntedSkullTextures;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ai.SummonTargetGoal;
import com.Polarice3.Goety.common.entities.neutral.Minion;
import com.Polarice3.Goety.common.entities.projectiles.HauntedSkullProjectile;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.ExplosionUtil;
import com.Polarice3.Goety.utils.LootingExplosion;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class HauntedSkull
extends Minion {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(HauntedSkull.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int burning = 0;
    private float explosionPower = 1.0f;
    public boolean upgraded;

    public HauntedSkull(EntityType<? extends Minion> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new ChargeGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomMoveGoal());
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new SummonTargetGoal((Mob)this));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Creeper.class, true));
    }

    public ResourceLocation getResourceLocation() {
        return HauntedSkullTextures.TEXTURES.getOrDefault(this.getAnimation(), HauntedSkullTextures.TEXTURES.get(0));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22281_, ((Double)SpellConfig.HauntedSkullDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)SpellConfig.HauntedSkullDamage.get());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_20242_(true);
        if (this.f_19853_.f_46443_) {
            Vec3 vector3d = this.m_20184_();
            double d0 = this.m_20185_() + vector3d.f_82479_;
            double d1 = this.m_20186_() + vector3d.f_82480_;
            double d2 = this.m_20189_() + vector3d.f_82481_;
            SimpleParticleType particleData = ParticleTypes.f_123762_;
            if (this.isCharging()) {
                particleData = ParticleTypes.f_123745_;
                if (this.getAnimation() < 16) {
                    this.setAnimation(this.getAnimation() + 1);
                } else {
                    this.setAnimation(9);
                }
            } else if (this.getAnimation() < 8) {
                this.setAnimation(this.getAnimation() + 1);
            } else {
                this.setAnimation(1);
            }
            for (int j = 0; j < 2; ++j) {
                this.f_19853_.m_7106_((ParticleOptions)particleData, d0 + this.f_19796_.m_188583_() * (double)0.3f, d1 + this.f_19796_.m_188583_() * (double)0.3f, d2 + this.f_19796_.m_188583_() * (double)0.3f, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void lifeSpanDamage() {
        this.explode();
    }

    @Override
    public void m_6478_(MoverType typeIn, Vec3 pos) {
        super.m_6478_(typeIn, pos);
        this.m_20101_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag p_34008_) {
        super.m_7378_(p_34008_);
        this.setAnimation(p_34008_.m_128451_("Animation"));
        this.setBurning(p_34008_.m_128451_("Burning"));
        this.setExplosionPower(p_34008_.m_128457_("ExplosionPower"));
        this.setUpgraded(p_34008_.m_128471_("Upgraded"));
        if (p_34008_.m_128441_("Burning")) {
            this.burning = p_34008_.m_128451_("Burning");
        }
    }

    @Override
    public void m_7380_(CompoundTag p_34015_) {
        super.m_7380_(p_34015_);
        p_34015_.m_128405_("Animation", this.getAnimation());
        p_34015_.m_128405_("Burning", this.getBurning());
        p_34015_.m_128350_("ExplosionPower", this.getExplosionPower());
        p_34015_.m_128379_("Upgraded", this.isUpgraded());
    }

    public float getExplosionPower() {
        return this.explosionPower;
    }

    public void setExplosionPower(float explosionPower) {
        this.explosionPower = explosionPower;
    }

    public int getBurning() {
        return this.burning;
    }

    public void setBurning(int burning) {
        this.burning = burning;
    }

    public void explode() {
        float wanting;
        Player player;
        boolean loot = false;
        LivingEntity livingEntity = this.getTrueOwner();
        if (livingEntity instanceof Player && CuriosFinder.findRing(player = (Player)livingEntity).m_41720_() == ModItems.RING_OF_WANT.get() && CuriosFinder.findRing(player).m_41793_() && (wanting = (float)EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.WANTING.get()), (ItemStack)CuriosFinder.findRing(player))) > 0.0f) {
            loot = true;
        }
        LootingExplosion.Mode lootMode = loot ? LootingExplosion.Mode.LOOT : LootingExplosion.Mode.REGULAR;
        ExplosionUtil.lootExplode(this.f_19853_, (Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionPower, false, Explosion.BlockInteraction.KEEP, lootMode);
        this.m_146870_();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public int getAnimation() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    public void setAnimation(int pType) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)pType);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11936_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34002_, DifficultyInstance p_34003_, MobSpawnType p_34004_, @Nullable SpawnGroupData p_34005_, @Nullable CompoundTag p_34006_) {
        RandomSource randomsource = p_34002_.m_213780_();
        this.m_213945_(randomsource, p_34003_);
        this.m_213946_(randomsource, p_34003_);
        if (this.getTrueOwner() == null) {
            this.setBoundOrigin(this.m_20183_());
        }
        return super.m_6518_(p_34002_, p_34003_, p_34004_, p_34005_, p_34006_);
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public void setUpgraded(boolean upgraded) {
        this.upgraded = upgraded;
    }

    @Override
    public void playChargeCry() {
        this.m_5496_(SoundEvents.f_12558_, 1.0f, 1.0f);
    }

    @Override
    public float m_213856_() {
        return 1.0f;
    }

    public class ChargeGoal
    extends Goal {
        public ChargeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = HauntedSkull.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && HauntedSkull.this.m_142582_((Entity)livingentity) && !HauntedSkull.this.m_5830_() && !HauntedSkull.this.m_21566_().m_24995_();
        }

        public void m_8056_() {
            LivingEntity livingentity = HauntedSkull.this.m_5448_();
            if (livingentity != null) {
                double d4 = livingentity.m_20185_() - HauntedSkull.this.m_20185_();
                double d5 = livingentity.m_20189_() - HauntedSkull.this.m_20189_();
                HauntedSkull.this.m_146922_(-((float)Mth.m_14136_((double)d4, (double)d5)) * 57.295776f);
                HauntedSkull.this.f_20883_ = HauntedSkull.this.m_146908_();
            }
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = HauntedSkull.this.m_5448_();
            if (livingentity != null && HauntedSkull.this.f_19797_ % 20 == 0) {
                double d1 = livingentity.m_20185_() - HauntedSkull.this.m_20185_();
                double d2 = livingentity.m_20227_(0.5) - HauntedSkull.this.m_20227_(0.5);
                double d3 = livingentity.m_20189_() - HauntedSkull.this.m_20189_();
                HauntedSkullProjectile soulSkull = new HauntedSkullProjectile((LivingEntity)HauntedSkull.this, d1, d2, d3, HauntedSkull.this.f_19853_);
                if (HauntedSkull.this.getTrueOwner() != null) {
                    soulSkull.m_5602_((Entity)HauntedSkull.this.getTrueOwner());
                }
                soulSkull.m_6034_(soulSkull.m_20185_(), HauntedSkull.this.m_20227_(0.75), soulSkull.m_20189_());
                soulSkull.setDamage((float)HauntedSkull.this.m_21133_(Attributes.f_22281_));
                soulSkull.setUpgraded(HauntedSkull.this.isUpgraded());
                soulSkull.setBurning(HauntedSkull.this.getBurning());
                soulSkull.setExplosionPower(HauntedSkull.this.getExplosionPower());
                if (HauntedSkull.this.f_19853_.m_7967_((Entity)soulSkull)) {
                    HauntedSkull.this.playChargeCry();
                    HauntedSkull.this.m_146870_();
                }
            }
        }
    }

    public class RandomMoveGoal
    extends Goal {
        public RandomMoveGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !HauntedSkull.this.m_21566_().m_24995_() && HauntedSkull.this.f_19796_.m_188503_(RandomMoveGoal.m_186073_((int)7)) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = HauntedSkull.this.m_20183_();
            if (HauntedSkull.this.getTrueOwner() != null) {
                blockpos = BlockPos.m_274446_((Position)HauntedSkull.this.getTrueOwner().m_146892_());
            } else if (HauntedSkull.this.m_5448_() != null) {
                blockpos = BlockPos.m_274446_((Position)HauntedSkull.this.m_5448_().m_146892_());
            } else if (HauntedSkull.this.getBoundOrigin() != null) {
                blockpos = HauntedSkull.this.getBoundOrigin();
            }
            if (blockpos != null) {
                if (HauntedSkull.this.getTrueOwner() != null && (double)HauntedSkull.this.m_20270_((Entity)HauntedSkull.this.getTrueOwner()) > 8.0) {
                    blockpos = BlockPos.m_274446_((Position)HauntedSkull.this.getTrueOwner().m_146892_());
                    HauntedSkull.this.f_21342_.m_6849_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, 1.0);
                } else {
                    for (int i = 0; i < 3; ++i) {
                        BlockPos blockpos1 = blockpos.m_7918_(HauntedSkull.this.f_19796_.m_188503_(15) - 7, HauntedSkull.this.f_19796_.m_188503_(4) - 2, HauntedSkull.this.f_19796_.m_188503_(15) - 7);
                        if (!BlockFinder.isEmptyBox(HauntedSkull.this.f_19853_, blockpos1)) continue;
                        HauntedSkull.this.f_21342_.m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                        if (HauntedSkull.this.m_5448_() != null) break;
                        HauntedSkull.this.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                        break;
                    }
                }
            }
        }
    }
}

