/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.undead;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.client.particles.ShockwaveParticleOption;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.AbstractGolemServant;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.Haunt;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.HauntedSkullProjectile;
import com.Polarice3.Goety.common.entities.projectiles.SoulBomb;
import com.Polarice3.Goety.common.entities.util.SummonCircle;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class GraveGolem
extends AbstractGolemServant {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(GraveGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static float SUMMON_SECONDS_TIME = 4.7f;
    private int activateTick;
    public int attackTick;
    public int summonTick;
    private int summonCool;
    private int summonCount;
    public int belchCool;
    public int isSittingDown;
    public int isStandingUp;
    public float getGlow;
    public float deathRotation = 0.0f;
    public int deathTime = 0;
    public final SimpleContainer inventory = new SimpleContainer(50);
    public boolean hasInventory;
    public AnimationState activateAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState summonAnimationState = new AnimationState();
    public AnimationState toSitAnimationState = new AnimationState();
    public AnimationState toStandAnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();
    public AnimationState shootAnimationState = new AnimationState();
    public AnimationState belchAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();

    public GraveGolem(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new SummonGoal());
        this.f_21345_.m_25352_(2, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(3, (Goal)new GolemRangedGoal(this, 1.0, 32.0f));
        this.f_21345_.m_25352_(5, (Goal)new AttackGoal(1.0));
        this.f_21345_.m_25352_(8, (Goal)new Summoned.WanderGoal(this, 1.0, 10.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.GraveGolemHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.GraveGolemDamage.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.GraveGolemHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.GraveGolemDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.m_217003_(Pose.EMERGING) ? 1 : 0);
    }

    public void m_141965_(ClientboundAddEntityPacket p_219420_) {
        super.m_141965_(p_219420_);
        if (p_219420_.m_131509_() == 1) {
            this.m_20124_(Pose.EMERGING);
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (f_19806_.equals(p_219422_) && this.m_20089_() == Pose.EMERGING) {
            this.activateAnimationState.m_216977_(this.f_19797_);
        }
        super.m_7350_(p_219422_);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("ActivateTick", this.activateTick);
        pCompound.m_128405_("SummonTick", this.summonTick);
        pCompound.m_128405_("SummonCount", this.summonCount);
        pCompound.m_128405_("BelchCool", this.belchCool);
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            listnbt.add((Object)itemstack.m_41739_(new CompoundTag()));
        }
        pCompound.m_128365_("Inventory", (Tag)listnbt);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("ActivateTick")) {
            this.activateTick = pCompound.m_128451_("ActivateTick");
        }
        if (pCompound.m_128441_("SummonTick")) {
            this.summonTick = pCompound.m_128451_("SummonTick");
        }
        if (pCompound.m_128441_("SummonCount")) {
            this.summonCount = pCompound.m_128451_("SummonCount");
        }
        if (pCompound.m_128441_("BelchCool")) {
            this.belchCool = pCompound.m_128451_("BelchCool");
        }
        if (pCompound.m_128441_("Inventory")) {
            ListTag listnbt = pCompound.m_128437_("Inventory", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)listnbt.m_128728_(i));
                if (itemstack.m_41619_()) continue;
                this.inventory.m_19173_(itemstack);
            }
        }
    }

    public SlotAccess m_141942_(int p_149743_) {
        int i = p_149743_ - 300;
        return i >= 0 && i < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)i) : super.m_141942_(p_149743_);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.MOB_SUMMONED) {
            this.m_20124_(Pose.EMERGING);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public boolean canAnimateMove() {
        return super.canAnimateMove() && !this.isMeleeAttacking();
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isSummoning() || this.isActivating();
    }

    public boolean m_142582_(Entity p_149755_) {
        return this.summonTick <= 0 && !this.isActivating() && super.m_142582_(p_149755_);
    }

    public boolean isSummoning() {
        return this.summonTick > 0;
    }

    private void glow() {
        this.getGlow = Mth.m_14036_((float)(this.getGlow - 0.05f), (float)0.0f, (float)1.0f);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.GRAVE_GOLEM_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.GRAVE_GOLEM_HURT.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_216990_((SoundEvent)ModSounds.GRAVE_GOLEM_STEP.get());
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.GRAVE_GOLEM_DEATH.get();
    }

    private boolean getGolemFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setGolemFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isMeleeAttacking() {
        return this.getGolemFlag(1);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.setGolemFlags(1, attacking);
        this.attackTick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    public void setShooting(boolean shooting) {
        this.setGolemFlags(2, shooting);
    }

    public boolean isShooting() {
        return this.getGolemFlag(2);
    }

    public void setBelching(boolean belching) {
        this.setGolemFlags(4, belching);
    }

    public boolean isBelching() {
        return this.getGolemFlag(4);
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.activateAnimationState);
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.summonAnimationState);
        animationStates.add(this.belchAnimationState);
        animationStates.add(this.toSitAnimationState);
        animationStates.add(this.toStandAnimationState);
        animationStates.add(this.sitAnimationState);
        animationStates.add(this.shootAnimationState);
        animationStates.add(this.walkAnimationState);
        animationStates.add(this.deathAnimationState);
        return animationStates;
    }

    @Override
    public void setStaying(boolean staying) {
        super.setStaying(staying);
        if (staying) {
            this.f_19853_.m_7605_((Entity)this, (byte)22);
        } else if (this.isFollowing()) {
            this.f_19853_.m_7605_((Entity)this, (byte)23);
        }
    }

    protected void m_6153_() {
        ++this.deathTime;
        if (this.deathTime >= MathHelper.secondsToTicks(5)) {
            this.m_21373_();
            this.dropInventory();
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.f_20916_ = 1;
        this.m_146922_(this.deathRotation);
        this.m_5618_(this.deathRotation);
    }

    @Override
    public void m_6667_(DamageSource p_21014_) {
        this.f_19853_.m_7605_((Entity)this, (byte)7);
        this.deathRotation = this.m_146908_();
        super.m_6667_(p_21014_);
    }

    public void addDrops(Collection<ItemEntity> items) {
        List<ItemStack> drops = items.stream().filter(Objects::nonNull).map(ItemEntity::m_32055_).filter(itemStack -> !itemStack.m_41619_()).toList();
        for (ItemStack itemStack2 : drops) {
            if (this.inventory.m_19183_(itemStack2)) {
                this.inventory.m_19173_(itemStack2);
                continue;
            }
            ItemEntity itemEntity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), itemStack2);
            itemEntity.m_32060_();
            float f = this.f_19796_.m_188501_() * 0.5f;
            float f1 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
            itemEntity.m_20334_((double)(-Mth.m_14031_((float)f1) * f), (double)0.2f, (double)(Mth.m_14089_((float)f1) * f));
            this.f_19853_.m_7967_((Entity)itemEntity);
        }
    }

    public void dropInventory() {
        this.dropInventory(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public void dropInventory(BlockPos blockPos) {
        this.dropInventory(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public void dropInventory(double x, double y, double z) {
        if (!this.inventory.m_7983_()) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack == ItemStack.f_41583_) continue;
                ItemEntity itemEntity = new ItemEntity(this.f_19853_, x, y, z, itemstack);
                itemEntity.m_32060_();
                if (!this.f_19853_.m_7967_((Entity)itemEntity)) continue;
                this.inventory.m_6836_(i, ItemStack.f_41583_);
            }
        }
    }

    public void stopMostAnimations(AnimationState animationState0) {
        for (AnimationState animationState : this.getAnimations()) {
            if (animationState == animationState0) continue;
            animationState.m_216973_();
        }
    }

    public void stopAnimations() {
        for (AnimationState animationState : this.getAnimations()) {
            animationState.m_216973_();
        }
    }

    private boolean isActivating() {
        return this.m_217003_(Pose.EMERGING);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_21224_()) {
            this.stopMostAnimations(this.deathAnimationState);
            this.m_146922_(this.deathRotation);
            this.m_5618_(this.deathRotation);
        }
        if (this.m_217003_(Pose.EMERGING)) {
            ++this.activateTick;
            if (this.activateTick == 1) {
                this.m_5496_((SoundEvent)ModSounds.GRAVE_GOLEM_AWAKEN.get(), 2.0f, 1.0f);
            }
            if ((float)this.activateTick > MathHelper.secondsToTicks(3.25f)) {
                this.m_20124_(Pose.STANDING);
            }
        }
        if (this.f_19853_.m_5776_() && this.m_6084_() && !this.isActivating()) {
            this.glow();
            if (!(this.isMeleeAttacking() || this.isShooting() || this.isBelching() || this.isSummoning())) {
                if (this.isMoving()) {
                    this.stopMostAnimations(this.walkAnimationState);
                    this.walkAnimationState.m_216982_(this.f_19797_);
                } else if (this.isStaying()) {
                    if (this.isSittingDown > 0) {
                        --this.isSittingDown;
                        this.stopMostAnimations(this.toSitAnimationState);
                        this.toSitAnimationState.m_216982_(this.f_19797_);
                    } else {
                        this.stopMostAnimations(this.sitAnimationState);
                        this.sitAnimationState.m_216982_(this.f_19797_);
                    }
                } else if (this.isStandingUp > 0) {
                    --this.isStandingUp;
                    this.stopMostAnimations(this.toStandAnimationState);
                    this.toStandAnimationState.m_216982_(this.f_19797_);
                } else {
                    this.stopMostAnimations(this.idleAnimationState);
                    this.idleAnimationState.m_216982_(this.f_19797_);
                }
            } else {
                this.isSittingDown = this.isStaying() ? MathHelper.secondsToTicks(1) : 0;
                this.isStandingUp = 0;
                this.sitAnimationState.m_216973_();
                this.idleAnimationState.m_216973_();
                this.walkAnimationState.m_216973_();
                this.toSitAnimationState.m_216973_();
                this.toStandAnimationState.m_216973_();
            }
            if (this.isMeleeAttacking()) {
                this.getGlow = 1.0f;
                ++this.attackTick;
            }
            if (this.isSummoning()) {
                this.getGlow = 1.0f;
                this.stopMostAnimations(this.summonAnimationState);
                if (!this.summonAnimationState.m_216984_()) {
                    this.summonAnimationState.m_216977_(this.f_19797_);
                }
                --this.summonTick;
            } else {
                this.summonAnimationState.m_216973_();
            }
            if (this.isShooting()) {
                this.stopMostAnimations(this.shootAnimationState);
                if (!this.shootAnimationState.m_216984_()) {
                    this.shootAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        if (!this.f_19853_.f_46443_) {
            if (this.m_6084_() && !this.isActivating() && !this.isShooting() && !this.isBelching() && this.isMeleeAttacking()) {
                ++this.attackTick;
            }
            if (this.summonTick > 0) {
                --this.summonTick;
            }
            if (this.summonCool > 0) {
                --this.summonCool;
            }
            if (this.belchCool > 0) {
                --this.belchCool;
            }
            if (!this.inventory.m_7983_()) {
                this.f_19853_.m_7605_((Entity)this, (byte)19);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)24);
            }
            if (this.isSummoning()) {
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 5; ++i) {
                        double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
                        double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
                        double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.WRAITH.get()), this.m_20208_(0.5), this.m_20188_() - (double)serverLevel.f_46441_.m_188503_(2), this.m_20262_(0.5), 0, d0, d1, d2, 0.5);
                    }
                    if (!this.f_19853_.m_8055_(this.m_20183_().m_7495_()).m_60795_()) {
                        for (int j = 0; j < 4; ++j) {
                            double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                            double d2 = (float)this.m_20183_().m_7495_().m_123342_() + 0.5f;
                            double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.WRAITH_BURST.get()), d1, d2, d3, 0, 0.0, 0.0, 0.0, 0.5);
                        }
                    }
                }
                if ((float)this.summonTick == MathHelper.secondsToTicks(SUMMON_SECONDS_TIME - 1.0f)) {
                    this.m_216990_((SoundEvent)ModSounds.GRAVE_GOLEM_BLAST.get());
                }
                if ((float)this.summonTick <= MathHelper.secondsToTicks(SUMMON_SECONDS_TIME - 2.0f) && this.summonCount != 0) {
                    for (int i = 0; i < 6; ++i) {
                        BlockPos blockPos = this.m_20183_();
                        blockPos = blockPos.m_7918_(-8 + this.f_19853_.f_46441_.m_188503_(16), 0, -8 + this.f_19853_.f_46441_.m_188503_(16));
                        Haunt summoned = new Haunt((EntityType<? extends Summoned>)((EntityType)ModEntityType.HAUNT.get()), this.f_19853_);
                        summoned.setLimitedLife(MathHelper.secondsToTicks(20));
                        SummonCircle summonCircle = new SummonCircle(this.f_19853_, blockPos, (Entity)summoned, true, true, (LivingEntity)this);
                        summonCircle.noParticles = true;
                        this.f_19853_.m_7967_((Entity)summonCircle);
                    }
                    this.summonCount = 0;
                }
            }
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.stopAnimations();
            this.setShooting(true);
            this.shootAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 5) {
            this.attackTick = 0;
        } else if (pId == 6) {
            this.stopAnimations();
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 7) {
            this.stopAnimations();
            this.deathAnimationState.m_216977_(this.f_19797_);
            this.deathRotation = this.m_146908_();
            this.m_5496_((SoundEvent)ModSounds.GRAVE_GOLEM_DEATH.get(), 1.0f, 1.0f);
        } else if (pId == 8) {
            this.stopAnimations();
            this.activateAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 9) {
            this.shootAnimationState.m_216973_();
        } else if (pId == 10) {
            this.stopAnimations();
            this.summonAnimationState.m_216977_(this.f_19797_);
            this.summonTick = (int)MathHelper.secondsToTicks(SUMMON_SECONDS_TIME);
        } else if (pId == 11) {
            this.attackAnimationState.m_216973_();
        } else if (pId == 12) {
            this.stopAnimations();
            this.setBelching(true);
            this.belchAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 13) {
            this.belchAnimationState.m_216973_();
        } else if (pId == 14) {
            this.setShooting(false);
        } else if (pId == 15) {
            this.getGlow = 1.0f;
        } else if (pId == 16) {
            this.setBelching(false);
        } else if (pId == 17) {
            this.setMeleeAttacking(true);
        } else if (pId == 18) {
            this.setMeleeAttacking(false);
        } else if (pId == 19) {
            if (!this.hasInventory) {
                this.hasInventory = true;
            }
        } else if (pId == 24) {
            if (this.hasInventory) {
                this.hasInventory = false;
            }
        } else if (pId == 22) {
            this.isSittingDown = MathHelper.secondsToTicks(1);
        } else if (pId == 23) {
            this.isStandingUp = MathHelper.secondsToTicks(1);
        } else {
            super.m_7822_(pId);
        }
    }

    public Vec3 getHorizontalLookAngle() {
        return this.m_20171_(0.0f, this.m_146908_());
    }

    public Vec3 getHorizontalRightLookAngle(LivingEntity livingEntity) {
        return MobUtil.calculateViewVector(0.0f, livingEntity.m_146908_() + 90.0f);
    }

    @Override
    public double getAttackReachSqr(LivingEntity enemy) {
        return (double)(this.m_20205_() * 6.0f + enemy.m_20205_()) + 1.0;
    }

    @Override
    public boolean targetClose(LivingEntity enemy, double distToEnemySqr) {
        double reach = this.getAttackReachSqr(enemy);
        return distToEnemySqr <= reach || this.m_20191_().m_82381_(enemy.m_20191_());
    }

    public boolean targetClose(LivingEntity enemy) {
        return this.targetClose(enemy, this.m_20275_(enemy.m_20185_(), enemy.m_20186_(), enemy.m_20189_()));
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        if (!this.f_19853_.f_46443_ && !this.isMeleeAttacking()) {
            this.setMeleeAttacking(true);
            this.f_19853_.m_7605_((Entity)this, (byte)17);
        }
        return true;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
            Item item = itemstack.m_41720_();
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
                if ((item == Items.f_42262_ || item == Items.f_42500_) && this.m_21223_() < this.m_21233_()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    if (item == Items.f_42262_) {
                        this.m_5634_(this.m_21233_() / 4.0f);
                        this.m_5496_(SoundEvents.f_12009_, 1.0f, 0.5f);
                    } else {
                        this.m_5634_(this.m_21233_() / 4.0f / 8.0f);
                        this.m_5496_(SoundEvents.f_12009_, 0.25f, 0.75f);
                    }
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 7; ++i) {
                            double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
                            double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
                            double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.TOTEM_EFFECT.get()), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (item instanceof ShovelItem && !this.inventory.m_7983_()) {
                    this.m_5496_(SoundEvents.f_12406_, 1.0f, 1.0f);
                    this.dropInventory(pPlayer.m_20183_());
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void shootProjectile(LivingEntity p_33317_) {
        Vec3 vector3d = this.m_20252_(1.0f);
        double x = this.getHorizontalRightLookAngle((LivingEntity)this).f_82479_ * 2.0;
        double z = this.getHorizontalRightLookAngle((LivingEntity)this).f_82481_ * 2.0;
        double d1 = p_33317_.m_20185_() - (this.m_20185_() + x);
        double d2 = p_33317_.m_20186_() - this.m_20227_(0.5);
        double d3 = p_33317_.m_20189_() - (this.m_20189_() + z);
        HauntedSkullProjectile soulSkull = new HauntedSkullProjectile((LivingEntity)this, d1, d2, d3, this.f_19853_);
        soulSkull.m_6034_(this.m_20185_() + x + vector3d.f_82479_ / 2.0, this.m_20227_(0.75), this.m_20189_() + z + vector3d.f_82481_ / 2.0);
        soulSkull.m_146922_(this.m_146908_());
        soulSkull.m_146926_(this.m_146909_());
        soulSkull.setUpgraded(true);
        this.f_19853_.m_7967_((Entity)soulSkull);
        this.m_5496_((SoundEvent)ModSounds.GRAVE_GOLEM_BLAST.get(), 1.0f, 1.0f);
    }

    public class SummonGoal
    extends Goal {
        public boolean m_8036_() {
            LivingEntity livingentity = GraveGolem.this.m_5448_();
            int i = GraveGolem.this.f_19853_.m_45976_(Haunt.class, GraveGolem.this.m_20191_().m_82400_(32.0)).size();
            if (livingentity != null && livingentity.m_6084_()) {
                return GraveGolem.this.summonCool <= 0 && i < 3 && !GraveGolem.this.isShooting() && !GraveGolem.this.isBelching() && GraveGolem.this.m_20096_() && GraveGolem.this.m_20270_((Entity)livingentity) < 16.0f;
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            GraveGolem.this.m_5496_((SoundEvent)ModSounds.GRAVE_GOLEM_ARM.get(), GraveGolem.this.m_6121_(), GraveGolem.this.m_6100_());
            GraveGolem.this.f_19853_.m_7605_((Entity)GraveGolem.this, (byte)10);
            GraveGolem.this.summonTick = (int)MathHelper.secondsToTicks(SUMMON_SECONDS_TIME);
            GraveGolem.this.summonCool = MathHelper.secondsToTicks(20);
            GraveGolem.this.summonCount = 1;
        }
    }

    class MeleeGoal
    extends Goal {
        private float yRot;

        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return GraveGolem.this.m_5448_() != null && !GraveGolem.this.isShooting() && !GraveGolem.this.isBelching() && GraveGolem.this.isMeleeAttacking();
        }

        public boolean m_8045_() {
            return (float)GraveGolem.this.attackTick < MathHelper.secondsToTicks(3.0417f) && !GraveGolem.this.isShooting() && !GraveGolem.this.isBelching();
        }

        public void m_8056_() {
            GraveGolem.this.setMeleeAttacking(true);
            GraveGolem.this.f_19853_.m_7605_((Entity)GraveGolem.this, (byte)17);
            if (GraveGolem.this.m_5448_() != null) {
                MobUtil.instaLook((Mob)GraveGolem.this, GraveGolem.this.m_5448_());
            }
            this.yRot = GraveGolem.this.f_20883_;
        }

        public void m_8041_() {
            GraveGolem.this.setMeleeAttacking(false);
            GraveGolem.this.f_19853_.m_7605_((Entity)GraveGolem.this, (byte)18);
        }

        public void m_8037_() {
            GraveGolem.this.m_146922_(this.yRot);
            GraveGolem.this.f_20883_ = this.yRot;
            GraveGolem.this.m_21573_().m_26573_();
            if (GraveGolem.this.attackTick == 1) {
                GraveGolem.this.m_5496_((SoundEvent)ModSounds.GRAVE_GOLEM_GROWL.get(), 5.0f, 1.0f);
                GraveGolem.this.f_19853_.m_7605_((Entity)GraveGolem.this, (byte)6);
            }
            if (GraveGolem.this.attackTick == 22) {
                GraveGolem.this.m_5496_(SoundEvents.f_11913_, 2.0f, 1.0f);
                AABB aabb = MeleeGoal.makeAttackRange(GraveGolem.this.m_20185_() + GraveGolem.this.getHorizontalLookAngle().f_82479_ * 2.0, GraveGolem.this.m_20186_(), GraveGolem.this.m_20189_() + GraveGolem.this.getHorizontalLookAngle().f_82481_ * 2.0, 9.0, 7.0, 9.0);
                for (LivingEntity target : GraveGolem.this.f_19853_.m_45976_(LivingEntity.class, aabb)) {
                    if (target == GraveGolem.this || target.m_7307_((Entity)GraveGolem.this) || GraveGolem.this.m_7307_((Entity)target)) continue;
                    this.hurtTarget((Entity)target);
                }
                Level level = GraveGolem.this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)new ShockwaveParticleOption(0), GraveGolem.this.m_20185_() + GraveGolem.this.getHorizontalLookAngle().f_82479_ * 2.0, GraveGolem.this.m_20186_() + 0.25, GraveGolem.this.m_20189_() + GraveGolem.this.getHorizontalLookAngle().f_82481_ * 2.0, 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }

        public void hurtTarget(Entity target) {
            DamageSource damageSource;
            boolean flag;
            float f = (float)GraveGolem.this.m_21133_(Attributes.f_22281_);
            float f1 = (float)GraveGolem.this.m_21133_(Attributes.f_22282_);
            if (target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                f += livingEntity.m_21233_() * 0.08f;
            }
            if (flag = target.m_6469_(damageSource = GraveGolem.this.getTrueOwner() != null ? ModDamageSource.summonAttack((LivingEntity)GraveGolem.this, GraveGolem.this.getTrueOwner()) : GraveGolem.this.m_269291_().m_269333_((LivingEntity)GraveGolem.this), f)) {
                if (f1 > 0.0f && target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    if (livingEntity.m_20191_().m_82309_() > GraveGolem.this.m_20191_().m_82309_()) {
                        livingEntity.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(GraveGolem.this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(GraveGolem.this.m_146908_() * ((float)Math.PI / 180)))));
                    } else {
                        MobUtil.forcefulKnockBack(livingEntity, f1 * 0.5f, Mth.m_14031_((float)(GraveGolem.this.m_146908_() * ((float)Math.PI / 180))), -Mth.m_14089_((float)(GraveGolem.this.m_146908_() * ((float)Math.PI / 180))), 0.5);
                    }
                    GraveGolem.this.m_20256_(GraveGolem.this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                GraveGolem.this.m_19970_((LivingEntity)GraveGolem.this, target);
                GraveGolem.this.m_21335_(target);
            }
        }

        public static AABB makeAttackRange(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
            return new AABB(x - sizeX / 2.0, y - sizeY / 2.0, z - sizeZ / 2.0, x + sizeX / 2.0, y + sizeY / 2.0, z + sizeZ / 2.0);
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public static class GolemRangedGoal
    extends Goal {
        private final GraveGolem mob;
        @Nullable
        private LivingEntity target;
        private int attackTime = 0;
        private final double speedModifier;
        private int seeTime;
        private final float attackRadius;
        private final float attackRadiusSqr;

        public GolemRangedGoal(GraveGolem mob, double speed, float attackRadius) {
            this.mob = mob;
            this.speedModifier = speed;
            this.attackRadius = attackRadius;
            this.attackRadiusSqr = attackRadius * attackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && !this.mob.targetClose(livingentity) && (double)this.mob.m_20270_((Entity)livingentity) > 8.0) {
                this.target = livingentity;
                return !this.mob.isMeleeAttacking() && !this.mob.isSummoning() && !this.mob.isBelching();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_() || !this.mob.isMeleeAttacking() && !this.mob.isSummoning() && !this.mob.isBelching() && this.target != null && (double)this.mob.m_20270_((Entity)this.target) > 8.0 && !this.mob.targetClose(this.target) && this.target.m_6084_() && !this.mob.m_21573_().m_26571_();
        }

        public void m_8041_() {
            this.mob.setShooting(false);
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)9);
            this.target = null;
            this.seeTime = 0;
            this.attackTime = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.target != null && !this.mob.isMeleeAttacking() && !this.mob.isSummoning()) {
                double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
                boolean flag = this.mob.m_21574_().m_148306_((Entity)this.target);
                this.seeTime = flag ? ++this.seeTime : 0;
                if (d0 <= (double)this.attackRadiusSqr && this.seeTime >= 5) {
                    this.mob.m_21573_().m_26573_();
                } else {
                    this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
                }
                MobUtil.instaLook((Mob)this.mob, this.target);
                ++this.attackTime;
                if (this.attackTime == 1) {
                    this.mob.setShooting(true);
                    this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)4);
                } else if (this.attackTime == 10) {
                    if (!flag) {
                        return;
                    }
                    this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)15);
                    this.mob.shootProjectile(this.target);
                } else if (this.attackTime >= 23) {
                    this.mob.setShooting(false);
                    this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)14);
                    this.attackTime = 0;
                }
            }
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        private final double moveSpeed;
        private int delayCounter;

        public AttackGoal(double moveSpeed) {
            super((PathfinderMob)GraveGolem.this, moveSpeed, true);
            this.moveSpeed = moveSpeed;
        }

        public boolean m_8036_() {
            return GraveGolem.this.m_5448_() != null && !GraveGolem.this.isSummoning() && !GraveGolem.this.isShooting() && !GraveGolem.this.isBelching() && GraveGolem.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            GraveGolem.this.m_21561_(true);
            this.delayCounter = 0;
        }

        public void m_8041_() {
            GraveGolem.this.m_21573_().m_26573_();
            if (GraveGolem.this.m_5448_() == null) {
                GraveGolem.this.m_21561_(false);
            }
        }

        public void m_8037_() {
            LivingEntity livingentity = GraveGolem.this.m_5448_();
            if (livingentity == null) {
                return;
            }
            GraveGolem.this.m_21563_().m_24960_((Entity)livingentity, (float)GraveGolem.this.m_8085_(), (float)GraveGolem.this.m_8132_());
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                GraveGolem.this.m_21573_().m_5624_((Entity)livingentity, this.moveSpeed);
            }
            this.m_6739_(livingentity, GraveGolem.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_()));
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            if (GraveGolem.this.targetClose(enemy, distToEnemySqr) && !GraveGolem.this.isShooting()) {
                GraveGolem.this.m_7327_((Entity)enemy);
            }
        }
    }

    public static class BelchGoal
    extends Goal {
        private final GraveGolem mob;
        private int attackTime = 0;
        private int seeTime;

        public BelchGoal(GraveGolem mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (this.mob.belchCool <= 0 && livingentity != null && livingentity.m_6084_() && !this.mob.targetClose(livingentity) && (double)this.mob.m_20270_((Entity)livingentity) <= 8.0) {
                return !this.mob.isMeleeAttacking() && !this.mob.isShooting() && !this.mob.isSummoning();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_() || !this.mob.isMeleeAttacking() && !this.mob.isSummoning() && !this.mob.isShooting() && this.attackTime > 0 && this.mob.belchCool <= 0;
        }

        public void m_8041_() {
            this.mob.setBelching(false);
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)13);
            this.seeTime = 0;
            this.attackTime = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (!this.mob.isMeleeAttacking() && !this.mob.isSummoning()) {
                if (target != null) {
                    double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                    boolean flag = this.mob.m_21574_().m_148306_((Entity)target);
                    this.seeTime = flag ? ++this.seeTime : 0;
                    if (distance <= (double)Mth.m_144944_((int)32) && this.seeTime >= 5) {
                        this.mob.m_21573_().m_26573_();
                    } else {
                        this.mob.m_21573_().m_5624_((Entity)target, 1.0);
                    }
                    MobUtil.instaLook((Mob)this.mob, target);
                }
                ++this.attackTime;
                if (this.attackTime == 1) {
                    this.mob.setBelching(true);
                    this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)12);
                    this.mob.m_216990_((SoundEvent)ModSounds.GRAVE_GOLEM_GROWL.get());
                } else if (this.attackTime == 17) {
                    Vec3 vec3 = this.mob.m_20182_().m_82549_(this.mob.m_20154_().m_82490_(20.0));
                    this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)15);
                    for (int i = 0; i < 8; ++i) {
                        SoulBomb snowball = new SoulBomb((LivingEntity)this.mob, this.mob.f_19853_);
                        double d0 = vec3.f_82480_ - 2.5;
                        double d1 = vec3.f_82479_ - this.mob.m_20185_();
                        double d2 = d0 - snowball.m_20186_();
                        double d3 = vec3.f_82481_ - this.mob.m_20189_();
                        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
                        snowball.m_6027_(this.mob.m_20185_(), this.mob.m_20186_() + 4.5, this.mob.m_20189_());
                        snowball.m_6686_(d1, d2 + d4, d3, 1.0f, 30.0f);
                        this.mob.f_19853_.m_7967_((Entity)snowball);
                    }
                    this.mob.m_216990_((SoundEvent)ModSounds.GRAVE_GOLEM_BLAST.get());
                } else if (this.attackTime >= 37) {
                    this.mob.setBelching(false);
                    this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)16);
                    this.attackTime = 0;
                    this.mob.belchCool = 100;
                }
            }
        }
    }
}

