/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.client.particles.FoggyCloudParticleOption;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.ai.LookAtTargelGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.Wavewhisperer;
import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.EntangleVines;
import com.Polarice3.Goety.init.ModMobType;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Whisperer
extends Summoned {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(Whisperer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Whisperer.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DATA_WAVE_CONVERSION_ID = SynchedEntityData.m_135353_(Whisperer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static String IDLE = "idle";
    public static String WALK = "walk";
    public static String ATTACK = "attack";
    public static String SUMMON = "summon";
    public static String SUMMON_POISON = "summonPoison";
    public static String SUMMON_THORNS = "summonThorns";
    public int attackTick;
    public int summonTick = 0;
    public int summonCool = 0;
    private int inWaterTime;
    private int conversionTime;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState summonAnimationState = new AnimationState();
    public AnimationState summonPoisonAnimationState = new AnimationState();
    public AnimationState summonThornsAnimationState = new AnimationState();

    public Whisperer(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this){

            public boolean m_8036_() {
                return super.m_8036_() && !(Whisperer.this.m_21573_() instanceof WaterBoundPathNavigation);
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new SummonGoal(this));
        this.f_21345_.m_25352_(1, AvoidTargetGoal.AvoidRadiusGoal.newGoal(this, 4.0f, 8, 1.0, 1.2f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtTargelGoal((Mob)this, 15.0f));
        this.f_21345_.m_25352_(8, (Goal)new Summoned.WanderGoal((PathfinderMob)this, 1.0){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Whisperer.this.m_5448_() == null;
            }
        });
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.WhispererHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.WhispererDamage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 15.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.WhispererHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.WhispererDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(DATA_WAVE_CONVERSION_ID, (Object)false);
    }

    public boolean isUnderWaterConverting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_WAVE_CONVERSION_ID);
    }

    private void startUnderWaterConversion(int p_204704_1_) {
        this.conversionTime = p_204704_1_;
        this.m_20088_().m_135381_(DATA_WAVE_CONVERSION_ID, (Object)true);
    }

    protected void doUnderWaterConversion() {
        this.convertToWave((EntityType<? extends Wavewhisperer>)((EntityType)ModEntityType.WAVEWHISPERER.get()));
        if (!this.m_20067_()) {
            this.f_19853_.m_5898_((Player)null, 1040, this.m_20183_(), 0);
        }
    }

    protected void convertToWave(EntityType<? extends Wavewhisperer> p_234341_1_) {
        Wavewhisperer wavewhisperer = (Wavewhisperer)this.m_21406_(p_234341_1_, true);
        if (wavewhisperer != null) {
            if (this.getTrueOwner() != null) {
                wavewhisperer.setTrueOwner(this.getTrueOwner());
            }
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)wavewhisperer);
        }
    }

    public MobType m_6336_() {
        return ModMobType.NATURAL;
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, IDLE)) {
            return 1;
        }
        if (Objects.equals(animation, WALK)) {
            return 2;
        }
        if (Objects.equals(animation, ATTACK)) {
            return 3;
        }
        if (Objects.equals(animation, SUMMON)) {
            return 4;
        }
        if (Objects.equals(animation, SUMMON_POISON)) {
            return 5;
        }
        if (Objects.equals(animation, SUMMON_THORNS)) {
            return 6;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.walkAnimationState);
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.summonAnimationState);
        animationStates.add(this.summonPoisonAnimationState);
        animationStates.add(this.summonThornsAnimationState);
        return animationStates;
    }

    public void stopAllAnimations() {
        for (AnimationState animationState : this.getAllAnimations()) {
            animationState.m_216973_();
        }
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.walkAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.walkAnimationState);
                    break;
                }
                case 3: {
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 4: {
                    this.summonAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.summonAnimationState);
                    break;
                }
                case 5: {
                    this.summonPoisonAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.summonPoisonAnimationState);
                    break;
                }
                case 6: {
                    this.summonThornsAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.summonThornsAnimationState);
                }
            }
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.WHISPERER_AMBIENT.get();
    }

    public void m_8032_() {
        if (this.getCurrentAnimation() == this.getAnimationState(IDLE)) {
            super.m_8032_();
        }
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.WHISPERER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.WHISPERER_DEATH.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_((SoundEvent)ModSounds.WHISPERER_STEP.get(), 0.15f, 1.0f);
    }

    protected SoundEvent getAttackSound() {
        return (SoundEvent)ModSounds.WHISPERER_ATTACK.get();
    }

    protected SoundEvent getSummonSound() {
        return (SoundEvent)ModSounds.WHISPERER_SUMMON.get();
    }

    protected SoundEvent getSummonPoisonSound() {
        return (SoundEvent)ModSounds.WHISPERER_SUMMON_POISON.get();
    }

    protected SoundEvent getSummonThornsSound() {
        return (SoundEvent)ModSounds.WHISPERER_SUMMON_THORNS.get();
    }

    protected EntityType<? extends AbstractMonolith> getVines() {
        return (EntityType)ModEntityType.QUICK_GROWING_VINE.get();
    }

    protected EntityType<? extends AbstractMonolith> getPoison() {
        return (EntityType)ModEntityType.POISON_QUILL_VINE.get();
    }

    private boolean getFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isSummonCool() {
        return this.summonCool > 0;
    }

    public boolean isSummoning() {
        return this.getFlag(2);
    }

    public void setSummoning(boolean summon) {
        this.setFlag(2, summon);
    }

    public boolean isMeleeAttacking() {
        return this.getFlag(4);
    }

    public void setMeleeAttacking(boolean attack) {
        this.setFlag(4, attack);
        this.attackTick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    public boolean isMoving() {
        return this.m_20184_().m_165925_() > 1.0E-6;
    }

    public Vec3 getHorizontalLeftLookAngle() {
        return MobUtil.calculateViewVector(0.0f, this.m_146908_() - 90.0f);
    }

    public Vec3 getHorizontalRightLookAngle() {
        return MobUtil.calculateViewVector(0.0f, this.m_146908_() + 90.0f);
    }

    protected boolean convertsInWater() {
        return true;
    }

    @Override
    public EntityType<?> getVariant(Level level, BlockPos blockPos) {
        EntityType entityType = (EntityType)ModEntityType.WHISPERER.get();
        if (level.m_46801_(blockPos)) {
            entityType = (EntityType)ModEntityType.WAVEWHISPERER.get();
        }
        return entityType;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_() && !this.f_19853_.f_46443_) {
            Level level;
            if (this.m_6084_() && !this.m_21525_()) {
                if (this.isUnderWaterConverting()) {
                    --this.conversionTime;
                    if (this.conversionTime < 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)((EntityType)ModEntityType.ZOMBIE_SERVANT.get()), timer -> {
                        this.conversionTime = timer;
                    })) {
                        this.doUnderWaterConversion();
                    }
                } else if (this.convertsInWater()) {
                    if (this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
                        ++this.inWaterTime;
                        if (this.inWaterTime >= 600) {
                            this.startUnderWaterConversion(300);
                        }
                    } else {
                        this.inWaterTime = -1;
                    }
                }
            }
            if (!this.isMeleeAttacking() && !this.isSummoning()) {
                if (!this.isMoving()) {
                    this.setAnimationState(IDLE);
                } else {
                    this.setAnimationState(WALK);
                }
            }
            if (this.isMeleeAttacking()) {
                ++this.attackTick;
                if ((float)this.attackTick >= MathHelper.secondsToTicks(1.3333f)) {
                    this.setMeleeAttacking(false);
                    this.f_19853_.m_7605_((Entity)this, (byte)9);
                }
            }
            if (this.isSummoning()) {
                ++this.summonTick;
            }
            if (this.summonCool > 0) {
                --this.summonCool;
            }
            if ((level = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.getCurrentAnimation() == this.getAnimationState(SUMMON) && this.summonTick > 5 && this.summonTick <= 20) {
                    ColorUtil colorUtil = new ColorUtil(16570871);
                    float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
                    float f1 = Mth.m_14089_((float)f);
                    float f2 = Mth.m_14031_((float)f);
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SPELL_SQUARE.get()), this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 3.0, this.m_20189_() + (double)f2 * 0.6, 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 0.5);
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SPELL_SQUARE.get()), this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 3.0, this.m_20189_() - (double)f2 * 0.6, 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 0.5);
                    serverLevel.m_8767_((ParticleOptions)new FoggyCloudParticleOption(new ColorUtil(13596079), 0.25f, 6), this.m_20185_(), this.m_20186_() + 2.5, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void lifeSpanDamage() {
        this.m_6667_(this.m_269291_().m_269064_());
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 5) {
            this.attackTick = 0;
        } else if (p_21375_ == 6) {
            this.m_21561_(true);
        } else if (p_21375_ == 7) {
            this.m_21561_(false);
        } else {
            super.m_7822_(p_21375_);
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
            Item item = itemstack.m_41720_();
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && item == Items.f_42499_ && this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (this.m_6095_() == ModEntityType.WAVEWHISPERER.get()) {
                    this.m_5496_((SoundEvent)ModSounds.WAVEWHISPERER_AMBIENT.get(), 1.0f, 2.0f);
                } else {
                    this.m_5496_((SoundEvent)ModSounds.WHISPERER_AMBIENT.get(), 1.0f, 2.0f);
                }
                this.m_5634_(2.0f);
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.HEAL_EFFECT.get(), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                }
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6071_(pPlayer, p_230254_2_);
    }

    static class AttackGoal
    extends Goal {
        public Whisperer whisperer;
        public LivingEntity target;
        private int ticksUntilNextAttack;

        public AttackGoal(Whisperer whisperer) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.whisperer = whisperer;
            this.target = whisperer.m_5448_();
        }

        public boolean m_8036_() {
            this.target = this.whisperer.m_5448_();
            return this.target != null && this.target.m_6084_() && !this.whisperer.isSummoning() && this.whisperer.m_142582_((Entity)this.target) && this.target.m_20270_((Entity)this.whisperer) < 2.5f;
        }

        public boolean m_8045_() {
            return this.whisperer.isMeleeAttacking() && this.target != null;
        }

        public void m_8056_() {
            this.ticksUntilNextAttack = 0;
            this.whisperer.setMeleeAttacking(true);
            this.whisperer.m_21561_(true);
            this.whisperer.f_19853_.m_7605_((Entity)this.whisperer, (byte)6);
        }

        public void m_8041_() {
            this.whisperer.setMeleeAttacking(false);
            this.whisperer.m_21561_(false);
            this.whisperer.f_19853_.m_7605_((Entity)this.whisperer, (byte)7);
        }

        public void m_8037_() {
            if (this.target == null) {
                return;
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            if (this.ticksUntilNextAttack == 0) {
                MobUtil.instaLook((Mob)this.whisperer, this.target);
                this.whisperer.m_21573_().m_26573_();
                if (this.whisperer.getCurrentAnimation() != this.whisperer.getAnimationState(ATTACK)) {
                    this.whisperer.setAnimationState(ATTACK);
                    this.whisperer.m_5496_(this.whisperer.getAttackSound(), this.whisperer.m_6121_(), this.whisperer.m_6100_());
                }
                if (this.whisperer.attackTick == 14 && this.target.m_20270_((Entity)this.whisperer) < 2.5f) {
                    this.resetAttackCooldown();
                    this.whisperer.m_6674_(InteractionHand.MAIN_HAND);
                    this.whisperer.m_7327_((Entity)this.target);
                }
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.m_183277_(10);
        }

        public boolean m_183429_() {
            return true;
        }
    }

    static class SummonGoal
    extends Goal {
        public Whisperer whisperer;
        public LivingEntity target;
        public int type = 0;

        public SummonGoal(Whisperer whisperer) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.whisperer = whisperer;
            this.target = whisperer.m_5448_();
        }

        public boolean m_8036_() {
            this.target = this.whisperer.m_5448_();
            return !this.whisperer.isMeleeAttacking() && !this.whisperer.isSummoning() && !this.whisperer.isSummonCool() && this.target != null;
        }

        public boolean m_8045_() {
            return this.whisperer.isSummoning();
        }

        public void m_8041_() {
            super.m_8041_();
            this.type = 0;
            this.whisperer.summonTick = 0;
            this.whisperer.setSummoning(false);
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.target != null) {
                if (this.target.m_20270_((Entity)this.whisperer) > 13.0f) {
                    this.whisperer.f_21344_.m_5624_((Entity)this.target, 1.0);
                } else {
                    MobUtil.instaLook((Mob)this.whisperer, this.target);
                    this.whisperer.f_21344_.m_26573_();
                    boolean first = this.whisperer.m_217043_().m_188499_();
                    float chance = this.whisperer.m_217043_().m_188501_();
                    int spellTime = 0;
                    int cooldown = MathHelper.secondsToTicks(1);
                    if (!this.whisperer.isSummoning()) {
                        if (first) {
                            if (chance >= 0.5f) {
                                this.type = 1;
                            } else if (chance >= 0.35f) {
                                this.type = 3;
                            } else if (chance >= 0.15f) {
                                this.type = 2;
                            }
                        } else if (chance >= 0.75f) {
                            this.type = 3;
                        } else if (chance >= 0.15f) {
                            this.type = 1;
                        } else if (chance >= 0.1f) {
                            this.type = 2;
                        }
                        this.whisperer.setSummoning(true);
                    } else {
                        if (this.type == 1) {
                            spellTime = 34;
                            if (this.whisperer.getCurrentAnimation() != this.whisperer.getAnimationState(SUMMON)) {
                                this.whisperer.setAnimationState(SUMMON);
                                this.whisperer.m_5496_(this.whisperer.getSummonSound(), this.whisperer.m_6121_(), this.whisperer.m_6100_());
                            }
                            if (this.whisperer.summonTick == 20) {
                                int random = this.whisperer.f_19796_.m_188503_(5);
                                Direction direction = Direction.m_122364_((double)this.target.m_6080_());
                                if (random == 0) {
                                    WandUtil.summonMinorSquareTrap((LivingEntity)this.whisperer, (Entity)this.target, this.whisperer.getVines(), direction, 0);
                                } else if (random == 1) {
                                    WandUtil.summonHallTrap((LivingEntity)this.whisperer, (Entity)this.target, this.whisperer.getVines(), 0);
                                } else if (random == 2) {
                                    WandUtil.summonCubeTrap((LivingEntity)this.whisperer, (Entity)this.target, this.whisperer.getVines(), 0);
                                } else if (random == 3) {
                                    WandUtil.summonCircleTrap((LivingEntity)this.whisperer, (Entity)this.target, this.whisperer.getVines(), direction, 0);
                                } else {
                                    WandUtil.summonSurroundTrap((LivingEntity)this.whisperer, (Entity)this.target, this.whisperer.getVines(), 0);
                                }
                            }
                            cooldown = MathHelper.secondsToTicks(7);
                        } else if (this.type == 2) {
                            int z;
                            int x;
                            spellTime = 63;
                            if (this.whisperer.getCurrentAnimation() != this.whisperer.getAnimationState(SUMMON_POISON)) {
                                this.whisperer.setAnimationState(SUMMON_POISON);
                                this.whisperer.m_5496_(this.whisperer.getSummonPoisonSound(), this.whisperer.m_6121_(), this.whisperer.m_6100_());
                            }
                            if (this.whisperer.summonTick == 20) {
                                x = (int)(this.whisperer.getHorizontalLeftLookAngle().f_82479_ * 4.0);
                                z = (int)(this.whisperer.getHorizontalLeftLookAngle().f_82481_ * 4.0);
                                BlockPos left = new BlockPos((Vec3i)this.whisperer.m_20183_().m_7918_(x, 0, z));
                                WandUtil.summonTurret((LivingEntity)this.whisperer, BlockFinder.SummonPosition((LivingEntity)this.whisperer, left), this.whisperer.getPoison(), (Entity)this.target, 0, 0);
                            }
                            if (this.whisperer.summonTick == 50) {
                                x = (int)(this.whisperer.getHorizontalRightLookAngle().f_82479_ * 4.0);
                                z = (int)(this.whisperer.getHorizontalRightLookAngle().f_82481_ * 4.0);
                                BlockPos right = new BlockPos((Vec3i)this.whisperer.m_20183_().m_7918_(x, 0, z));
                                WandUtil.summonTurret((LivingEntity)this.whisperer, BlockFinder.SummonPosition((LivingEntity)this.whisperer, right), this.whisperer.getPoison(), (Entity)this.target, 0, 0);
                            }
                            cooldown = spellTime * 2;
                        } else if (this.type == 3) {
                            spellTime = 74;
                            if (this.whisperer.getCurrentAnimation() != this.whisperer.getAnimationState(SUMMON_THORNS)) {
                                this.whisperer.setAnimationState(SUMMON_THORNS);
                                this.whisperer.m_5496_((SoundEvent)ModSounds.WHISPERER_CAST_THORNS.get(), this.whisperer.m_6121_(), this.whisperer.m_6100_());
                            }
                            if (this.whisperer.summonTick == 44) {
                                this.whisperer.m_5496_(this.whisperer.getSummonThornsSound(), this.whisperer.m_6121_(), this.whisperer.m_6100_());
                            }
                            if (this.whisperer.summonTick == 46) {
                                EntangleVines entangleVines = new EntangleVines(this.whisperer.f_19853_, (LivingEntity)this.whisperer, (Entity)this.target);
                                this.whisperer.f_19853_.m_7967_((Entity)entangleVines);
                            }
                            cooldown = spellTime;
                        }
                        if (this.type < 1 || spellTime > 0 && this.whisperer.summonTick >= spellTime) {
                            this.whisperer.setSummoning(false);
                            this.whisperer.summonTick = 0;
                            this.whisperer.summonCool = cooldown;
                        }
                    }
                }
            } else {
                this.whisperer.setSummoning(false);
                this.whisperer.summonTick = 0;
            }
        }
    }
}

