/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.MobsConfig;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ai.SummonTargetGoal;
import com.Polarice3.Goety.common.entities.ally.AbstractGolemServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.init.ModMobType;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class Summoned
extends Owned
implements IServant {
    protected static final EntityDataAccessor<Byte> SUMMONED_FLAGS = SynchedEntityData.m_135353_(Summoned.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("9c47949c-b896-4802-8e8a-f08c50791a8a");
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(SPEED_MODIFIER_UUID, "Staying speed penalty", -1.0, AttributeModifier.Operation.ADDITION);
    public boolean upgraded;
    public LivingEntity commandPosEntity;
    public BlockPos commandPos;
    public int commandTick;

    protected Summoned(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.followGoal();
        this.targetSelectGoal();
    }

    public void followGoal() {
        this.f_21345_.m_25352_(8, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f));
    }

    public void targetSelectGoal() {
        this.f_21346_.m_25352_(1, (Goal)new SummonTargetGoal((Mob)this));
    }

    public void m_6043_() {
        if (this.isHostile()) {
            super.m_6043_();
        }
    }

    public ItemStack m_6298_(ItemStack pShootable) {
        if (pShootable.m_41720_() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)pShootable.m_41720_()).m_6442_();
            ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
            return itemstack.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : itemstack;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void m_8119_() {
        boolean flag;
        LivingEntity livingEntity;
        super.m_8119_();
        this.stayingMode();
        if (this.isCommanded()) {
            if (this.m_21573_().m_6342_(this.commandPos) || this.commandPosEntity != null) {
                --this.commandTick;
                if (this.commandPosEntity != null) {
                    this.m_21573_().m_5624_((Entity)this.commandPosEntity, 1.25);
                } else {
                    this.m_21573_().m_26519_((double)this.commandPos.m_123341_() + 0.5, (double)this.commandPos.m_123342_(), (double)this.commandPos.m_123343_() + 0.5, 1.25);
                }
                if (this.m_21573_().m_26577_() || this.commandTick <= 0) {
                    this.commandPosEntity = null;
                    this.commandPos = null;
                } else if (this.commandPos.m_203195_((Position)(this.m_275832_() != null ? this.m_275832_().m_20182_() : this.m_20182_()), this.m_275832_() != null ? (double)this.m_275832_().m_20205_() + 1.0 : (double)this.m_20205_() + 1.0)) {
                    if (this.commandPosEntity != null && this.m_20191_().m_82400_(1.25).m_82381_(this.commandPosEntity.m_20191_())) {
                        if (this.canRide(this.commandPosEntity) && this.m_20329_((Entity)this.commandPosEntity) && (livingEntity = this.getTrueOwner()) instanceof Player) {
                            Player player = (Player)livingEntity;
                            player.m_5661_((Component)Component.m_237115_((String)"info.goety.servant.dismount"), true);
                        }
                        this.commandPosEntity = null;
                    }
                    this.m_20035_(this.commandPos, this.m_146908_(), this.m_146909_());
                    this.commandPos = null;
                }
            } else {
                this.commandPos = null;
            }
        }
        if (this.isWandering() && this.isStaying()) {
            this.setStaying(false);
        }
        if (this.getTrueOwner() != null) {
            if (CuriosFinder.hasUndeadCrown(this.getTrueOwner()) && this.m_6336_() == MobType.f_21641_) {
                this.limitedLifespan = false;
            } else if (this.limitedLifeTicks > 0) {
                this.limitedLifespan = true;
            }
            if (!(this.f_19853_.f_46443_ || this.m_6060_() || this.m_21224_() || this.limitedLifespan && this.limitedLifeTicks <= 20 || !(this.m_21223_() < this.m_21233_()) || !((livingEntity = this.getTrueOwner()) instanceof Player))) {
                Player owner = (Player)livingEntity;
                boolean curio = false;
                int soulCost = 0;
                int healRate = 0;
                float healAmount = 0.0f;
                if (this.m_6336_() == MobType.f_21641_ && ((Boolean)MobsConfig.UndeadMinionHeal.get()).booleanValue()) {
                    curio = CuriosFinder.hasUndeadCape((LivingEntity)owner);
                    soulCost = (Integer)MobsConfig.UndeadMinionHealCost.get();
                    healRate = (Integer)MobsConfig.UndeadMinionHealTime.get();
                    healAmount = ((Double)MobsConfig.UndeadMinionHealAmount.get()).floatValue();
                }
                if (this.m_6336_() == ModMobType.NATURAL && ((Boolean)MobsConfig.NaturalMinionHeal.get()).booleanValue()) {
                    curio = CuriosFinder.hasWildRobe((LivingEntity)owner);
                    soulCost = (Integer)MobsConfig.NaturalMinionHealCost.get();
                    healRate = (Integer)MobsConfig.NaturalMinionHealTime.get();
                    healAmount = ((Double)MobsConfig.NaturalMinionHealAmount.get()).floatValue();
                }
                if (curio && SEHelper.getSoulsAmount(owner, soulCost) && this.f_19797_ % MathHelper.secondsToTicks(healRate) == 0) {
                    this.m_5634_(healAmount);
                    Vec3 vector3d = this.m_20184_();
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        SEHelper.decreaseSouls(owner, soulCost);
                        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_235898_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0, vector3d.f_82479_ * -0.2, 0.1, vector3d.f_82481_ * -0.2, 0.5);
                    }
                }
            }
        }
        boolean bl = flag = this.isSunSensitive() && this.m_21527_() && (Boolean)MobsConfig.UndeadServantSunlightBurn.get() != false;
        if (flag) {
            ItemStack itemstack = this.m_6844_(EquipmentSlot.HEAD);
            if (!itemstack.m_41619_()) {
                if (itemstack.m_41763_() && ((Boolean)MobsConfig.UndeadServantSunlightHelmet.get()).booleanValue()) {
                    itemstack.m_41721_(itemstack.m_41773_() + this.f_19796_.m_188503_(2));
                    if (itemstack.m_41773_() >= itemstack.m_41776_()) {
                        this.m_21166_(EquipmentSlot.HEAD);
                        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.m_20254_(8);
            }
        }
    }

    public void stayingMode() {
        AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
        if (modifiableattributeinstance != null) {
            if (this.isStaying()) {
                if (this.f_21344_.m_26570_() != null) {
                    this.f_21344_.m_26573_();
                }
                if (this.m_21051_(Attributes.f_22279_) != null) {
                    modifiableattributeinstance.m_22130_(SPEED_MODIFIER);
                    modifiableattributeinstance.m_22118_(SPEED_MODIFIER);
                }
                this.stayingPosition();
                if (this.isWandering()) {
                    this.setWandering(false);
                }
            } else if (modifiableattributeinstance.m_22109_(SPEED_MODIFIER)) {
                modifiableattributeinstance.m_22130_(SPEED_MODIFIER);
            }
        }
    }

    public boolean canRide(LivingEntity livingEntity) {
        if (!(this instanceof PlayerRideable) && !(this instanceof AbstractGolemServant) && livingEntity instanceof PlayerRideable && livingEntity.m_146895_() == null) {
            if (livingEntity instanceof AbstractHorse) {
                AbstractHorse horse = (AbstractHorse)livingEntity;
                return horse.m_30614_();
            }
            if (livingEntity instanceof OwnableEntity) {
                OwnableEntity ownable = (OwnableEntity)livingEntity;
                if (this.getTrueOwner() != null) {
                    return ownable.m_269323_() == this.getTrueOwner();
                }
            }
            if (livingEntity instanceof IOwned) {
                IOwned owned = (IOwned)livingEntity;
                if (this.getTrueOwner() != null) {
                    return owned.getTrueOwner() == this.getTrueOwner();
                }
            }
        }
        return false;
    }

    public void stayingPosition() {
        if (this.m_5448_() != null) {
            this.m_21563_().m_24960_((Entity)this.m_5448_(), (float)this.m_8085_(), (float)this.m_8132_());
            double d2 = this.m_5448_().m_20185_() - this.m_20185_();
            double d1 = this.m_5448_().m_20189_() - this.m_20189_();
            this.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
            this.f_20883_ = this.m_146908_();
        }
    }

    protected boolean isSunSensitive() {
        return false;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pReason == MobSpawnType.MOB_SUMMONED && this.getTrueOwner() != null && this.m_6336_() == MobType.f_21641_) {
            for (int i = 0; i < pLevel.m_6018_().f_46441_.m_188503_(10) + 10; ++i) {
                pLevel.m_6018_().m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SUMMON.get()), this.m_20208_(1.5), this.m_20187_(), this.m_20262_(1.5), 0, 0.0, 1.0, 0.0, 1.0);
            }
            pLevel.m_6018_().m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SOUL_EXPLODE.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 2.0, 0.0, 1.0);
        }
        this.setWandering(false);
        this.setStaying(false);
        return pSpawnData;
    }

    public void m_6667_(DamageSource pCause) {
        if (!this.f_19853_.f_46443_ && this.m_8077_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46142_) && this.getTrueOwner() instanceof ServerPlayer) {
            this.getTrueOwner().m_213846_(this.m_21231_().m_19293_());
        }
        super.m_6667_(pCause);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Summoned summoned;
        Entity entity;
        if (((Boolean)MobsConfig.MinionsMasterImmune.get()).booleanValue() && (entity = source.m_7639_()) instanceof Summoned && !(summoned = (Summoned)entity).isHostile() && !this.isHostile() && this.getTrueOwner() != null && summoned.getTrueOwner() == this.getTrueOwner()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag) {
            if (this.m_6336_() == MobType.f_21641_) {
                float f = this.f_19853_.m_6436_(this.m_20183_()).m_19056_();
                if (this.m_21205_().m_41619_() && this.m_6060_() && this.f_19796_.m_188501_() < f * 0.3f) {
                    entityIn.m_20254_(2 * (int)f);
                }
            }
            if (!this.m_21205_().m_41619_() && this.m_21205_().m_41763_()) {
                ItemHelper.hurtAndBreak(this.m_21205_(), 1, this);
            }
        }
        return flag;
    }

    protected void m_6472_(DamageSource pDamageSource, float pDamage) {
        if (!(pDamage <= 0.0f)) {
            if ((pDamage /= 4.0f) < 1.0f) {
                pDamage = 1.0f;
            }
            for (EquipmentSlot equipmentSlotType : EquipmentSlot.values()) {
                if (equipmentSlotType.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.m_6844_(equipmentSlotType);
                if (pDamageSource.m_269533_(DamageTypeTags.f_268745_) && itemstack.m_41720_().m_41475_() || !(itemstack.m_41720_() instanceof ArmorItem)) continue;
                itemstack.m_41622_((int)pDamage, (LivingEntity)this, p_214023_1_ -> p_214023_1_.m_21166_(equipmentSlotType));
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMONED_FLAGS, (Object)0);
    }

    private boolean getFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(SUMMONED_FLAGS);
        return (i & mask) != 0;
    }

    private void setFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(SUMMONED_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(SUMMONED_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    @Override
    public boolean isWandering() {
        return this.getFlag(1);
    }

    @Override
    public void setWandering(boolean wandering) {
        this.setFlags(1, wandering);
    }

    @Override
    public boolean isStaying() {
        return this.getFlag(2) && !this.isCommanded() && !this.m_20160_();
    }

    @Override
    public void setStaying(boolean staying) {
        this.setFlags(2, staying);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setUpgraded(compound.m_128471_("Upgraded"));
        if (compound.m_128441_("wandering")) {
            this.setWandering(compound.m_128471_("wandering"));
        }
        if (compound.m_128441_("staying")) {
            this.setStaying(compound.m_128471_("staying"));
        }
        if (compound.m_128441_("commandPos")) {
            this.commandPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("commandPos"));
        }
        if (compound.m_128441_("commandPosEntity") && EntityFinder.getLivingEntityByUuiD(compound.m_128342_("commandPosEntity")) != null) {
            this.commandPosEntity = EntityFinder.getLivingEntityByUuiD(compound.m_128342_("commandPosEntity"));
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Upgraded", this.upgraded);
        compound.m_128379_("wandering", this.isWandering());
        compound.m_128379_("staying", this.isStaying());
        if (this.commandPos != null) {
            compound.m_128365_("commandPos", (Tag)NbtUtils.m_129224_((BlockPos)this.commandPos));
        }
        if (this.commandPosEntity != null) {
            compound.m_128362_("commandPosEntity", this.commandPosEntity.m_20148_());
        }
        compound.m_128405_("commandTick", this.commandTick);
    }

    @Override
    public boolean canUpdateMove() {
        return this.m_6336_() == MobType.f_21641_ || this.m_6336_() == ModMobType.NATURAL;
    }

    @Override
    public void updateMoveMode(Player player) {
        if (!this.isWandering() && !this.isStaying()) {
            this.setWandering(true);
            this.setStaying(false);
            player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.wander", (Object[])new Object[]{this.m_5446_()}), true);
        } else if (!this.isStaying()) {
            this.setWandering(false);
            this.setStaying(true);
            player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.staying", (Object[])new Object[]{this.m_5446_()}), true);
        } else {
            this.setWandering(false);
            this.setStaying(false);
            player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.follow", (Object[])new Object[]{this.m_5446_()}), true);
        }
        this.m_5496_(SoundEvents.f_12616_, 1.0f, 1.0f);
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public void setUpgraded(boolean upgraded) {
        this.upgraded = upgraded;
    }

    @Override
    public void setCommandPos(BlockPos blockPos) {
        this.setCommandPos(blockPos, true);
    }

    @Override
    public void setCommandPos(BlockPos blockPos, boolean removeEntity) {
        if (removeEntity) {
            this.commandPosEntity = null;
        }
        this.commandPos = blockPos;
        this.commandTick = MathHelper.secondsToTicks(10);
    }

    @Override
    public void setCommandPosEntity(LivingEntity living) {
        this.commandPosEntity = living;
        this.setCommandPos(living.m_20183_(), false);
    }

    public boolean isCommanded() {
        return this.commandPos != null;
    }

    public void dropEquipment(EquipmentSlot equipmentSlot, ItemStack stack) {
        if (this.m_21519_(equipmentSlot) > 0.0f) {
            this.m_19983_(stack);
        }
    }

    public static class FollowOwnerGoal
    extends Goal {
        private final Summoned summonedEntity;
        private LivingEntity owner;
        private final LevelReader level;
        private final double followSpeed;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private final float startDistance;
        private float oldWaterCost;

        public FollowOwnerGoal(Summoned summonedEntity, double speed, float startDistance, float stopDistance) {
            this.summonedEntity = summonedEntity;
            this.level = summonedEntity.f_19853_;
            this.followSpeed = speed;
            this.navigation = summonedEntity.m_21573_();
            this.startDistance = startDistance;
            this.stopDistance = stopDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(summonedEntity.m_21573_() instanceof GroundPathNavigation) && !(summonedEntity.m_21573_() instanceof FlyingPathNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.summonedEntity.getTrueOwner();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            if (this.summonedEntity.m_20280_((Entity)livingentity) < (double)Mth.m_14207_((float)this.startDistance)) {
                return false;
            }
            if (this.summonedEntity.isWandering() || this.summonedEntity.isStaying() || this.summonedEntity.isCommanded()) {
                return false;
            }
            if (this.summonedEntity.m_5448_() != null) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean m_8045_() {
            if (this.navigation.m_26571_()) {
                return false;
            }
            if (this.summonedEntity.m_5448_() != null) {
                return false;
            }
            return !(this.summonedEntity.m_20280_((Entity)this.owner) <= (double)Mth.m_14207_((float)this.stopDistance));
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.summonedEntity.m_21439_(BlockPathTypes.WATER);
            this.summonedEntity.m_21441_(BlockPathTypes.WATER, 0.0f);
        }

        public void m_8041_() {
            this.owner = null;
            this.navigation.m_26573_();
            this.summonedEntity.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        }

        public void m_8037_() {
            if (this.owner != null) {
                this.summonedEntity.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.summonedEntity.m_8132_());
                if (this.summonedEntity.m_275832_() != null) {
                    this.navigation.m_5624_((Entity)this.owner, this.followSpeed + 0.25);
                    Entity entity = this.summonedEntity.m_275832_();
                    if (entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        mob.m_21573_().m_5624_((Entity)this.owner, this.followSpeed + 0.25);
                    }
                } else if (--this.timeToRecalcPath <= 0) {
                    this.timeToRecalcPath = 10;
                    if (!this.summonedEntity.m_21523_() && !this.summonedEntity.m_20159_()) {
                        if (this.summonedEntity.m_20280_((Entity)this.owner) >= 144.0 && ((Boolean)MobsConfig.UndeadTeleport.get()).booleanValue()) {
                            this.tryToTeleportNearEntity();
                        } else {
                            this.navigation.m_5624_((Entity)this.owner, this.followSpeed);
                        }
                    }
                }
            }
        }

        private void tryToTeleportNearEntity() {
            BlockPos blockpos = this.owner.m_20183_();
            for (int i = 0; i < 10; ++i) {
                int j = this.getRandomNumber(-3, 3);
                int k = this.getRandomNumber(-1, 1);
                int l = this.getRandomNumber(-3, 3);
                boolean flag = this.tryToTeleportToLocation(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
                if (!flag) continue;
                return;
            }
        }

        private boolean tryToTeleportToLocation(int x, int y, int z) {
            if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
                return false;
            }
            if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
                return false;
            }
            this.summonedEntity.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.summonedEntity.m_146908_(), this.summonedEntity.m_146909_());
            this.navigation.m_26573_();
            return true;
        }

        private boolean isTeleportFriendlyBlock(BlockPos pos) {
            BlockPathTypes pathnodetype = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
            if (pathnodetype != BlockPathTypes.WALKABLE) {
                return false;
            }
            BlockState blockstate = this.level.m_8055_(pos.m_7495_());
            if (blockstate.m_60734_() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockpos = pos.m_121996_((Vec3i)this.summonedEntity.m_20183_());
            return this.level.m_45756_((Entity)this.summonedEntity, this.summonedEntity.m_20191_().m_82338_(blockpos));
        }

        private int getRandomNumber(int min, int max) {
            return this.summonedEntity.m_217043_().m_188503_(max - min + 1) + min;
        }
    }

    public static class NaturalAttackGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        protected Summoned summoned;

        public NaturalAttackGoal(Summoned summoned, Class<T> p_26061_) {
            super((Mob)summoned, p_26061_, true);
            this.summoned = summoned;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.summoned.isNatural() && this.summoned.getTrueOwner() == null && this.f_26050_ != null;
        }
    }

    public static class GoToWaterGoal
    extends Goal {
        private final Summoned mob;
        private double wantedX;
        private double wantedY;
        private double wantedZ;
        private final double speedModifier;
        private final Level level;

        public GoToWaterGoal(Summoned p_i48910_1_, double p_i48910_2_) {
            this.mob = p_i48910_1_;
            this.speedModifier = p_i48910_2_;
            this.level = p_i48910_1_.f_19853_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.getTrueOwner() != null ? !this.mob.getTrueOwner().m_20069_() : !this.level.m_46461_()) {
                return false;
            }
            if (this.mob.m_20069_()) {
                return false;
            }
            Vec3 vector3d = this.getWaterPos();
            if (vector3d == null) {
                return false;
            }
            this.wantedX = vector3d.f_82479_;
            this.wantedY = vector3d.f_82480_;
            this.wantedZ = vector3d.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        @Nullable
        private Vec3 getWaterPos() {
            RandomSource random = this.mob.m_217043_();
            BlockPos blockpos = this.mob.m_20183_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(random.m_188503_(20) - 10, 2 - random.m_188503_(8), random.m_188503_(20) - 10);
                if (!this.level.m_8055_(blockpos1).m_60713_(Blocks.f_49990_)) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }

    public class WaterWanderGoal
    extends RandomStrollGoal {
        public WaterWanderGoal(PathfinderMob p_i47301_1_) {
            super(p_i47301_1_, 1.0);
        }

        public boolean m_8036_() {
            if (super.m_8036_()) {
                return !Summoned.this.isStaying() || Summoned.this.getTrueOwner() == null;
            }
            return false;
        }
    }

    public class WanderGoal
    extends RandomStrollGoal {
        protected final float probability;

        public WanderGoal(PathfinderMob p_i47301_1_, double p_i47301_2_) {
            this(p_i47301_1_, p_i47301_2_, 0.001f);
        }

        public WanderGoal(PathfinderMob entity, double speedModifier, float probability) {
            super(entity, speedModifier, 120, false);
            this.probability = probability;
        }

        @Nullable
        protected Vec3 m_7037_() {
            if (this.f_25725_.m_20072_()) {
                Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)15, (int)7);
                return vec3 == null ? super.m_7037_() : vec3;
            }
            return this.f_25725_.m_217043_().m_188501_() >= this.probability ? LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)10, (int)7) : super.m_7037_();
        }

        public boolean m_8036_() {
            if (super.m_8036_()) {
                return (!Summoned.this.isStaying() && !Summoned.this.isCommanded() || Summoned.this.getTrueOwner() == null) && !(Summoned.this.m_21573_() instanceof WaterBoundPathNavigation);
            }
            return false;
        }
    }
}

