/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.api.blocks.entities.IWindPowered;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.entities.ai.SummonTargetGoal;
import com.Polarice3.Goety.common.entities.ally.AbstractGolemServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SquallGolem
extends AbstractGolemServant
implements IWindPowered {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(SquallGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private int startingUpTick;
    private int shuttingDownTick;
    public int activeTime;
    public int attackTick;
    private int idleTime;
    public int noveltyTick;
    public int homeTick;
    public boolean isNovelty = false;
    public boolean requiresPower = true;
    public boolean proximity = false;
    public BlockPos homePos;
    public AnimationState activateAnimationState = new AnimationState();
    public AnimationState deactivateAnimationState = new AnimationState();
    public AnimationState offAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState alertAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();

    public SquallGolem(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(5, (Goal)new AttackGoal(1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f){

            public boolean m_8036_() {
                return super.m_8036_() && SquallGolem.this.isNotProcessing();
            }
        });
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f){

            public boolean m_8036_() {
                return super.m_8036_() && SquallGolem.this.isNotProcessing();
            }
        });
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.SquallGolemHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 1.25).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.SquallGolemDamage.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.SquallGolemHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.SquallGolemDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("ActiveTime", this.activeTime);
        pCompound.m_128405_("StartingUpTick", this.startingUpTick);
        pCompound.m_128405_("ShuttingDownTick", this.shuttingDownTick);
        pCompound.m_128379_("Activated", this.isActivated());
        pCompound.m_128379_("RequiresPower", this.requiresPower());
        pCompound.m_128379_("Proximity", this.isProximity());
        if (this.getHomePos() != null) {
            pCompound.m_128365_("HomePos", (Tag)NbtUtils.m_129224_((BlockPos)this.getHomePos()));
        }
        pCompound.m_128405_("HomeTick", this.homeTick);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("ActiveTime")) {
            this.activeTime = pCompound.m_128451_("ActiveTime");
        }
        if (pCompound.m_128441_("StartingUpTick")) {
            this.startingUpTick = pCompound.m_128451_("StartingUpTick");
        }
        if (pCompound.m_128441_("ShuttingDownTick")) {
            this.shuttingDownTick = pCompound.m_128451_("ShuttingDownTick");
        }
        if (pCompound.m_128441_("Activated")) {
            this.setActivated(pCompound.m_128471_("Activated"));
        }
        if (pCompound.m_128441_("RequiresPower")) {
            this.setRequiresPower(pCompound.m_128471_("RequiresPower"));
        }
        if (pCompound.m_128441_("Proximity")) {
            this.setProximity(pCompound.m_128471_("Proximity"));
        }
        if (pCompound.m_128441_("HomePos")) {
            this.homePos = NbtUtils.m_129239_((CompoundTag)pCompound.m_128469_("HomePos"));
        }
        if (pCompound.m_128441_("HomeTick")) {
            this.homeTick = pCompound.m_128451_("HomeTick");
        }
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        return (SoundEvent)ModSounds.SQUALL_GOLEM_HURT.get();
    }

    protected void m_7355_(@NotNull BlockPos p_20135_, @NotNull BlockState p_20136_) {
        this.m_5496_((SoundEvent)ModSounds.SQUALL_GOLEM_STEP.get(), 1.0f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SQUALL_GOLEM_DEATH.get();
    }

    private boolean getGolemFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setGolemFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isMeleeAttacking() {
        return this.getGolemFlag(1);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.setGolemFlags(1, attacking);
        this.attackTick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    public boolean isStartingUp() {
        return this.getGolemFlag(2);
    }

    public void setStartingUp(boolean activating) {
        this.setGolemFlags(2, activating);
    }

    public boolean isActivated() {
        return this.getGolemFlag(4);
    }

    public void setActivated(boolean activated) {
        this.setGolemFlags(4, activated);
    }

    public boolean isShuttingDown() {
        return this.getGolemFlag(8);
    }

    public void setShuttingDown(boolean deactivating) {
        this.setGolemFlags(8, deactivating);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isStartingUp() || this.isShuttingDown() || !this.isActivated();
    }

    public boolean m_142582_(@NotNull Entity p_149755_) {
        return !this.isStartingUp() && !this.isShuttingDown() && this.isActivated() && super.m_142582_(p_149755_);
    }

    @Override
    public int xpReward() {
        return 20;
    }

    @Override
    public boolean isWandering() {
        return false;
    }

    @Override
    public void updateMoveMode(Player player) {
        if (!this.isStaying()) {
            this.setStaying(true);
            player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.staying", (Object[])new Object[]{this.m_5446_()}), true);
        } else {
            this.setStaying(false);
            player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.follow", (Object[])new Object[]{this.m_5446_()}), true);
        }
        this.m_5496_(SoundEvents.f_12616_, 1.0f, 1.0f);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason != MobSpawnType.MOB_SUMMONED && pReason != MobSpawnType.COMMAND) {
            this.setActivated(true);
            this.setRequiresPower(false);
        } else {
            this.setActivated(false);
        }
        this.setStartingUp(false);
        this.setShuttingDown(false);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.activateAnimationState);
        animationStates.add(this.deactivateAnimationState);
        animationStates.add(this.offAnimationState);
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.alertAnimationState);
        animationStates.add(this.walkAnimationState);
        return animationStates;
    }

    public void stopMostAnimations(AnimationState animationState0) {
        for (AnimationState animationState : this.getAnimations()) {
            if (animationState == animationState0) continue;
            animationState.m_216973_();
        }
    }

    public void stopAnimations() {
        for (AnimationState animationState : this.getAnimations()) {
            animationState.m_216973_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_21224_()) {
            this.stopAnimations();
        }
        if (this.f_19853_.f_46443_ && this.m_6084_()) {
            if (!this.isStartingUp() && !this.isShuttingDown()) {
                if (!this.isActivated()) {
                    this.stopMostAnimations(this.offAnimationState);
                    this.offAnimationState.m_216982_(this.f_19797_);
                } else if (!this.isMeleeAttacking()) {
                    this.attackAnimationState.m_216973_();
                    if (this.isMoving()) {
                        this.stopMostAnimations(this.walkAnimationState);
                        this.walkAnimationState.m_216982_(this.f_19797_);
                    } else if (this.isNovelty) {
                        this.stopMostAnimations(this.alertAnimationState);
                        this.alertAnimationState.m_216982_(this.f_19797_);
                    } else {
                        this.stopMostAnimations(this.idleAnimationState);
                        this.idleAnimationState.m_216982_(this.f_19797_);
                    }
                } else if (this.isMeleeAttacking()) {
                    ++this.attackTick;
                }
            } else if (this.isStartingUp()) {
                this.stopMostAnimations(this.activateAnimationState);
                this.activateAnimationState.m_216982_(this.f_19797_);
            } else if (this.isShuttingDown()) {
                this.stopMostAnimations(this.deactivateAnimationState);
                this.deactivateAnimationState.m_216982_(this.f_19797_);
            }
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            if ((this.isStartingUp() || this.isActivated()) && this.f_19797_ % 7 == 0) {
                if (!this.m_5912_()) {
                    this.m_216990_((SoundEvent)ModSounds.SQUALL_GOLEM_WIND_SLOW.get());
                } else {
                    this.m_216990_((SoundEvent)ModSounds.SQUALL_GOLEM_WIND_FAST.get());
                }
            }
            if (this.proximity) {
                LivingEntity livingEntity = null;
                for (LivingEntity living : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(4.0))) {
                    if (!SummonTargetGoal.predicate((LivingEntity)this).test(living)) continue;
                    livingEntity = living;
                }
                if (livingEntity != null) {
                    this.activeTime = 100;
                }
            }
            if (this.requiresPower) {
                if (this.activeTime > 0) {
                    --this.activeTime;
                    if (!this.isStartingUp() && !this.isActivated()) {
                        this.setStartingUp(true);
                        this.f_19853_.m_7605_((Entity)this, (byte)25);
                    }
                } else if (this.homePos != null) {
                    ++this.homeTick;
                    if (this.m_21573_().m_6342_(this.homePos)) {
                        this.m_21573_().m_26519_((double)this.homePos.m_123341_() + 0.5, (double)this.homePos.m_123342_(), (double)this.homePos.m_123343_() + 0.5, 1.0);
                        if (this.m_21573_().m_26577_() || this.homeTick >= MathHelper.secondsToTicks(10)) {
                            this.homeTick = 0;
                            this.homePos = null;
                        } else if (this.homePos.m_203195_((Position)this.m_20182_(), (double)this.m_20205_() + 1.0)) {
                            this.m_20035_(this.homePos, this.m_146908_(), this.m_146909_());
                            this.homePos = null;
                        }
                    } else {
                        this.homePos = null;
                    }
                } else if (!this.isShuttingDown() && this.isActivated()) {
                    this.setShuttingDown(true);
                    this.f_19853_.m_7605_((Entity)this, (byte)26);
                }
            }
            if (this.isStartingUp() && !this.isActivated()) {
                this.m_21573_().m_26573_();
                ++this.startingUpTick;
                if (this.startingUpTick == 1) {
                    this.m_5496_((SoundEvent)ModSounds.SQUALL_GOLEM_ACTIVATE.get(), 2.0f, 1.0f);
                    this.m_216990_((SoundEvent)ModSounds.SQUALL_GOLEM_WIND_START.get());
                }
                if ((float)this.startingUpTick >= MathHelper.secondsToTicks(2.6f)) {
                    this.setStartingUp(false);
                    this.f_19853_.m_7605_((Entity)this, (byte)27);
                    this.setActivated(true);
                    this.f_19853_.m_7605_((Entity)this, (byte)29);
                    this.startingUpTick = 0;
                }
            } else if (this.isShuttingDown() && this.isActivated()) {
                this.m_21573_().m_26573_();
                ++this.shuttingDownTick;
                if (this.shuttingDownTick == 1) {
                    this.m_5496_((SoundEvent)ModSounds.SQUALL_GOLEM_DEACTIVATE.get(), 2.0f, 1.0f);
                    this.m_216990_((SoundEvent)ModSounds.SQUALL_GOLEM_WIND_START.get());
                }
                if ((float)this.shuttingDownTick >= MathHelper.secondsToTicks(2.6f)) {
                    this.setShuttingDown(false);
                    this.f_19853_.m_7605_((Entity)this, (byte)28);
                    this.setActivated(false);
                    this.f_19853_.m_7605_((Entity)this, (byte)30);
                    this.shuttingDownTick = 0;
                }
            }
            if (!this.isStartingUp() && !this.isShuttingDown()) {
                if (this.isMeleeAttacking()) {
                    ++this.attackTick;
                }
                if (this.isActivated() && !this.isMeleeAttacking() && !this.isMoving()) {
                    ++this.idleTime;
                    if (this.f_19853_.f_46441_.m_188501_() <= 0.05f && this.f_20916_ <= 0 && (this.m_5448_() == null || this.m_5448_().m_21224_()) && !this.isNovelty && this.idleTime >= MathHelper.secondsToTicks(10)) {
                        this.idleTime = 0;
                        this.isNovelty = true;
                        this.f_19853_.m_7605_((Entity)this, (byte)22);
                    }
                } else {
                    this.isNovelty = false;
                    this.f_19853_.m_7605_((Entity)this, (byte)23);
                }
                if (this.isNovelty) {
                    ++this.noveltyTick;
                    this.f_19853_.m_7605_((Entity)this, (byte)24);
                    if (this.noveltyTick >= 150 || this.m_5448_() != null || this.f_20916_ > 0) {
                        this.isNovelty = false;
                        this.noveltyTick = 0;
                        this.f_19853_.m_7605_((Entity)this, (byte)23);
                    }
                }
            }
        }
    }

    @Override
    public void stayingMode() {
    }

    public boolean isNotActive() {
        return !this.isActivated() || this.isStartingUp() || this.isShuttingDown();
    }

    public boolean fullyInactive() {
        return !this.isActivated() && !this.isStartingUp() && !this.isShuttingDown();
    }

    public boolean isNotProcessing() {
        return !this.isStartingUp() && !this.isShuttingDown();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isNotActive() && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7822_(byte pId) {
        if (pId == 5) {
            this.attackTick = 0;
        } else if (pId == 6) {
            this.stopAnimations();
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 8) {
            this.stopAnimations();
            this.activateAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 11) {
            this.attackAnimationState.m_216973_();
        } else if (pId == 12) {
            this.stopAnimations();
            this.deactivateAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 13) {
            this.stopAnimations();
            this.offAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 17) {
            this.setMeleeAttacking(true);
        } else if (pId == 18) {
            this.setMeleeAttacking(false);
        } else if (pId == 19) {
            this.m_21561_(true);
        } else if (pId == 31) {
            this.m_21561_(false);
        } else if (pId == 22) {
            this.isNovelty = true;
        } else if (pId == 23) {
            this.isNovelty = false;
            this.noveltyTick = 0;
        } else if (pId == 24) {
            ++this.noveltyTick;
        } else if (pId == 25) {
            this.setStartingUp(true);
        } else if (pId == 26) {
            this.setShuttingDown(true);
        } else if (pId == 27) {
            this.setStartingUp(false);
        } else if (pId == 28) {
            this.setShuttingDown(false);
        } else if (pId == 29) {
            this.setActivated(true);
        } else if (pId == 30) {
            this.setActivated(false);
        } else {
            super.m_7822_(pId);
        }
    }

    public Vec3 getHorizontalLookAngle() {
        return this.m_20171_(0.0f, this.m_146908_());
    }

    @Override
    public double getAttackReachSqr(LivingEntity enemy) {
        return (double)(this.m_20205_() * 6.0f + enemy.m_20205_()) + 1.0;
    }

    @Override
    public boolean targetClose(LivingEntity enemy, double distToEnemySqr) {
        double reach = this.getAttackReachSqr(enemy);
        return distToEnemySqr <= reach || this.m_20191_().m_82381_(enemy.m_20191_());
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        if (!this.f_19853_.f_46443_ && !this.isMeleeAttacking()) {
            this.setMeleeAttacking(true);
            this.f_19853_.m_7605_((Entity)this, (byte)17);
        }
        return true;
    }

    @Override
    public int activeTicks() {
        return this.activeTime;
    }

    @Override
    public void activate(int tick) {
        this.activeTime = tick;
    }

    public boolean requiresPower() {
        return this.requiresPower;
    }

    public void setRequiresPower(boolean power) {
        this.requiresPower = power;
    }

    public boolean isProximity() {
        return this.proximity;
    }

    public void setProximity(boolean power) {
        this.proximity = power;
    }

    public BlockPos getHomePos() {
        return this.homePos;
    }

    public void setHomePos(BlockPos blockPos) {
        this.homePos = blockPos;
    }

    @Override
    public void setCommandPos(BlockPos blockPos, boolean removeEntity) {
        if (this.isActivated() && !this.isStartingUp() && !this.isShuttingDown()) {
            super.setCommandPos(blockPos, removeEntity);
        }
    }

    @Override
    public void setCommandPosEntity(LivingEntity living) {
        if (this.isActivated() && !this.isStartingUp() && !this.isShuttingDown()) {
            super.setCommandPosEntity(living);
        }
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            Item item = itemstack.m_41720_();
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
                if ((item == ((Block)ModBlocks.JADE_BLOCK.get()).m_5456_() || item == ModItems.JADE.get()) && this.m_21223_() < this.m_21233_()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    if (item == ((Block)ModBlocks.JADE_BLOCK.get()).m_5456_()) {
                        this.m_5634_(this.m_21233_() / 4.0f);
                        this.m_5496_(SoundEvents.f_12009_, 1.0f, 1.25f);
                    } else {
                        this.m_5634_(this.m_21233_() / 4.0f / 8.0f);
                        this.m_5496_(SoundEvents.f_12009_, 0.25f, 1.0f);
                    }
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.HEAL_EFFECT.get(), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                    }
                } else if (itemstack.m_41619_() && this.fullyInactive()) {
                    float f = (float)Mth.m_14143_((float)((Mth.m_14177_((float)(pPlayer.m_146908_() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
                    this.m_146922_(f);
                    this.m_5616_(f);
                    this.m_5496_(SoundEvents.f_12010_, 1.0f, 0.5f);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    class MeleeGoal
    extends Goal {
        private float yRot;

        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return SquallGolem.this.m_5448_() != null && SquallGolem.this.isMeleeAttacking();
        }

        public boolean m_8045_() {
            return (float)SquallGolem.this.attackTick < MathHelper.secondsToTicks(1.7083f);
        }

        public void m_8056_() {
            SquallGolem.this.setMeleeAttacking(true);
            SquallGolem.this.f_19853_.m_7605_((Entity)SquallGolem.this, (byte)17);
            if (SquallGolem.this.m_5448_() != null) {
                MobUtil.instaLook((Mob)SquallGolem.this, SquallGolem.this.m_5448_());
            }
            this.yRot = SquallGolem.this.f_20883_;
        }

        public void m_8041_() {
            SquallGolem.this.setMeleeAttacking(false);
            SquallGolem.this.f_19853_.m_7605_((Entity)SquallGolem.this, (byte)18);
        }

        public void m_8037_() {
            SquallGolem.this.m_146922_(this.yRot);
            SquallGolem.this.f_20883_ = this.yRot;
            SquallGolem.this.m_21573_().m_26573_();
            if (SquallGolem.this.attackTick == 1) {
                SquallGolem.this.m_5496_((SoundEvent)ModSounds.SQUALL_GOLEM_ATTACK.get(), 5.0f, 1.0f);
                SquallGolem.this.f_19853_.m_7605_((Entity)SquallGolem.this, (byte)6);
            }
            if (SquallGolem.this.attackTick == 15) {
                LivingEntity target2;
                AABB aabb = MeleeGoal.makeAttackRange(SquallGolem.this.m_20185_() + SquallGolem.this.getHorizontalLookAngle().f_82479_ * 2.0, SquallGolem.this.m_20186_(), SquallGolem.this.m_20189_() + SquallGolem.this.getHorizontalLookAngle().f_82481_ * 2.0, 5.0, 3.0, 5.0);
                for (LivingEntity target2 : SquallGolem.this.f_19853_.m_45976_(LivingEntity.class, aabb)) {
                    if (target2 == SquallGolem.this || target2.m_7307_((Entity)SquallGolem.this) || SquallGolem.this.m_7307_((Entity)target2)) continue;
                    this.hurtTarget((Entity)target2);
                }
                target2 = SquallGolem.this.f_19853_;
                if (target2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)target2;
                    BlockPos blockPos = BlockPos.m_274561_((double)(SquallGolem.this.m_20185_() + SquallGolem.this.getHorizontalLookAngle().f_82479_ * 2.0), (double)(SquallGolem.this.m_20186_() - 1.0), (double)(SquallGolem.this.m_20189_() + SquallGolem.this.getHorizontalLookAngle().f_82481_ * 2.0));
                    BlockParticleOption option = new BlockParticleOption(ParticleTypes.f_123794_, serverLevel.m_8055_(blockPos));
                    for (int i = 0; i < 8; ++i) {
                        ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)option, SquallGolem.this.m_20185_() + SquallGolem.this.getHorizontalLookAngle().f_82479_ * 2.0, SquallGolem.this.m_20186_() + 0.25, SquallGolem.this.m_20189_() + SquallGolem.this.getHorizontalLookAngle().f_82481_ * 2.0, 3.0f);
                    }
                }
            }
        }

        public void hurtTarget(Entity target) {
            float f = (float)SquallGolem.this.m_21133_(Attributes.f_22281_);
            float f1 = (float)SquallGolem.this.m_21133_(Attributes.f_22282_);
            DamageSource damageSource = SquallGolem.this.getTrueOwner() != null ? ModDamageSource.summonAttack((LivingEntity)SquallGolem.this, SquallGolem.this.getTrueOwner()) : SquallGolem.this.m_269291_().m_269333_((LivingEntity)SquallGolem.this);
            boolean flag = target.m_6469_(damageSource, f);
            if (flag) {
                if (f1 > 0.0f && target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    if (livingEntity.m_20191_().m_82309_() > SquallGolem.this.m_20191_().m_82309_()) {
                        livingEntity.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(SquallGolem.this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(SquallGolem.this.m_146908_() * ((float)Math.PI / 180)))));
                    } else {
                        MobUtil.forcefulKnockBack(livingEntity, f1 * 0.5f, Mth.m_14031_((float)(SquallGolem.this.m_146908_() * ((float)Math.PI / 180))), -Mth.m_14089_((float)(SquallGolem.this.m_146908_() * ((float)Math.PI / 180))), 0.5);
                    }
                    SquallGolem.this.m_20256_(SquallGolem.this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                SquallGolem.this.m_19970_((LivingEntity)SquallGolem.this, target);
                SquallGolem.this.m_21335_(target);
            }
        }

        public static AABB makeAttackRange(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
            return new AABB(x - sizeX / 2.0, y - sizeY / 2.0, z - sizeZ / 2.0, x + sizeX / 2.0, y + sizeY / 2.0, z + sizeZ / 2.0);
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        private final double moveSpeed;
        private int delayCounter;

        public AttackGoal(double moveSpeed) {
            super((PathfinderMob)SquallGolem.this, moveSpeed, true);
            this.moveSpeed = moveSpeed;
        }

        public boolean m_8036_() {
            return SquallGolem.this.m_5448_() != null && SquallGolem.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            SquallGolem.this.m_21561_(true);
            SquallGolem.this.f_19853_.m_7605_((Entity)SquallGolem.this, (byte)19);
            this.delayCounter = 0;
        }

        public void m_8041_() {
            SquallGolem.this.m_21573_().m_26573_();
            SquallGolem.this.m_21561_(false);
            SquallGolem.this.f_19853_.m_7605_((Entity)SquallGolem.this, (byte)31);
        }

        public void m_8037_() {
            LivingEntity livingentity = SquallGolem.this.m_5448_();
            if (livingentity == null) {
                return;
            }
            SquallGolem.this.m_21563_().m_24960_((Entity)livingentity, (float)SquallGolem.this.m_8085_(), (float)SquallGolem.this.m_8132_());
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                SquallGolem.this.m_21573_().m_5624_((Entity)livingentity, this.moveSpeed);
            }
            this.m_6739_(livingentity, SquallGolem.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_()));
        }

        protected void m_6739_(@NotNull LivingEntity enemy, double distToEnemySqr) {
            if (SquallGolem.this.targetClose(enemy, distToEnemySqr)) {
                SquallGolem.this.m_7327_((Entity)enemy);
            }
        }
    }
}

