/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.MobsConfig;
import com.Polarice3.Goety.common.entities.ally.MagmaCubeServant;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SlimeServant
extends Summoned {
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(SlimeServant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_INTERESTED_ID = SynchedEntityData.m_135353_(SlimeServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float interestTime;
    public static final int MIN_SIZE = 1;
    public static final int MAX_SIZE = 127;
    public float targetSquish;
    public float squish;
    public float oSquish;
    private boolean wasOnGround;

    public SlimeServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new SlimeServantMoveControl(this);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new SlimeFloatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SlimeAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SlimeRandomDirectionGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new SlimeKeepOnJumpingGoal(this));
    }

    @Override
    public void followGoal() {
        this.f_21345_.m_25352_(8, (Goal)new SlimeFollowGoal(this, 4.0f, 10.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22266_(Attributes.f_22281_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_SIZE, (Object)1);
        this.f_19804_.m_135372_(DATA_INTERESTED_ID, (Object)false);
    }

    public void setSize(int p_33594_, boolean p_33595_) {
        int i = Mth.m_14045_((int)p_33594_, (int)1, (int)127);
        this.f_19804_.m_135381_(ID_SIZE, (Object)i);
        this.m_20090_();
        this.m_6210_();
        this.m_21051_(Attributes.f_22276_).m_22100_((double)(i * i));
        this.m_21051_(Attributes.f_22279_).m_22100_((double)(0.2f + 0.1f * (float)i));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)i);
        if (p_33595_) {
            this.m_21153_(this.m_21233_());
        }
        this.f_21364_ = i;
    }

    public int getSize() {
        return (Integer)this.f_19804_.m_135370_(ID_SIZE);
    }

    public void setIsInterested(boolean pBeg) {
        this.f_19804_.m_135381_(DATA_INTERESTED_ID, (Object)pBeg);
    }

    public boolean isInterested() {
        return (Boolean)this.f_19804_.m_135370_(DATA_INTERESTED_ID);
    }

    @Override
    public void m_7380_(CompoundTag p_33619_) {
        super.m_7380_(p_33619_);
        p_33619_.m_128405_("Size", this.getSize() - 1);
        p_33619_.m_128379_("wasOnGround", this.wasOnGround);
    }

    @Override
    public void m_7378_(CompoundTag p_33607_) {
        this.setSize(p_33607_.m_128451_("Size") + 1, false);
        super.m_7378_(p_33607_);
        this.wasOnGround = p_33607_.m_128471_("wasOnGround");
    }

    public boolean isTiny() {
        return this.getSize() <= 1;
    }

    protected ParticleOptions getParticleType() {
        return ParticleTypes.f_123753_;
    }

    @Override
    protected boolean m_8028_() {
        return this.getSize() > 0 && super.m_8028_();
    }

    @Override
    public boolean canUpdateMove() {
        return true;
    }

    @Override
    public void m_8119_() {
        this.squish += (this.targetSquish - this.squish) * 0.5f;
        this.oSquish = this.squish;
        if (this.m_6084_()) {
            if (this.isInterested()) {
                this.interestTime -= 1.0f;
            }
            if (this.interestTime <= 0.0f) {
                this.setIsInterested(false);
            }
            if (this.m_5448_() != null && this.m_5448_().m_6084_()) {
                AABB aabb = this.m_5448_().m_20159_() && this.m_5448_().m_20202_() != null ? this.m_5448_().m_20191_().m_82367_(this.m_5448_().m_20202_().m_20191_()).m_82377_(1.0, 0.0, 1.0) : this.m_5448_().m_20191_().m_82377_(1.0, 0.5, 1.0);
                List list = this.m_9236_().m_45976_(LivingEntity.class, aabb);
                for (LivingEntity target : list) {
                    if (target != this.m_5448_()) continue;
                    this.dealDamage(target);
                }
            }
        }
        super.m_8119_();
        if (this.m_20096_() && !this.wasOnGround) {
            int i = this.getSize();
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float f1 = this.f_19796_.m_188501_() * 0.5f + 0.5f;
                float f2 = Mth.m_14031_((float)f) * (float)i * 0.5f * f1;
                float f3 = Mth.m_14089_((float)f) * (float)i * 0.5f * f1;
                this.f_19853_.m_7106_(this.getParticleType(), this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.m_5496_(this.getSquishSound(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) / 0.8f);
            this.targetSquish = -0.5f;
        } else if (!this.m_20096_() && this.wasOnGround) {
            this.targetSquish = 1.0f;
        }
        this.wasOnGround = this.m_20096_();
        this.decreaseSquish();
    }

    protected void decreaseSquish() {
        this.targetSquish *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.f_19796_.m_188503_(20) + 10;
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public void m_7350_(EntityDataAccessor<?> p_33609_) {
        if (ID_SIZE.equals(p_33609_)) {
            this.m_6210_();
            this.m_146922_(this.f_20885_);
            this.f_20883_ = this.f_20885_;
            if (this.m_20069_() && this.f_19796_.m_188503_(20) == 0) {
                this.m_5841_();
            }
        }
        super.m_7350_(p_33609_);
    }

    public EntityType<? extends SlimeServant> m_6095_() {
        return super.m_6095_();
    }

    public void m_142687_(Entity.RemovalReason p_149847_) {
        int i = this.getSize();
        if (!this.f_19853_.f_46443_ && i > 1 && this.m_21224_()) {
            Component component = this.m_7770_();
            boolean flag = this.m_21525_();
            float f = (float)i / 4.0f;
            int j = i / 2;
            int k = 2 + this.f_19796_.m_188503_(3);
            for (int l = 0; l < k; ++l) {
                float f1 = ((float)(l % 2) - 0.5f) * f;
                float f2 = ((float)(l / 2) - 0.5f) * f;
                SlimeServant slime = (SlimeServant)this.m_6095_().m_20615_(this.f_19853_);
                if (this.m_21532_()) {
                    slime.m_21530_();
                }
                slime.m_6593_(component);
                slime.m_21557_(flag);
                slime.m_20331_(this.m_20147_());
                slime.setSize(j, true);
                if (this.getTrueOwner() != null) {
                    slime.setTrueOwner(this.getTrueOwner());
                }
                slime.m_7678_(this.m_20185_() + (double)f1, this.m_20186_() + 0.5, this.m_20189_() + (double)f2, this.f_19796_.m_188501_() * 360.0f, 0.0f);
                this.f_19853_.m_7967_((Entity)slime);
            }
        }
        super.m_142687_(p_149847_);
    }

    @Override
    public void m_7334_(Entity p_33636_) {
        super.m_7334_(p_33636_);
        if (p_33636_ == this.m_5448_() && this.isDealsDamage()) {
            this.dealDamage((LivingEntity)p_33636_);
        }
    }

    protected void dealDamage(LivingEntity p_33638_) {
        if (this.m_6084_()) {
            int i = this.getSize();
            if (this.m_20280_((Entity)p_33638_) < 0.6 * (double)i * 0.6 * (double)i && this.m_142582_((Entity)p_33638_) && p_33638_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.getAttackDamage())) {
                this.m_5496_(SoundEvents.f_12384_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.m_19970_((LivingEntity)this, (Entity)p_33638_);
            }
        }
    }

    protected float m_6431_(Pose p_33614_, EntityDimensions p_33615_) {
        return 0.625f * p_33615_.f_20378_;
    }

    protected boolean isDealsDamage() {
        return !this.isTiny() && this.m_21515_();
    }

    protected float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    protected SoundEvent m_7975_(DamageSource p_33631_) {
        return this.isTiny() ? SoundEvents.f_12468_ : SoundEvents.f_12386_;
    }

    protected SoundEvent m_5592_() {
        return this.isTiny() ? SoundEvents.f_12467_ : SoundEvents.f_12385_;
    }

    protected SoundEvent getSquishSound() {
        return this.isTiny() ? SoundEvents.f_12470_ : SoundEvents.f_12388_;
    }

    protected float m_6121_() {
        return 0.4f * (float)this.getSize();
    }

    public int m_8132_() {
        return 0;
    }

    protected boolean doPlayJumpSound() {
        return this.getSize() > 0;
    }

    protected void m_6135_() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, this.m_6118_(), vec3.f_82481_);
        this.f_19812_ = true;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33601_, DifficultyInstance p_33602_, MobSpawnType p_33603_, @Nullable SpawnGroupData p_33604_, @Nullable CompoundTag p_33605_) {
        if (p_33603_ != MobSpawnType.MOB_SUMMONED) {
            RandomSource randomsource = p_33601_.m_213780_();
            int i = randomsource.m_188503_(3);
            if (i < 2 && randomsource.m_188501_() < 0.5f * p_33602_.m_19057_()) {
                ++i;
            }
            int j = 1 << i;
            this.setSize(j, true);
        }
        return super.m_6518_(p_33601_, p_33602_, p_33603_, p_33604_, p_33605_);
    }

    float getSoundPitch() {
        float f = this.isTiny() ? 1.4f : 0.8f;
        return ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * f;
    }

    protected SoundEvent getJumpSound() {
        return this.isTiny() ? SoundEvents.f_12469_ : SoundEvents.f_12387_;
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(0.255f * (float)this.getSize());
    }

    protected boolean spawnCustomParticles() {
        return false;
    }

    public Item getIncreaseItem() {
        return Items.f_42204_;
    }

    public Item getHealItem() {
        return Items.f_42518_;
    }

    public InteractionResult m_6071_(Player p_34394_, InteractionHand p_34395_) {
        ItemStack itemstack = p_34394_.m_21120_(p_34395_);
        if (itemstack.m_150930_(this.getIncreaseItem())) {
            if (this.getSize() < (Integer)MobsConfig.MaxSlimeSize.get()) {
                if (!p_34394_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.setSize(this.getSize() + 1, true);
                this.m_216990_(SoundEvents.f_12384_);
                return InteractionResult.SUCCESS;
            }
            if (this.m_21223_() < this.m_21233_()) {
                if (!p_34394_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(20.0f);
                this.m_216990_(this.getSquishSound());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (itemstack.m_150930_(this.getHealItem())) {
            if (this.m_21223_() < this.m_21233_()) {
                if (!p_34394_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(2.0f);
                this.m_216990_(this.getSquishSound());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (this.getTrueOwner() != null && p_34394_ == this.getTrueOwner()) {
            if (!this.isInterested()) {
                if (itemstack.m_41619_()) {
                    this.setIsInterested(true);
                    this.interestTime = 40.0f;
                    this.f_19853_.m_7605_((Entity)this, (byte)102);
                    this.m_5496_(this.getSquishSound(), 1.0f, 2.0f);
                    this.m_5634_(1.0f);
                    if (this instanceof MagmaCubeServant && !p_34394_.m_5825_()) {
                        p_34394_.m_20254_(5);
                        if (p_34394_.m_6469_(this.m_269291_().m_269047_(), 2.0f)) {
                            p_34394_.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + this.f_19796_.m_188501_() * 0.4f);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(p_34394_, p_34395_);
    }

    public void m_7822_(byte pId) {
        super.m_7822_(pId);
        if (pId == 102) {
            this.setIsInterested(true);
            this.interestTime = 40.0f;
            this.m_5496_(SoundEvents.f_12388_, 1.0f, 2.0f);
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123750_);
        }
    }

    protected void addParticlesAroundSelf(ParticleOptions pParticleData) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_(pParticleData, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    static class SlimeServantMoveControl
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final SlimeServant slime;
        private boolean isAggressive;

        public SlimeServantMoveControl(SlimeServant p_33668_) {
            super((Mob)p_33668_);
            this.slime = p_33668_;
            this.yRot = 180.0f * p_33668_.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float p_33673_, boolean p_33674_) {
            this.yRot = p_33673_;
            this.isAggressive = p_33674_;
        }

        public void setWantedMovement(double p_33671_) {
            this.f_24978_ = p_33671_;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.m_21569_().m_24901_();
                        if (this.slime.doPlayJumpSound()) {
                            this.slime.m_5496_(this.slime.getJumpSound(), this.slime.m_6121_(), this.slime.getSoundPitch());
                        }
                    } else {
                        this.slime.f_20900_ = 0.0f;
                        this.slime.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    static class SlimeFloatGoal
    extends Goal {
        private final SlimeServant slime;

        public SlimeFloatGoal(SlimeServant p_33655_) {
            this.slime = p_33655_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            p_33655_.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return (this.slime.m_20069_() || this.slime.m_20077_()) && this.slime.m_21566_() instanceof SlimeServantMoveControl;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            MoveControl movecontrol;
            if (this.slime.m_217043_().m_188501_() < 0.8f) {
                this.slime.m_21569_().m_24901_();
            }
            if ((movecontrol = this.slime.m_21566_()) instanceof SlimeServantMoveControl) {
                SlimeServantMoveControl slime$slimemovecontrol = (SlimeServantMoveControl)movecontrol;
                slime$slimemovecontrol.setWantedMovement(1.2);
            }
        }
    }

    static class SlimeAttackGoal
    extends Goal {
        private final SlimeServant slime;
        private int growTiredTimer;

        public SlimeAttackGoal(SlimeServant p_33648_) {
            this.slime = p_33648_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            return this.slime.m_6779_(livingentity) && this.slime.m_21566_() instanceof SlimeServantMoveControl;
        }

        public void m_8056_() {
            this.growTiredTimer = SlimeAttackGoal.m_186073_((int)300);
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!this.slime.m_6779_(livingentity)) {
                return false;
            }
            return --this.growTiredTimer > 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            MoveControl movecontrol;
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity != null) {
                this.slime.m_21391_((Entity)livingentity, 10.0f, 10.0f);
            }
            if ((movecontrol = this.slime.m_21566_()) instanceof SlimeServantMoveControl) {
                SlimeServantMoveControl slime$slimemovecontrol = (SlimeServantMoveControl)movecontrol;
                slime$slimemovecontrol.setDirection(this.slime.m_146908_(), this.slime.isDealsDamage());
            }
        }
    }

    static class SlimeRandomDirectionGoal
    extends Goal {
        private final SlimeServant slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public SlimeRandomDirectionGoal(SlimeServant p_33679_) {
            this.slime = p_33679_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return !(this.slime.m_5448_() != null || this.slime.getTrueOwner() != null && !this.slime.isWandering() || !this.slime.m_20096_() && !this.slime.m_20069_() && !this.slime.m_20077_() && !this.slime.m_21023_(MobEffects.f_19620_) || !(this.slime.m_21566_() instanceof SlimeServantMoveControl));
        }

        public void m_8037_() {
            MoveControl movecontrol;
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.m_183277_(40 + this.slime.m_217043_().m_188503_(60));
                this.chosenDegrees = this.slime.m_217043_().m_188503_(360);
            }
            if ((movecontrol = this.slime.m_21566_()) instanceof SlimeServantMoveControl) {
                SlimeServantMoveControl slime$slimemovecontrol = (SlimeServantMoveControl)movecontrol;
                slime$slimemovecontrol.setDirection(this.chosenDegrees, false);
            }
        }
    }

    static class SlimeKeepOnJumpingGoal
    extends Goal {
        private final SlimeServant slime;

        public SlimeKeepOnJumpingGoal(SlimeServant p_33660_) {
            this.slime = p_33660_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.slime.m_20159_() && !this.slime.isStaying() && (this.slime.getTrueOwner() == null || this.slime.isWandering() || this.slime.m_5448_() != null);
        }

        public void m_8037_() {
            MoveControl movecontrol = this.slime.m_21566_();
            if (movecontrol instanceof SlimeServantMoveControl) {
                SlimeServantMoveControl slime$slimemovecontrol = (SlimeServantMoveControl)movecontrol;
                slime$slimemovecontrol.setWantedMovement(1.0);
            }
        }
    }

    static class SlimeFollowGoal
    extends Goal {
        private final SlimeServant slime;
        private LivingEntity owner;
        private final float stopDistance;
        private final float startDistance;

        public SlimeFollowGoal(SlimeServant p_33648_, float startDistance, float stopDistance) {
            this.slime = p_33648_;
            this.startDistance = startDistance;
            this.stopDistance = stopDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.slime.getTrueOwner();
            if (livingentity == null) {
                return false;
            }
            if (!(this.slime.m_21566_() instanceof SlimeServantMoveControl)) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            if (this.slime.m_20280_((Entity)livingentity) < (double)Mth.m_14207_((float)this.startDistance)) {
                return false;
            }
            if (this.slime.isWandering() || this.slime.isStaying() || this.slime.isCommanded()) {
                return false;
            }
            if (this.slime.m_5448_() != null) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
        }

        public boolean m_8045_() {
            if (this.slime.m_21573_().m_26571_()) {
                return false;
            }
            if (this.slime.m_5448_() != null) {
                return false;
            }
            return !(this.slime.m_20280_((Entity)this.owner) <= (double)Mth.m_14207_((float)this.stopDistance));
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            MoveControl movecontrol;
            if (this.owner != null) {
                this.slime.m_21391_((Entity)this.owner, 10.0f, 10.0f);
            }
            if ((movecontrol = this.slime.m_21566_()) instanceof SlimeServantMoveControl) {
                SlimeServantMoveControl slime$slimemovecontrol = (SlimeServantMoveControl)movecontrol;
                slime$slimemovecontrol.setDirection(this.slime.m_146908_(), true);
                slime$slimemovecontrol.setWantedMovement(1.0);
            }
        }
    }
}

