/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.AttributesConfig;
import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.init.ModMobType;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Leapleaf
extends Summoned {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(Leapleaf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Leapleaf.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final UUID LEAP_ATTACK_MODIFIER_UUID = UUID.fromString("c8724bee-d7fe-46e5-9319-980ea1146ebb");
    private static final AttributeModifier LEAP_ATTACK_MODIFIER = new AttributeModifier(LEAP_ATTACK_MODIFIER_UUID, "Leap Attack Bonus", 1.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public int attackTick;
    public int chargeTick;
    public int leapTick;
    public int restTick = 0;
    public int coolTick = MathHelper.secondsToTicks(2);
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState smashAnimationState = new AnimationState();
    public AnimationState chargeAnimationState = new AnimationState();
    public AnimationState leapAnimationState = new AnimationState();
    public AnimationState restAnimationState = new AnimationState();

    public Leapleaf(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new AttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new StrafeGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LeapGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new Summoned.WanderGoal(this, this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.LeapleafHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.LeapleafDamage.get()).doubleValue()).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22277_, 16.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.LeapleafHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.LeapleafDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    public MobType m_6336_() {
        return ModMobType.NATURAL;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    public int xpReward() {
        return 20;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.LEAPLEAF_AMBIENT.get();
    }

    public void m_8032_() {
        if (this.getCurrentAnimation() == this.getAnimationState("idle")) {
            super.m_8032_();
        }
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.LEAPLEAF_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.LEAPLEAF_DEATH.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_((SoundEvent)ModSounds.LEAPLEAF_STEP.get(), 0.15f, this.m_6100_());
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 1;
        }
        if (Objects.equals(animation, "walk")) {
            return 2;
        }
        if (Objects.equals(animation, "smash")) {
            return 3;
        }
        if (Objects.equals(animation, "charge")) {
            return 4;
        }
        if (Objects.equals(animation, "leap")) {
            return 5;
        }
        if (Objects.equals(animation, "rest")) {
            return 6;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.walkAnimationState);
        animationStates.add(this.smashAnimationState);
        animationStates.add(this.chargeAnimationState);
        animationStates.add(this.leapAnimationState);
        animationStates.add(this.restAnimationState);
        return animationStates;
    }

    public void stopAllAnimations() {
        for (AnimationState animationState : this.getAllAnimations()) {
            animationState.m_216973_();
        }
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.walkAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.walkAnimationState);
                    break;
                }
                case 3: {
                    this.smashAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.smashAnimationState);
                    break;
                }
                case 4: {
                    this.chargeAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.chargeAnimationState);
                    break;
                }
                case 5: {
                    this.leapAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.leapAnimationState);
                    break;
                }
                case 6: {
                    this.restAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.restAnimationState);
                }
            }
        }
    }

    private boolean getFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.restTick > 0;
    }

    public boolean m_142582_(Entity p_147185_) {
        return super.m_142582_(p_147185_) && this.restTick <= 0;
    }

    public boolean isCharging() {
        return this.getFlag(1);
    }

    public void setCharging(boolean leap) {
        this.setFlag(1, leap);
        this.chargeTick = 0;
    }

    public boolean isLeaping() {
        return this.getFlag(2);
    }

    public void setLeaping(boolean leaping) {
        this.setFlag(2, leaping);
        this.leapTick = 0;
    }

    public boolean isMeleeAttacking() {
        return this.getFlag(4);
    }

    public void setMeleeAttacking(boolean leaping) {
        this.setFlag(4, leaping);
        this.attackTick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    public boolean isResting() {
        return this.getCurrentAnimation() == this.getAnimationState("rest");
    }

    public boolean isChestPound() {
        return this.isCharging() && (float)this.chargeTick < MathHelper.secondsToTicks(1.21f);
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource p_147189_) {
        return false;
    }

    public boolean isMoving() {
        return this.m_20184_().m_165925_() > 1.0E-6;
    }

    public boolean m_5829_() {
        return this.m_6084_() && this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.5)).stream().noneMatch(living -> living == this.getTrueOwner() && CuriosFinder.hasWildRobe(living));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_() && !this.f_19853_.f_46443_) {
            AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22281_);
            if (modifiableattributeinstance != null) {
                if (this.isLeaping()) {
                    if (this.m_21051_(Attributes.f_22281_) != null) {
                        modifiableattributeinstance.m_22130_(LEAP_ATTACK_MODIFIER);
                        modifiableattributeinstance.m_22118_(LEAP_ATTACK_MODIFIER);
                    }
                } else if (modifiableattributeinstance.m_22109_(LEAP_ATTACK_MODIFIER)) {
                    modifiableattributeinstance.m_22130_(LEAP_ATTACK_MODIFIER);
                }
            }
            if (this.restTick > 0) {
                this.setAnimationState("rest");
                --this.restTick;
                if (this.restTick == MathHelper.secondsToTicks(4) - 1) {
                    this.m_5496_((SoundEvent)ModSounds.LEAPLEAF_REST.get(), this.m_6121_(), this.m_6100_());
                }
            } else {
                if (!(this.isMeleeAttacking() || this.isChestPound() || this.isLeaping())) {
                    if (!this.isMoving()) {
                        this.setAnimationState("idle");
                    } else {
                        this.setAnimationState("walk");
                    }
                }
                if (this.isMeleeAttacking()) {
                    ++this.attackTick;
                    if ((float)this.attackTick >= MathHelper.secondsToTicks(1.21f)) {
                        this.setMeleeAttacking(false);
                    }
                }
                if (this.isCharging()) {
                    ++this.chargeTick;
                }
                if (this.isLeaping()) {
                    ++this.leapTick;
                }
                if (this.coolTick > 0) {
                    --this.coolTick;
                }
            }
        }
    }

    public Vec3 getHorizontalLookAngle() {
        return this.m_20171_(0.0f, this.m_146908_());
    }

    public Vec3 getHorizontalLeftLookAngle() {
        return MobUtil.calculateViewVector(0.0f, this.m_146908_() - 90.0f);
    }

    public Vec3 getHorizontalRightLookAngle() {
        return MobUtil.calculateViewVector(0.0f, this.m_146908_() + 90.0f);
    }

    public double getAttackReachSqr(LivingEntity enemy) {
        return this.m_20205_() * 4.0f * this.m_20205_() * 4.0f + enemy.m_20205_();
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 5) {
            this.attackTick = 0;
        } else if (p_21375_ == 6) {
            this.m_21561_(true);
        } else if (p_21375_ == 7) {
            this.m_21561_(false);
        } else {
            super.m_7822_(p_21375_);
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
            Item item = itemstack.m_41720_();
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && item == Items.f_42499_ && this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_((SoundEvent)ModSounds.LEAPLEAF_AMBIENT.get(), 1.0f, 1.5f);
                this.m_5634_(5.0f);
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.HEAL_EFFECT.get(), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                }
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6071_(pPlayer, p_230254_2_);
    }

    class AttackGoal
    extends Goal {
        AttackGoal() {
        }

        public boolean m_8036_() {
            return Leapleaf.this.m_5448_() != null && Leapleaf.this.m_5448_().m_6084_() && !Leapleaf.this.isCharging() && !Leapleaf.this.isLeaping() && Leapleaf.this.m_142582_((Entity)Leapleaf.this.m_5448_()) && Leapleaf.this.m_5448_().m_20270_((Entity)Leapleaf.this) < 4.0f;
        }

        public boolean m_8045_() {
            return Leapleaf.this.isMeleeAttacking();
        }

        public void m_8056_() {
            Leapleaf.this.setMeleeAttacking(true);
            Leapleaf.this.m_21561_(true);
            Leapleaf.this.f_19853_.m_7605_((Entity)Leapleaf.this, (byte)6);
        }

        public void m_8041_() {
            Leapleaf.this.setMeleeAttacking(false);
            Leapleaf.this.m_21561_(false);
            Leapleaf.this.f_19853_.m_7605_((Entity)Leapleaf.this, (byte)7);
        }

        public void m_8037_() {
            LivingEntity livingentity = Leapleaf.this.m_5448_();
            if (livingentity == null) {
                return;
            }
            MobUtil.instaLook((Mob)Leapleaf.this, Leapleaf.this.m_5448_());
            Leapleaf.this.m_21573_().m_26573_();
            if (Leapleaf.this.attackTick == 1) {
                Leapleaf.this.setAnimationState("smash");
                Leapleaf.this.m_5496_((SoundEvent)ModSounds.LEAPLEAF_SMASH.get(), Leapleaf.this.m_6121_(), Leapleaf.this.m_6100_());
            }
            if (Leapleaf.this.attackTick == 13) {
                LivingEntity target2;
                double x = Leapleaf.this.m_20185_() + Leapleaf.this.getHorizontalLookAngle().f_82479_ * 2.0;
                double z = Leapleaf.this.m_20189_() + Leapleaf.this.getHorizontalLookAngle().f_82481_ * 2.0;
                AABB aabb = AttackGoal.makeAttackRange(x, Leapleaf.this.m_20186_(), z, 3.0, 1.0, 3.0);
                for (LivingEntity target2 : Leapleaf.this.f_19853_.m_45976_(LivingEntity.class, aabb)) {
                    if (target2 == Leapleaf.this || target2.m_7307_((Entity)Leapleaf.this) || Leapleaf.this.m_7307_((Entity)target2)) continue;
                    Leapleaf.this.m_7327_((Entity)target2);
                }
                target2 = Leapleaf.this.f_19853_;
                if (target2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)target2;
                    BlockPos blockPos = BlockPos.m_274561_((double)x, (double)(Leapleaf.this.m_20186_() - 1.0), (double)z);
                    BlockParticleOption option = new BlockParticleOption(ParticleTypes.f_123794_, serverLevel.m_8055_(blockPos));
                    for (int i = 0; i < 8; ++i) {
                        ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)option, x, Leapleaf.this.m_20186_() + 0.25, z, 1.5f);
                    }
                    ColorUtil colorUtil = new ColorUtil(serverLevel.m_8055_((BlockPos)blockPos).m_284242_((BlockGetter)serverLevel, (BlockPos)blockPos).f_283871_);
                    serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), 2.0f, 1), x, BlockFinder.moveDownToGround((Entity)Leapleaf.this), z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }

        public static AABB makeAttackRange(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
            return new AABB(x - sizeX / 2.0, y - sizeY / 2.0, z - sizeZ / 2.0, x + sizeX / 2.0, y + sizeY / 2.0, z + sizeZ / 2.0);
        }

        public boolean m_183429_() {
            return true;
        }
    }

    static class StrafeGoal
    extends Goal {
        public Leapleaf leapleaf;
        @Nullable
        public LivingEntity target;
        private int seeTime;
        private int strafingTime = -1;
        private boolean strafingLeft;

        public StrafeGoal(Leapleaf leapleaf) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.leapleaf = leapleaf;
            this.target = leapleaf.m_5448_();
        }

        public boolean m_8036_() {
            this.target = this.leapleaf.m_5448_();
            return this.target != null && !this.leapleaf.isMeleeAttacking() && !this.leapleaf.isCharging() && !this.leapleaf.isLeaping() && this.leapleaf.coolTick > 0;
        }

        public void m_8041_() {
            super.m_8041_();
            this.seeTime = 0;
            this.leapleaf.m_21566_().m_24988_(0.0f, 0.0f);
        }

        public void m_8037_() {
            this.target = this.leapleaf.m_5448_();
            if (this.target != null) {
                boolean flag1;
                double d0 = this.leapleaf.m_20270_((Entity)this.target);
                boolean flag = this.leapleaf.m_21574_().m_148306_((Entity)this.target);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (flag) {
                    this.leapleaf.m_7618_(EntityAnchorArgument.Anchor.EYES, this.target.m_20182_());
                }
                if (this.strafingTime >= 20) {
                    if (this.leapleaf.f_19796_.m_188503_(30) == 0) {
                        this.strafingLeft = !this.strafingLeft;
                    }
                    this.strafingTime = 0;
                }
                if (d0 > 8.0 && this.seeTime < 20) {
                    this.leapleaf.m_21573_().m_5624_((Entity)this.target, 1.25);
                    this.strafingTime = -1;
                } else {
                    this.leapleaf.m_21573_().m_26573_();
                    ++this.strafingTime;
                }
                if (this.strafingTime > -1) {
                    this.leapleaf.m_21566_().m_24988_(d0 < 5.0 ? -0.5f : 0.5f, this.strafingLeft ? 0.5f : -0.5f);
                }
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    static class LeapGoal
    extends Goal {
        public Leapleaf leapleaf;
        @Nullable
        public LivingEntity target;

        public LeapGoal(Leapleaf leapleaf) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.leapleaf = leapleaf;
            this.target = leapleaf.m_5448_();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.leapleaf.m_5448_();
            return this.target != null && !this.leapleaf.isCharging() && !this.leapleaf.isLeaping() && this.leapleaf.coolTick <= 0 && this.leapleaf.m_142582_((Entity)this.target);
        }

        public boolean m_8045_() {
            return this.leapleaf.isCharging() || this.leapleaf.isLeaping();
        }

        public void m_8056_() {
            if (this.target != null) {
                MobUtil.instaLook((Mob)this.leapleaf, this.target);
            }
            this.leapleaf.setMeleeAttacking(false);
            this.leapleaf.setCharging(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.leapleaf.setCharging(false);
            this.leapleaf.setLeaping(false);
            this.leapleaf.leapTick = 0;
        }

        public void m_8037_() {
            this.target = this.leapleaf.m_5448_();
            this.leapleaf.f_21344_.m_26573_();
            if (this.target != null) {
                this.leapleaf.m_7618_(EntityAnchorArgument.Anchor.EYES, this.target.m_20182_());
                if (this.leapleaf.chargeTick == 1) {
                    this.leapleaf.setAnimationState("charge");
                    this.leapleaf.m_5496_((SoundEvent)ModSounds.LEAPLEAF_CHARGE.get(), this.leapleaf.m_6121_(), this.leapleaf.m_6100_());
                }
                if ((float)this.leapleaf.chargeTick < MathHelper.secondsToTicks(1.21f)) {
                    this.leapleaf.f_21344_.m_26573_();
                } else if (this.leapleaf.m_20270_((Entity)this.target) <= 6.0f) {
                    this.leapleaf.setCharging(false);
                    this.leapleaf.setAnimationState("leap");
                    this.leapleaf.m_5496_((SoundEvent)ModSounds.LEAPLEAF_LEAP.get(), this.leapleaf.m_6121_(), this.leapleaf.m_6100_());
                    this.leapleaf.setLeaping(true);
                } else {
                    this.leapleaf.f_21344_.m_5624_((Entity)this.target, 1.25);
                }
                if (this.leapleaf.leapTick == 1) {
                    double d0 = this.target.m_20185_() - this.leapleaf.m_20185_();
                    double d1 = this.target.m_20186_() - this.leapleaf.m_20186_();
                    double d2 = this.target.m_20189_() - this.leapleaf.m_20189_();
                    this.leapleaf.m_20334_(d0 * 0.15, 0.75 + Mth.m_14008_((double)(d1 * 0.05), (double)0.0, (double)10.0), d2 * 0.15);
                }
            }
            double xLeft = this.leapleaf.m_20185_() + this.leapleaf.getHorizontalLeftLookAngle().f_82479_;
            double zLeft = this.leapleaf.m_20189_() + this.leapleaf.getHorizontalLeftLookAngle().f_82481_;
            double xRight = this.leapleaf.m_20185_() + this.leapleaf.getHorizontalRightLookAngle().f_82479_;
            double zRight = this.leapleaf.m_20189_() + this.leapleaf.getHorizontalRightLookAngle().f_82481_;
            if (this.leapleaf.isLeaping() && this.leapleaf.m_20096_() && this.leapleaf.leapTick > 1) {
                LivingEntity target2;
                AABB aabb = LeapGoal.makeAttackRange(xLeft, this.leapleaf.m_20186_(), zLeft, 5.0, 3.0, 5.0);
                AABB aabb2 = LeapGoal.makeAttackRange(xRight, this.leapleaf.m_20186_(), zRight, 5.0, 3.0, 5.0);
                boolean random = this.leapleaf.f_19796_.m_188501_() <= 0.25f;
                for (LivingEntity target2 : this.leapleaf.f_19853_.m_45976_(LivingEntity.class, aabb)) {
                    if (target2 == this.leapleaf || target2.m_7307_((Entity)this.leapleaf) || this.leapleaf.m_7307_((Entity)target2) || !this.leapleaf.m_7327_((Entity)target2) || !random && target2.m_6084_()) continue;
                    this.leapleaf.restTick = MathHelper.secondsToTicks(4);
                }
                for (LivingEntity target2 : this.leapleaf.f_19853_.m_45976_(LivingEntity.class, aabb2)) {
                    if (target2 == this.leapleaf || target2.m_7307_((Entity)this.leapleaf) || this.leapleaf.m_7307_((Entity)target2) || !this.leapleaf.m_7327_((Entity)target2) || !random && target2.m_6084_()) continue;
                    this.leapleaf.restTick = MathHelper.secondsToTicks(4);
                }
                this.leapleaf.setLeaping(false);
                this.leapleaf.coolTick = MathHelper.secondsToTicks(2);
                target2 = this.leapleaf.f_19853_;
                if (target2 instanceof ServerLevel) {
                    int i;
                    ServerLevel serverLevel = (ServerLevel)target2;
                    BlockPos leftPos = BlockPos.m_274561_((double)xLeft, (double)(this.leapleaf.m_20186_() - 1.0), (double)zLeft);
                    BlockPos rightPos = BlockPos.m_274561_((double)xRight, (double)(this.leapleaf.m_20186_() - 1.0), (double)zRight);
                    BlockState leftState = serverLevel.m_8055_(leftPos);
                    BlockState rightState = serverLevel.m_8055_(rightPos);
                    BlockParticleOption leftOption = new BlockParticleOption(ParticleTypes.f_123794_, leftState);
                    BlockParticleOption rightOption = new BlockParticleOption(ParticleTypes.f_123794_, rightState);
                    for (i = 0; i < 8; ++i) {
                        ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)leftOption, xLeft, this.leapleaf.m_20186_() + 0.25, zLeft, 1.5f);
                    }
                    for (i = 0; i < 8; ++i) {
                        ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)rightOption, xRight, this.leapleaf.m_20186_() + 0.25, zRight, 1.5f);
                    }
                    ColorUtil colorUtil = new ColorUtil(leftState.m_284242_((BlockGetter)serverLevel, (BlockPos)leftPos).f_283871_);
                    ColorUtil colorUtil1 = new ColorUtil(rightState.m_284242_((BlockGetter)serverLevel, (BlockPos)rightPos).f_283871_);
                    serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), 5.0f, 1), xLeft, BlockFinder.moveDownToGround((Entity)this.leapleaf), zLeft, 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil1.red(), colorUtil1.green(), colorUtil1.blue(), 5.0f, 1), xRight, BlockFinder.moveDownToGround((Entity)this.leapleaf), zRight, 1, 0.0, 0.0, 0.0, 0.0);
                    BlockPos blockPos2 = BlockPos.m_274561_((double)xLeft, (double)(this.leapleaf.m_20186_() + 0.25), (double)zLeft);
                    BlockPos blockPos3 = BlockPos.m_274561_((double)xRight, (double)(this.leapleaf.m_20186_() + 0.25), (double)zRight);
                    for (Direction direction : Direction.values()) {
                        if (!direction.m_122434_().m_122479_()) continue;
                        BlockPos blockPos4 = blockPos2.m_5484_(direction, 2);
                        BlockPos blockPos5 = blockPos3.m_5484_(direction, 2);
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_CULT_SPELL.get()), (double)blockPos4.m_123341_(), (double)blockPos4.m_123342_(), (double)blockPos4.m_123343_(), 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 0.5);
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_CULT_SPELL.get()), (double)blockPos5.m_123341_(), (double)blockPos5.m_123342_(), (double)blockPos5.m_123343_(), 0, (double)colorUtil1.red(), (double)colorUtil1.green(), (double)colorUtil1.blue(), 0.5);
                    }
                }
            }
        }

        public static AABB makeAttackRange(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
            return new AABB(x - sizeX / 2.0, y - sizeY / 2.0, z - sizeZ / 2.0, x + sizeX / 2.0, y + sizeY / 2.0, z + sizeZ / 2.0);
        }
    }
}

