/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.capabilities.witchbarter;

import com.Polarice3.Goety.common.capabilities.lichdom.LichProvider;
import com.Polarice3.Goety.common.capabilities.witchbarter.WitchBarterProvider;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.LichdomHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class WBUpdatePacket {
    private final UUID WitchUUID;
    private CompoundTag tag;

    public WBUpdatePacket(UUID uuid, CompoundTag tag) {
        this.WitchUUID = uuid;
        this.tag = tag;
    }

    public WBUpdatePacket(LivingEntity player) {
        this.WitchUUID = player.m_20148_();
        player.getCapability(LichProvider.CAPABILITY, null).ifPresent(lichdom -> {
            this.tag = LichdomHelper.save(new CompoundTag(), lichdom);
        });
    }

    public static void encode(WBUpdatePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.WitchUUID);
        buffer.m_130079_(packet.tag);
    }

    public static WBUpdatePacket decode(FriendlyByteBuf buffer) {
        return new WBUpdatePacket(buffer.m_130259_(), buffer.m_130260_());
    }

    public static void consume(WBUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            Entity entity = EntityFinder.getEntityByUuiDGlobal(packet.WitchUUID).get();
            entity.getCapability(WitchBarterProvider.CAPABILITY).ifPresent(infamy -> WitchBarterProvider.load(packet.tag, infamy));
        });
        ctx.get().setPacketHandled(true);
    }
}

