/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.capabilities.soulenergy;

import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SFocusCooldownPacket;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class FocusCooldown {
    public final Map<Item, CooldownInstance> cooldowns = Maps.newHashMap();

    public boolean isOnCooldown(Item item) {
        return this.getCooldownPercent(item) > 0.0f;
    }

    public float getCooldownPercent(Item item) {
        CooldownInstance cooldownInstance = this.cooldowns.get(item);
        if (cooldownInstance != null) {
            return Mth.m_14036_((float)((float)cooldownInstance.time / (float)cooldownInstance.totalTime), (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }

    public void tick(Player player, Level level) {
        if (!this.cooldowns.isEmpty()) {
            Iterator<Map.Entry<Item, CooldownInstance>> iterator = this.cooldowns.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Item, CooldownInstance> entry = iterator.next();
                entry.getValue().decreaseTime();
                if (entry.getValue().time > 0) continue;
                iterator.remove();
                if (level.f_46443_) continue;
                this.onCooldownEnded(player, entry.getKey());
            }
        }
    }

    public void addCooldown(Player player, Level level, Item item, int coolDown) {
        this.cooldowns.put(item, new CooldownInstance(coolDown));
        if (!level.f_46443_) {
            this.onCooldownStarted(player, item, coolDown);
        }
    }

    public void removeCooldown(Player player, Level level, Item item) {
        this.cooldowns.remove(item);
        if (!level.f_46443_) {
            this.onCooldownEnded(player, item);
        }
    }

    protected void onCooldownStarted(Player player, Item item, int duration) {
        ModNetwork.sendTo(player, new SFocusCooldownPacket(item, duration));
    }

    protected void onCooldownEnded(Player player, Item item) {
        ModNetwork.sendTo(player, new SFocusCooldownPacket(item, 0));
    }

    public CooldownInstance getInstance(Item item) {
        return this.cooldowns.get(item);
    }

    public void setCooldown(Item item, CooldownInstance cooldownInstance) {
        this.cooldowns.put(item, cooldownInstance);
    }

    public void save(ListTag listTag) {
        this.cooldowns.forEach((item, cooldown) -> {
            if (this.isOnCooldown((Item)item)) {
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.m_128405_("Item", Item.m_41393_((Item)item));
                compoundTag.m_128405_("Time", cooldown.time);
                compoundTag.m_128405_("TotalTime", cooldown.totalTime);
                listTag.add((Object)compoundTag);
            }
        });
    }

    public void load(ListTag listTag) {
        if (listTag != null) {
            listTag.forEach(tag -> {
                CompoundTag compoundTag = (CompoundTag)tag;
                Item item = Item.m_41445_((int)compoundTag.m_128451_("Item"));
                int startTime = compoundTag.m_128451_("Time");
                int endTime = compoundTag.m_128451_("TotalTime");
                this.cooldowns.put(item, new CooldownInstance(startTime, endTime));
            });
        }
    }

    public static class CooldownInstance {
        int time;
        final int totalTime;

        public CooldownInstance(int time) {
            this(time, time);
        }

        public CooldownInstance(int time, int totalTime) {
            this.time = time;
            this.totalTime = totalTime;
        }

        public void decreaseTime() {
            if (this.time > 0) {
                --this.time;
            }
        }
    }
}

