/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.capabilities.misc;

import com.Polarice3.Goety.common.capabilities.misc.MiscProvider;
import com.Polarice3.Goety.utils.MiscCapHelper;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class MiscCapUpdatePacket {
    private final int entityID;
    private CompoundTag tag;

    public MiscCapUpdatePacket(int id, CompoundTag tag) {
        this.entityID = id;
        this.tag = tag;
    }

    public MiscCapUpdatePacket(LivingEntity living) {
        this.entityID = living.m_19879_();
        living.getCapability(MiscProvider.CAPABILITY, null).ifPresent(misc -> {
            this.tag = MiscCapHelper.save(new CompoundTag(), misc);
        });
    }

    public static void encode(MiscCapUpdatePacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.entityID);
        buffer.m_130079_(packet.tag);
    }

    public static MiscCapUpdatePacket decode(FriendlyByteBuf buffer) {
        return new MiscCapUpdatePacket(buffer.readInt(), buffer.m_130260_());
    }

    public static void consume(MiscCapUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
            if (clientLevel != null && (entity = clientLevel.m_6815_(packet.entityID)) != null) {
                entity.getCapability(MiscProvider.CAPABILITY).ifPresent(misc -> MiscCapHelper.load(packet.tag, misc));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

