/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.capabilities.lichdom;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.common.capabilities.lichdom.LichProvider;
import com.Polarice3.Goety.utils.LichdomHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class LichUpdatePacket {
    private final UUID PlayerUUID;
    private CompoundTag tag;

    public LichUpdatePacket(UUID uuid, CompoundTag tag) {
        this.PlayerUUID = uuid;
        this.tag = tag;
    }

    public LichUpdatePacket(Player player) {
        this.PlayerUUID = player.m_20148_();
        player.getCapability(LichProvider.CAPABILITY, null).ifPresent(lichdom -> {
            this.tag = LichdomHelper.save(new CompoundTag(), lichdom);
        });
    }

    public static void encode(LichUpdatePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.PlayerUUID);
        buffer.m_130079_(packet.tag);
    }

    public static LichUpdatePacket decode(FriendlyByteBuf buffer) {
        return new LichUpdatePacket(buffer.m_130259_(), buffer.m_130260_());
    }

    public static void consume(LichUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            Player player = Goety.PROXY.getPlayer();
            if (player != null) {
                player.getCapability(LichProvider.CAPABILITY).ifPresent(lichdom -> LichdomHelper.load(packet.tag, lichdom));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

